/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.FolderIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.shortcuts.Category;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutsOrganizer;
import com.mathworks.mlwidgets.shortcuts.TransferableTreePathList;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ShortcutTreePanel
extends MJPanel {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");
    private static ImageIcon sFolderIcon;
    private static final String NONE;
    private DefaultTreeModel fModel;
    private JMenuItem fOpenCloseMenu;
    private Matlab fMatlab = new Matlab();
    private MJPopupMenu fPopupMenu;
    private final MJTree fTree;
    private EditFavoriteAction fEditAction;
    private RemoveFavoriteAction fDeleteAction;
    private DefaultMutableTreeNode fTopNode;
    private Color fBGColor;
    private Color fTextColor;
    private TreePath fInitialDragTreePath;
    private TreePath fCurrentDragSelectionPath;
    private boolean fGroupMoveInProgress;

    public ShortcutTreePanel() {
        sFolderIcon = FolderIcon.CLOSED.getIcon();
        this.setLayout((LayoutManager)new FormLayout("fill:130dlu:grow", "fill:pref:grow"));
        this.fTree = this.createNewTree();
        this.fTree.setName("ShortcutTree");
        this.fTree.getAccessibleContext().setAccessibleName(sRes.getString("acc.Tree"));
        new TreeDragSource((JTree)this.fTree, 2);
        new TreeDropTarget((JTree)this.fTree);
        DefaultMutableTreeNode defaultMutableTreeNode = this.createTreeNode();
        ShortcutUtils.addFavoritesListener(new FavoritesChangedListener());
        this.fModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.fTree.setModel((TreeModel)this.fModel);
        this.fModel.reload();
        this.setBackgroundColor();
        this.setTextColor();
        MyColorListener myColorListener = new MyColorListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)myColorListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)myColorListener);
        this.createPopupMenu();
        this.fTree.addKeyListener((KeyListener)new TreeKeyListener());
        this.fTree.addFocusListener((FocusListener)new MyFocusAdapter());
        this.fTree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "open_files");
        this.fTree.getActionMap().put("open_files", (Action)((Object)new EnterAction()));
        this.fTree.setVisible(true);
        this.fTree.setVisibleRowCount(12);
        this.add((Component)new MJScrollPane((Component)this.fTree), new CellConstraints().xy(1, 1));
    }

    private DefaultMutableTreeNode createTreeNode() {
        this.fTopNode = new DefaultMutableTreeNode(sRes.getString("node.Shortcuts"));
        Shortcut[] shortcutArray = ShortcutUtils.getTopLevelItems();
        this.fTopNode = ShortcutTreePanel.addTopLevelItems(shortcutArray, this.fTopNode);
        return this.fTopNode;
    }

    private static DefaultMutableTreeNode addTopLevelItems(Shortcut[] shortcutArray, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (Shortcut shortcut : shortcutArray) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(shortcut);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (!(shortcut instanceof Category)) continue;
            ShortcutTreePanel.addChildrenToNode(((Category)shortcut).getItems(), defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private static DefaultMutableTreeNode addChildrenToNode(Vector vector, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < vector.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(vector.elementAt(i));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (!(vector.elementAt(i) instanceof Category)) continue;
            ShortcutTreePanel.addChildrenToNode(((Category)vector.elementAt(i)).getItems(), defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private void refreshNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findCategoryNode(string);
        if (defaultMutableTreeNode != null) {
            this.reloadNode(defaultMutableTreeNode);
        } else {
            this.refreshTree();
        }
    }

    private void reloadNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        Enumeration enumeration = this.fTree.getExpandedDescendants(this.fTree.getPathForRow(0));
        Vector<String> vector = new Vector<String>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object = (Shortcut[])enumeration.nextElement();
                DefaultMutableTreeNode object2 = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent();
                if (!(object2.getUserObject() instanceof Shortcut)) continue;
                vector.addElement(((Shortcut)object2.getUserObject()).getLabel());
            }
        }
        defaultMutableTreeNode.removeAllChildren();
        if (defaultMutableTreeNode.equals(this.fTopNode)) {
            object = ShortcutUtils.getTopLevelItems();
            this.fTopNode = ShortcutTreePanel.addTopLevelItems((Shortcut[])object, this.fTopNode);
        } else {
            object = ShortcutUtils.getShortcutsByCategory(((Shortcut)defaultMutableTreeNode.getUserObject()).getLabel());
            if (object != null) {
                ShortcutTreePanel.addChildrenToNode((Vector)object, defaultMutableTreeNode);
            }
        }
        this.fModel.reload(defaultMutableTreeNode);
        for (String string : vector) {
            this.expandCategory(string);
        }
    }

    private void setTextColor() {
        this.fTextColor = ColorPrefs.getTextColor();
        this.fTree.setForeground(this.fTextColor);
    }

    private void setBackgroundColor() {
        this.fBGColor = ColorPrefs.getBackgroundColor();
        this.fTree.setBackground(this.fBGColor);
    }

    private static DefaultMutableTreeNode findShortcutNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Shortcut shortcut = (Shortcut)defaultMutableTreeNode2.getUserObject();
            if (!shortcut.getLabel().equals(string) || shortcut.isCategory()) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private DefaultMutableTreeNode findCategoryNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (string.equals(NONE)) {
            defaultMutableTreeNode = this.fTopNode;
        } else {
            Enumeration<TreeNode> enumeration = this.fTopNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!((Shortcut)defaultMutableTreeNode2.getUserObject()).getLabel().equals(string) || !((Shortcut)defaultMutableTreeNode2.getUserObject()).isCategory()) continue;
                defaultMutableTreeNode = defaultMutableTreeNode2;
                break;
            }
        }
        return defaultMutableTreeNode;
    }

    private MJTree createNewTree() {
        final MJTree mJTree = new MJTree();
        ShortcutRenderer shortcutRenderer = new ShortcutRenderer();
        Font font = FontPrefs.getTextFont();
        FontPrefs.addTextFontListener((FontListener)new FontListener(){

            public void fontChanged(Font font) {
                mJTree.setFont(font);
            }
        });
        shortcutRenderer.setText("Sample Text");
        shortcutRenderer.setIcon(null);
        mJTree.setFont(font);
        mJTree.setCellRenderer((TreeCellRenderer)shortcutRenderer);
        mJTree.setVisible(false);
        mJTree.setRootVisible(true);
        mJTree.setShowsRootHandles(true);
        mJTree.addMouseListener((MouseListener)new FavoritesMouseAdapter());
        mJTree.addTreeSelectionListener((TreeSelectionListener)new MyTreeSelectionListener());
        mJTree.getSelectionModel().setSelectionMode(4);
        return mJTree;
    }

    void refreshTree() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.reloadNode(this.fTopNode);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
                }
            });
        }
    }

    public MJTree getTree() {
        return this.fTree;
    }

    private void createPopupMenu() {
        this.fPopupMenu = new MJPopupMenu();
        this.fOpenCloseMenu = this.fPopupMenu.add((Action)((Object)new OpenAction()));
        this.fEditAction = new EditFavoriteAction();
        this.fDeleteAction = new RemoveFavoriteAction();
        this.fPopupMenu.add((Action)((Object)new NewFavoriteAction()));
        this.fPopupMenu.add((Action)((Object)this.fDeleteAction));
        this.fPopupMenu.add((Action)((Object)this.fEditAction));
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.add((Action)((Object)new RefreshAction()));
        this.fPopupMenu.add((Action)((Object)new RestoreDefaultAction()));
    }

    private void enableDisable() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.fTree.getLastSelectedPathComponent();
        ShortcutsOrganizer.enableDisableMoveDownButton(defaultMutableTreeNode != null && (defaultMutableTreeNode.getNextLeaf() != null || defaultMutableTreeNode.getParent() != this.fTopNode) && defaultMutableTreeNode != this.fTopNode);
        ShortcutsOrganizer.enableDisableMoveUpButton(defaultMutableTreeNode != null && (defaultMutableTreeNode.getPreviousLeaf() != null || defaultMutableTreeNode.getParent() != this.fTopNode) && defaultMutableTreeNode != this.fTopNode);
        boolean bl = true;
        boolean bl2 = false;
        if (defaultMutableTreeNode != null && defaultMutableTreeNode != this.fTopNode) {
            Object object = defaultMutableTreeNode.getUserObject();
            bl2 = true;
            bl = !(object instanceof Category);
        }
        ShortcutsOrganizer.enableDisableMoveToCatButton(bl2 && bl);
        ShortcutsOrganizer.enableDisableEditButton(bl2);
        ShortcutsOrganizer.enableDisableDeleteButton(bl2, !bl);
        this.fEditAction.setEnabled(bl2);
        this.fDeleteAction.setEnabled(bl2);
        if (bl) {
            this.fDeleteAction.setName(sRes.getString("action.RemoveFav"));
            this.fEditAction.setName(sRes.getString("action.EditFav"));
            this.fEditAction.setTip(sRes.getString("action.EditFavToolTip"));
        } else {
            this.fDeleteAction.setName(sRes.getString("action.RemoveCat"));
            this.fEditAction.setName(sRes.getString("action.EditCat"));
            this.fEditAction.setTip(sRes.getString("action.EditCatToolTip"));
        }
    }

    private Shortcut getSelectedItem() {
        TreePath treePath = this.fTree.getSelectionPath();
        if (treePath != null) {
            return this.getShortcut(treePath);
        }
        Shortcut shortcut = null;
        return shortcut;
    }

    private Shortcut getShortcut(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getUserObject() instanceof Shortcut ? (Shortcut)defaultMutableTreeNode.getUserObject() : null;
    }

    private Map<Shortcut, Category> getItems(TreePath[] treePathArray) {
        Arrays.sort(treePathArray, new Comparator<TreePath>(){

            @Override
            public int compare(TreePath treePath, TreePath treePath2) {
                return ShortcutTreePanel.this.fTree.getRowForPath(treePath) - ShortcutTreePanel.this.fTree.getRowForPath(treePath2);
            }
        });
        LinkedHashMap<Shortcut, Category> linkedHashMap = new LinkedHashMap<Shortcut, Category>();
        for (TreePath treePath : treePathArray) {
            Shortcut shortcut = this.getShortcut(treePath);
            if (shortcut == null) continue;
            linkedHashMap.put(shortcut, ShortcutTreePanel.getSelectedItemsParent(treePath));
        }
        return linkedHashMap;
    }

    private Map<Shortcut, Category> getSelectedItems() {
        return this.getItems(this.fTree.getSelectionPaths());
    }

    private void openNode(boolean bl) {
        TreePath treePath = this.fTree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getChildCount() > 0 && this.fTree.isExpanded(treePath)) {
                this.fOpenCloseMenu.setText(sRes.getString("action.Close"));
                if (!bl) {
                    this.fTree.collapsePath(treePath);
                }
            } else if (defaultMutableTreeNode.getChildCount() > 0 && !this.fTree.isExpanded(treePath)) {
                this.fOpenCloseMenu.setText(sRes.getString("action.Open"));
                if (!bl) {
                    this.fTree.expandPath(treePath);
                }
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.editSelectedFavorite();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShortcutTreePanel.this.editSelectedFavorite();
                    }
                });
            }
        }
    }

    void removeFavorite() {
        Map<Shortcut, Category> map = this.getSelectedItems();
        for (Shortcut shortcut : map.keySet()) {
            String string;
            String string2 = shortcut.getLabel();
            String string3 = string = map.get(shortcut) == null ? NONE : map.get(shortcut).getLabel();
            if (shortcut instanceof Category) {
                if (string2.equals(ShortcutUtils.getToolbarCategory()) && !MatlabDesktopServices.getDesktop().useToolstrip() || string2.equals(ShortcutUtils.getHelpCategory())) {
                    MJOptionPane.showMessageDialog((Component)((Object)this), (Object)sRes.getString("alert.NoDeleteCategory"));
                    return;
                }
                int n = MJOptionPane.showConfirmDialog((Component)((Object)this), (Object)sRes.getString("alert.reallyDelete"), (String)sRes.getString("alert.reallyDeleteTitle"), (int)2);
                if (n != 0) continue;
                ShortcutUtils.removeShortcutCategory(string2);
                continue;
            }
            ShortcutUtils.removeShortcut(string, string2);
        }
    }

    void editSelectedFavorite() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Shortcut shortcut = this.getSelectedItem();
        TreePath treePath = this.fTree.getSelectionPath();
        if (shortcut.isCategory()) {
            if (shortcut.getLabel().equals(ShortcutUtils.getToolbarCategory()) && !MatlabDesktopServices.getDesktop().useToolstrip() || shortcut.getLabel().equals(ShortcutUtils.getHelpCategory())) {
                MJOptionPane.showMessageDialog((Component)((Object)this), (Object)sRes.getString("alert.NoRenameCategory"));
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            String string = (String)MJOptionPane.showInputDialog((Component)this.fTree, (Object)sRes.getString("alert.RenameCatMsg"), (String)sRes.getString("action.EditCat"), (int)3, null, null, (Object)shortcut.getLabel());
            while (string == null || string.length() == 0) {
                if (string == null) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                string = (String)MJOptionPane.showInputDialog((Component)this.fTree, (Object)sRes.getString("alert.ErrorRenameCatMsg"), (String)sRes.getString("action.EditCat"), (int)0, null, null, (Object)shortcut.getLabel());
            }
            this.setCursor(Cursor.getDefaultCursor());
            ShortcutUtils.editCategory(shortcut.getLabel(), null, string);
            return;
        }
        String string = ShortcutTreePanel.getParentsName(treePath);
        String string2 = shortcut.getLabel();
        String string3 = shortcut.getCallback();
        String string4 = shortcut.getIconPath();
        boolean bl = shortcut.isEditable();
        if (string == null || string.length() == 0 || !bl) {
            System.out.println("Cannot edit this favorite.  It is either read-only or is a category.");
        } else {
            ShortcutEditor.invoke(string2, string3, string4, string, false);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private static String getName(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Shortcut shortcut = null;
        if (defaultMutableTreeNode.getUserObject() instanceof Shortcut) {
            shortcut = (Shortcut)defaultMutableTreeNode.getUserObject();
        }
        if (shortcut != null) {
            return shortcut.getLabel();
        }
        return ShortcutUtils.getTopLevelNodeName();
    }

    private static String getParentsName(TreePath treePath) {
        Category category = ShortcutTreePanel.getSelectedItemsParent(treePath);
        String string = ShortcutUtils.getTopLevelNodeName();
        if (category != null) {
            string = category.getLabel();
        }
        return string;
    }

    private static Category getSelectedItemsParent(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
        }
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof Category) {
            return (Category)defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    void moveSelectedFavorite(final String string) {
        final Map<Shortcut, Category> map = this.getSelectedItems();
        this.runAsGroupMove(new Runnable(){

            @Override
            public void run() {
                for (Shortcut shortcut : map.keySet()) {
                    String string2 = map.get(shortcut) == null ? NONE : ((Category)map.get(shortcut)).getLabel();
                    ShortcutUtils.editShortcut(shortcut.getLabel(), string2, shortcut.getLabel(), string, shortcut.getCallback(), shortcut.getIconPath(), null);
                }
            }
        });
        this.enableDisable();
    }

    void moveUp() {
        final Map<Shortcut, Category> map = this.getSelectedItems();
        this.runAsGroupMove(new Runnable(){

            @Override
            public void run() {
                ShortcutUtils.moveUp(map);
            }
        });
    }

    void moveDown() {
        final Map<Shortcut, Category> map = this.getSelectedItems();
        this.runAsGroupMove(new Runnable(){

            @Override
            public void run() {
                ShortcutUtils.moveDown(map);
            }
        });
    }

    void executeCommand() {
        if (this.fTree.isSelectionEmpty()) {
            return;
        }
        TreePath treePath = this.fTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            if (this.fTree.isExpanded(treePath)) {
                this.fTree.collapsePath(treePath);
            } else {
                this.fTree.expandPath(treePath);
            }
        } else {
            Shortcut shortcut = (Shortcut)defaultMutableTreeNode.getUserObject();
            if (shortcut.getCallback() != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.fMatlab.evalConsoleOutput(shortcut.getCallback(), (CompletionObserver)new ExplorerCompletionObserver());
            }
        }
    }

    private void runAsGroupMove(Runnable runnable) {
        this.fTree.clearSelection();
        this.fGroupMoveInProgress = true;
        runnable.run();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShortcutTreePanel.this.fGroupMoveInProgress = false;
            }
        });
    }

    private void selectItem(final String string, final String string2, final TreePath[] treePathArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = ShortcutTreePanel.this.findCategoryNode(string);
                if (string2 != null) {
                    defaultMutableTreeNode = ShortcutTreePanel.findShortcutNode(defaultMutableTreeNode, string2);
                }
                if (defaultMutableTreeNode != null) {
                    TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                    if (ShortcutTreePanel.this.fGroupMoveInProgress) {
                        if (treePathArray != null) {
                            ShortcutTreePanel.this.fTree.setSelectionPaths(treePathArray);
                        }
                        ShortcutTreePanel.this.fTree.addSelectionPath(treePath);
                    } else {
                        ShortcutTreePanel.this.fTree.setSelectionPath(treePath);
                    }
                    ShortcutTreePanel.this.fTree.scrollPathToVisible(treePath);
                }
            }
        });
    }

    private void expandCategory(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findCategoryNode(string);
        if (defaultMutableTreeNode != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.fTree.expandPath(treePath);
        }
    }

    static {
        NONE = sRes.getString("node.category.None");
    }

    private class MyColorListener
    implements PrefListener {
        private MyColorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                ShortcutTreePanel.this.setTextColor();
            } else if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                ShortcutTreePanel.this.setBackgroundColor();
            }
        }
    }

    private class MyFocusAdapter
    extends FocusAdapter {
        private MyFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (ShortcutTreePanel.this.getSelectedItem() == null) {
                ShortcutTreePanel.this.fTree.setSelectionRow(0);
            }
        }
    }

    private class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u007f') {
                ShortcutTreePanel.this.removeFavorite();
            }
        }
    }

    private class TreeDropTarget
    implements DropTargetListener {
        private JTree iTargetTree;

        TreeDropTarget(JTree jTree) {
            this.iTargetTree = jTree;
            new DropTarget(this.iTargetTree, this);
        }

        private boolean isDroppableSpot(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
            return ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof Category || ShortcutTreePanel.getName(treePath) != null && ShortcutTreePanel.getName(treePath).equals(ShortcutUtils.getTopLevelNodeName());
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (this.isDroppableSpot(dropTargetDragEvent) && dropTargetDragEvent.isDataFlavorSupported(TransferableTreePathList.TREE_PATH_FLAVOR)) {
                dropTargetDragEvent.acceptDrag(2);
                Point point = dropTargetDragEvent.getLocation();
                TreePath treePath = ShortcutTreePanel.this.fTree.getPathForLocation(point.x, point.y);
                if (ShortcutTreePanel.this.fCurrentDragSelectionPath != treePath) {
                    ShortcutTreePanel.this.fCurrentDragSelectionPath = treePath;
                    ShortcutTreePanel.this.fTree.setSelectionPath(treePath);
                }
            } else {
                dropTargetDragEvent.rejectDrag();
                ShortcutTreePanel.this.fTree.setSelectionPath(null);
                ShortcutTreePanel.this.fCurrentDragSelectionPath = null;
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.isDroppableSpot(dropTargetDragEvent) && dropTargetDragEvent.isDataFlavorSupported(TransferableTreePathList.TREE_PATH_FLAVOR)) {
                dropTargetDragEvent.acceptDrag(2);
                Point point = dropTargetDragEvent.getLocation();
                TreePath treePath = ShortcutTreePanel.this.fTree.getPathForLocation(point.x, point.y);
                if (ShortcutTreePanel.this.fCurrentDragSelectionPath != treePath) {
                    ShortcutTreePanel.this.fCurrentDragSelectionPath = treePath;
                    ShortcutTreePanel.this.fTree.setSelectionPath(treePath);
                }
            } else {
                dropTargetDragEvent.rejectDrag();
                ShortcutTreePanel.this.fTree.setSelectionPath(null);
                ShortcutTreePanel.this.fCurrentDragSelectionPath = null;
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        private TreePath[] convertUserObjectPathsToNodePaths(Object[] objectArray) {
            if (objectArray == null) {
                return null;
            }
            TreePath[] treePathArray = new TreePath[objectArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                Object[] objectArray2 = (Object[])objectArray[i];
                Object[] objectArray3 = new Object[objectArray2.length];
                objectArray3[0] = ShortcutTreePanel.this.fTree.getModel().getRoot();
                for (int j = 1; j < objectArray3.length; ++j) {
                    objectArray3[j] = this.findChild((DefaultMutableTreeNode)objectArray3[j - 1], objectArray2[j]);
                }
                treePathArray[i] = new TreePath(objectArray3);
            }
            return treePathArray;
        }

        private DefaultMutableTreeNode findChild(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (defaultMutableTreeNode2.getUserObject() == null || !defaultMutableTreeNode2.getUserObject().toString().equals(object)) continue;
                return defaultMutableTreeNode2;
            }
            return null;
        }

        @Override
        public void drop(final DropTargetDropEvent dropTargetDropEvent) {
            Point point = dropTargetDropEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
            final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!defaultMutableTreeNode.getAllowsChildren() || !dropTargetDropEvent.isDataFlavorSupported(TransferableTreePathList.TREE_PATH_FLAVOR)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                TreePath[] treePathArray = this.convertUserObjectPathsToNodePaths((Object[])transferable.getTransferData(TransferableTreePathList.TREE_PATH_FLAVOR));
                ShortcutTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ShortcutTreePanel.this.fTree.setCursor(Cursor.getPredefinedCursor(3));
                final Map map = ShortcutTreePanel.this.getItems(treePathArray);
                if (map.isEmpty()) {
                    dropTargetDropEvent.rejectDrop();
                } else {
                    dropTargetDropEvent.acceptDrop(2);
                    ShortcutTreePanel.this.runAsGroupMove(new Runnable(){

                        @Override
                        public void run() {
                            for (Shortcut shortcut : map.keySet()) {
                                String string = ShortcutTreePanel.getParentsName(ShortcutTreePanel.this.fInitialDragTreePath);
                                if (defaultMutableTreeNode.isRoot()) {
                                    ShortcutUtils.removeShortcut(string, shortcut.getLabel());
                                    ShortcutUtils.addShortcutToBottom(shortcut.getLabel(), shortcut.getCallback(), shortcut.getIconPath(), NONE, "true");
                                } else {
                                    String string2 = ((Shortcut)defaultMutableTreeNode.getUserObject()).getLabel();
                                    ShortcutUtils.editShortcut(shortcut.getLabel(), string, shortcut.getLabel(), string2, shortcut.getCallback(), shortcut.getIconPath(), null);
                                }
                                dropTargetDropEvent.dropComplete(true);
                                ShortcutTreePanel.this.enableDisable();
                                ShortcutTreePanel.this.fTree.setCursor(Cursor.getDefaultCursor());
                                ShortcutTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    private class TreeDragSource
    implements DragSourceListener,
    DragGestureListener {
        private DragSource iSource;
        private JTree iSourceTree;

        TreeDragSource(JTree jTree, int n) {
            this.iSourceTree = jTree;
            this.iSource = new DragSource();
            this.iSource.createDefaultDragGestureRecognizer(this.iSourceTree, n, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TreePath treePath = this.iSourceTree.getSelectionPath();
            ShortcutTreePanel.this.fInitialDragTreePath = treePath;
            if (treePath == null || treePath.getPathCount() <= 1) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            TransferableTreePathList transferableTreePathList = new TransferableTreePathList(this.iSourceTree.getSelectionPaths());
            if (!(defaultMutableTreeNode.getUserObject() instanceof Category)) {
                dragGestureEvent.startDrag(MJDragCursorUtilities.getCursor((int)2), MJDragCursorUtilities.getMacImageToDrag(), new Point(0, 0), transferableTreePathList, this);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)2));
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)2));
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess()) {
                // empty if block
            }
        }
    }

    private class ShortcutRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon fIcon;

        private ShortcutRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (!(defaultMutableTreeNode.getUserObject() instanceof Shortcut)) {
                this.setText(sRes.getString("node.TopLevel"));
                this.setIcon(sFolderIcon);
            } else {
                Shortcut shortcut = (Shortcut)defaultMutableTreeNode.getUserObject();
                String string = shortcut.getLabel();
                this.fIcon = shortcut.getIcon();
                this.setIcon(this.fIcon);
                if (this.fIcon == null && shortcut instanceof Category) {
                    this.setIcon(sFolderIcon);
                }
                this.setText(string);
            }
            this.setToolTipText(null);
            this.setOpaque(!bl);
            if (!bl) {
                this.setBackground(ShortcutTreePanel.this.fBGColor);
                this.setForeground(ShortcutTreePanel.this.fTextColor);
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = dimension.width;
            int n2 = dimension.height + 4;
            return new Dimension(n, n2);
        }
    }

    private static class NewFavoriteAction
    extends MJAbstractAction {
        NewFavoriteAction() {
            super(sRes.getString("action.NewFav"));
            this.setTip(sRes.getString("action.NewFavToolTip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutEditor.invoke();
        }
    }

    private class OpenAction
    extends MJAbstractAction {
        OpenAction() {
            super("Run Shortcut");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
            ShortcutTreePanel.this.executeCommand();
            ShortcutTreePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class RefreshAction
    extends MJAbstractAction {
        RefreshAction() {
            super(sRes.getString("action.Refresh"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutTreePanel.this.refreshTree();
        }
    }

    private static class RestoreDefaultAction
    extends MJAbstractAction {
        RestoreDefaultAction() {
            super(sRes.getString("action.RestoreDefault"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsOrganizer.restoreDefaults();
        }
    }

    private class EnterAction
    extends MJAbstractAction {
        private EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutTreePanel.this.openNode(false);
        }
    }

    private class EditFavoriteAction
    extends MJAbstractAction {
        EditFavoriteAction() {
            super(sRes.getString("action.EditFav"));
            this.setTip(sRes.getString("action.EditFavToolTip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutTreePanel.this.editSelectedFavorite();
        }
    }

    private class RemoveFavoriteAction
    extends MJAbstractAction {
        RemoveFavoriteAction() {
            super(sRes.getString("action.RemoveFav"));
            this.setTip(sRes.getString("action.RemoveFavToolTip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutTreePanel.this.removeFavorite();
        }
    }

    private class FavoritesChangedListener
    implements ActionListener {
        private FavoritesChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = ShortcutTreePanel.this.fTree.getSelectionPaths();
            int n = ((ShortcutUtils.ShortcutEvent)actionEvent).getType();
            String string = ((ShortcutUtils.ShortcutEvent)actionEvent).getName();
            String string2 = ((ShortcutUtils.ShortcutEvent)actionEvent).getCategory();
            String string3 = ((ShortcutUtils.ShortcutEvent)actionEvent).getOldCategory();
            if (n == 0) {
                if (string2.equals(ShortcutUtils.getTopLevelNodeName())) {
                    ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
                } else {
                    ShortcutTreePanel.this.refreshNode(string2);
                }
                ShortcutTreePanel.this.selectItem(string2, string, treePathArray);
                ShortcutTreePanel.this.expandCategory(string2);
            } else if (n == 2) {
                ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
                ShortcutTreePanel.this.selectItem(string2, string, treePathArray);
            } else if (n == 1) {
                if (string2.equals(ShortcutUtils.getTopLevelNodeName())) {
                    ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
                } else {
                    ShortcutTreePanel.this.refreshNode(string2);
                }
            } else if (n == 5) {
                ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
            } else if (n == 4) {
                if (string2.equals(ShortcutUtils.getTopLevelNodeName()) || string3.equals(ShortcutUtils.getTopLevelNodeName())) {
                    ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
                } else if (string == null) {
                    ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
                } else {
                    ShortcutTreePanel.this.refreshNode(string2);
                    ShortcutTreePanel.this.refreshNode(string3);
                }
                ShortcutTreePanel.this.selectItem(string2, string, treePathArray);
                ShortcutTreePanel.this.expandCategory(string2);
            } else if (n == 6 || n == 7 || n == 8 || n == 9) {
                if (string2.equals(ShortcutUtils.getTopLevelNodeName()) || string3.equals(ShortcutUtils.getTopLevelNodeName())) {
                    ShortcutTreePanel.this.reloadNode(ShortcutTreePanel.this.fTopNode);
                } else {
                    ShortcutTreePanel.this.refreshNode(string2);
                    if (!string3.equals(string2)) {
                        ShortcutTreePanel.this.refreshNode(string3);
                    }
                }
                if (n == 8 || n == 9) {
                    ShortcutTreePanel.this.selectItem(string, null, treePathArray);
                } else {
                    ShortcutTreePanel.this.selectItem(string2, string, treePathArray);
                }
                ShortcutTreePanel.this.expandCategory(string2);
            } else {
                ShortcutTreePanel.this.refreshTree();
            }
        }
    }

    private class ExplorerCompletionObserver
    implements CompletionObserver {
        private ExplorerCompletionObserver() {
        }

        public void completed(int n, Object object) {
            ShortcutTreePanel.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class FavoritesMouseAdapter
    extends MouseAdapter {
        private FavoritesMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                this.doDoubleClick(mouseEvent);
            } else {
                this.showPopup(mouseEvent);
            }
        }

        public void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (ShortcutTreePanel.this.fTree.isSelectionEmpty()) {
                    return;
                }
                TreePath treePath = ShortcutTreePanel.this.fTree.getSelectionPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (!ShortcutTreePanel.this.fOpenCloseMenu.isEnabled()) {
                    ShortcutTreePanel.this.fOpenCloseMenu.setEnabled(true);
                }
                if (defaultMutableTreeNode.getChildCount() > 0 && ShortcutTreePanel.this.fTree.isExpanded(treePath)) {
                    ShortcutTreePanel.this.fOpenCloseMenu.setText(sRes.getString("action.Close"));
                } else if (defaultMutableTreeNode.getChildCount() > 0 && !ShortcutTreePanel.this.fTree.isExpanded(treePath)) {
                    ShortcutTreePanel.this.fOpenCloseMenu.setText(sRes.getString("action.Open"));
                } else if (!(defaultMutableTreeNode.getUserObject() instanceof Category)) {
                    ShortcutTreePanel.this.fOpenCloseMenu.setText(sRes.getString("action.Evaluate"));
                } else {
                    ShortcutTreePanel.this.fOpenCloseMenu.setText(sRes.getString("action.Close"));
                    ShortcutTreePanel.this.fOpenCloseMenu.setEnabled(false);
                }
                Object object = mouseEvent.getSource();
                if (object instanceof Component) {
                    ShortcutTreePanel.this.fPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
                }
                ShortcutTreePanel.this.fPopupMenu.show((Component)ShortcutTreePanel.this.fTree, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void doDoubleClick(MouseEvent mouseEvent) {
            TreePath treePath = ShortcutTreePanel.this.fTree.getSelectionPath();
            boolean bl = false;
            if (treePath != null) {
                bl = ShortcutTreePanel.this.fTree.getPathBounds(treePath).contains(mouseEvent.getPoint());
            }
            if (treePath != null && bl) {
                ShortcutTreePanel.this.openNode(true);
            }
        }
    }

    public class MyTreeSelectionListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ShortcutTreePanel.this.enableDisable();
        }
    }
}

