/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.beans.editors.BooleanEditor;
import com.mathworks.beans.editors.CallbackEditor;
import com.mathworks.beans.editors.EditorContext;
import com.mathworks.beans.editors.IEditorContextSupport;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.beans.editors.ModelessPropertyEditor;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDArrayEditor;
import com.mathworks.jmi.bean.UDDArrayIndexedEditor;
import com.mathworks.mlwidgets.inspector.AbstractTreeTableNode;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.JidePropertyItem;
import com.mathworks.mlwidgets.inspector.JidePropertyTableModel;
import com.mathworks.mlwidgets.inspector.JidePropertyViewTable;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyCellBoolean;
import com.mathworks.mlwidgets.inspector.PropertyCellCallback;
import com.mathworks.mlwidgets.inspector.PropertyCellCustom;
import com.mathworks.mlwidgets.inspector.PropertyCellCustomEdit;
import com.mathworks.mlwidgets.inspector.PropertyCellEditField;
import com.mathworks.mlwidgets.inspector.PropertyCellEnum;
import com.mathworks.mlwidgets.inspector.PropertyDialog;
import com.mathworks.mlwidgets.inspector.PropertyItemNode;
import com.mathworks.mlwidgets.inspector.PropertyRootNode;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mlwidgets.inspector.PropertyTreeTableModel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.DebugUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

public abstract class PropertyCell {
    private static final int NO_INDEX = -1;
    protected static Image sReadOnlyIcon = null;
    protected final JComponent fView;
    private final PropertyTarget fTarget;
    private PropertyTarget fChildTarget;
    private final int fItemId;
    private final NamedEditor fEditor;
    private int fIndex;
    private int fIndexCount;
    private Vector fCells;
    private boolean fHasChildren = false;
    private PropertyItemNode fItemNode;

    PropertyCell(JComponent jComponent, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        this.fView = jComponent;
        this.fItemId = n2;
        this.fEditor = namedEditor;
        this.fTarget = propertyTarget;
        this.fChildTarget = null;
        this.fIndex = -1;
        this.fCells = new Vector();
        if (this.fEditor != null) {
            this.fHasChildren = MWPropertyEditorUtils.canExpand((PropertyEditor)this.fEditor.getEditor());
            this.initIcons();
        }
    }

    void setItemNode(PropertyItemNode propertyItemNode) {
        this.fItemNode = propertyItemNode;
    }

    boolean hasChildren() {
        return this.fHasChildren;
    }

    abstract void updateComponent_EventThread();

    abstract MJPanel getEditorComponent();

    abstract MJPanel getRendererComponent();

    final PropertyTarget getChildTarget() {
        return this.fChildTarget;
    }

    protected final boolean isMixed() {
        return this.fEditor.isMixed();
    }

    private boolean isIndexedPropertyCell() {
        return this.fEditor.getEditor() instanceof UDDArrayEditor;
    }

    Vector expand(int n) {
        Vector<PropertyCell> vector = new Vector<PropertyCell>();
        PropertyTarget propertyTarget = null;
        int n2 = 1000 * (this.fItemId + 1);
        if (this.isIndexedPropertyCell()) {
            this.fIndexCount = this.fTarget.getIndexCount(this.fEditor.getName());
            for (int i = 0; i < this.fIndexCount; ++i) {
                NamedEditor namedEditor = new NamedEditor(this.fEditor.getName(), (PropertyEditor)new UDDArrayIndexedEditor(), true);
                PropertyCell propertyCell = PropertyCell.makePropertyCell(this.fView, this.fTarget, this.fItemId, n2++, namedEditor);
                propertyCell.setIndex(i);
                vector.addElement(propertyCell);
            }
        } else {
            propertyTarget = this.fIndex != -1 ? this.fTarget.getValues_MatlabThread(this.fEditor.getName(), this.fIndex) : this.fTarget.getValues_MatlabThread(this.fEditor.getName());
            this.fChildTarget = propertyTarget;
            if (propertyTarget != null) {
                while (propertyTarget.hasMoreProperties()) {
                    NamedEditor namedEditor = propertyTarget.nextProperty();
                    if (namedEditor == null) continue;
                    if (!this.fEditor.isEditable()) {
                        namedEditor.setParentReadOnly();
                    }
                    if (namedEditor.getEditor() == null || !namedEditor.isEditable()) {
                        // empty if block
                    }
                    PropertyCell propertyCell = PropertyCell.makePropertyCell(this.fView, propertyTarget, this.fItemId, n2++, namedEditor);
                    vector.addElement(propertyCell);
                }
            }
        }
        this.fCells = vector;
        return vector;
    }

    private void collapse_AnyThread() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyCell.this.collapse_EventThread();
            }
        });
    }

    private void collapse_EventThread() {
        this.collapseJideInspector_EventThread();
    }

    private void collapseJideInspector_EventThread() {
        if (this.getTreeTableView() instanceof JidePropertyViewTable && this.fItemNode != null) {
            Object object;
            Object object2;
            Object object3;
            boolean bl = false;
            final JidePropertyViewTable jidePropertyViewTable = (JidePropertyViewTable)((Object)this.getTreeTableView());
            JidePropertyTableModel jidePropertyTableModel = jidePropertyViewTable.getJideTableModel();
            for (int i = 0; i < jidePropertyTableModel.getRowCount(); ++i) {
                object3 = jidePropertyTableModel.getRowAt(i);
                if (!(object3 instanceof JidePropertyItem) || !(object2 = ((JidePropertyItem)((Object)(object = (JidePropertyItem)((Object)object3)))).getItemNode()).equals(this.fItemNode)) continue;
                bl = true;
                jidePropertyViewTable.collapseAll();
                break;
            }
            PropertyTreeTableModel propertyTreeTableModel = jidePropertyTableModel.getUnderlyingModel();
            if (bl && (object3 = propertyTreeTableModel.getRoot()) instanceof PropertyRootNode && (object2 = ((AbstractTreeTableNode)(object = (PropertyRootNode)object3)).getTarget()) != null) {
                final Object[] objectArray = ((PropertyTarget)object2).getObjects();
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        jidePropertyViewTable.setObjects_MatlabThread(objectArray, true);
                    }
                });
            }
        }
    }

    private void setIndex(int n) {
        this.fIndex = n;
    }

    final void refreshChildren_MatlabThread() {
        assert (NativeMatlab.nativeIsMatlabThread());
        if (this.fChildTarget != null) {
            boolean bl;
            Object[] objectArray = this.fChildTarget.getObjects();
            this.fChildTarget.pullInPropertyValuesFromMatlab_MatlabThread();
            Object[] objectArray2 = this.fChildTarget.getObjects();
            boolean bl2 = bl = objectArray.length != objectArray2.length;
            if (!bl) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    Object object2 = objectArray2[i];
                    if (object != null && object2 == null) {
                        bl = true;
                        continue;
                    }
                    if (object == null && object2 != null) {
                        bl = true;
                        continue;
                    }
                    if (object == null || object2 == null || object.getClass() == object2.getClass()) continue;
                    bl = true;
                }
            }
            if (bl) {
                this.collapse_AnyThread();
            }
        }
    }

    void dispose() {
    }

    void customEditorClosed() {
    }

    PropertyEditor getEditor() {
        return this.fEditor.getEditor();
    }

    String getName() {
        return this.fEditor.getName();
    }

    JComponent getTreeTableView() {
        return this.fView;
    }

    boolean isEditable() {
        return this.fEditor.isEditable();
    }

    private void initIcons() {
        if (sReadOnlyIcon == null) {
            URL uRL = PropertyCell.class.getResource("/com/mathworks/mde/inspector/resources/inspectoricon.gif");
            ImageIcon imageIcon = new ImageIcon(uRL);
            sReadOnlyIcon = imageIcon.getImage();
        }
    }

    static PropertyCell makePropertyCell(JComponent jComponent, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        PropertyCell propertyCell = null;
        PropertyEditor propertyEditor = namedEditor.getEditor();
        if (propertyEditor != null) {
            propertyCell = propertyEditor.supportsCustomEditor() ? (MWPropertyEditorUtils.supportsInPlaceEditing((PropertyEditor)propertyEditor) ? new PropertyCellCustomEdit(jComponent, propertyTarget, n, n2, namedEditor) : new PropertyCellCustom(jComponent, propertyTarget, n, n2, namedEditor)) : (propertyEditor instanceof CallbackEditor ? new PropertyCellCallback(jComponent, propertyTarget, n, n2, namedEditor) : (propertyEditor instanceof BooleanEditor ? new PropertyCellBoolean(jComponent, propertyTarget, n, n2, namedEditor) : (propertyEditor.getTags() != null ? new PropertyCellEnum(jComponent, propertyTarget, n, n2, namedEditor) : new PropertyCellEditField(jComponent, propertyTarget, n, n2, namedEditor))));
        }
        return propertyCell;
    }

    protected static final MJButton createRightSideButton(Icon icon) {
        assert (icon != null);
        MJButton mJButton = new MJButton(icon);
        mJButton.setBorder(BorderFactory.createEmptyBorder());
        mJButton.setOpaque(false);
        Dimension dimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        mJButton.setMaximumSize(dimension);
        mJButton.setPreferredSize(dimension);
        if (PlatformInfo.isWindowsModernAppearance()) {
            mJButton.setUI((ButtonUI)new BasicButtonUI());
        }
        return mJButton;
    }

    protected final Icon getIcon() {
        ImageIcon imageIcon = null;
        Image image = MWPropertyEditorUtils.getIcon((PropertyEditor)this.getEditor());
        if (image != null) {
            imageIcon = new ImageIcon(image);
        }
        return imageIcon;
    }

    protected AbstractButton createButton(PropertyEditor propertyEditor) {
        Icon icon = this.getIcon();
        MJButton mJButton = new MJButton();
        mJButton.setIcon(icon);
        mJButton.setFocusPainted(false);
        mJButton.setName("propertyinspector.invokecustomeditor");
        Dimension dimension = icon != null ? new Dimension(icon.getIconWidth() + InspectorUIResources.getIconButtonPadding(), icon.getIconHeight()) : new Dimension(InspectorUIResources.getIconButtonWidth(), InspectorUIResources.getCellHeight());
        mJButton.setOpaque(false);
        mJButton.setPreferredSize(dimension);
        mJButton.setBorder(BorderFactory.createBevelBorder(0, InspectorUIResources.getButtonHighlight(), InspectorUIResources.getButtonShadow()));
        if (this.isEditable()) {
            mJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyCell.this.invokeContentEditor();
                }
            });
        } else {
            mJButton.setEnabled(false);
        }
        return mJButton;
    }

    MJPanel createMainPanelWithNoIcon(PropertyEditor propertyEditor, JComponent jComponent) {
        return this.createMainPanelWithLeftIcon(null, jComponent);
    }

    MJPanel createMainPanelWithLeftIcon(PropertyEditor propertyEditor, JComponent jComponent) {
        BorderLayout borderLayout = new BorderLayout();
        MJPanel mJPanel = new MJPanel((LayoutManager)borderLayout);
        AbstractButton abstractButton = null;
        if (propertyEditor != null && this.isEditable()) {
            boolean bl;
            boolean bl2 = bl = propertyEditor instanceof MWPropertyEditorSupport && propertyEditor.supportsCustomEditor() && propertyEditor.getCustomEditor() == null && !((MWPropertyEditorSupport)propertyEditor).hasCustomDialog();
            if (!bl) {
                abstractButton = this.createButton(propertyEditor);
            }
        }
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        int n = InspectorUIResources.getIconHorizontalOffset();
        int n2 = InspectorUIResources.getCellHeight();
        mJPanel2.setPreferredSize(new Dimension(n, n2));
        if (abstractButton != null) {
            mJPanel2.add((Component)abstractButton, (Object)"West");
        }
        mJPanel2.setOpaque(false);
        mJPanel.add((Component)mJPanel2, (Object)"West");
        mJPanel.add((Component)jComponent, (Object)"Center");
        mJPanel.setOpaque(false);
        assert (mJPanel != null);
        return mJPanel;
    }

    protected void addCallback(JComponent jComponent) {
        if (jComponent != null && this.isEditable()) {
            jComponent.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    PropertyCell.this.invokeContentEditor();
                }
            });
        }
    }

    protected void invokeContentEditor() {
        Object object;
        PropertyEditor propertyEditor = this.getEditor();
        if (propertyEditor == null) {
            assert (DebugUtils.warning((String)("Property editor for property " + this.getName() + " is null")));
            return;
        }
        if (propertyEditor instanceof IEditorContextSupport) {
            object = new EditorContext();
            object.setValue("propertyname", (Object)this.getName());
            object.setValue("inspectedobjects", (Object)this.fTarget.getObjects());
            ((IEditorContextSupport)propertyEditor).setContext(object);
        }
        if (propertyEditor instanceof ModelessPropertyEditor) {
            object = (ModelessPropertyEditor)this.getEditor();
            object.invokeModelessEdit();
        } else if (propertyEditor instanceof MWPropertyEditorSupport && ((MWPropertyEditorSupport)propertyEditor).hasCustomDialog()) {
            ((MWPropertyEditorSupport)propertyEditor).invokeDialog();
        } else {
            JComponent jComponent;
            Container container;
            object = propertyEditor.getCustomEditor();
            if (object != null && (container = SwingUtilities.getAncestorOfClass(Frame.class, jComponent = this.getTreeTableView())) != null) {
                if (object instanceof JDialog) {
                    JDialog jDialog = (JDialog)object;
                    jDialog.setTitle(this.getName());
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(container);
                    jDialog.setVisible(true);
                } else {
                    new PropertyDialog(this.getName(), this, (Component)object, (Frame)container);
                }
            }
        }
    }
}

