/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.Property;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.inspector.AutopilotInspectorTable;
import com.mathworks.mlwidgets.inspector.AutopilotPropertyValue;
import com.mathworks.mlwidgets.inspector.AutopilotTableAccessor;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.JideCategoryRenderer;
import com.mathworks.mlwidgets.inspector.JidePropertyItem;
import com.mathworks.mlwidgets.inspector.JidePropertyTableModel;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.mlwidgets.inspector.TreeTableModelUpdateListener;
import com.mathworks.widgets.jidesoft.grid.MWPropertyTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

class JidePropertyViewTable
extends MWPropertyTable
implements AutopilotTableAccessor {
    private JidePropertyTableModel fTreeTableModel = null;
    private JidePropertyViewTable fTable = null;
    private JPopupMenu fPopup = null;
    private Property fCurrPopupProperty = null;
    private volatile Object[] fObjects = null;
    private volatile Boolean fTargetHasHelpDoc = null;
    private static HashMap<String, Boolean> sExpandedGroups = new HashMap();
    private static HashMap<String, Boolean> sExpandedProperties = new HashMap();

    JidePropertyViewTable(JidePropertyTableModel jidePropertyTableModel) {
        super((TableModel)((Object)jidePropertyTableModel));
        this.fTreeTableModel = jidePropertyTableModel;
        this.fTreeTableModel.setTable(this);
        this.fTable = this;
        this.setName("InspectorTable");
        this.setUseTableRendererForCategoryRow(true);
        this.setDefaultRenderer(Object.class, new JideCategoryRenderer());
        this.fPopup = new JPopupMenu();
        this.fPopup.setEnabled(true);
        this.fPopup.setName("ContextHelpPopup");
        JMenuItem jMenuItem = new JMenuItem(InspectorUIResources.getContextHelpLabel());
        jMenuItem.setName("ContextHelpMenu");
        jMenuItem.addActionListener(new WhatsThisAction());
        this.fPopup.add(jMenuItem);
        PopupListener popupListener = new PopupListener(this);
        this.addMouseListener(popupListener);
    }

    public void expandAll() {
        super.expandFirstLevel();
    }

    void refreshValues_MatlabThread() {
        this.fTreeTableModel.refreshValues_MatlabThread();
    }

    void cleanup_EventThread() {
        if (this.fTreeTableModel != null) {
            this.fTreeTableModel.cleanup_EventThread();
            this.serializeExpandedGroupNodes_EventThread();
        }
    }

    void addInspectorUpdateListener(TreeTableModelUpdateListener treeTableModelUpdateListener) {
        if (this.fTreeTableModel != null) {
            this.fTreeTableModel.addInspectorUpdateListener(treeTableModelUpdateListener);
        }
    }

    JidePropertyTableModel getJideTableModel() {
        return this.fTreeTableModel;
    }

    void selectProperty_AnyThread(final String string) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() {
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                JidePropertyViewTable.this.selectProperty(string);
            }
        };
        matlabWorker.start();
    }

    private void selectProperty(String string) {
        Property property = this.fTreeTableModel.getPropertyFromName_AnyThread(string);
        if (property != null && property.getName().equals(string)) {
            this.selectProperty_EventThread(property);
        }
    }

    private void selectProperty_EventThread(Property property) {
        this.setSelectedProperty(property);
        Expandable expandable = property.getParent();
        if (expandable != null) {
            expandable.setExpanded(true);
        }
    }

    static Object[] filterOutInvalidObjects(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (object instanceof UDDObject) {
                if (!((UDDObject)object).isValid()) continue;
                arrayList.add(object);
                continue;
            }
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    void setObjects_MatlabThread(Object[] objectArray, boolean bl) {
        assert (NativeMatlab.nativeIsMatlabThread());
        Object[] objectArray2 = JidePropertyViewTable.filterOutInvalidObjects(objectArray);
        this.fObjects = objectArray2;
        this.fTargetHasHelpDoc = null;
        this.setModelTargetAndStorePropertyGroups_AnyThread(objectArray2);
    }

    private void setModelTargetAndStorePropertyGroups_AnyThread(final Object[] objectArray) {
        final JidePropertyViewTable jidePropertyViewTable = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jidePropertyViewTable.getCellEditor() != null) {
                    jidePropertyViewTable.getCellEditor().stopCellEditing();
                }
                JidePropertyViewTable.this.serializeExpandedGroupNodes_EventThread();
                SetObjectWorker setObjectWorker = new SetObjectWorker(jidePropertyViewTable, objectArray);
                setObjectWorker.start();
            }
        });
    }

    private void setModelTarget_MatlabThread(final JidePropertyViewTable jidePropertyViewTable, Object[] objectArray) {
        this.fTreeTableModel.setObjects_MatlabThread((JTable)((Object)jidePropertyViewTable), objectArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jidePropertyViewTable.resizeAndRepaint();
            }
        });
    }

    private void serializeExpandedGroupNodes_EventThread() {
        assert (SwingUtilities.isEventDispatchThread());
        for (int i = 0; i < this.fTreeTableModel.getRows().size(); ++i) {
            Boolean bl;
            Property property = this.fTreeTableModel.getPropertyAt(i);
            Boolean bl2 = bl = property.isExpanded() ? Boolean.TRUE : Boolean.FALSE;
            if (this.fTreeTableModel.isCategoryRow(i)) {
                sExpandedGroups.put(property.getName(), bl);
                continue;
            }
            sExpandedProperties.put(property.getName(), bl);
        }
    }

    private void restoreExpandedGroupNodes_EventThread() {
        assert (SwingUtilities.isEventDispatchThread());
        for (int i = 0; i < this.fTreeTableModel.getRows().size(); ++i) {
            Property property = this.fTreeTableModel.getPropertyAt(i);
            if (this.fTreeTableModel.isCategoryRow(i)) {
                this.helperExpandRow(property, sExpandedGroups);
                continue;
            }
            this.helperExpandRow(property, sExpandedProperties);
        }
    }

    private void helperExpandRow(Property property, HashMap<String, Boolean> hashMap) {
        Boolean bl = hashMap.get(property.getName());
        if (bl != null && bl.booleanValue()) {
            this.fTreeTableModel.expandRow((ExpandableRow)property, true);
        }
    }

    @Override
    public AutopilotInspectorTable getAutopilotAccessor() {
        return new AutopilotTable();
    }

    private static boolean targetHasHelp_MatlabThread(Object[] objectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        boolean bl = false;
        try {
            Object object = Matlab.mtFeval((String)"inspect", (Object[])new Object[]{"-hasHelp", objectArray}, (int)1);
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void doPopupMenuAction_EventThread(JidePropertyViewTable jidePropertyViewTable, MouseEvent mouseEvent) {
        this.fCurrPopupProperty = null;
        if (mouseEvent.isPopupTrigger()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = jidePropertyViewTable.originalRowAtPoint(mouseEvent.getPoint());
            Property property = this.fTreeTableModel.getPropertyAt(n3);
            if (property != null && !property.isCategoryRow() && this.fPopup != null && this.fPopup.isEnabled()) {
                boolean bl;
                boolean bl2 = bl = 0 == this.fTreeTableModel.getOrder();
                if (bl && property.getLevel() == 1 || !bl && property.getLevel() == 0) {
                    this.fPopup.show(mouseEvent.getComponent(), n, n2);
                    this.fCurrPopupProperty = property;
                }
            }
        }
    }

    static /* synthetic */ Object[] access$502(JidePropertyViewTable jidePropertyViewTable, Object[] objectArray) {
        jidePropertyViewTable.fObjects = objectArray;
        return objectArray;
    }

    private class WhatsThisAction
    implements ActionListener {
        private WhatsThisAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    WhatsThisAction.this.showHelpWindow_MatlabThread();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showHelpWindow_MatlabThread() {
            if (JidePropertyViewTable.this.fCurrPopupProperty != null) {
                Property property = JidePropertyViewTable.this.fCurrPopupProperty;
                synchronized (property) {
                    String string = JidePropertyViewTable.this.fCurrPopupProperty.getName();
                    if (string != null) {
                        Object[] objectArray = new Object[]{"-showHelp", JidePropertyViewTable.this.fObjects, string};
                        try {
                            int n = 0;
                            Matlab.mtFeval((String)"inspect", (Object[])objectArray, (int)n);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener(JidePropertyViewTable jidePropertyViewTable2) {
            JidePropertyViewTable.this.fTable = jidePropertyViewTable2;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.maybeShowPopup_EventThread(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseReleased(mouseEvent);
        }

        private void maybeShowPopup_EventThread(MouseEvent mouseEvent) {
            if (JidePropertyViewTable.this.fTargetHasHelpDoc == null) {
                TargetHasHelpDocWorker targetHasHelpDocWorker = new TargetHasHelpDocWorker(JidePropertyViewTable.this.fObjects, JidePropertyViewTable.this.fTable, mouseEvent);
                targetHasHelpDocWorker.start();
            } else if (JidePropertyViewTable.this.fTargetHasHelpDoc.booleanValue()) {
                JidePropertyViewTable.this.doPopupMenuAction_EventThread(JidePropertyViewTable.this.fTable, mouseEvent);
            }
        }
    }

    private class TargetHasHelpDocWorker
    extends MatlabWorker {
        private Object[] iObjects;
        private MouseEvent fMouseEvent;

        TargetHasHelpDocWorker(Object[] objectArray, JidePropertyViewTable jidePropertyViewTable2, MouseEvent mouseEvent) {
            this.iObjects = objectArray;
            JidePropertyViewTable.this.fTable = jidePropertyViewTable2;
            this.fMouseEvent = mouseEvent;
        }

        public Object runOnMatlabThread() throws Exception {
            return JidePropertyViewTable.targetHasHelp_MatlabThread(this.iObjects);
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object instanceof Boolean) {
                JidePropertyViewTable.this.fTargetHasHelpDoc = (Boolean)object;
                if (JidePropertyViewTable.this.fTargetHasHelpDoc.booleanValue()) {
                    JidePropertyViewTable.this.doPopupMenuAction_EventThread(JidePropertyViewTable.this.fTable, this.fMouseEvent);
                }
            }
        }
    }

    private class AutopilotTable
    implements AutopilotInspectorTable {
        private AutopilotTable() {
        }

        @Override
        public AutopilotPropertyValue getValue(int n) {
            AutopilotPropertyValue autopilotPropertyValue = null;
            Property property = JidePropertyViewTable.this.fTreeTableModel.getPropertyAt(n);
            if (property instanceof JidePropertyItem) {
                autopilotPropertyValue = ((JidePropertyItem)property).getAutopilotAccesssor();
            }
            return autopilotPropertyValue;
        }
    }

    private class SetObjectWorker
    extends MatlabWorker {
        private Object[] iObjects;
        private JidePropertyViewTable iTable;

        SetObjectWorker(JidePropertyViewTable jidePropertyViewTable2, Object[] objectArray) {
            JidePropertyViewTable.access$502(JidePropertyViewTable.this, JidePropertyViewTable.filterOutInvalidObjects(objectArray));
            this.iTable = jidePropertyViewTable2;
        }

        public Object runOnMatlabThread() throws Exception {
            JidePropertyViewTable.this.setModelTarget_MatlabThread(this.iTable, JidePropertyViewTable.filterOutInvalidObjects(JidePropertyViewTable.this.fObjects));
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            JidePropertyViewTable.this.restoreExpandedGroupNodes_EventThread();
            PropertyView.fireAutopilotUpdateEvent();
        }
    }
}

