/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mwswing.MJTable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

class WorksheetMouseListener
extends MouseAdapter {
    private ImportTable fTable;
    private int[] fSelectedRowInterval;
    private int[] fSelectedColumnInterval;
    private int[] fAnchorCell;
    private int[] fLeadingCell;
    private ResizeDirection fResizingDirection = ResizeDirection.NONE;
    private boolean fMouseDown = false;
    private int[] fLeadSelectionModelCell;
    private Component fFocusOwner;
    private static final int BORDERHITWIDTH = 5;

    WorksheetMouseListener(ImportTable importTable) {
        this.fTable = importTable;
    }

    private ImportCellRenderer getWorksheetCellRenderer() {
        if (this.fTable == null) {
            return null;
        }
        return (ImportCellRenderer)this.fTable.getDefaultRenderer(Object.class);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        mouseWheelEvent.consume();
        MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent((Component)((Object)this.fTable), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        for (MouseWheelListener mouseWheelListener : this.fTable.getMouseWheelListeners()) {
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        if (!this.fTable.hasFocus()) {
            Window window = SwingUtilities.getWindowAncestor((Component)((Object)this.fTable));
            this.fFocusOwner = window.getFocusOwner();
            if (this.fFocusOwner == null) {
                this.fFocusOwner = window;
            }
            this.fFocusOwner.addMouseWheelListener(this);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.fFocusOwner != null) {
            this.fFocusOwner.removeMouseWheelListener(this);
            this.fFocusOwner = null;
        }
        if (this.fMouseDown) {
            this.selectToEnd(mouseEvent);
        }
        if (this.fTable.getVisibleRect().contains(mouseEvent.getPoint())) {
            return;
        }
        ImportCellRenderer importCellRenderer = this.getWorksheetCellRenderer();
        if (importCellRenderer == null) {
            return;
        }
        importCellRenderer.setHighlightLocation(-1, -1, -1, -1);
        importCellRenderer.setGlowBorderLocation(-1, -1, -1, -1);
        importCellRenderer.setHoverCell(-1, -1);
        this.fTable.setCursor(null);
        if (this.fTable.getTableHeader().getCursor() != null && this.fTable.getTableHeader().getCursor().getType() == 3) {
            this.fTable.getTableHeader().setCursor(null);
        }
        if (this.fTable instanceof TextTable) {
            ((TextTable)this.fTable).hideToolTip();
        }
        this.fTable.repaint();
    }

    static int[] getCloseButtonCell(JTable jTable, int[] nArray, double d, double d2) {
        int n;
        Rectangle rectangle = jTable.getVisibleRect();
        if (rectangle.height <= 0 || rectangle.width <= 0) {
            return new int[]{nArray[0], nArray[3]};
        }
        int n2 = jTable.rowAtPoint(new Point(rectangle.x, rectangle.y));
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = jTable.columnAtPoint(new Point(rectangle.x + rectangle.width, rectangle.y))) < 0) {
            n = jTable.getColumnCount() - 1;
        }
        Rectangle rectangle2 = jTable.getCellRect(n2, n, true);
        if ((double)rectangle.y > (double)(rectangle2.y + rectangle2.height) - d2) {
            ++n2;
        }
        if ((double)(rectangle.x + rectangle.width) < (double)rectangle2.x + d) {
            --n;
        }
        return new int[]{nArray[0] < n2 ? n2 : nArray[0], nArray[3] > n ? n : nArray[3]};
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.fMouseDown) {
            return;
        }
        int n = this.fTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.fTable.columnAtPoint(mouseEvent.getPoint());
        ResizeDirection resizeDirection = this.fResizingDirection;
        ImportCellRenderer importCellRenderer = this.getWorksheetCellRenderer();
        int n3 = importCellRenderer.getBorderedRow();
        int n4 = importCellRenderer.getBorderedColumn();
        if (this.fTable.isCellSelected(n, n2)) {
            Rectangle rectangle = this.fTable.getCellRect(n, n2, true);
            Point point = mouseEvent.getPoint();
            Cursor cursor = null;
            int[] nArray = WorksheetMouseListener.getSelectedCellBlock((MJTable)this.fTable, n, n2);
            if (n2 == nArray[2] && point.x <= rectangle.x + 5) {
                this.fResizingDirection = ResizeDirection.HORIZONTAL_LEFT;
                cursor = new Cursor(10);
            } else if (n2 == nArray[3] && point.x >= rectangle.x + rectangle.width - 5) {
                this.fResizingDirection = ResizeDirection.HORIZONTAL_RIGHT;
                cursor = new Cursor(11);
            } else if (n == nArray[0] && point.y <= rectangle.y + 5) {
                this.fResizingDirection = ResizeDirection.VERTICAL_TOP;
                cursor = new Cursor(8);
            } else if (n == nArray[1] && point.y >= rectangle.y + rectangle.height - 5) {
                this.fResizingDirection = ResizeDirection.VERTICAL_BOTTOM;
                cursor = new Cursor(9);
            } else {
                this.fResizingDirection = ResizeDirection.NONE;
            }
            if (this.fTable.isRowExcluded(n)) {
                importCellRenderer.setBorderedRow(n);
            } else if (this.fTable.isColumnExcluded(n2)) {
                importCellRenderer.setBorderedColumn(n2);
            } else {
                importCellRenderer.setBorderedRow(-1);
            }
            this.fTable.setCursor(cursor);
        } else {
            this.getWorksheetCellRenderer().setBorderedRow(-1);
            this.getWorksheetCellRenderer().setBorderedColumn(-1);
            this.fTable.setCursor(null);
            this.fResizingDirection = ResizeDirection.NONE;
        }
        this.fTable.refreshSelectionEffects(mouseEvent.getPoint());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.fMouseDown = true;
        int n2 = this.fTable.rowAtPoint(mouseEvent.getPoint());
        if (!this.fTable.isCellSelected(n2, n = this.fTable.columnAtPoint(mouseEvent.getPoint()))) {
            return;
        }
        if (this.fResizingDirection == ResizeDirection.NONE) {
            if (mouseEvent.isControlDown()) {
                ListSelectionModel listSelectionModel = this.fTable.getColumnModel().getSelectionModel();
                if (listSelectionModel.getMaxSelectionIndex() == n && listSelectionModel.getMinSelectionIndex() == n) {
                    this.fTable.getSelectionModel().removeSelectionInterval(n2, n2);
                } else {
                    listSelectionModel.removeSelectionInterval(n, n);
                }
                mouseEvent.consume();
            } else {
                this.fTable.clearSelection();
            }
        } else {
            int[] nArray = WorksheetMouseListener.getSelectedCellBlock((MJTable)this.fTable, n2, n);
            this.fSelectedRowInterval = new int[]{nArray[0], nArray[1]};
            this.fSelectedColumnInterval = new int[]{nArray[2], nArray[3]};
            this.fAnchorCell = new int[]{n2, n};
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fAnchorCell == null) {
            return;
        }
        if (this.fLeadingCell == null) {
            this.fLeadingCell = this.fAnchorCell;
        }
        mouseEvent.consume();
        int n = this.fTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.fTable.columnAtPoint(mouseEvent.getPoint());
        if (n < 0 || n2 < 0) {
            this.fTable.setCursor(null);
            return;
        }
        this.fTable.getColumnModel().getSelectionModel().setValueIsAdjusting(true);
        this.fTable.getSelectionModel().setValueIsAdjusting(true);
        if (this.fLeadSelectionModelCell == null) {
            this.fLeadSelectionModelCell = new int[]{this.fTable.getSelectionModel().getLeadSelectionIndex(), this.fTable.getColumnModel().getSelectionModel().getLeadSelectionIndex()};
        }
        if (this.fResizingDirection == ResizeDirection.VERTICAL_BOTTOM) {
            int n3 = (n = this.fSelectedRowInterval[1] + n - this.fAnchorCell[0] > this.fTable.getRowCount() ? this.fTable.getRowCount() + this.fAnchorCell[0] - this.fSelectedRowInterval[1] - 1 : n) - this.fLeadingCell[0];
            if (n3 < 0) {
                this.fTable.removeRowSelectionInterval(this.fSelectedRowInterval[1] + n - this.fAnchorCell[0], this.fSelectedRowInterval[1] + this.fLeadingCell[0] - this.fAnchorCell[0]);
                this.fTable.addRowSelectionInterval(this.fSelectedRowInterval[0], this.fSelectedRowInterval[1] + n - this.fAnchorCell[0]);
                Rectangle rectangle = this.fTable.getCellRect(this.fSelectedRowInterval[1] + n - this.fAnchorCell[0], n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y));
            } else {
                this.fTable.addRowSelectionInterval(this.fSelectedRowInterval[0], this.fSelectedRowInterval[1] + n - this.fAnchorCell[0]);
                Rectangle rectangle = this.fTable.getCellRect(this.fSelectedRowInterval[1] + n - this.fAnchorCell[0], n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y + rectangle.height));
            }
            this.fTable.setCursor(new Cursor(9));
        } else if (this.fResizingDirection == ResizeDirection.VERTICAL_TOP) {
            int n4 = (n = this.fSelectedRowInterval[0] + n - this.fAnchorCell[0] < 0 ? this.fAnchorCell[0] - this.fSelectedRowInterval[0] : n) - this.fLeadingCell[0];
            if (n4 > 0) {
                this.fTable.removeRowSelectionInterval(this.fSelectedRowInterval[0] + this.fLeadingCell[0] - this.fAnchorCell[0], this.fSelectedRowInterval[0] + n - this.fAnchorCell[0]);
                this.fTable.addRowSelectionInterval(this.fSelectedRowInterval[1], this.fSelectedRowInterval[0] + n - this.fAnchorCell[0]);
                Rectangle rectangle = this.fTable.getCellRect(this.fSelectedRowInterval[0] + n - this.fAnchorCell[0], n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y + rectangle.height));
            } else {
                this.fTable.addRowSelectionInterval(this.fSelectedRowInterval[1], this.fSelectedRowInterval[0] + n - this.fAnchorCell[0]);
                Rectangle rectangle = this.fTable.getCellRect(this.fSelectedRowInterval[0] + n - this.fAnchorCell[0], n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y));
            }
            this.fTable.setCursor(new Cursor(8));
        } else if (this.fResizingDirection == ResizeDirection.HORIZONTAL_LEFT) {
            int n5 = (n2 = this.fSelectedColumnInterval[0] + n2 - this.fAnchorCell[1] < 0 ? this.fAnchorCell[1] - this.fSelectedColumnInterval[0] : n2) - this.fLeadingCell[1];
            if (n5 > 0) {
                this.fTable.removeColumnSelectionInterval(this.fSelectedColumnInterval[0] + this.fLeadingCell[1] - this.fAnchorCell[1], this.fSelectedColumnInterval[0] + n2 - this.fAnchorCell[1]);
                this.fTable.addColumnSelectionInterval(this.fSelectedColumnInterval[1], this.fSelectedColumnInterval[0] + n2 - this.fAnchorCell[1]);
                Rectangle rectangle = this.fTable.getCellRect(n, this.fSelectedColumnInterval[0] + n2 - this.fAnchorCell[1], false);
                this.fTable.refreshSelectionEffects(new Point(rectangle.x + rectangle.width, mouseEvent.getPoint().y));
            } else {
                this.fTable.addColumnSelectionInterval(this.fSelectedColumnInterval[1], this.fSelectedColumnInterval[0] + n2 - this.fAnchorCell[1]);
                Rectangle rectangle = this.fTable.getCellRect(n, this.fSelectedColumnInterval[0] + n2 - this.fAnchorCell[1], false);
                this.fTable.refreshSelectionEffects(new Point(rectangle.x, mouseEvent.getPoint().y));
            }
            this.fTable.setCursor(new Cursor(10));
        } else if (this.fResizingDirection == ResizeDirection.HORIZONTAL_RIGHT) {
            int n6 = (n2 = this.fSelectedColumnInterval[1] + n2 - this.fAnchorCell[1] > this.fTable.getColumnCount() ? this.fTable.getColumnCount() + this.fAnchorCell[1] - this.fSelectedColumnInterval[1] - 1 : n2) - this.fLeadingCell[1];
            if (n6 < 0) {
                this.fTable.removeColumnSelectionInterval(this.fSelectedColumnInterval[1] + n2 - this.fAnchorCell[1], this.fSelectedColumnInterval[1] + this.fLeadingCell[1] - this.fAnchorCell[1]);
                this.fTable.addColumnSelectionInterval(this.fSelectedColumnInterval[0], this.fSelectedColumnInterval[1] + n2 - this.fAnchorCell[1]);
                Rectangle rectangle = this.fTable.getCellRect(n, this.fSelectedColumnInterval[1] + n2 - this.fAnchorCell[1], false);
                this.fTable.refreshSelectionEffects(new Point(rectangle.x, mouseEvent.getPoint().y));
            } else {
                this.fTable.addColumnSelectionInterval(this.fSelectedColumnInterval[0], this.fSelectedColumnInterval[1] + n2 - this.fAnchorCell[1]);
                Rectangle rectangle = this.fTable.getCellRect(n, this.fSelectedColumnInterval[1] + n2 - this.fAnchorCell[1], false);
                this.fTable.refreshSelectionEffects(new Point(rectangle.x + rectangle.width, mouseEvent.getPoint().y));
            }
            this.fTable.setCursor(new Cursor(11));
        } else {
            this.fTable.setCursor(null);
        }
        this.fTable.scrollRectToVisible(new Rectangle(mouseEvent.getPoint().x, mouseEvent.getPoint().y, 1, 1));
        this.fLeadingCell = new int[]{n, n2};
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.fAnchorCell = null;
        this.fLeadingCell = null;
        this.fMouseDown = false;
        this.fLeadSelectionModelCell = null;
        this.fTable.getColumnModel().getSelectionModel().setValueIsAdjusting(false);
        this.fTable.getSelectionModel().setValueIsAdjusting(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.fAnchorCell != null) {
            mouseEvent.consume();
            return;
        }
        this.fTable.requestFocus();
    }

    static int[] getSelectedCellBlock(MJTable mJTable, int n, int n2) {
        if (!mJTable.isCellSelected(n, n2)) {
            return null;
        }
        int[] nArray = ((IntervalSelectionModel)mJTable.getSelectionModel()).getSelectedCellBlock(n);
        int[] nArray2 = ((IntervalSelectionModel)mJTable.getColumnModel().getSelectionModel()).getSelectedCellBlock(n2);
        if (nArray == null || nArray2 == null) {
            return null;
        }
        return new int[]{nArray[0], nArray[1], nArray2[0], nArray2[1]};
    }

    public void selectToEnd(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        Rectangle rectangle = this.fTable.getVisibleRect();
        if (point.x > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width - 1;
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x + 1;
        }
        if (point.y > rectangle.y + rectangle.height) {
            point.y = rectangle.y + rectangle.height - 1;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y + 1;
        }
        int n2 = this.fTable.getSelectionModel().getLeadSelectionIndex();
        int n3 = this.fTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        int n4 = this.fTable.getSelectionModel().getAnchorSelectionIndex();
        int n5 = this.fTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        int n6 = this.fTable.rowAtPoint(point);
        int n7 = this.fTable.columnAtPoint(point);
        int n8 = n3 - n5 > 0 ? 1 : -1;
        int n9 = n = n7 - n5 > 0 ? 1 : -1;
        if (n7 > 0 && point.x < rectangle.x || n7 < this.fTable.getColumnCount() && point.x > rectangle.x + rectangle.width) {
            return;
        }
        if (n6 >= 0 && n7 >= 0) {
            if (n8 == n) {
                this.fTable.getSelectionModel().addSelectionInterval(n2, n6);
                this.fTable.getColumnModel().getSelectionModel().addSelectionInterval(n3, n7);
            } else {
                this.fTable.getSelectionModel().removeSelectionInterval(n2, n4);
                this.fTable.getColumnModel().getSelectionModel().removeSelectionInterval(n3, n5);
                this.fTable.getSelectionModel().addSelectionInterval(n4, n6);
                this.fTable.getColumnModel().getSelectionModel().addSelectionInterval(n5, n7);
            }
            this.fTable.getSelectionModel().setAnchorSelectionIndex(n4);
            this.fTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n5);
        }
    }

    private static enum ResizeDirection {
        HORIZONTAL_LEFT,
        HORIZONTAL_RIGHT,
        VERTICAL_TOP,
        VERTICAL_BOTTOM,
        NONE;

    }
}

