/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.widgets.spreadsheet.SpreadsheetScrollPane;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class VariableNamePanel
extends MJPanel {
    private MJTextField fTextField;
    private MJLabel fTextLabel;
    private String iCurrentName;
    private ImportTable fTable;
    private SpreadsheetScrollPane fScrollPane;
    private EditorMouseFocusLostListener fEditorMouseFocusLostListener = new EditorMouseFocusLostListener();
    private int fClickCount = 0;
    private Popup fTooltipPopup;

    private static void decorateTextComponent(JComponent jComponent, ImportTable importTable) {
        boolean bl;
        Color color = importTable.getTableHeader().getBackground();
        Color color2 = importTable.getTableHeader().getForeground();
        Color color3 = new Color(255, 255, 255, 200);
        jComponent.setBackground(color3);
        jComponent.setForeground(color2);
        Color color4 = importTable.getGridColor();
        Color color5 = new Color(color4.getRed(), color4.getGreen(), color4.getBlue(), 50);
        jComponent.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, color5));
        if (importTable instanceof TextTable && !(bl = ((VariableHeaderRenderer)((Object)importTable.getTableHeader().getDefaultRenderer())).getVariableNamesVisible())) {
            jComponent.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, color5));
        }
        jComponent.setOpaque(false);
        jComponent.setFont(importTable.getFont().deriveFont(1));
    }

    VariableNamePanel(SpreadsheetScrollPane spreadsheetScrollPane, ImportTable importTable, String string) {
        super((LayoutManager)new BorderLayout());
        this.fScrollPane = spreadsheetScrollPane;
        this.setOpaque(false);
        this.fTextField = new MJTextField(string);
        this.fTextField.setVisible(false);
        this.fTextLabel = new MJLabel(string);
        this.fTextLabel.setName("ImportTool:GroupVariableNameLabel");
        this.fTextField.setName("ImportTool:GroupVariableNameTextField");
        this.fTextLabel.setHorizontalAlignment(0);
        this.fTextField.setHorizontalAlignment(0);
        this.fTextLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.fTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        VariableNamePanel.decorateTextComponent((JComponent)this.fTextField, importTable);
        VariableNamePanel.decorateTextComponent((JComponent)this.fTextLabel, importTable);
        Color color = importTable.getTableHeader().getBackground();
        Color color2 = importTable.getTableHeader().getForeground();
        Color color3 = new Color(255, 255, 255, 200);
        this.iCurrentName = string;
        this.fTable = importTable;
        this.setBorder(null);
        this.add((Component)this.fTextLabel, "Center");
        this.setPreferredSize(new Dimension(importTable.getWidth(), 20));
        this.setBackground(color3);
        this.setForeground(color2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                VariableNamePanel.this.fTextLabel.setForeground(Color.BLACK);
                VariableNamePanel.this.fTextLabel.setBackground(Color.WHITE);
                VariableNamePanel.this.fTextField.setForeground(Color.BLACK);
                VariableNamePanel.this.fTextField.setBackground(Color.WHITE);
                VariableNamePanel.this.fTextLabel.setBorder(BorderFactory.createBevelBorder(1));
                VariableNamePanel.this.fTextField.setBorder(BorderFactory.createBevelBorder(1));
                VariableNamePanel.this.fTextLabel.setOpaque(true);
                VariableNamePanel.this.fTextField.setOpaque(true);
                VariableNamePanel.this.setCursor(Cursor.getPredefinedCursor(2));
                VariableNamePanel.this.showTooltip(mouseEvent.getLocationOnScreen());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                if (VariableNamePanel.this.fTextLabel.isVisible()) {
                    VariableNamePanel.decorateTextComponent((JComponent)VariableNamePanel.this.fTextField, VariableNamePanel.this.fTable);
                    VariableNamePanel.decorateTextComponent((JComponent)VariableNamePanel.this.fTextLabel, VariableNamePanel.this.fTable);
                }
                JRootPane jRootPane = VariableNamePanel.this.getRootPane();
                jRootPane.setToolTipText(null);
                VariableNamePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                if (VariableNamePanel.this.fTooltipPopup != null) {
                    VariableNamePanel.this.fTooltipPopup.hide();
                    VariableNamePanel.this.fTooltipPopup = null;
                }
            }
        };
        this.fTextLabel.addMouseListener((MouseListener)mouseAdapter);
        this.fTextField.addMouseListener((MouseListener)mouseAdapter);
        this.fTextLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                VariableNamePanel.this.fClickCount++;
                if (VariableNamePanel.this.fClickCount >= 2 && VariableNamePanel.this.fTextLabel.isVisible()) {
                    VariableNamePanel.this.enableEditor();
                }
            }
        });
        this.fTextLabel.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(mouseEvent);
                VariableNamePanel.this.fTextLabel.setForeground(Color.BLACK);
                VariableNamePanel.this.fTextLabel.setBackground(Color.WHITE);
                VariableNamePanel.this.fTable.getTableHeader().setToolTipText(ImportToolUtils.getResourceString("variablename.editmatrix.tooltip"));
            }
        });
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    VariableNamePanel.this.saveAndCloseEditor();
                }
            }
        });
        this.fTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableNamePanel.this.fTable.requestFocusInWindow();
            }
        });
        this.fTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                super.keyPressed(keyEvent);
                if (keyEvent.getKeyCode() == 27) {
                    VariableNamePanel.this.fTextField.setText(VariableNamePanel.this.iCurrentName);
                    VariableNamePanel.this.fTable.requestFocusInWindow();
                }
            }
        });
        this.fTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                VariableNamePanel.this.revalidate();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                VariableNamePanel.this.revalidate();
            }
        });
    }

    private void showTooltip(Point point) {
        if (this.fTooltipPopup != null) {
            this.fTooltipPopup.hide();
            this.fTooltipPopup = null;
        }
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(ImportToolUtils.getResourceString("variablename.editmatrix.tooltip"));
        this.fTooltipPopup = PopupFactory.getSharedInstance().getPopup((Component)this.fTextLabel, jToolTip, point.x, this.getLocationOnScreen().y + 25);
        this.fTooltipPopup.show();
        Timer timer = new Timer(ToolTipManager.sharedInstance().getDismissDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VariableNamePanel.this.fTooltipPopup != null) {
                    VariableNamePanel.this.fTooltipPopup.hide();
                    VariableNamePanel.this.fTooltipPopup = null;
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void doLayout() {
        if (this.fTable.showMatrixHeadervariableWarning()) {
            this.fTextLabel.setIcon((Icon)VariableHeaderRenderer.sWarningIcon);
            this.fTextLabel.setToolTipText(ImportToolUtils.getResourceString("variablewarn.tooltip"));
        } else {
            this.fTextLabel.setIcon(null);
            this.fTextLabel.setToolTipText(null);
        }
        super.doLayout();
    }

    void enableEditor() {
        this.fTextField.setVisible(true);
        this.fTextLabel.setVisible(false);
        this.add((Component)this.fTextField, "Center");
        this.fTextField.selectAll();
        this.fTextField.requestFocusInWindow();
        this.fTextField.getCaret().setVisible(true);
        this.revalidate();
        this.repaint();
        long l = 16L;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fEditorMouseFocusLostListener, l);
    }

    void saveAndCloseEditor() {
        this.iCurrentName = this.fTextField.getText();
        this.fTextLabel.setText(this.iCurrentName);
        this.add((Component)this.fTextLabel, "Center");
        this.fTextField.setVisible(false);
        this.fTextLabel.setVisible(true);
        this.fTextLabel.setBackground(this.fTable.getTableHeader().getBackground());
        this.fTextLabel.setForeground(this.fTable.getTableHeader().getForeground());
        this.fTable.updateWarningIcon();
        this.revalidate();
        this.repaint();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fEditorMouseFocusLostListener);
        this.fClickCount = 0;
        this.fTable.processMatrixVarNameEdit(this.iCurrentName);
    }

    public String getVariableName() {
        return this.fTextField.getText();
    }

    void updateBorders() {
        VariableNamePanel.decorateTextComponent((JComponent)this.fTextField, this.fTable);
        VariableNamePanel.decorateTextComponent((JComponent)this.fTextLabel, this.fTable);
    }

    public void setVariableName(String string) {
        this.fTextLabel.setText(string);
        this.fTextField.setText(string);
        this.fTable.setMatrixVariableName(string);
    }

    public void paint(Graphics graphics) {
        Color color = new Color(255, 255, 255, 200);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(color);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paint(graphics);
    }

    public static class VariableNamePanelLayout
    implements LayoutManager {
        private MJPanel iTopPanel;
        private JTable iTable;

        public VariableNamePanelLayout(MJPanel mJPanel, JTable jTable) {
            this.iTopPanel = mJPanel;
            this.iTable = jTable;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            for (Component component : container.getComponents()) {
                if (component.equals(this.iTopPanel)) {
                    Rectangle rectangle = this.iTable.getVisibleRect();
                    Point point = SwingUtilities.convertPoint(this.iTable, new Point(rectangle.x, rectangle.y), container);
                    Container container2 = SwingUtilities.getAncestorOfClass(JScrollPane.class, this.iTable);
                    int n = point.x;
                    int n2 = 0;
                    if (container2 != null && ((JScrollPane)container2).getVerticalScrollBar() != null) {
                        n2 = ((JScrollPane)container2).getVerticalScrollBar().getWidth() + ((JComponent)container2).getBorder().getBorderInsets((Component)container2).right;
                    }
                    int n3 = container.getWidth() - n2 - n;
                    Rectangle rectangle2 = this.iTable.getCellRect(0, this.iTable.getColumnCount() - 1, true);
                    int n4 = rectangle2.x + rectangle2.width - rectangle.x;
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    VariableHeaderRenderer variableHeaderRenderer = (VariableHeaderRenderer)((Object)this.iTable.getTableHeader().getDefaultRenderer());
                    if (this.iTable.getColumnCount() > 0) {
                        Rectangle rectangle3 = variableHeaderRenderer.getGroupVarNameBounds(0, this.iTable.getTableHeader().getColumnModel().getColumn(0).getHeaderValue());
                        component.setBounds(n, rectangle3.y, n3, this.iTopPanel.getPreferredSize().height);
                        continue;
                    }
                    component.setBounds(point.x, 0, container.getWidth(), this.iTopPanel.getPreferredSize().height);
                    continue;
                }
                component.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    class EditorMouseFocusLostListener
    implements AWTEventListener {
        EditorMouseFocusLostListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (VariableNamePanel.this.fTextField.isVisible() && mouseEvent.getClickCount() > 0 && mouseEvent.getID() == 501 && !(mouseEvent.getSource() instanceof MJMenuItem)) {
                    Point point = mouseEvent.getLocationOnScreen();
                    Rectangle rectangle = VariableNamePanel.this.fTextField.getBounds();
                    Point point2 = VariableNamePanel.this.fTextField.getLocationOnScreen();
                    rectangle.x = point2.x;
                    rectangle.y = point2.y;
                    if (!rectangle.contains(point) && VariableNamePanel.this.fTextField.hasFocus()) {
                        VariableNamePanel.this.saveAndCloseEditor();
                        VariableNamePanel.this.fTable.requestFocus();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

