/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.JTable;

class TextCellRenderer
extends ImportCellRenderer {
    private Font fDefaultFont;
    private boolean fFixedWidth = false;
    private static Color HOVER_SPLITTER_HIGHLIGHT_COLOR = new Color(0, 0, 255, 25);
    protected int fHoverSplitterColumn = -1;

    TextCellRenderer() {
        TextCellRenderer.createFormats();
        this.fDefaultFont = this.getFont();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.getOverlayLabel() == null || !(this.fOverlayLabel instanceof OverlayTextLabel)) {
            this.setOverlayLabel(new OverlayTextLabel(jTable));
        }
        OverlayTextLabel overlayTextLabel = (OverlayTextLabel)this.getOverlayLabel();
        if (object != null) {
            overlayTextLabel.setText(object.toString());
        } else {
            overlayTextLabel.setText("");
        }
        overlayTextLabel.setOverlayText(null, false);
        overlayTextLabel.setTable(jTable);
        overlayTextLabel.setFixedWidth(this.fFixedWidth);
        if (this.fFixedWidth) {
            if (n2 == this.fHoverSplitterColumn) {
                overlayTextLabel.setHoverSplitterColumn(true);
            } else {
                overlayTextLabel.setHoverSplitterColumn(false);
            }
            if (n2 == this.fHoverSplitterColumn - 1) {
                overlayTextLabel.setEndHoverSplitterColumn(true);
            } else {
                overlayTextLabel.setEndHoverSplitterColumn(false);
            }
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public Font getRenderedFont() {
        return this.getOverlayLabel().getFont();
    }

    public int getStringWidth(String string, JTable jTable) {
        return this.getFontMetrics(this.getFixedWidthFont()).stringWidth(string);
    }

    private Font getFixedWidthFont() {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, "Monospaced");
        hashMap.put(TextAttribute.SIZE, this.getFont().getSize());
        hashMap.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        Font font = Font.getFont(hashMap);
        return font;
    }

    public boolean isFixedWidth() {
        return this.fFixedWidth;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.fFixedWidth) {
            Font font2 = this.getFixedWidthFont();
            super.setFont(font2);
            if (this.getOverlayLabel() != null) {
                this.getOverlayLabel().setFont(font2);
            }
        }
    }

    public void setFixedWidth(boolean bl) {
        if (this.fFixedWidth == bl) {
            return;
        }
        this.fFixedWidth = bl;
        if (bl) {
            Font font = this.getFixedWidthFont();
            this.setFont(font);
        } else {
            this.setFont(this.fDefaultFont);
        }
    }

    public static void setColor(String string, Color color) {
        if (string.toUpperCase().equals("HOVER_SPLITTER_HIGHLIGHT_COLOR")) {
            HOVER_SPLITTER_HIGHLIGHT_COLOR = color;
        } else {
            ImportCellRenderer.setColor(string, color);
        }
    }

    public static Color getColor(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("HOVER_SPLITTER_HIGHLIGHT_COLOR")) {
            return HOVER_SPLITTER_HIGHLIGHT_COLOR;
        }
        return null;
    }

    public int getHoverSplitterColumn() {
        return this.fHoverSplitterColumn;
    }

    public void setHoverSplitterColumn(int n) {
        this.fHoverSplitterColumn = n;
    }

    static class OverlayTextLabel
    extends ImportCellRenderer.OverlayLabel {
        private boolean fFixedWidth = false;
        private boolean fHoverSplitterColumn = false;
        private boolean fEndHoverSplitterColumn = false;

        OverlayTextLabel(JTable jTable) {
            super(jTable);
        }

        public boolean isFixedWidth() {
            return this.fFixedWidth;
        }

        public void setFixedWidth(boolean bl) {
            this.fFixedWidth = bl;
        }

        public boolean isHoverSplitterColumn() {
            return this.fHoverSplitterColumn;
        }

        public boolean isEndHoverSplitterColumn() {
            return this.fEndHoverSplitterColumn;
        }

        public void setEndHoverSplitterColumn(boolean bl) {
            this.fEndHoverSplitterColumn = bl;
        }

        public void setHoverSplitterColumn(boolean bl) {
            this.fHoverSplitterColumn = bl;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Rectangle rectangle = this.getBounds();
            if (this.fFixedWidth) {
                graphics2D.setColor(this.fLineColor);
                graphics2D.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height);
                if (this.fHoverSplitterColumn) {
                    graphics2D.setColor(HOVER_SPLITTER_HIGHLIGHT_COLOR);
                    graphics2D.fillRoundRect(0, 0, 4, rectangle.height, 2, 2);
                }
                if (this.fEndHoverSplitterColumn) {
                    graphics2D.setColor(HOVER_SPLITTER_HIGHLIGHT_COLOR);
                    graphics2D.fillRoundRect(rectangle.width - 4, 0, 4, rectangle.height, 2, 2);
                }
            }
            graphics2D.dispose();
        }
    }
}

