/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class NonNumericRowExcludeRule
extends WorksheetRule {
    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    @Override
    public Object clone() {
        return new NonNumericRowExcludeRule();
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.nonnumrowexcludesummary");
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        boolean bl = WorksheetRule.isRuleFollowedByDateRule(list, this);
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.excluderownonnumeric"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        if (WorksheetRule.rulesNeedNaNConvert(list)) {
            generatedCode.addCode(" = ~all(cellfun(@(x) isnumeric(x) || islogical(x),");
        } else {
            generatedCode.addCode(" = ~all(cellfun(@(x) (isnumeric(x) || islogical(x)) && ~isnan(x),");
        }
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("),2); % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcellrow"));
        generatedCode.addCode("\n");
        NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getRawCellArray());
        if (generatedCode.usesCellVectors()) {
            NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getCellVectors());
        }
        if (bl) {
            NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getDateArray());
        }
    }

    private static void generateExcludeRows(GeneratedCode generatedCode, String string) {
        generatedCode.addCode(string);
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        generatedCode.addCode(",:) = [];\n");
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("excludeRowFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.nonnumericcells");
    }
}

