/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetCellRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class NonNumericReplacementRule
extends WorksheetReplacementRule {
    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.REPLACE;
    }

    public NonNumericReplacementRule(WorksheetRule worksheetRule) {
        super(worksheetRule);
    }

    public NonNumericReplacementRule() {
    }

    @Override
    public Object clone() {
        NonNumericReplacementRule nonNumericReplacementRule = new NonNumericReplacementRule(this);
        return nonNumericReplacementRule;
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.nonnumreplacesummary") + " " + Double.toString(this.getReplacementNumber());
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.replacecolnonnumericrows"));
        generatedCode.addCode(" ");
        generatedCode.addCode(Double.toString(this.fReplacementNumber));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getReplacementIndex());
        if (WorksheetRule.rulesNeedNaNConvert(list)) {
            generatedCode.addCode(" = cellfun(@(x) ~isnumeric(x) && ~islogical(x),");
        } else {
            generatedCode.addCode(" = cellfun(@(x) (~isnumeric(x) && ~islogical(x)) || isnan(x),");
        }
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("); % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcell"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getReplacementIndex());
        generatedCode.addCode(") = {");
        if (Double.isInfinite(this.fReplacementNumber)) {
            generatedCode.addCode(WorksheetCellRenderer.formatDouble(this.fReplacementNumber));
        } else {
            generatedCode.addCode(Double.toString(this.fReplacementNumber));
        }
        generatedCode.addCode("}; % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.replacenonnumcomment"));
        generatedCode.addCode("\n");
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("nonNumericReplaceFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.nonnumeric");
    }
}

