/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.Fader;
import com.mathworks.mlwidgets.importtool.FadingAcknowledgementWindow;
import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportDataSource;
import com.mathworks.mlwidgets.importtool.ImportSelectionManager;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.Importer;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.TextTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.VariableNamePanel;
import com.mathworks.mlwidgets.importtool.WorksheetMouseListener;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceChange;
import com.mathworks.mlwidgets.workspace.WorkspaceObserver;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTable;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.CellLocation;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetScrollPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class ImportTable
extends AbstractSpreadsheetTable
implements WorkspaceObserver,
Importer,
AbstractFileTableModel.WorksheetCachedDataListener {
    protected List<AbstractFileTableModel.WorksheetCachedDataListener> fWorksheetCachedDataListeners = new ArrayList<AbstractFileTableModel.WorksheetCachedDataListener>();
    protected CopyAction fCopyAction;
    protected WorksheetMouseListener fWorksheetMouseListener;
    protected boolean fTABFocusKeyHit = false;
    private int fVariableNamesHighlightRow = -1;
    private HashMap<Integer, String> fColumnVarNames = new HashMap();
    private HashMap<Integer, Boolean> fColumnVarNameWarningStates = new HashMap();
    private String fMatrixVarName;
    private String fDefaultMatrixVarName;
    private boolean fMatrixVarNameWarningState = false;
    private ImportClient.TargetType fTargetType = ImportClient.TargetType.COLUMNVECTORS;
    private VariableNamePanel fVariableNamePanel;
    protected ImportSelectionManager fImportSelectionModel;
    protected ImportAction fImportAction;
    protected ImportCellRenderer fCellRenderer;
    protected static final double ZOOM_OUT_SCALE_FACTOR = 0.9;
    protected static final double ZOOM_IN_SCALE_FACTOR = 1.1;
    private static double COPYCELLTHRESHOLD = 10000.0;
    protected static List<String> sImportedVariableNames = new ArrayList<String>();
    protected volatile WhosInformation fCachedWhosInformation;
    protected static final int COLUMN_RESIZE_TOLERANCE = 3;
    protected transient MouseListener fTmel;
    protected transient MouseAdapter fThmel;
    protected Point fMouseReleasedLocation;
    protected Point fHeaderMouseReleaseLocation;
    private IntervalSelectionModel fTemporarySelectionModel = new IntervalSelectionModel();
    private TableColumnModel fTemporarySelectionColumnModel = new DefaultTableColumnModel();
    private HoverTimer fHoverTimer;
    private Point fLastPopupMenuLocation;
    protected static final int MAX_STR_LEN = 30;

    public ImportTable(TableModel tableModel) {
        super(tableModel);
        this.installEditorsAndRenderersForFormat();
        this.setHorizontalAutoScrollEnabled(true);
        ImportTableHeader importTableHeader = new ImportTableHeader(this.getColumnModel());
        importTableHeader.setOpaque(false);
        importTableHeader.setReorderingAllowed(false);
        importTableHeader.setTable((JTable)((Object)this));
        this.setTableHeader(importTableHeader);
        this.fHeaderRenderer = this.createColumnHeaderRenderer((JTable)((Object)this));
        this.getTableHeader().setDefaultRenderer((TableCellRenderer)this.fHeaderRenderer);
        this.fEditable = false;
        this.setFocusTraversalKeysEnabled(false);
        this.fImportAction = new ImportAction(this);
        this.initActions();
        this.bindKeysAsPerSpreadsheet();
        this.setupContextMenu();
        this.fThmel = new TableHeaderMouseEventListener();
        this.getTableHeader().addMouseListener(this.fThmel);
        this.getTableHeader().addMouseMotionListener(this.fThmel);
        if (Matlab.isMatlabAvailable()) {
            MatlabWorkspaceListener.addWorkspaceChangeObserver(this);
        }
        if (PlatformInfo.isMacintosh() && Matlab.isMatlabAvailable()) {
            this.setGridColor(this.fHeaderRenderer.getPreferredGridColor());
        }
        this.fImportSelectionModel = new ImportSelectionManager(this);
        this.getColumnModel().setSelectionModel(this.fImportSelectionModel.getColumnSelectionModel());
        this.fImportSelectionModel.getColumnSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ImportTable.this.getMousePosition() != null) {
                    ImportTable.this.refreshSelectionEffects(ImportTable.this.getMousePosition());
                }
                if (Matlab.isMatlabAvailable()) {
                    ImportTable.this.fCopyAction.setEnabled(!ImportTable.this.fImportSelectionModel.isSelectionEmpty());
                }
                ImportTable.this.getTableHeader().repaint();
                ImportTable.this.repaint();
            }
        });
        this.setSelectionModel(this.fImportSelectionModel.getRowSelectionModel());
        this.fImportSelectionModel.getRowSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (Matlab.isMatlabAvailable()) {
                    ImportTable.this.fCopyAction.setEnabled(!ImportTable.this.fImportSelectionModel.isSelectionEmpty());
                }
                ImportTable.this.refreshSelectionEffects(ImportTable.this.getMousePosition());
                ImportTable.this.repaint();
            }
        });
        this.fWorksheetMouseListener = new WorksheetMouseListener(this);
        this.enableEvents(48L);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getModifiers() == 2) {
                    ImportTable.this.zoom(1.0 - (double)mouseWheelEvent.getWheelRotation() / 20.0);
                    return;
                }
                if (ImportTable.this.getParent() != null) {
                    ImportTable.this.getParent().dispatchEvent(mouseWheelEvent);
                }
                if (ImportTable.this.fWorksheetMouseListener != null) {
                    ImportTable.this.fWorksheetMouseListener.mouseMoved(mouseWheelEvent);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                super.keyPressed(keyEvent);
                if (keyEvent.getKeyCode() == 27) {
                    ImportTable.this.clearAllSelection();
                }
            }
        });
        if (tableModel instanceof AbstractFileTableModel) {
            ((AbstractFileTableModel)tableModel).addWorksheetCachedDataListener(this);
        }
    }

    protected abstract void initActions();

    protected abstract void setupContextMenu();

    private HashMap<Integer, String> getColumnVarNames() {
        return this.fColumnVarNames;
    }

    boolean allowColumnExcludeRuleEvaluation() {
        return ((AbstractFileTableModel)this.getModel()).allowColumnExcludeRuleEvaluation(this.getSelectionModel());
    }

    private String[] getDefaultColumnVarNames(int n) {
        String[] stringArray = ((AbstractFileTableModel)this.getModel()).getDefaultColumnVarNames(n);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        for (int i = 0; i < (stringArray2.length > 100 ? 100 : stringArray2.length); ++i) {
            stringArray2[i] = this.genVarName(stringArray[i]);
        }
        return stringArray2;
    }

    public String[] getColumnVariableNamesArray() {
        return this.filterColumnVarNames(((AbstractFileTableModel)this.getModel()).getDefaultColumnVarNames(this.getHeaderRow()));
    }

    public String[] getNonConflictingColumnVariableNamesArray() {
        return this.filterColumnVarNames(this.getDefaultColumnVarNames(this.getHeaderRow()));
    }

    private String[] filterColumnVarNames(String[] stringArray) {
        HashMap<Integer, String> hashMap = this.getColumnVarNames();
        String[] stringArray2 = new String[this.getColumnCount()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = hashMap != null && hashMap.containsKey(i) ? hashMap.get(i) : (stringArray != null && i < stringArray.length ? stringArray[i] : "VarName" + Integer.toString(i + 1));
        }
        return stringArray2;
    }

    public String[] getSelectedColumnVariableNames() {
        if (this.isMatrix() || this.isCellArray()) {
            return new String[]{this.getMatrixVariableName()};
        }
        int[] nArray = this.getSelectedColumns();
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = this.getColumnVariableNamesArray();
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            int n = nArray[i];
            stringArray[i] = string = stringArray2[n];
        }
        return stringArray;
    }

    public List<int[]> getSelectedRowsAfterRules() {
        if (this.getSelectedRowCount() <= 0) {
            return new ArrayList<int[]>();
        }
        List<int[]> list = ((IntervalSelectionModel)this.getSelectionModel()).getSelectedIntervals();
        ArrayList<int[]> arrayList = new ArrayList();
        int n = this.getHeaderRow();
        if (this.isHeaderRowExcluded() && this.isRowSelected(n)) {
            for (int i = 0; i < list.size(); ++i) {
                int n2 = list.get(i)[0];
                int n3 = list.get(i)[1];
                if (n2 <= n && n3 >= n) {
                    if (n2 == n3) continue;
                    int n4 = n;
                    int n5 = n;
                    if (n2 < n) {
                        n4 = n - 1;
                    } else {
                        n2 = n + 1;
                        n4 = n3;
                    }
                    if (n3 > n) {
                        n5 = n + 1;
                    } else {
                        n3 = n - 1;
                        n5 = n2;
                    }
                    if (n5 != n2) {
                        arrayList.add(new int[]{n2, n4});
                        arrayList.add(new int[]{n5, n3});
                        continue;
                    }
                    arrayList.add(new int[]{n2, n3});
                    continue;
                }
                arrayList.add(new int[]{n2, n3});
            }
        } else {
            arrayList = list;
        }
        return arrayList;
    }

    public int getSelectedRowCountAfterRules() {
        List<int[]> list = this.getSelectedRowsAfterRules();
        return list != null ? list.size() : 0;
    }

    void setCachedWhosInformation(WhosInformation whosInformation) {
        this.fCachedWhosInformation = whosInformation;
    }

    public void setColumnVarNames(HashMap<Integer, String> hashMap) {
        this.fColumnVarNames = hashMap;
    }

    public void setColumnVariableName(int n, String string) {
        String[] stringArray;
        if (this.fColumnVarNames.containsKey(n)) {
            this.fColumnVarNames.remove(n);
        }
        if ((stringArray = this.getDefaultColumnVarNames(this.getHeaderRow())) == null || !string.equals(stringArray[n])) {
            this.fColumnVarNames.put(n, string);
        }
    }

    public HashMap<Integer, Boolean> getColumnVarNameWarningStates() {
        return this.fColumnVarNameWarningStates;
    }

    public void setColumnVarNameWarningStates(HashMap<Integer, Boolean> hashMap) {
        this.fColumnVarNameWarningStates = hashMap;
    }

    public void setMatrixVariableName(String string) {
        this.fMatrixVarName = string;
    }

    public void setDefaultMatrixVariableName(String string) {
        this.fDefaultMatrixVarName = string;
    }

    public String getMatrixVariableName() {
        if (this.fMatrixVarName != null) {
            return this.fMatrixVarName;
        }
        return this.fDefaultMatrixVarName;
    }

    public String getDefaultMatrixVariableName() {
        return this.fDefaultMatrixVarName;
    }

    public boolean isMatrixVarNameWarningState() {
        return this.fMatrixVarNameWarningState;
    }

    public void setMatrixVarNameWarningState(boolean bl) {
        this.fMatrixVarNameWarningState = bl;
    }

    public ImportClient.TargetType getTargetType() {
        return this.fTargetType;
    }

    public void setTargetType(ImportClient.TargetType targetType) {
        this.fTargetType = targetType;
        this.updateWarningIcon();
        if (this.fHeaderRenderer instanceof VariableHeaderRenderer) {
            ((VariableHeaderRenderer)this.fHeaderRenderer).setVariableNamesVisible(targetType == ImportClient.TargetType.COLUMNVECTORS || targetType == ImportClient.TargetType.DATASET);
            ((VariableHeaderRenderer)this.fHeaderRenderer).setGroupNamesVisible(targetType != ImportClient.TargetType.COLUMNVECTORS);
        }
    }

    public ImportSelectionManager getImportSelectionModel() {
        return this.fImportSelectionModel;
    }

    public void setImportSelectionModel(ImportSelectionManager importSelectionManager) {
        this.fImportSelectionModel = importSelectionManager;
    }

    public VariableNamePanel getVariableNamePanel() {
        return this.fVariableNamePanel;
    }

    public void setVariableNamePanel(VariableNamePanel variableNamePanel) {
        this.fVariableNamePanel = variableNamePanel;
    }

    protected VariableNamePanel createVariableNamePanel(SpreadsheetScrollPane spreadsheetScrollPane, String string) {
        this.fVariableNamePanel = new VariableNamePanel(spreadsheetScrollPane, this, string);
        return this.fVariableNamePanel;
    }

    protected abstract IHeaderRenderer createColumnHeaderRenderer(JTable var1);

    protected abstract void installEditorsAndRenderersForFormat();

    @Override
    public void workspaceUpdate(WorkspaceChange workspaceChange, WhosInformation whosInformation) {
        this.fCachedWhosInformation = whosInformation;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportTable.this.updateWarningIcon();
            }
        });
    }

    public void updateWarningIcon() {
        if (this.fCachedWhosInformation != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.fCachedWhosInformation.size(); ++i) {
                if (sImportedVariableNames.contains(this.fCachedWhosInformation.getName(i))) continue;
                arrayList.add(this.fCachedWhosInformation.getName(i));
            }
            this.updateWarningIcon(arrayList);
        }
    }

    static void commitVariableNames(String[] stringArray) {
        for (String string : stringArray) {
            if (sImportedVariableNames.contains(string)) continue;
            sImportedVariableNames.add(string);
        }
    }

    void updateWarningIcon(List<String> list) {
        HashMap hashMap = (HashMap)this.fColumnVarNameWarningStates.clone();
        if (this.fTargetType == ImportClient.TargetType.COLUMNVECTORS) {
            this.fColumnVarNameWarningStates.clear();
            for (int n : this.getColumnVarNames().keySet()) {
                if (!list.contains(this.getColumnVarNames().get(n))) continue;
                this.fColumnVarNameWarningStates.put(n, true);
            }
        } else {
            this.fColumnVarNameWarningStates.clear();
        }
        if (!hashMap.equals(this.fColumnVarNameWarningStates)) {
            this.getTableHeader().repaint();
        }
        if (this.getVariableNamePanel() == null) {
            return;
        }
        if (this.fTargetType == ImportClient.TargetType.MATRIX || this.fTargetType == ImportClient.TargetType.CELLARRAY || this.fTargetType == ImportClient.TargetType.DATASET) {
            if (this.fMatrixVarNameWarningState != list.contains(this.fMatrixVarName)) {
                this.fMatrixVarNameWarningState = list.contains(this.fMatrixVarName);
                this.getVariableNamePanel().revalidate();
                this.getVariableNamePanel().repaint();
            }
        } else if (this.fMatrixVarNameWarningState) {
            this.fMatrixVarNameWarningState = false;
            this.getVariableNamePanel().revalidate();
            this.getVariableNamePanel().repaint();
        }
    }

    public boolean isMatrix() {
        return this.fTargetType == ImportClient.TargetType.MATRIX;
    }

    public boolean isCellArray() {
        return this.fTargetType == ImportClient.TargetType.CELLARRAY;
    }

    public boolean isDataSet() {
        return this.fTargetType == ImportClient.TargetType.DATASET;
    }

    public boolean isColumnVectors() {
        return this.fTargetType == ImportClient.TargetType.COLUMNVECTORS;
    }

    public Point getColumnPoint(int n) {
        Rectangle rectangle = this.getCellRect(0, n, true);
        Rectangle rectangle2 = this.getVisibleRect();
        if (rectangle == null) {
            return null;
        }
        return new Point(rectangle.x - rectangle2.x - this.getLocation().x, 0);
    }

    abstract String getAllocationFcn();

    public boolean showColumnHeaderVariableWarning(int n) {
        return this.fColumnVarNameWarningStates != null && this.fColumnVarNameWarningStates.containsKey(n) && this.fColumnVarNameWarningStates.get(n) != false;
    }

    public boolean showMatrixHeadervariableWarning() {
        return this.fMatrixVarNameWarningState;
    }

    public int getHeaderRow() {
        return ((AbstractFileTableModel)this.getModel()).getTopHeaderRow();
    }

    public boolean isHeaderRowExcluded() {
        return this.isRowExcluded(this.getHeaderRow());
    }

    void setImportedVariableLayout(String string) {
        for (ImportClient.TargetType targetType : ImportClient.TargetType.values()) {
            if (!targetType.toString().equals(string)) continue;
            this.setTargetType(targetType);
            return;
        }
    }

    void setHeaderRow(int n) {
        ((AbstractFileTableModel)this.getModel()).setHeaderRow(n);
        this.updateColumnHeader();
        this.getTableHeader().revalidate();
        this.getTableHeader().repaint();
    }

    public boolean externalVariableExistsInMatlab(String string) {
        if (this.fCachedWhosInformation == null || sImportedVariableNames.contains(string)) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.fCachedWhosInformation.size(); ++i) {
            arrayList.add(this.fCachedWhosInformation.getName(i));
        }
        return arrayList.contains(string);
    }

    String genVarName(String string) {
        if (!this.externalVariableExistsInMatlab(string)) {
            return string;
        }
        string = string.replaceAll("\\d*$", "");
        int n = 1;
        while (this.externalVariableExistsInMatlab(string + Integer.toString(n))) {
            ++n;
        }
        return string + Integer.toString(n);
    }

    public abstract void updateColumnHeader();

    abstract boolean isRowExcluded(int var1);

    abstract boolean isColumnExcluded(int var1);

    protected abstract void zoom(double var1);

    void refreshSelectionEffects(Point point) {
        if (this.fCellRenderer == null) {
            this.fCellRenderer = new ImportCellRenderer();
        }
        int n = -1;
        int n2 = -1;
        if (point != null) {
            n = this.rowAtPoint(point);
            n2 = this.columnAtPoint(point);
        }
        if (point != null && this.isCellSelected(n, n2)) {
            Rectangle rectangle = this.getCellRect(n, n2, true);
            int[] nArray = WorksheetMouseListener.getSelectedCellBlock((MJTable)this, n, n2);
            if (((IntervalSelectionModel)this.getColumnModel().getSelectionModel()).getMultiVariableSelection()) {
                this.fCellRenderer.setHighlightLocation(nArray[0], nArray[1], n2, n2);
            } else {
                this.fCellRenderer.setHighlightLocation(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
            int n3 = 5;
            if (n2 == nArray[2] && point.x <= rectangle.x + n3) {
                this.fCellRenderer.setGlowBorderLocation(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else if (n2 == nArray[3] && point.x >= rectangle.x + rectangle.width - n3) {
                this.fCellRenderer.setGlowBorderLocation(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else if (n == nArray[0] && point.y <= rectangle.y + n3) {
                this.fCellRenderer.setGlowBorderLocation(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else if (n == nArray[1] && point.y >= rectangle.y + rectangle.height - n3) {
                this.fCellRenderer.setGlowBorderLocation(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else {
                this.fCellRenderer.setGlowBorderLocation(-1, -1, -1, -1);
            }
            String string = this.getToolTipString(n, n2);
            if (string != null) {
                this.setToolTipText(string);
                ToolTipManager.sharedInstance().setInitialDelay(150);
                this.setHoverAffects(n, n2);
            } else {
                this.hideToolTip();
            }
        } else {
            this.hideToolTip();
            this.fCellRenderer.setHighlightLocation(-1, -1, -1, -1);
            this.fCellRenderer.setGlowBorderLocation(-1, -1, -1, -1);
            this.setHoverAffects(-1, -1);
        }
        this.repaint();
    }

    private void setHoverAffects(int n, int n2) {
        int[] nArray;
        if (this.fHoverTimer == null) {
            this.fHoverTimer = new HoverTimer(this.fCellRenderer, (JTable)((Object)this));
        }
        if (((nArray = this.fCellRenderer.getHoverCell())[0] < 0 || nArray[1] < 0) && n >= 0 && n2 >= 0) {
            this.fHoverTimer.setCell(n, n2);
            this.fHoverTimer.restart();
        } else {
            this.fCellRenderer.setHoverCell(n, n2);
        }
    }

    void hideToolTip() {
        this.setHoverAffects(-1, -1);
        this.setToolTipText(null);
        ToolTipManager.sharedInstance().setInitialDelay(750);
        ToolTipManager.sharedInstance().mousePressed(new MouseEvent((Component)((Object)this), 501, 0L, 0, 0, 0, 1, false));
    }

    public abstract String getToolTipString(int var1, int var2);

    public static String truncateString(String string) {
        return ImportTable.truncateString(string, 30);
    }

    public static String truncateString(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n) + " ...";
        }
        return string;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n;
        int n2 = this.rowAtPoint(mouseEvent.getPoint());
        if (this.isCellSelected(n2, n = this.columnAtPoint(mouseEvent.getPoint()))) {
            Rectangle rectangle = this.getCellRect(n2, n, true);
            return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height - 40);
        }
        ToolTipManager.sharedInstance().mousePressed(mouseEvent);
        return null;
    }

    AbstractFileTableModel getWorksheetTableModel() {
        return (AbstractFileTableModel)this.getModel();
    }

    void setSelectedRanges(String string) {
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        boolean bl = this.getColumnModel().getSelectionModel().getValueIsAdjusting();
        boolean bl2 = this.getSelectionModel().getValueIsAdjusting();
        this.getColumnModel().getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().setValueIsAdjusting(true);
        this.clearAllSelection();
        if (this.getRowCount() == 0 || this.getColumnCount() == 0) {
            return;
        }
        for (int[] nArray : list) {
            if (nArray[0] > this.getRowCount() || nArray[2] < 1 || nArray[1] > this.getColumnCount() || nArray[3] < 1) continue;
            this.addRowSelectionInterval(nArray[0] < 1 ? 0 : nArray[0] - 1, nArray[2] > this.getRowCount() ? this.getRowCount() - 1 : nArray[2] - 1);
            this.addColumnSelectionInterval(nArray[1] < 1 ? 0 : nArray[1] - 1, nArray[3] > this.getColumnCount() ? this.getColumnCount() - 1 : nArray[3] - 1);
        }
        this.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
        this.getSelectionModel().setValueIsAdjusting(bl2);
    }

    protected void clearAllSelection() {
        this.clearSelection();
    }

    protected void bindKeysAsPerSpreadsheet() {
        super.bindKeysAsPerSpreadsheet();
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "SelectToZeroZero", 36, 3, false, "selectToZeroZero"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "RightArrow", 39, 0, false, "arrowRight"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "LeftArrow", 37, 0, false, "arrowLeft"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "UpArrow", 38, 0, false, "arrowUp"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "DownArrow", 40, 0, false, "arrowDown"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "PageDown", 34, 0, false, "pageDown"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "PageUp", 33, 0, false, "pageUp"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "selectUp", 38, 1, false, "selectUp"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "selectDown", 40, 1, false, "selectDown"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "selectRight", 39, 1, false, "selectRight"));
        this.registerWithInputMap((MJAbstractAction)new AbstractSpreadsheetTable.AnonNavigationAction((AbstractSpreadsheetTable)this, "selectLeft", 37, 1, false, "selectLeft"));
    }

    public void arrowLeft() {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.rowAtPoint(new Point(rectangle.x, rectangle.y));
        int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (--n2 >= 0) {
            this.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
            this.scrollCellToVisible(n, n2);
            this.repaint();
        }
    }

    public void arrowRight() {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.rowAtPoint(new Point(rectangle.x, rectangle.y));
        int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (++n2 < this.getColumnCount()) {
            this.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
            this.scrollCellToVisible(n, n2);
            this.repaint();
        }
    }

    public void arrowUp() {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.columnAtPoint(new Point(rectangle.x, rectangle.y));
        int n2 = this.getSelectionModel().getLeadSelectionIndex();
        if (--n2 >= 0) {
            this.getSelectionModel().setLeadSelectionIndex(n2);
            this.scrollCellToVisible(n2, n);
            this.repaint();
        }
    }

    public void arrowDown() {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.columnAtPoint(new Point(rectangle.x, rectangle.y));
        int n2 = this.getSelectionModel().getLeadSelectionIndex();
        if (++n2 < this.getRowCount()) {
            this.getSelectionModel().setLeadSelectionIndex(n2);
            this.scrollCellToVisible(n2, n);
            this.repaint();
        }
    }

    public void pageDown() {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.rowAtPoint(new Point(rectangle.x, rectangle.y + 2 * rectangle.height));
        int n2 = this.columnAtPoint(new Point(rectangle.x, rectangle.y));
        if (n >= 0) {
            this.scrollCellToVisible(n, n2);
        }
    }

    public void pageUp() {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.rowAtPoint(new Point(rectangle.x, rectangle.y - rectangle.height));
        int n2 = this.columnAtPoint(new Point(rectangle.x, rectangle.y));
        if (n >= 0) {
            this.scrollCellToVisible(n, n2);
        }
    }

    public void selectUp() {
        this.arrowUp();
        int n = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        this.addColumnSelectionInterval(n, n);
    }

    public void selectDown() {
        this.arrowDown();
        int n = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        this.addColumnSelectionInterval(n, n);
    }

    public void selectLeft() {
        this.arrowLeft();
        int n = this.getSelectionModel().getLeadSelectionIndex();
        this.addRowSelectionInterval(n, n);
    }

    public void selectRight() {
        this.arrowRight();
        int n = this.getSelectionModel().getLeadSelectionIndex();
        this.addRowSelectionInterval(n, n);
    }

    public void selectEntireColumns() {
        if (this.getSelectedColumnCount() == 0) {
            return;
        }
        int n = this.getRowCount();
        if (n != 0) {
            CellLocation cellLocation = this.getAnchorLocation();
            ListSelectionModel listSelectionModel = this.getColumnModel().getSelectionModel();
            if (listSelectionModel instanceof IntervalSelectionModel) {
                IntervalSelectionModel intervalSelectionModel = (IntervalSelectionModel)listSelectionModel;
                for (int[] nArray : intervalSelectionModel.getSelectedIntervals()) {
                    if (nArray == null || nArray.length < 2 || nArray[0] < 0 || nArray[1] < 0) continue;
                    this.addColumnSelectionInterval(nArray[0], nArray[1]);
                }
                this.setRowSelectionInterval(0, n - 1);
                this.setAnchorLocation(cellLocation);
            }
        }
    }

    public void selectEntireRows() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        int n = this.getColumnCount();
        if (n != 0) {
            CellLocation cellLocation = this.getAnchorLocation();
            this.setColumnSelectionInterval(0, n - 1);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            if (listSelectionModel instanceof IntervalSelectionModel) {
                IntervalSelectionModel intervalSelectionModel = (IntervalSelectionModel)listSelectionModel;
                for (int[] nArray : intervalSelectionModel.getSelectedIntervals()) {
                    this.addRowSelectionInterval(nArray[0], nArray[1]);
                }
                this.setAnchorLocation(cellLocation);
            }
        }
    }

    void addWorksheetCachedDataListener(AbstractFileTableModel.WorksheetCachedDataListener worksheetCachedDataListener) {
        if (!this.fWorksheetCachedDataListeners.contains(worksheetCachedDataListener)) {
            this.fWorksheetCachedDataListeners.add(worksheetCachedDataListener);
        }
    }

    void removeWorksheetCachedDataListener(AbstractFileTableModel.WorksheetCachedDataListener worksheetCachedDataListener) {
        this.fWorksheetCachedDataListeners.remove(worksheetCachedDataListener);
    }

    void fireWorksheetCachedDataListeners(EventObject eventObject) {
        for (AbstractFileTableModel.WorksheetCachedDataListener worksheetCachedDataListener : this.fWorksheetCachedDataListeners) {
            worksheetCachedDataListener.worksheetCachedDataChanged(eventObject);
        }
    }

    public final Action getSelectAllAction() {
        return this.fSelectAllAction;
    }

    Action getCopyAction() {
        return this.fCopyAction;
    }

    protected boolean validateUniqueNames(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        Collections.sort(arrayList);
        for (int i = 1; i < arrayList.size(); ++i) {
            if (!((String)arrayList.get(i)).equals(arrayList.get(i - 1))) continue;
            MJOptionPane.showMessageDialog((Component)this.getTopLevelAncestor(), (Object)ImportToolUtils.getResourceString("messages.dupvars"), (String)ImportToolUtils.getResourceString("error.title"), (int)1);
            return false;
        }
        return true;
    }

    boolean isRuleClassAppliedToSelection(Class clazz) {
        IntervalSelectionModel intervalSelectionModel = (IntervalSelectionModel)this.getSelectionModel();
        IntervalSelectionModel intervalSelectionModel2 = (IntervalSelectionModel)this.getColumnModel().getSelectionModel();
        if (!this.getWorksheetTableModel().isSelectionInCachedArray(intervalSelectionModel, intervalSelectionModel2)) {
            return true;
        }
        List<int[]> list = intervalSelectionModel.getSelectedIntervals();
        List<int[]> list2 = intervalSelectionModel2.getSelectedIntervals();
        for (int[] nArray : list) {
            for (int[] nArray2 : list2) {
                for (int i = nArray[0]; i <= nArray[1]; ++i) {
                    for (int j = nArray2[0]; j <= nArray2[1]; ++j) {
                        if (this.getWorksheetTableModel().getRuleClassAt(i, j) != clazz) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    void cleanup() {
        MatlabWorkspaceListener.removeWorkspaceChangeObserver(this);
    }

    void stopHeaderEditing() {
        ((VariableHeaderRenderer)this.fHeaderRenderer).fireEditingStopped();
    }

    @Override
    public void importData(ImportDataSource importDataSource) {
        Object[] objectArray;
        String[] stringArray;
        this.stopHeaderEditing();
        String[] stringArray2 = null;
        if (this.getTargetType() == ImportClient.TargetType.MATRIX || this.getTargetType() == ImportClient.TargetType.CELLARRAY) {
            Object[] objectArray2 = new Object[]{new double[]{this.getSelectedRowCount(), this.getSelectedColumnCount()}};
            stringArray = new String[]{this.getMatrixVariableName()};
        } else if (this.getTargetType() == ImportClient.TargetType.DATASET) {
            Object[] objectArray3 = new Object[]{new double[]{this.getSelectedRowCount(), this.getSelectedColumnCount()}};
            stringArray = new String[]{this.getMatrixVariableName()};
            stringArray2 = this.getSelectedColumnVariableNames();
            if (!this.validateUniqueNames(stringArray2)) {
                importDataSource.setEnabled(true);
                return;
            }
        } else {
            stringArray = this.getSelectedColumnVariableNames();
            Object[] objectArray4 = new Object[this.getSelectedColumnCount()];
            objectArray = this.getSelectedColumns();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray4[i] = new double[]{this.getSelectedRowCount(), 1.0};
            }
            stringArray2 = stringArray;
            if (!this.validateUniqueNames(stringArray)) {
                importDataSource.setEnabled(true);
                return;
            }
        }
        objectArray = stringArray;
        String[] stringArray3 = stringArray2;
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>((String[])objectArray, stringArray3, importDataSource){
            final /* synthetic */ String[] val$outVarNames;
            final /* synthetic */ String[] val$outColumnVarNames;
            final /* synthetic */ ImportDataSource val$src;
            {
                this.val$outVarNames = stringArray;
                this.val$outColumnVarNames = stringArray2;
                this.val$src = importDataSource;
            }

            public Object runOnMatlabThread() {
                try {
                    String[][] stringArray = ImportTable.this.fImportSelectionModel.getSelectedRangeArray();
                    int n = ImportTable.this.fImportSelectionModel.getSeletedCellCount();
                    return ImportTable.this.getWorksheetTableModel().importData(this.val$outVarNames, this.val$outColumnVarNames, ImportTable.this.getAllocationFcn(), stringArray, n);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(Object object) {
                this.val$src.setEnabled(true);
                if (object == null || !(object instanceof Object[])) {
                    MJOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)ImportTable.this)), (Object)ImportToolUtils.getResourceString("error.import"), (String)ImportToolUtils.getResourceString("error.title"), (int)0);
                    return;
                }
                Object[] objectArray = (Object[])object;
                if (objectArray.length < 2 || objectArray[0] == null || objectArray[1] == null) {
                    return;
                }
                Object[] objectArray2 = (Object[])objectArray[1];
                String[] stringArray = (String[])objectArray[0];
                if (objectArray2.length == 0 || stringArray.length == 0) {
                    return;
                }
                ImportTable.commitVariableNames(stringArray);
                if (PlatformInfo.isMacintosh() || !Fader.isTranslucencySupported()) {
                    return;
                }
                Point point = new Point(0, this.val$src.getImportingComponent().getHeight());
                SwingUtilities.convertPointToScreen(point, this.val$src.getImportingComponent());
                FadingAcknowledgementWindow fadingAcknowledgementWindow = new FadingAcknowledgementWindow((Frame)SwingUtilities.getWindowAncestor((Component)((Object)ImportTable.this)));
                fadingAcknowledgementWindow.setVariableContent(stringArray, objectArray2);
                fadingAcknowledgementWindow.setLocation(point);
                fadingAcknowledgementWindow.show();
            }
        };
        matlabWorker.start();
    }

    public void setVariableNamesHighlightRow(int n) {
        this.fVariableNamesHighlightRow = n;
    }

    public int getVariableNamesHighlightRow() {
        return this.fVariableNamesHighlightRow;
    }

    @Override
    public abstract void generateMatlabFunction(String var1);

    @Override
    public abstract void generateMatlabScript();

    ImportTableHeader getImportTableHeader() {
        return (ImportTableHeader)this.getTableHeader();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fWorksheetMouseListener != null) {
            if (mouseEvent.getID() == 506) {
                this.fWorksheetMouseListener.mouseDragged(mouseEvent);
            }
            if (mouseEvent.getID() == 503) {
                this.fWorksheetMouseListener.mouseMoved(mouseEvent);
            }
            if (mouseEvent.isConsumed()) {
                return;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        KeyEvent keyEvent2 = keyEvent;
        if (keyEvent.getKeyCode() == 10) {
            if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown())) {
                if (!this.fMotionOnEnter) {
                    keyEvent.consume();
                    this.editingStopped(new ChangeEvent(this));
                    return;
                }
                int n = keyEvent.getModifiers();
                if (this.fMotionOnEnterDirection == 2 || this.fMotionOnEnterDirection == 3) {
                    n = keyEvent.isShiftDown() ? 0 : 1;
                }
                int n2 = this.fMotionOnEnterDirection == 3 || this.fMotionOnEnterDirection == 1 ? 9 : 10;
                keyEvent2 = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), n, n2, keyEvent.getKeyChar());
                keyEvent.consume();
            }
        } else {
            Component component;
            if (keyEvent.getKeyCode() == 9) {
                if (this.fTABFocusKeyHit) {
                    this.getFocusCycleRootAncestor().getFocusTraversalPolicy().getComponentAfter(this.getFocusCycleRootAncestor(), (Component)((Object)this)).requestFocus();
                    this.fTABFocusKeyHit = false;
                } else {
                    this.fTABFocusKeyHit = true;
                }
                return;
            }
            if (!keyEvent.isConsumed() && (ImportTable.isZoomOutKeyEvent(keyEvent) || ImportTable.isZoomInKeyEvent(keyEvent)) && (keyEvent.getModifiersEx() & 0x80) == 128 && !((component = FocusManager.getCurrentManager().getFocusOwner()) instanceof WorksheetTable)) {
                keyEvent.consume();
                if (ImportTable.isZoomOutKeyEvent(keyEvent)) {
                    this.zoom(0.9);
                } else {
                    this.zoom(1.1);
                }
            }
        }
        super.processKeyEvent(keyEvent2);
    }

    VarNameUpdateWorker processMatrixVarNameEdit(String string) {
        VarNameUpdateWorker varNameUpdateWorker = this.validateVariableName(string, false, new VariableNameValidationCallback(){

            @Override
            public void nameValidated(String string, boolean bl) {
                ImportTable.this.setMatrixVariableName(string);
                ImportTable.this.getVariableNamePanel().setVariableName(string);
                ImportTable.this.updateWarningIcon();
                ImportTable.this.revalidate();
                ImportTable.this.repaint();
            }
        });
        return varNameUpdateWorker;
    }

    VarNameUpdateWorker processVarNameEdit(String string, final int n, final VariableHeaderRenderer.ImportDataHeader importDataHeader) {
        VarNameUpdateWorker varNameUpdateWorker = this.validateVariableName(string, false, new VariableNameValidationCallback(){

            @Override
            public void nameValidated(String string, boolean bl) {
                if (bl && ImportTable.this.getTargetType() == ImportClient.TargetType.COLUMNVECTORS) {
                    ImportTable.this.validateVariableName(string, true, new VariableNameValidationCallback(){

                        @Override
                        public void nameValidated(String string, boolean bl) {
                            importDataHeader.setName(string);
                            ImportTable.this.getColumnModel().getColumn(n).setHeaderValue(importDataHeader);
                            ImportTable.this.setColumnVariableName(n, string);
                            ImportTable.this.updateWarningIcon();
                            ImportTable.this.getTableHeader().repaint();
                        }
                    });
                } else {
                    importDataHeader.setName(string);
                    ImportTable.this.getColumnModel().getColumn(n).setHeaderValue(importDataHeader);
                    ImportTable.this.setColumnVariableName(n, string);
                    ImportTable.this.updateWarningIcon();
                    ImportTable.this.getTableHeader().repaint();
                }
            }
        });
        return varNameUpdateWorker;
    }

    public VarNameUpdateWorker validateVariableName(String string, boolean bl, final VariableNameValidationCallback variableNameValidationCallback) {
        final VarNameUpdateWorker varNameUpdateWorker = new VarNameUpdateWorker();
        varNameUpdateWorker.setVariableName(string);
        varNameUpdateWorker.setCheckForNameConflicts(bl);
        varNameUpdateWorker.queueEditCompletionRunnable(new Runnable(){

            @Override
            public void run() {
                variableNameValidationCallback.nameValidated(varNameUpdateWorker.getNewVarName(), varNameUpdateWorker.isNameModified());
            }
        });
        varNameUpdateWorker.start();
        return varNameUpdateWorker;
    }

    public static void checkExternalVariableName(final String string, final VariableNameValidationCallback variableNameValidationCallback) {
        MatlabWorker<String> matlabWorker = new MatlabWorker<String>(){

            public String runOnMatlabThread() {
                try {
                    String[] stringArray = (String[])Matlab.mtFeval((String)"internal.matlab.codetools.genvalidnames", (Object[])new Object[]{new Object[]{string}, true}, (int)1);
                    String string2 = stringArray[0];
                    if (!this.externalVariableExistsInMatlab(string2)) {
                        return string2;
                    }
                    string2 = string2.replaceAll("\\d*$", "");
                    int n = 1;
                    while (this.externalVariableExistsInMatlab(string2 + Integer.toString(n))) {
                        ++n;
                    }
                    return string2 + Integer.toString(n);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(String string2) {
                variableNameValidationCallback.nameValidated(string2, string2.equals(string));
            }

            private boolean externalVariableExistsInMatlab(String string2) throws Exception {
                double[] dArray = (double[])Matlab.mtFeval((String)"exist", (Object[])new Object[]{string2}, (int)1);
                if (dArray != null && dArray.length > 0) {
                    return (int)dArray[0] == 1;
                }
                return false;
            }
        };
        if (Matlab.isMatlabAvailable()) {
            matlabWorker.start();
        }
    }

    public void enableVariableNameEditor(int n) {
        ((TextTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).editColumnHeaderCellAt((JTable)((Object)this), n);
    }

    public void enableGroupVariableNameEditor() {
        this.getVariableNamePanel().enableEditor();
    }

    protected void addImportContextMenuItem() {
        this.fSelectionPopupMenu.add((Component)new JPopupMenu.Separator());
        this.fSelectionPopupMenu.add((Action)((Object)this.fImportAction));
        this.fSelectionPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ImportTable.this.fLastPopupMenuLocation = null;
                if (ImportTable.this.fSelectionPopupMenu != null && ImportTable.this.fSelectionPopupMenu.isVisible()) {
                    ImportTable.this.fLastPopupMenuLocation = ImportTable.this.fSelectionPopupMenu.getLocationOnScreen();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    public void setImportContextMenuEnabled(boolean bl) {
        this.fImportAction.setEnabled(bl);
    }

    void setTemporarySelectedRanges(String string) {
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        this.fTemporarySelectionModel.clearSelection();
        this.fTemporarySelectionColumnModel.getSelectionModel().clearSelection();
        if (this.getRowCount() == 0 || this.getColumnCount() == 0) {
            return;
        }
        for (int[] nArray : list) {
            if (nArray[0] > this.getRowCount() || nArray[2] < 1 || nArray[1] > this.getColumnCount() || nArray[3] < 1) continue;
            this.fTemporarySelectionModel.addSelectionInterval(nArray[0] < 1 ? 0 : nArray[0] - 1, nArray[2] > this.getRowCount() ? this.getRowCount() - 1 : nArray[2] - 1);
            this.fTemporarySelectionColumnModel.getSelectionModel().addSelectionInterval(nArray[1] < 1 ? 0 : nArray[1] - 1, nArray[3] > this.getColumnCount() ? this.getColumnCount() - 1 : nArray[3] - 1);
        }
    }

    boolean isCellTemporarilySelected(int n, int n2) {
        return this.isRowTemporarilySelected(n) && this.isColumnTemporarilySelected(n2);
    }

    boolean isColumnTemporarilySelected(int n) {
        return this.fTemporarySelectionColumnModel.getSelectionModel().isSelectedIndex(n);
    }

    boolean isRowTemporarilySelected(int n) {
        return this.fTemporarySelectionModel.isSelectedIndex(n);
    }

    public MJPopupMenu getPopupMenu() {
        return this.fSelectionPopupMenu;
    }

    public static boolean isZoomInKeyEvent(KeyEvent keyEvent) {
        return keyEvent != null && (keyEvent.getKeyCode() == 61 || keyEvent.getKeyCode() == 107);
    }

    public static boolean isZoomOutKeyEvent(KeyEvent keyEvent) {
        return keyEvent != null && (keyEvent.getKeyCode() == 45 || keyEvent.getKeyCode() == 109);
    }

    private static class HoverTimer
    extends Timer
    implements ActionListener {
        private ImportCellRenderer iCellRenderer;
        private JTable iTable;
        private int iRow = -1;
        private int iCol = -1;

        private HoverTimer(ImportCellRenderer importCellRenderer, JTable jTable) {
            super(150, null);
            this.iCellRenderer = importCellRenderer;
            this.iTable = jTable;
            this.addActionListener(this);
            this.setRepeats(false);
        }

        void setCell(int n, int n2) {
            this.iRow = n;
            this.iCol = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point point = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(point, this.iTable);
            if (this.iRow != this.iTable.rowAtPoint(point) || this.iCol != this.iTable.columnAtPoint(point)) {
                return;
            }
            this.iCellRenderer.setHoverCell(this.iRow, this.iCol);
            this.iTable.repaint();
        }
    }

    protected class ImportAction
    extends MJAbstractAction {
        ImportTable fTable = null;
        private MJFrame fLocationFrame;

        ImportAction(ImportTable importTable2) {
            this.fTable = importTable2;
            this.fLocationFrame = new MJFrame();
            this.setComponentName("ImportDataAction");
            this.setName(ImportToolUtils.getResourceString("ActionNames.importdata"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fTable.importData(new ImportDataSource(){

                @Override
                public void setEnabled(boolean bl) {
                }

                @Override
                public JComponent getImportingComponent() {
                    MJPopupMenu mJPopupMenu = ImportTable.this.getPopupMenu();
                    if (ImportTable.this.fLastPopupMenuLocation != null) {
                        ImportAction.this.fLocationFrame.setLocation(ImportTable.this.fLastPopupMenuLocation);
                    } else {
                        ImportAction.this.fLocationFrame.setLocation(SwingUtilities.getRoot((Component)((Object)ImportAction.this.fTable)).getLocationOnScreen());
                    }
                    ImportAction.this.fLocationFrame.setSize(0, 0);
                    return SwingUtilities.getRootPane((Component)ImportAction.this.fLocationFrame);
                }
            });
        }
    }

    public static interface VariableNameValidationCallback {
        public void nameValidated(String var1, boolean var2);
    }

    public class VarNameUpdateWorker
    extends MatlabWorker<String> {
        protected String iOriginalVarName;
        protected String iNewVarName;
        protected boolean iProcessing = false;
        protected List<Runnable> iEditCompletionRunnable = new ArrayList<Runnable>();
        protected boolean iCheckForNameConflicts = false;

        public String runOnMatlabThread() {
            try {
                this.iProcessing = true;
                String[] stringArray = (String[])Matlab.mtFeval((String)"internal.matlab.codetools.genvalidnames", (Object[])new Object[]{new Object[]{this.iNewVarName.trim()}, true}, (int)1);
                if (!this.iNewVarName.equals(stringArray[0]) || this.iCheckForNameConflicts) {
                    return ImportTable.this.genVarName(stringArray[0]);
                }
                return stringArray[0];
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void runOnAWTEventDispatchThread(String string) {
            if (string == null) {
                this.iProcessing = false;
                return;
            }
            this.iNewVarName = string;
            this.iProcessing = false;
            if (this.iEditCompletionRunnable != null) {
                for (Runnable runnable : this.iEditCompletionRunnable) {
                    runnable.run();
                }
                this.iEditCompletionRunnable.clear();
            }
        }

        protected void setVariableName(String string) {
            this.iOriginalVarName = string;
            this.iNewVarName = string;
        }

        protected void queueEditCompletionRunnable(Runnable runnable) {
            this.iEditCompletionRunnable.add(runnable);
        }

        protected boolean isProcessing() {
            return this.iProcessing;
        }

        public void start() {
            if (Matlab.isMatlabAvailable()) {
                this.iProcessing = true;
                super.start();
            } else {
                this.runOnAWTEventDispatchThread(this.iNewVarName);
            }
        }

        public String getNewVarName() {
            return this.iNewVarName;
        }

        public String getOriginalVarName() {
            return this.iOriginalVarName;
        }

        public boolean isNameModified() {
            return !this.iOriginalVarName.equals(this.iNewVarName);
        }

        public void setCheckForNameConflicts(boolean bl) {
            this.iCheckForNameConflicts = bl;
        }

        public boolean IsCheckingForNameConflicts() {
            return this.iCheckForNameConflicts;
        }
    }

    class CopyAction
    extends MJAbstractAction {
        public CopyAction() {
            MatlabKeyBindings.getManager().addActionInfoOnly("SpreadsheetTable", "copy-to-clipboard", (ExtendedAction)this);
            this.setComponentName("Copy");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            List<int[]> list = ImportTable.this.fImportSelectionModel.getRowSelectionModel().getSelectedIntervals();
            List<int[]> list2 = ImportTable.this.fImportSelectionModel.getColumnSelectionModel().getSelectedIntervals();
            int n2 = ImportTable.this.fImportSelectionModel.getRowSelectionModel().getSelectionCount();
            if ((double)(n2 * (n = ImportTable.this.fImportSelectionModel.getColumnSelectionModel().getSelectionCount())) > COPYCELLTHRESHOLD) {
                n2 = (n2 = (int)Math.sqrt((double)n2 * COPYCELLTHRESHOLD / (double)n)) < 1 ? 1 : n2;
                n = (int)(COPYCELLTHRESHOLD / (double)n2);
            }
            int n3 = 1;
            for (int[] object2 : list) {
                for (int i = object2[0]; i <= object2[1]; ++i) {
                    int n4 = 1;
                    for (int[] nArray : list2) {
                        for (int j = nArray[0]; j <= nArray[1]; ++j) {
                            stringBuffer.append(ImportTable.this.getValueAt(i, j));
                            if (n4 < n) {
                                stringBuffer.append("\t");
                            } else {
                                stringBuffer.append("\n");
                            }
                            if (++n4 > n) break;
                        }
                        if (n4 <= n) continue;
                        break;
                    }
                    if (++n3 > n2) break;
                }
                if (n3 <= n2) continue;
                break;
            }
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public class ImportTableHeader
    extends JTableHeader {
        public ImportTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }
    }

    protected class TableHeaderMouseEventListener
    extends AbstractSpreadsheetTable.AbstractTableHeaderMouseEventListener {
        protected TableHeaderMouseEventListener() {
            super((AbstractSpreadsheetTable)ImportTable.this);
        }

        private boolean inSelectionArea(int n, Point point) {
            Rectangle rectangle = ImportTable.this.getTableHeader().getHeaderRect(n);
            Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
            return ((VariableHeaderRenderer)ImportTable.this.fHeaderRenderer).isSelectionArea(point2, n, ImportTable.this.getColumnModel().getColumn(n).getHeaderValue());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            boolean bl = ImportTable.this.processPossiblePopup(mouseEvent);
            boolean bl2 = true;
            if (!bl) {
                JTableHeader jTableHeader = ImportTable.this.getTableHeader();
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                if (!tableColumnModel.getColumnSelectionAllowed() && !ImportTable.this.isSelectionModeByHeader()) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                int n = jTableHeader.columnAtPoint(point);
                if (n == -1) {
                    return;
                }
                if (!this.inSelectionArea(n, point)) {
                    return;
                }
                if (this.isResizingColumn(jTableHeader, point, n)) {
                    return;
                }
                ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
                if (mouseEvent.isShiftDown()) {
                    int n2 = listSelectionModel.getAnchorSelectionIndex();
                    int n3 = listSelectionModel.getLeadSelectionIndex();
                    if (n2 != -1) {
                        boolean bl3 = listSelectionModel.getValueIsAdjusting();
                        listSelectionModel.setValueIsAdjusting(true);
                        boolean bl4 = listSelectionModel.isSelectedIndex(n2);
                        if (n3 != -1) {
                            if (bl4) {
                                listSelectionModel.removeSelectionInterval(n2, n3);
                                bl2 = false;
                            } else if (mouseEvent.getButton() == 1) {
                                listSelectionModel.addSelectionInterval(n2, n3);
                            }
                        }
                        if (bl4) {
                            listSelectionModel.addSelectionInterval(n2, n);
                        } else {
                            listSelectionModel.removeSelectionInterval(n2, n);
                            bl2 = false;
                        }
                        listSelectionModel.setValueIsAdjusting(bl3);
                    } else if (mouseEvent.getButton() == 1) {
                        listSelectionModel.setSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isControlDown()) {
                    if (listSelectionModel.isSelectedIndex(n)) {
                        listSelectionModel.removeSelectionInterval(n, n);
                        bl2 = false;
                    } else if (mouseEvent.getButton() == 1) {
                        listSelectionModel.addSelectionInterval(n, n);
                    }
                } else if (!((SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) && listSelectionModel.isSelectedIndex(n) || mouseEvent.getButton() != 1)) {
                    listSelectionModel.setSelectionInterval(n, n);
                }
                if (bl2) {
                    ImportTable.this.selectEntireColumns();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImportTable.this.fHeaderMouseReleaseLocation = mouseEvent.getPoint();
            super.mouseReleased(mouseEvent);
            ImportTable.this.processPossiblePopup(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            JTableHeader jTableHeader = ImportTable.this.getTableHeader();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            Point point = mouseEvent.getPoint();
            int n = jTableHeader.columnAtPoint(point);
            if (n == -1) {
                return;
            }
            if (this.isResizingColumn(jTableHeader, point, n)) {
                return;
            }
            if (!this.inSelectionArea(n, point)) {
                return;
            }
            ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
            if (!((SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) && listSelectionModel.isSelectedIndex(n) || mouseEvent.isControlDown())) {
                listSelectionModel.addSelectionInterval(listSelectionModel.getAnchorSelectionIndex(), n);
            }
            ImportTable.this.selectEntireColumns();
        }

        private boolean isResizingColumn(JTableHeader jTableHeader, Point point, int n) {
            Point point2 = new Point(point.x - 3, point.y);
            Point point3 = new Point(point.x + 3, point.y);
            int n2 = jTableHeader.columnAtPoint(point2);
            int n3 = jTableHeader.columnAtPoint(point3);
            if (n3 != n) {
                return true;
            }
            return n2 != n && n2 != -1;
        }
    }

    protected class ZoomInNumPadAction
    extends ZoomAction {
        public ZoomInNumPadAction() {
            super(107, 1.1, "ZoomInNumPadAction", "ActionNames.zoomin");
        }
    }

    protected class ZoomInAction
    extends ZoomAction {
        public ZoomInAction() {
            super(61, 1.1, "ZoomInAction", "ActionNames.zoomin", true);
        }
    }

    protected class ZoomOutNumPadAction
    extends ZoomAction {
        public ZoomOutNumPadAction() {
            super(109, 0.9, "ZoomOutNumPadAction", "ActionNames.zoomout");
        }
    }

    protected class ZoomOutAction
    extends ZoomAction {
        public ZoomOutAction() {
            super(45, 0.9, "ZoomOutAction", "ActionNames.zoomout");
        }
    }

    private class ZoomAction
    extends MJAbstractAction {
        private double fZoomFactor;

        ZoomAction(int n, double d, String string, String string2) {
            this(n, d, string, string2, false);
        }

        ZoomAction(int n, double d, String string, String string2, boolean bl) {
            this.fZoomFactor = d;
            this.setAccelerator(KeyStroke.getKeyStroke(n, 2));
            this.setComponentName(string);
            this.setName(ImportToolUtils.getResourceString(string2));
            if (bl) {
                ImportTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke(n, 3), (Action)((Object)this));
            } else {
                ImportTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke(n, 2), (Action)((Object)this));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportTable.this.zoom(this.fZoomFactor);
        }
    }

    protected class ClearAllSelectionAction
    extends MJAbstractAction {
        ClearAllSelectionAction() {
            this.setAccelerator(KeyStroke.getKeyStroke("ESCAPE"));
            this.setComponentName("ClearAllSelectionAction");
            this.setName(ImportToolUtils.getResourceString("ActionNames.clear"));
            ImportTable.this.registerWithInputMapNoKeyBindingManager(KeyStroke.getKeyStroke("ESCAPE"), (Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportTable.this.clearAllSelection();
        }
    }
}

