/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLLicenseChecker;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.HeaderRowListenerInterface;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.ImportToolstripTab;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportToolGroup;
import com.mathworks.mlwidgets.importtool.SpreadsheetTabbedPane;
import com.mathworks.mlwidgets.importtool.TextFilePane;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ImportClient
extends DTClientBase {
    protected ImportToolstripTab fImportToolstripTab;
    protected File fFileLocation;
    protected String fFileHash = "";
    protected JComponent fImportComponent;
    protected static Boolean sHasStats;
    private SpinnerMouseListener fSpinnerMouseListener = new SpinnerMouseListener();

    public static TargetType[] getTargetTypesForTesting() {
        return new TargetType[]{TargetType.COLUMNVECTORS, TargetType.MATRIX, TargetType.CELLARRAY, TargetType.DATASET};
    }

    void setFile(File file) {
        this.fFileLocation = file;
    }

    File getFile() {
        return this.fFileLocation;
    }

    protected synchronized String getFileHash() {
        return this.fFileHash;
    }

    protected synchronized void setFileHash() {
        try {
            if (this.getFile() != null) {
                this.fFileHash = FileUtils.generateFileHash((File)this.getFile());
            }
        }
        catch (IOException iOException) {
            this.fFileHash = "";
        }
    }

    protected abstract void cleanup(boolean var1);

    protected ImportClient(File file) {
        if (!Matlab.isMatlabAvailable()) {
            sHasStats = true;
        }
        if (sHasStats == null) {
            sHasStats = MLLicenseChecker.hasLicense((String)"statistics_toolbox") && ProductInfoUtils.isProductInstalled("Statistics");
        }
        this.setLayout(new BorderLayout());
        this.fFileLocation = file;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ImportClient.this.setFileHash();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        this.setName("ImportClient");
        this.setMultipleInstances(true);
        this.setPermitUserUndock(false);
        this.setGroup((DTGroupPropertyProvider)SpreadsheetImportToolGroup.getInstance());
        this.setDontReopen(true);
        final Desktop desktop = MatlabDesktopServices.getDesktop();
        if (desktop != null) {
            desktop.addClientListener((Component)((Object)this), (DTClientListener)new DTClientAdapter(){

                public void clientClosed(DTClientEvent dTClientEvent) {
                    desktop.removeClientListener((DTClientListener)this);
                    ImportClient.this.cleanup(true);
                }

                public void clientActivated(DTClientEvent dTClientEvent) {
                    if (ImportClient.this.isLastLoadedFileContentDifferentThanOnDiskFileContent()) {
                        ImportClient.this.reOpen(ImportClient.this.getFile().getPath());
                    }
                }
            });
        }
    }

    protected abstract void reOpen(String var1);

    protected boolean isLastLoadedFileContentDifferentThanOnDiskFileContent() {
        if (this.getFileHash() == null || this.getFileHash().isEmpty()) {
            return false;
        }
        try {
            String string = FileUtils.generateFileHash((File)this.getFile());
            return !string.equals(this.getFileHash());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected void addClient(Desktop desktop, String string) {
        String string2 = ImportToolUtils.getResourceString("spreadhseetimport.title");
        if (!desktop.hasGroup(string2)) {
            desktop.addGroup((DTGroupPropertyProvider)SpreadsheetImportToolGroup.getInstance());
        }
        if (!desktop.hasClient(string, SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME)) {
            desktop.addClient((Component)((Object)this), string, true, null, true);
        }
        desktop.setClientDocked((Component)((Object)this), true);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        if (desktop.useToolstrip() && this.fImportToolstripTab != null) {
            this.fImportToolstripTab.getComponent().setCursor(cursor);
        }
    }

    ImportToolstripTab getImportToolstripTab() {
        return this.fImportToolstripTab;
    }

    public JComponent getImportComponent() {
        return this.fImportComponent;
    }

    private void setVariableNamesHighlightRow(int n) {
        if (this.fImportComponent instanceof TextFilePane) {
            ((TextFilePane)this.fImportComponent).setVariableNamesHighlightRow(n);
        } else if (this.fImportComponent instanceof SpreadsheetTabbedPane) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).setVariableNamesHighlightRow(n);
        }
    }

    protected void addHeaderRowListener(JSpinner jSpinner, HeaderRowListenerInterface headerRowListenerInterface) {
        jSpinner.addChangeListener(new SpinnerChangeListener(headerRowListenerInterface));
        Component[] componentArray = jSpinner.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener(this.fSpinnerMouseListener);
        }
        ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField().addMouseListener(this.fSpinnerMouseListener);
    }

    protected void setHeaderRowSpinnerDefaultValue(JSpinner jSpinner, int n, int n2) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
        spinnerNumberModel.setMaximum(Integer.valueOf(n2));
        jSpinner.setValue(n <= 0 ? 1 : n + 1);
    }

    static class Target {
        TargetType iTargetType;
        private List<WorksheetRule> iWorksheetRules = new ArrayList<WorksheetRule>();

        Target(TargetType targetType) {
            this.iTargetType = targetType;
        }

        TargetType getTargetType() {
            return this.iTargetType;
        }

        public String toString() {
            if (this.iTargetType != null) {
                return this.iTargetType.toString();
            }
            return null;
        }

        public Icon getIcon() {
            if (this.iTargetType != null) {
                return this.iTargetType.getIcon();
            }
            return null;
        }

        List<WorksheetRule> getWorksheetRules() {
            return this.iWorksheetRules;
        }

        void setWorksheetRules(List<WorksheetRule> list) {
            this.iWorksheetRules = list;
        }

        void addWorksheetRule(WorksheetRule worksheetRule) {
            this.iWorksheetRules.add(worksheetRule);
        }
    }

    private class SpinnerMouseListener
    extends MouseAdapter {
        private boolean fMouseInComponent = false;

        private SpinnerMouseListener() {
        }

        public boolean isMouseInComponent() {
            return this.fMouseInComponent;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MJSpinner mJSpinner = ImportClient.this.fImportToolstripTab.getHeaderSpinner();
            if (mJSpinner.isEnabled()) {
                int n = (Integer)mJSpinner.getValue();
                ImportClient.this.setVariableNamesHighlightRow(n - 1);
                this.fMouseInComponent = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MJSpinner mJSpinner = ImportClient.this.fImportToolstripTab.getHeaderSpinner();
            if (mJSpinner.isEnabled()) {
                int n = (Integer)mJSpinner.getValue();
                ImportClient.this.setVariableNamesHighlightRow(n - 1);
                this.fMouseInComponent = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ImportClient.this.setVariableNamesHighlightRow(-1);
            this.fMouseInComponent = false;
        }
    }

    private class SpinnerChangeListener
    implements ChangeListener {
        private HeaderRowListenerInterface iHeaderRowListener = null;

        SpinnerChangeListener(HeaderRowListenerInterface headerRowListenerInterface) {
            this.iHeaderRowListener = headerRowListenerInterface;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            int n = (Integer)jSpinner.getValue();
            this.iHeaderRowListener.setHeaderRow(n - 1);
            if (((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField().hasFocus() && ImportClient.this.fSpinnerMouseListener.isMouseInComponent()) {
                ImportClient.this.setVariableNamesHighlightRow(n - 1);
            }
        }
    }

    static class ImportToolMenuBar
    extends MJMenuBar {
        ImportToolMenuBar(WorksheetTable worksheetTable) {
            Action action;
            MJMenu mJMenu = new MJMenu();
            this.add((JMenu)mJMenu);
            DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu);
            Action action2 = worksheetTable.getSelectAllAction();
            if (action2 != null) {
                action = new MJMenuItem(action2);
                mJMenu.add((JMenuItem)((Object)action));
                DTMenuMergeTag.SELECT_ALL.setTag((JMenuItem)((Object)action));
            }
            if ((action = worksheetTable.getCopyAction()) != null) {
                MJMenuItem mJMenuItem = new MJMenuItem(action);
                mJMenu.add((JMenuItem)mJMenuItem);
                DTMenuMergeTag.COPY.setTag((JMenuItem)mJMenuItem);
            }
        }
    }

    static class TargetRenderer
    extends DefaultListCellRenderer {
        TargetRenderer() {
            this.setHorizontalTextPosition(11);
            this.setIconTextGap(4);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setText(object.toString());
            if (object instanceof Target) {
                jLabel.setIcon(((Target)object).getIcon());
            }
            return jLabel;
        }
    }

    public static enum TargetType {
        MATRIX(ImportToolUtils.getResourceString("targettype.numeric"), ImportToolUtils.getResourceIcon("matrix.png")),
        COLUMNVECTORS(ImportToolUtils.getResourceString("targettype.vectors"), ImportToolUtils.getResourceIcon("columnvectors.png")),
        CELLARRAY(ImportToolUtils.getResourceString("targettype.cell"), ImportToolUtils.getResourceIcon("cellarray.png")),
        DATASET(ImportToolUtils.getResourceString("targettype.dataset"), ImportToolUtils.getResourceIcon("variable_dataset.png"));

        private String iIdentifier = "";
        private Icon iIcon;

        private TargetType(String string2, Icon icon) {
            this.iIdentifier = string2;
            this.iIcon = icon;
        }

        public String toString() {
            return this.iIdentifier;
        }

        public Icon getIcon() {
            return this.iIcon;
        }

        public boolean isCellArray() {
            return this == CELLARRAY;
        }

        public boolean isMatrix() {
            return this == MATRIX;
        }

        public boolean isColumnVectors() {
            return this == COLUMNVECTORS;
        }

        public boolean isDataSet() {
            return this == DATASET;
        }
    }
}

