/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.html.CharsetDetectionStrategy;
import com.mathworks.mlwidgets.html.DefaultPDFFileHandler;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLRendererSupport;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.JarFileLinkListener;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.mlwidgets.html.PDFFileHandler;
import com.mathworks.mlwidgets.html.WebRendererCachedBrowser;
import com.mathworks.mlwidgets.html.WebRendererFocusRequest;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.services.Prefs;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.Desktop;
import com.webrenderer.BrowserFactory;
import com.webrenderer.IBrowserCanvas;
import com.webrenderer.IMozillaBrowserCanvas;
import com.webrenderer.ProxySetting;
import com.webrenderer.dom.IDocument;
import com.webrenderer.dom.IElement;
import com.webrenderer.dom.IElementCollection;
import com.webrenderer.dom.IRange;
import com.webrenderer.event.BrowserAdapter;
import com.webrenderer.event.BrowserEvent;
import com.webrenderer.event.BrowserListener;
import com.webrenderer.event.KeyAdapter;
import com.webrenderer.event.KeyListener;
import com.webrenderer.event.MouseAdapter;
import com.webrenderer.event.MouseEvent;
import com.webrenderer.event.MouseListener;
import com.webrenderer.event.NetworkAdapter;
import com.webrenderer.event.NetworkEvent;
import com.webrenderer.event.NetworkListener;
import com.webrenderer.event.PrintEvent;
import com.webrenderer.event.PrintListener;
import com.webrenderer.event.PromptEvent;
import com.webrenderer.event.PromptListener;
import com.webrenderer.event.ProtocolEvent;
import com.webrenderer.event.ProtocolListener;
import com.webrenderer.event.WindowEvent;
import com.webrenderer.event.WindowListener;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class WebRenderer
extends HTMLRendererSupport {
    private static final int NOT_NAVIGATING = 0;
    private static final int NAVIGATING_BACK = 1;
    private static final int NAVIGATING_FORWARD = 2;
    private static final int NAVIGATING_RELOAD = 3;
    private static final Pattern NON_ASCII_PATTERN;
    private static boolean sFirstTime;
    private MJLabel fLoadingMessageLabel = null;
    private static String sLanguage;
    private static LanguageLocale sLanguageLocale;
    private static List<String> sLanguageFonts;
    private static long sTwipConversionFactor;
    private IBrowserCanvas fBrowser;
    private String fTitle;
    private String fCurrentLocation;
    private Runnable fQueuedLoadRunnable = null;
    private HTMLRenderer fParent;
    private MJPopupMenu fPopupMenu;
    private WebRendererCachedBrowser fCachedBrowser;
    private String fPendingUrl;
    private boolean fNavigationEnabled = true;
    private int fNavigating = 0;
    private static boolean sMatlabProtocolOK;
    private Matlab fMatlab = new Matlab();
    private PDFFileHandler fPdfFileHandler;
    private Font fInitialFont = null;
    private Thread fSetupThread;
    private int fHistoryPos = -1;
    private List<Runnable> fAfterSetup = new ArrayList<Runnable>();
    private MatlabProxyListener fProxyListener;
    private boolean fDisposed = false;
    private RunWhenVisible fRunWhenVisible = null;
    private final SynchronizationManager fSyncManager = new SynchronizationManager();
    private static final List<Pattern> sDialogExclusions;
    private static final Map<Pattern, String> sLocalizedMessages;
    private static final Set<String> sFormTags;
    private static String sAdaptiveDocString;
    private static final String[] sAdaptiveDocProducts;
    private static final String BLANK_PAGE_URL = "about:blank";
    private BrowserCreationListener fCreationListener;
    private WebRendererFocusRequest fActiveFocusRequest = null;
    private boolean fAlreadyFocused = false;

    private static void initializeLanguageLocale() {
        sLanguageLocale = LanguageLocale.getSupportedLanguageLocale(sLanguage, Locale.getDefault().getCountry());
        if (!sLanguageLocale.getLanguage().equalsIgnoreCase(sLanguage)) {
            sLanguageLocale = null;
        }
    }

    private static void initializeLanguageFonts() {
        sLanguageFonts = new ArrayList<String>();
        sLanguageFonts.add("x-western");
        for (LanguageLocale languageLocale : LanguageLocale.values()) {
            if (!WebRenderer.nonWestern(languageLocale)) continue;
            sLanguageFonts.add(languageLocale.getLanguage());
        }
    }

    private static boolean nonWestern(LanguageLocale languageLocale) {
        switch (languageLocale) {
            case JAPANESE: 
            case SIMPLIFIED_CHINESE: {
                return true;
            }
        }
        return false;
    }

    static String[] getClassNames() {
        return new String[]{"com.webrenderer.BrowserFactory", "com.webrenderer.IBrowserCanvas", "com.webrenderer.IMozillaBrowserCanvas"};
    }

    WebRenderer(BrowserCreationListener browserCreationListener) {
        this.fCreationListener = browserCreationListener;
    }

    private static void setMLRoot(String string) {
        HTMLRenderer.setMatlabRoot(string);
    }

    @Override
    HTMLRendererSupport createRenderer(HTMLRenderer hTMLRenderer) {
        this.fParent = hTMLRenderer;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        return this;
    }

    private synchronized boolean createWebRenderer() {
        if (this.shouldCancelSetup()) {
            return false;
        }
        if (this.getSetupThread() == null) {
            this.fSetupThread = new Thread(new SetupThread());
            if (sFirstTime) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebRenderer.this.displayLoadingMessage();
                        WebRenderer.this.getSetupThread().start();
                    }
                });
                sFirstTime = false;
            } else {
                this.getSetupThread().start();
            }
        }
        return true;
    }

    private synchronized Thread getSetupThread() {
        return this.fSetupThread;
    }

    public void addNotify() {
        super.addNotify();
        if (this.fRunWhenVisible != null) {
            this.fRunWhenVisible.run();
            this.fRunWhenVisible = null;
        }
    }

    private void displayLoadingMessage() {
        assert (this.fInitialFont != null) : "Initial font should not be null";
        this.fLoadingMessageLabel = new MJLabel(HTMLUtils.sRes.getString("loading"));
        this.fLoadingMessageLabel.setFont(this.fInitialFont.deriveFont(16.0f));
        this.fLoadingMessageLabel.setHorizontalAlignment(0);
        ImageIcon imageIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/mathworks/mlwidgets/html/resources/earth_and_membrane.png"));
        this.fLoadingMessageLabel.setIcon((Icon)imageIcon);
        this.add((Component)this.fLoadingMessageLabel, "North");
        this.validate();
    }

    synchronized boolean addPostSetupThread(Runnable runnable) {
        if (this.fAfterSetup != null) {
            this.fAfterSetup.add(runnable);
            return true;
        }
        return false;
    }

    private synchronized Runnable getNextPostSetupThread() {
        if (this.shouldCancelSetup()) {
            return null;
        }
        if (this.fAfterSetup != null && !this.fAfterSetup.isEmpty()) {
            return this.fAfterSetup.remove(0);
        }
        this.fAfterSetup = null;
        return null;
    }

    private static void setPrefProperties(IBrowserCanvas iBrowserCanvas) {
        if (sLanguageLocale != null) {
            switch (sLanguageLocale) {
                case SIMPLIFIED_CHINESE: {
                    iBrowserCanvas.setPrefProperty("intl.charset.detector", "universal_charset_detector");
                    break;
                }
                case JAPANESE: {
                    iBrowserCanvas.setPrefProperty("intl.charset.detector", "universal_charset_detector");
                    iBrowserCanvas.setPrefProperty("intl.charset.default", NativeJava.getSystemCharEncoding());
                    break;
                }
            }
        }
        iBrowserCanvas.setPrefProperty("security.warn_submit_insecure", false);
        iBrowserCanvas.setPrefProperty("dom.max_script_run_time", 20);
    }

    private synchronized MatlabProxyListener createProxyListener() {
        this.fProxyListener = new MatlabProxyListener();
        return this.fProxyListener;
    }

    private synchronized MatlabProxyListener getProxyListener() {
        return this.fProxyListener;
    }

    private void addWebRenderer(IBrowserCanvas iBrowserCanvas, WebRendererCachedBrowser webRendererCachedBrowser) {
        Canvas canvas = iBrowserCanvas.getCanvas();
        this.add(canvas, "Center");
        canvas.setFocusTraversalKeysEnabled(false);
        canvas.setFocusable(true);
        if (PlatformInfo.isWindows()) {
            canvas.addFocusListener(new CanvasFocusListener());
        }
        this.validate();
        if (this.fInitialFont != null) {
            WebRenderer.setHTMLFont(iBrowserCanvas, this.fInitialFont);
        }
        this.fCachedBrowser = webRendererCachedBrowser;
        this.setBrowser(iBrowserCanvas);
        Runnable runnable = this.getNextPostSetupThread();
        while (runnable != null) {
            runnable.run();
            runnable = this.getNextPostSetupThread();
        }
        if (this.shouldCancelSetup()) {
            this.dispose();
        }
    }

    private static Canvas findCanvas(Component component) {
        if (component instanceof Canvas) {
            return (Canvas)component;
        }
        if (component instanceof Container) {
            int n = ((Container)component).getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = ((Container)component).getComponent(i);
                Canvas canvas = WebRenderer.findCanvas(component2);
                if (canvas == null) continue;
                return canvas;
            }
        }
        return null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        Canvas canvas = WebRenderer.findCanvas((Component)this.getBrowser());
        if (canvas != null) {
            canvas.setVisible(bl);
        }
    }

    @Override
    void setHTMLFont(Font font) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            this.fInitialFont = font;
        } else {
            WebRenderer.setHTMLFont(iBrowserCanvas, font);
        }
    }

    private static void setHTMLFont(IBrowserCanvas iBrowserCanvas, Font font) {
        String string = font.getFamily();
        string = FontUtils.getOSFontName((String)string);
        LanguageLocale languageLocale = sLanguageLocale;
        if (languageLocale == null) {
            languageLocale = LanguageLocale.ENGLISH;
        }
        string = WebRenderer.getFontFamilyForLocale(languageLocale, font, string);
        iBrowserCanvas.setPrefProperty("font.default", string);
        int n = font.getSize();
        iBrowserCanvas.setPrefProperty("font.default." + sLanguage, string);
        iBrowserCanvas.setPrefProperty("font.size.variable." + sLanguage, n);
        iBrowserCanvas.setPrefProperty("font.size.fixed." + sLanguage, n);
        for (String string2 : sLanguageFonts) {
            iBrowserCanvas.setPrefProperty("font.default." + string2, string);
            iBrowserCanvas.setPrefProperty("font.size.variable." + string2, n);
            iBrowserCanvas.setPrefProperty("font.size.fixed." + string2, n);
        }
    }

    private static String getFontFamilyForLocale(LanguageLocale languageLocale, Font font, String string) {
        String string2 = font.getName();
        if (languageLocale.equals((Object)LanguageLocale.JAPANESE) && !string2.equals(string) && NON_ASCII_PATTERN.matcher(string2).find()) {
            return languageLocale.getFontFamily(string2);
        }
        return languageLocale.getFontFamily(string);
    }

    @Override
    boolean canGoBack(String string) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        return iBrowserCanvas != null && iBrowserCanvas.canGoBack() && this.fHistoryPos > -1;
    }

    @Override
    boolean canGoForward(String string) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        return iBrowserCanvas != null && iBrowserCanvas.canGoForward();
    }

    @Override
    void goBack() {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas != null && this.canGoBack(this.getViewportName())) {
            this.fNavigating = 1;
            iBrowserCanvas.goBack();
            --this.fHistoryPos;
            this.enableDisableEvents(false);
        }
    }

    @Override
    void goForward() {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas != null && this.canGoForward(this.getViewportName())) {
            this.fNavigating = 2;
            iBrowserCanvas.goForward();
            ++this.fHistoryPos;
            this.enableDisableEvents(false);
        }
    }

    @Override
    void reload() {
        this.reload(true);
    }

    @Override
    void copySelection() {
        this.getBrowser().copy();
    }

    private String getCurrentURL() {
        if (this.fCurrentLocation != null && this.fCurrentLocation.length() > 0 && !this.fCurrentLocation.equals(BLANK_PAGE_URL) && !this.fCurrentLocation.startsWith("matlab:")) {
            return this.fCurrentLocation;
        }
        return this.getBrowserURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBrowserURL() {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            return null;
        }
        SynchronizationManager synchronizationManager = this.fSyncManager;
        synchronized (synchronizationManager) {
            if (this.fSyncManager.getLoadingState() == LoadingState.NOT_LOADING) {
                return iBrowserCanvas.getURL();
            }
        }
        return null;
    }

    private void reload(boolean bl) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            return;
        }
        String string = this.getBrowserURL();
        if (HTMLUtils.needsDecoding(string)) {
            string = HTMLUtils.decodeUrl(string);
        }
        if (bl && string != null && string.startsWith("text:") && !string.equals(this.getCurrentLocation())) {
            String string2 = this.fCachedBrowser.getHTML(string);
            string2 = string2.replaceAll("<!--\\.highlight", "<!--.nohighlight");
            this.fCachedBrowser.setHTML(string, string2);
        }
        this.fNavigating = 3;
        iBrowserCanvas.reload(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getSelectedText() {
        String string;
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        SynchronizationManager synchronizationManager = this.fSyncManager;
        synchronized (synchronizationManager) {
            if (iBrowserCanvas == null) {
                return "";
            }
            string = iBrowserCanvas.getSelectedText();
            if (string == null || string.length() == 0) {
                return "";
            }
            IDocument iDocument = iBrowserCanvas.getDocument();
            if (iDocument == null) {
                return "";
            }
            IRange iRange = iDocument.getSelectionAsRange();
            if (iRange != null) {
                IElement iElement = iRange.getCommonAncestorContainer();
                if (iElement != null && WebRenderer.eltInTag(iElement, "pre") && !string.contains("\n")) {
                    string = iRange.toString();
                }
            } else {
                String string2 = iDocument.getActiveInnerHTML();
                if (string2 != null) {
                    string = string.replaceAll("\\<.*?\\>", "");
                }
            }
        }
        if (string != null) {
            string = string.replace('\u00c3', ' ');
            string = string.replace('\u0082', ' ');
            string = string.replace('\u00c2', ' ');
            string = string.replace('\u00a0', ' ');
        } else {
            string = "";
        }
        return string;
    }

    private static boolean eltInTag(IElement iElement, String string) {
        String string2 = iElement.getTagName();
        if (string2 != null && string2.equalsIgnoreCase(string)) {
            return true;
        }
        IElement iElement2 = iElement.getParentElement();
        return iElement2 != null && WebRenderer.eltInTag(iElement2, string);
    }

    @Override
    void saveAs(File file) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            return;
        }
        iBrowserCanvas.saveToFile(file.getAbsolutePath());
    }

    @Override
    void print(ActionListener actionListener) {
        if (this.getBrowser() == null) {
            return;
        }
        SwingUtilities.invokeLater(new PrinterJob(actionListener));
    }

    private void enableDisableEvents(boolean bl) {
        this.fParent.enableDisableEvents(bl);
    }

    @Override
    void setCurrentLocation(String string) {
        this.doLoadInBrowser(new SetLocationThread(string), string);
    }

    @Override
    void disableNavigation() {
        this.fNavigationEnabled = false;
        if (this.fCachedBrowser != null) {
            this.fCachedBrowser.setNavigationEnabled(false);
        }
    }

    @Override
    void clearHistory() {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas != null) {
            iBrowserCanvas.getHistory().clear();
            this.fHistoryPos = -1;
        }
    }

    @Override
    String getCurrentLocation() {
        String string = this.getCurrentURL();
        if (string == null) {
            string = "";
        }
        if (string.startsWith("text:")) {
            string = this.fCachedBrowser.getUrl(string);
        }
        if (HTMLUtils.needsDecoding(string)) {
            string = HTMLUtils.decodeUrl(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getCurrentPageTitle() {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            return null;
        }
        String string = this.fTitle;
        if (string == null || string.length() == 0) {
            SynchronizationManager synchronizationManager = this.fSyncManager;
            synchronized (synchronizationManager) {
                if (this.fSyncManager.getLoadingState() == LoadingState.NOT_LOADING) {
                    string = iBrowserCanvas.getTitle();
                    string = string.replaceAll("</?font[^>]*>", "");
                }
            }
        }
        if (string == null || string.length() == 0) {
            string = this.getCurrentLocation();
        }
        return string;
    }

    @Override
    void setHtmlText(String string) {
        this.setHtmlText("", string);
    }

    @Override
    void setHtmlText(String string, String string2) {
        this.doLoadInBrowser(new SetHtmlTextThread(string2, string), string);
    }

    private void doLoadInBrowser(Runnable runnable, String string) {
        if (!this.createWebRenderer()) {
            return;
        }
        LoadInBrowserRunnable loadInBrowserRunnable = new LoadInBrowserRunnable(runnable, string);
        if (!this.addPostSetupThread(loadInBrowserRunnable)) {
            if (!WebRenderer.canLoadWhenNotVisible() && !this.isShowing()) {
                if (this.fRunWhenVisible != null) {
                    this.fRunWhenVisible.setRunnable(loadInBrowserRunnable);
                } else {
                    this.fRunWhenVisible = new RunWhenVisible(loadInBrowserRunnable, false);
                }
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                loadInBrowserRunnable.run();
            } else {
                SwingUtilities.invokeLater(loadInBrowserRunnable);
            }
        }
    }

    private boolean isLoadPending() {
        return this.getPendingUrl() != null;
    }

    private synchronized void setPendingUrl(String string) {
        this.fPendingUrl = string;
    }

    private synchronized String getPendingUrl() {
        return this.fPendingUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getHtmlText() {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            return null;
        }
        String string = this.getBrowserURL();
        String string2 = null;
        if (string != null) {
            if (string.startsWith("text://")) {
                string2 = this.fCachedBrowser.getHTML(string);
            } else if (!(string.equals(BLANK_PAGE_URL) || (string2 = HTMLUtils.getSource(string, CharsetDetectionStrategy.getAutoDetectStrategy())) != null && string2.length() != 0)) {
                SynchronizationManager synchronizationManager = this.fSyncManager;
                synchronized (synchronizationManager) {
                    if (this.fSyncManager.getLoadingState() == LoadingState.NOT_LOADING) {
                        string2 = iBrowserCanvas.getDocument().getDocumentSource();
                    }
                }
            }
        }
        return string2;
    }

    @Override
    boolean search(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas != null && iBrowserCanvas.getBrowserType().equals("MOZILLA")) {
            IMozillaBrowserCanvas iMozillaBrowserCanvas = (IMozillaBrowserCanvas)iBrowserCanvas;
            boolean bl5 = iMozillaBrowserCanvas.findInPage(string, bl2, false, bl, bl3);
            if (!bl5) {
                Toolkit.getDefaultToolkit().beep();
                if (bl4) {
                    bl5 = iMozillaBrowserCanvas.findInPage(string, bl2, true, bl, bl3);
                }
            }
            return bl5;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void scrollToBottom() {
        SynchronizationManager synchronizationManager = this.fSyncManager;
        synchronized (synchronizationManager) {
            if (this.fSyncManager.getLoadingState() == LoadingState.NOT_LOADING) {
                IBrowserCanvas iBrowserCanvas = this.getBrowser();
                iBrowserCanvas.getDocument().scrollTo(0L, (long)iBrowserCanvas.getPageSize().getHeight() * sTwipConversionFactor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void scrollToTarget(String string) {
        IDocument iDocument;
        SynchronizationManager synchronizationManager = this.fSyncManager;
        synchronized (synchronizationManager) {
            iDocument = this.getBrowser().getDocument();
        }
        try {
            synchronizationManager = iDocument.getAll();
            for (int i = 0; i < synchronizationManager.length(); ++i) {
                String string2;
                IElement iElement = synchronizationManager.item(i);
                if (!iElement.getTagName().equalsIgnoreCase("a") || (string2 = iElement.getAttribute("name", 0L)) == null || !string2.equalsIgnoreCase(string)) continue;
                iElement.scrollIntoView(true);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVerticalScrollPosition(int n) {
        SynchronizationManager synchronizationManager = this.fSyncManager;
        synchronized (synchronizationManager) {
            if (this.fSyncManager.getLoadingState() == LoadingState.NOT_LOADING) {
                this.getBrowser().getDocument().scrollTo(0L, (long)n * sTwipConversionFactor);
            }
        }
    }

    @Override
    public boolean canExecuteScripts() {
        this.waitForSetup();
        return this.getBrowser() != null;
    }

    @Override
    public boolean canModifyDom() {
        return true;
    }

    @Override
    public void executeScript(final String string) throws UnsupportedOperationException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IBrowserCanvas iBrowserCanvas = WebRenderer.this.getBrowser();
                if (iBrowserCanvas == null) {
                    throw new UnsupportedOperationException();
                }
                iBrowserCanvas.executeScript(string);
            }
        };
        if (!this.addPostSetupThread(runnable)) {
            runnable.run();
        }
    }

    @Override
    public String executeScriptWithReturn(String string) throws UnsupportedOperationException {
        this.waitForSetup();
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            throw new UnsupportedOperationException();
        }
        return iBrowserCanvas.executeScriptWithReturn(string);
    }

    private void waitForSetup() {
        Thread thread;
        if (this.createWebRenderer() && (thread = this.getSetupThread()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setElementText(String string, String string2) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            return;
        }
        IDocument iDocument = iBrowserCanvas.getDocument();
        if (iDocument == null) {
            return;
        }
        IElement iElement = iDocument.getElementById(string);
        if (iElement != null) {
            iElement.putInnerHTML(string2);
        }
    }

    @Override
    public String getElementText(String string) {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas == null) {
            return null;
        }
        IDocument iDocument = iBrowserCanvas.getDocument();
        if (iDocument == null) {
            return null;
        }
        IElement iElement = iDocument.getElementById(string);
        if (iElement != null) {
            return iElement.getInnerHTML();
        }
        return null;
    }

    @Override
    public synchronized void dispose() {
        IBrowserCanvas iBrowserCanvas = this.getBrowser();
        if (iBrowserCanvas != null) {
            this.handleDisposal(iBrowserCanvas);
        } else {
            this.cancelSetup();
        }
    }

    private synchronized void cancelSetup() {
        this.fDisposed = true;
    }

    private synchronized boolean shouldCancelSetup() {
        return this.fDisposed;
    }

    private void handleDisposal(IBrowserCanvas iBrowserCanvas) {
        MatlabProxyListener matlabProxyListener;
        if (iBrowserCanvas != null) {
            WebRenderer.destroyBrowser(iBrowserCanvas);
        }
        if ((matlabProxyListener = this.getProxyListener()) != null) {
            HTMLPrefs.removeProxyListener(matlabProxyListener);
        }
    }

    private static void destroyBrowser(IBrowserCanvas iBrowserCanvas) {
        if (PlatformInfo.isLinux()) {
            iBrowserCanvas.destroy();
        } else {
            BrowserFactory.destroyBrowser((IBrowserCanvas)iBrowserCanvas);
        }
    }

    private void setCurrentLocationField(String string) {
        if (string == null) {
            this.fCurrentLocation = null;
        } else if (!string.startsWith("javascript:")) {
            this.fCurrentLocation = string;
        }
    }

    private void executeAdaptiveDocScript() {
        this.getBrowser().executeScript("if (adaptiveDocPresent) { doAdaptiveDoc('" + sAdaptiveDocString + "'); }");
    }

    private boolean isFocusInFormField() {
        IElement iElement = PlatformInfo.isWindows() ? this.getBrowser().getElementAtCaretPosition(true) : this.getBrowser().getDocument().getActiveElement();
        return iElement != null && WebRenderer.containsFormField(iElement);
    }

    private static boolean containsFormField(IElement iElement) {
        if (WebRenderer.isFormField(iElement)) {
            return true;
        }
        if (iElement != null) {
            IElementCollection iElementCollection = iElement.getChildElements();
            for (int i = 0; i < iElementCollection.length(); ++i) {
                if (!WebRenderer.containsFormField(iElementCollection.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFormField(IElement iElement) {
        String string;
        if (iElement != null && (string = iElement.getTagName()) != null) {
            string = string.toLowerCase(Locale.ENGLISH);
            return sFormTags.contains(string);
        }
        return false;
    }

    private static void modifyFileColonLinks(IDocument iDocument, Set<String> set) {
        IDocument[] iDocumentArray;
        if (iDocument.getElementById("doclinksfixed") == null) {
            IElement iElement;
            iDocumentArray = iDocument.getAnchors();
            if (iDocumentArray != null) {
                for (int i = 0; i < iDocumentArray.length(); ++i) {
                    iElement = iDocumentArray.item(i);
                    String string = iElement.getAttribute("href", 0L);
                    if (string == null || !string.startsWith("file:..")) continue;
                    iElement.setAttribute("href", (Object)string.replaceFirst("file", "xprod"), 0L);
                }
            }
            IDocument[] iDocumentArray2 = iDocument.createRange();
            iDocumentArray2.setStartBefore(iDocument.getBody());
            iElement = iDocument.createElement("a");
            iElement.putId("doclinksfixed");
            iDocumentArray2.surroundContents(iElement);
        }
        set.add(iDocument.getURL());
        iDocumentArray = iDocument.getChildFrames();
        if (iDocumentArray != null) {
            for (IDocument iDocument2 : iDocumentArray) {
                if (iDocument2.getURL() == null || set.contains(iDocument2.getURL())) continue;
                WebRenderer.modifyFileColonLinks(iDocument2, set);
            }
        }
    }

    private void showLinkErrPage(String string) {
        this.setPendingUrl(null);
        this.fParent.showLinkErrPage(string);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (PlatformInfo.isLinux()) {
            int n2 = keyStroke.getKeyCode();
            if (keyStroke.getKeyEventType() == 401) {
                switch (n2) {
                    case 116: {
                        this.fParent.getActions().fReloadAction.processOnceUntilReset();
                        break;
                    }
                    case 120: {
                        this.fParent.getActions().fEvalSelectionAction.processOnceUntilReset();
                    }
                }
            } else if (keyStroke.getKeyEventType() == 402) {
                switch (n2) {
                    case 116: {
                        this.fParent.getActions().fReloadAction.reset();
                        break;
                    }
                    case 120: {
                        this.fParent.getActions().fEvalSelectionAction.reset();
                    }
                }
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private void showPopupMenu(Component component, int n, int n2) {
        if (this.fPopupMenu == null) {
            this.fPopupMenu = this.fParent.createPopupMenu();
            this.fPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    WebRenderer.this.requestFocusInWindow();
                }
            });
        }
        this.fPopupMenu.show(component, n, n2);
    }

    private boolean isTargetOnCurrentPage(String string) {
        String string2 = this.getBrowser().getURL();
        return HTMLUtils.isTargetOnPage(string2, string);
    }

    private void cancelFocusRequest() {
        this.setActiveFocusRequest(null);
    }

    synchronized void setActiveFocusRequest(WebRendererFocusRequest webRendererFocusRequest) {
        this.fActiveFocusRequest = webRendererFocusRequest;
    }

    synchronized WebRendererFocusRequest getActiveFocusRequest() {
        return this.fActiveFocusRequest;
    }

    public boolean requestFocusInWindow() {
        if (!this.isAlreadyFocused()) {
            new WebRendererFocusRequest(this).doFocusRequest();
        }
        return true;
    }

    void doComponentFocusRequest() {
        super.requestFocusInWindow();
    }

    void setAlreadyFocused(boolean bl) {
        this.fAlreadyFocused = bl;
    }

    private boolean isAlreadyFocused() {
        return this.fAlreadyFocused;
    }

    @Override
    void clearBrowser() {
        if (!WebRenderer.canLoadWhenNotVisible() && !this.isShowing()) {
            this.fRunWhenVisible = new RunWhenVisible();
        } else {
            this.setCurrentLocation(BLANK_PAGE_URL);
        }
    }

    private void notifyPageChangedListeners(String string, String string2, boolean bl) {
        String string3;
        if (string2 == null || string == null || string2.equals(BLANK_PAGE_URL)) {
            return;
        }
        String string4 = string2;
        if (string4.startsWith("text://") && (string3 = this.fCachedBrowser.getUrl(string2)) != null) {
            string4 = string3;
        }
        this.fParent.notifyPageChangedListeners(string, string4, bl);
    }

    private static void setWebRendererProxySettings(IBrowserCanvas iBrowserCanvas) {
        if (HTMLPrefs.getUseProxy()) {
            int n;
            String string = HTMLPrefs.getProxyHost();
            try {
                n = Integer.parseInt(HTMLPrefs.getProxyPort());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            ProxySetting proxySetting = new ProxySetting(31, string, n);
            iBrowserCanvas.setProxyProtocol(proxySetting);
            String string2 = HTMLPrefs.getProxyUsername();
            String string3 = HTMLPrefs.getProxyPassword();
            if (string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0 && iBrowserCanvas instanceof IMozillaBrowserCanvas) {
                IMozillaBrowserCanvas iMozillaBrowserCanvas = (IMozillaBrowserCanvas)iBrowserCanvas;
                iMozillaBrowserCanvas.setProxyAuthentication(string2, string3);
            }
            iBrowserCanvas.enableProxy();
        } else {
            iBrowserCanvas.disableProxy();
        }
    }

    private static boolean canLoadWhenNotVisible() {
        return PlatformInfo.isWindows();
    }

    @Override
    boolean isFocusInRenderer() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return component == null;
    }

    synchronized IBrowserCanvas getBrowser() {
        return this.fBrowser;
    }

    synchronized void setBrowser(IBrowserCanvas iBrowserCanvas) {
        this.fBrowser = iBrowserCanvas;
    }

    @Override
    void disableDefaultDropTarget() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IBrowserCanvas iBrowserCanvas = WebRenderer.this.getBrowser();
                if (iBrowserCanvas != null && iBrowserCanvas instanceof IMozillaBrowserCanvas) {
                    ((IMozillaBrowserCanvas)iBrowserCanvas).disableDefaultDropTargetListener(true);
                }
            }
        };
        if (!this.addPostSetupThread(runnable)) {
            runnable.run();
        }
    }

    @Override
    void setWaitCursor(boolean bl) {
        this.setWaitCursor(this.getBrowser(), bl);
    }

    private void setWaitCursor(IBrowserCanvas iBrowserCanvas, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new CursorHandler(bl));
        } else {
            Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
            if (iBrowserCanvas != null) {
                iBrowserCanvas.getCanvas().setCursor(cursor);
            }
            this.setCursor(cursor);
        }
    }

    static {
        String[] stringArray;
        NON_ASCII_PATTERN = Pattern.compile("[^\\x00-\\x7f]");
        sFirstTime = true;
        sLanguage = Locale.getDefault().getLanguage();
        sLanguageLocale = null;
        sTwipConversionFactor = Toolkit.getDefaultToolkit().getScreenResolution() * 15 / 96;
        sMatlabProtocolOK = false;
        sAdaptiveDocProducts = new String[]{"Compiler", "Control_Toolbox", "Distrib_Computing_Toolbox", "Filter_Design_Toolbox", "Fixed-Point_Blocks", "Fixed_Point_Toolbox", "MATLAB_Builder_for_dot_Net", "MATLAB_Builder_for_Java", "MATLAB_Excel_Builder", "Real-Time_Win_Target", "Real-Time_Workshop", "RTW_Embedded_Coder", "Signal_Blocks", "SimEvents", "Simulink", "SL_Verification_Validation", "Signal_Toolbox", "Stateflow", "SystemTest", "Virtual_Reality_Toolbox", "XPC_Target", "Video_and_Image_Blockset", "Embedded_IDE_Link", "Target_Support_Package"};
        WebRenderer.initializeLanguageLocale();
        WebRenderer.initializeLanguageFonts();
        String string = Prefs.getPropertyDirectory();
        String string2 = HTMLRenderer.getMatlabRoot() + File.separator + "sys";
        String string3 = HTMLPrefs.getWebRendererRoot();
        if (!string3.equals(string2)) {
            stringArray = new File(string + File.separator + "WebRenderer" + File.separator + "secmod.db");
            if (stringArray.exists()) {
                try {
                    stringArray.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HTMLPrefs.setWebRendererRoot(string2);
        }
        BrowserFactory.setProfilePath((File)new File(string));
        BrowserFactory.setLicenseData((String)"mathwrks", (String)"K1TMGHUSIAT1LU4LI5M3RL90");
        BrowserFactory.setHomeDirectory((String)string2);
        BrowserFactory.setWebRendererDirectoryName((String)"webrenderer");
        stringArray = new String[]{"is not a registered protocol", "Please check the (name|location) and try again", "isn't associated with any program.", "Firefox can't find the (file|server) at", "The URL is not valid and cannot be loaded."};
        sDialogExclusions = new ArrayList<Pattern>();
        for (String string4 : stringArray) {
            sDialogExclusions.add(Pattern.compile(string4));
        }
        sFormTags = new HashSet<String>();
        sFormTags.add("input");
        sFormTags.add("textarea");
        sFormTags.add("select");
        sFormTags.add("button");
        sLocalizedMessages = new HashMap<Pattern, String>();
        sLocalizedMessages.put(Pattern.compile("done", 2), "status.done");
        sLocalizedMessages.put(Pattern.compile("transferring data from (.*)...", 2), "status.transferring");
        sLocalizedMessages.put(Pattern.compile("waiting for (.*)...", 2), "status.waiting");
        sLocalizedMessages.put(Pattern.compile("connecting to (.*)...", 2), "status.connecting");
        sLocalizedMessages.put(Pattern.compile("looking up (.*)...", 2), "status.looking_up");
    }

    private class CursorHandler
    implements Runnable {
        private boolean fOn;

        private CursorHandler(boolean bl) {
            this.fOn = bl;
        }

        @Override
        public void run() {
            WebRenderer.this.setWaitCursor(WebRenderer.this.getBrowser(), this.fOn);
        }
    }

    static interface BrowserCreationListener {
        public void creationFailed();

        public void creationSucceeded();
    }

    private class RunWhenVisible
    implements Runnable {
        private boolean iClear = false;
        private Runnable iRunnable;

        private RunWhenVisible() {
            this.iClear = true;
        }

        private RunWhenVisible(Runnable runnable, boolean bl) {
            this.iRunnable = runnable;
            this.iClear = bl;
        }

        private void setRunnable(Runnable runnable) {
            this.iRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.iClear) {
                WebRenderer.this.clearBrowser();
                WebRenderer.this.setPendingUrl(null);
            }
            if (this.iRunnable != null) {
                this.iRunnable.run();
            }
        }
    }

    private static class SynchronizationManager {
        private LoadingState iState = LoadingState.INITIAL;

        private SynchronizationManager() {
        }

        private synchronized void setLoadingState(LoadingState loadingState) {
            this.iState = loadingState;
        }

        private synchronized LoadingState getLoadingState() {
            return this.iState;
        }
    }

    private class PopupWindowListener
    extends com.webrenderer.event.WindowAdapter {
        private PopupWindowListener() {
        }

        public void onNewWindow(WindowEvent windowEvent) {
            WebRenderer.this.setPendingUrl(null);
            WebRenderer.this.cancelFocusRequest();
            final MJFrame mJFrame = new MJFrame();
            final IBrowserCanvas iBrowserCanvas = windowEvent.getPopupBrowser();
            mJFrame.getContentPane().add(iBrowserCanvas.getCanvas());
            iBrowserCanvas.addWindowListener((WindowListener)new com.webrenderer.event.WindowAdapter(){

                public void onWindowDestroy(WindowEvent windowEvent) {
                    mJFrame.dispose();
                }
            });
            mJFrame.addWindowListener((java.awt.event.WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(java.awt.event.WindowEvent windowEvent) {
                    WebRenderer.destroyBrowser(iBrowserCanvas);
                }
            });
            mJFrame.setName("HtmlPopupFrame");
            mJFrame.setSize(windowEvent.getWidth(), windowEvent.getHeight());
            mJFrame.setVisible(true);
        }
    }

    private class MatlabProxyListener
    implements ActionListener {
        private MatlabProxyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WebRenderer.setWebRendererProxySettings(WebRenderer.this.getBrowser());
                }
            };
            if (!WebRenderer.this.addPostSetupThread(runnable)) {
                runnable.run();
            }
        }
    }

    private class MatlabProtocolListener
    implements ProtocolListener {
        private MatlabProtocolListener() {
        }

        public void onOpen(ProtocolEvent protocolEvent) {
            WebRenderer.this.getBrowser().stopLoad();
            String string = WebRenderer.this.getCurrentLocation();
            boolean bl = true;
            if (!(string == null || string.length() == 0 || string.startsWith("file:") || string.startsWith("jar:") || string.startsWith("matlab:") || string.startsWith("linkerr:") || string.startsWith("text:") || string.equals(WebRenderer.BLANK_PAGE_URL))) {
                int n;
                bl = false;
                if (!sMatlabProtocolOK && (n = MJOptionPane.showConfirmDialog((Component)SwingUtilities.windowForComponent((Component)((Object)WebRenderer.this.fParent)), (Object)HTMLUtils.sRes.getString("alert.security_warning"), (String)HTMLUtils.sRes.getString("alert.security_warning_title"), (int)2, (int)2)) == 0) {
                    sMatlabProtocolOK = true;
                }
            }
            if (sMatlabProtocolOK || bl) {
                String string2 = protocolEvent.getURL();
                String string3 = protocolEvent.getPOSTData();
                if (string3 != null && string3.length() > 0) {
                    string2 = string2 + "?" + string3;
                }
                String string4 = HTMLUtils.buildMatlabEvalString(string2, WebRenderer.this.fParent.getBrowserId());
                WebRenderer.this.fMatlab.evalConsoleOutput(string4);
            }
        }
    }

    private class MyBrowserListener
    extends BrowserAdapter {
        private MyBrowserListener() {
        }

        public void onTitleChange(BrowserEvent browserEvent) {
            WebRenderer.this.fTitle = browserEvent.getTitle();
            WebRenderer.this.fTitle = WebRenderer.this.fTitle.replaceAll("</?font[^>]*>", "");
        }

        public void onLinkChange(BrowserEvent browserEvent) {
            String string = browserEvent.getLink();
            if (string != null) {
                string = this.resolveLink(string);
            }
            WebRenderer.this.fParent.updateStatusBar(this.getStatusBarText(string));
        }

        private String getStatusBarText(String string) {
            if (string == null || string.length() == 0) {
                return string;
            }
            for (Pattern pattern : sLocalizedMessages.keySet()) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.lookingAt()) continue;
                String string2 = (String)sLocalizedMessages.get(pattern);
                int n = matcher.groupCount();
                if (n > 0) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = matcher.group(i + 1);
                    }
                    String string3 = HTMLUtils.sRes.getString(string2);
                    return MessageFormat.format(string3, objectArray);
                }
                return HTMLUtils.sRes.getString(string2);
            }
            return string;
        }

        public void onLoadIntercept(BrowserEvent browserEvent) {
            String string = browserEvent.getURL();
            if (string == null) {
                return;
            }
            if (string.startsWith("matlab:")) {
                return;
            }
            String string2 = this.resolveLink(string);
            boolean bl = this.isLinkClickedInsideDocument(string2);
            if (WebRenderer.this.fParent.getUseSystemBrowserForExternalLinks() && this.isExternalLink(string2) && bl && !string2.endsWith(".pdf")) {
                this.doBlockLoad(browserEvent);
                WebRenderer.this.fMatlab.evalConsoleOutput("web('" + string2 + "', '-browser');");
            } else if (string2.endsWith(".pdf")) {
                this.doBlockLoad(browserEvent);
                if (HTMLUtils.needsDecoding(string2)) {
                    string2 = HTMLUtils.decodeUrl(string2);
                }
                string2 = string2.replaceAll(" ", "%20");
                WebRenderer.this.fPdfFileHandler.open((Frame)SwingUtilities.windowForComponent(WebRenderer.this.getBrowser().getCanvas()), string2);
            } else if (WebRenderer.this.fParent.getLinkClickedHandler() != null && bl) {
                this.doBlockLoad(browserEvent);
                WebRenderer.this.fParent.getLinkClickedHandler().linkClicked(string2);
            } else if (WebRenderer.this.fParent.getJarFileLinkListener() != null && bl && string2.startsWith("file:///") && WebRenderer.this.fNavigating == 0) {
                String string3;
                boolean bl2 = false;
                if (WebRenderer.this.fCurrentLocation != null && WebRenderer.this.fCurrentLocation.startsWith("file:") && !HTMLUtils.compareFiles(string2, string3 = WebRenderer.this.fParent.getJarFileLinkListener().getRealFilename(WebRenderer.this.fCurrentLocation, string2))) {
                    bl2 = true;
                    this.doBlockLoad(browserEvent);
                    WebRenderer.this.fParent.setCurrentLocation(string3);
                }
                if (!bl2 && WebRenderer.this.getPendingUrl() == null) {
                    WebRenderer.this.setPendingUrl(string2);
                }
            } else if (!string2.equals(string)) {
                WebRenderer.this.setPendingUrl(null);
                this.doBlockLoad(browserEvent);
                WebRenderer.this.fParent.setCurrentLocation(string2);
            } else if (WebRenderer.this.getPendingUrl() == null || string2.startsWith("text:")) {
                WebRenderer.this.setPendingUrl(string2);
            }
        }

        private String resolveLink(String string) {
            String string2 = string;
            if (string2.startsWith("xprod:")) {
                String string3;
                String string4;
                string2 = string2.replaceFirst("xprod", "file");
                JarFileLinkListener jarFileLinkListener = WebRenderer.this.fParent.getJarFileLinkListener();
                if (jarFileLinkListener != null && (string4 = jarFileLinkListener.getRealFilename(string3 = WebRenderer.this.getCurrentLocation(), string2)) != null && string4.trim().length() > 0) {
                    string2 = string4;
                }
            }
            return string2;
        }

        private void doBlockLoad(BrowserEvent browserEvent) {
            browserEvent.blockLoad();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WebRenderer.this.fSyncManager.setLoadingState(LoadingState.NOT_LOADING);
                }
            }).start();
        }

        private boolean isLinkClickedInsideDocument(String string) {
            return WebRenderer.this.getPendingUrl() == null && !WebRenderer.this.isTargetOnCurrentPage(string) && WebRenderer.this.fNavigating != 3;
        }

        private boolean isExternalLink(String string) {
            return string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://");
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private String fOriginatingUrl;

        private MyMouseListener() {
        }

        public void onMouseUp(MouseEvent mouseEvent) {
            if (PlatformInfo.isWindows() && !WebRenderer.isFormField(mouseEvent.getTargetElement())) {
                WebRenderer.this.requestFocusInWindow();
            }
            int n = mouseEvent.getButton();
            boolean bl = false;
            String string = this.getHrefAttribute(mouseEvent.getTargetElement());
            if (string != null) {
                if (string.startsWith("#")) {
                    bl = true;
                    string = HTMLUtils.getFilenameFromURL(this.fOriginatingUrl);
                } else if (!string.contains("/")) {
                    string = this.fOriginatingUrl = HTMLUtils.getFilenameFromURL(this.fOriginatingUrl);
                    bl = WebRenderer.this.isTargetOnCurrentPage(string);
                }
            }
            final String string2 = string;
            if (n != 0 || string2 == null) {
                WebRenderer.this.enableDisableEvents(true);
            } else if (bl) {
                WebRenderer.this.fHistoryPos++;
                WebRenderer.this.enableDisableEvents(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebRenderer.this.setCurrentLocationField(string2);
                        WebRenderer.this.notifyPageChangedListeners(WebRenderer.this.getCurrentPageTitle(), string2, true);
                    }
                });
            }
            if (mouseEvent.isPopupTrigger()) {
                WebRenderer.this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void onMouseDown(MouseEvent mouseEvent) {
            this.fOriginatingUrl = WebRenderer.this.getBrowser().getURL();
            if (!mouseEvent.isPopupTrigger()) {
                Container container;
                if (WebRenderer.this.fPopupMenu != null && WebRenderer.this.fPopupMenu.isShowing()) {
                    WebRenderer.this.fPopupMenu.setVisible(false);
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
                if (PlatformInfo.isWindows() && (container = SwingUtilities.getAncestorOfClass(DTClientBase.class, (Component)((Object)WebRenderer.this))) != null) {
                    DTClientBase dTClientBase = (DTClientBase)container;
                    Desktop desktop = Desktop.getContainingDesktop((Component)dTClientBase);
                    desktop.setClientSelected((Component)dTClientBase, true);
                }
            }
        }

        private String getHrefAttribute(IElement iElement) {
            for (IElement iElement2 = iElement; iElement2 != null; iElement2 = iElement2.getParentElement()) {
                String string;
                if (iElement2.getTagName() == null || (string = iElement2.getAttribute("href", 0L)) == null || string.length() <= 0) continue;
                return string;
            }
            return null;
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        public void onKeyDown(com.webrenderer.event.KeyEvent keyEvent) {
            if (!WebRenderer.this.isFocusInFormField()) {
                if (keyEvent.getKeyCode() == 8) {
                    WebRenderer.this.goBack();
                } else if (keyEvent.getKeyCode() == 9 && (keyEvent.getModifiers() & 2) != 0) {
                    WebRenderer.this.getBrowser().getCanvas().requestFocus();
                } else if (PlatformInfo.isWindows() && keyEvent.getKeyCode() == 121 && (keyEvent.getModifiers() & 1) != 0) {
                    WebRenderer.this.showPopupMenu(keyEvent.getComponent(), 0, 0);
                } else {
                    WebRenderer.this.enableDisableEvents(true);
                }
            }
        }

        public void onKeyUp(com.webrenderer.event.KeyEvent keyEvent) {
            if (PlatformInfo.isWindows() && !WebRenderer.this.isFocusInFormField() && keyEvent.getKeyCode() == 93) {
                WebRenderer.this.showPopupMenu(keyEvent.getComponent(), 0, 0);
            }
        }
    }

    private class MyPromptListener
    implements PromptListener {
        private int iTextRetryCount = 0;

        private MyPromptListener() {
        }

        public void onPromptDialog(PromptEvent promptEvent) {
            if (promptEvent.getDialogType() == 0) {
                String string = promptEvent.getDialogText();
                if (this.checkUnregisteredTextProtocol(string) && this.iTextRetryCount < 10) {
                    ++this.iTextRetryCount;
                    promptEvent.blockPromptDialog();
                    new Thread(new SetLocationThread(WebRenderer.this.getPendingUrl())).start();
                    return;
                }
                this.iTextRetryCount = 0;
                for (Pattern pattern : sDialogExclusions) {
                    if (!pattern.matcher(string).find()) continue;
                    promptEvent.blockPromptDialog();
                    WebRenderer.this.showLinkErrPage(WebRenderer.this.getPendingUrl());
                    break;
                }
            }
        }

        private boolean checkUnregisteredTextProtocol(String string) {
            return string.contains("the protocol (text)") && WebRenderer.this.getPendingUrl().startsWith("text:");
        }
    }

    private class AdaptiveDocWorker
    extends MatlabWorker {
        private AdaptiveDocWorker() {
        }

        public Object runOnMatlabThread() throws Exception {
            try {
                return Matlab.mtSendLicenseCheck((Object[])sAdaptiveDocProducts);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object != null) {
                boolean[] blArray = (boolean[])object;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < sAdaptiveDocProducts.length; ++i) {
                    if (!blArray[i]) continue;
                    stringBuilder.append(sAdaptiveDocProducts[i]).append(";");
                }
                sAdaptiveDocString = stringBuilder.toString();
            } else {
                sAdaptiveDocString = "";
            }
            WebRenderer.this.executeAdaptiveDocScript();
        }
    }

    private class MyNetworkListener
    extends NetworkAdapter {
        private boolean iLicenseCheckStarted = false;

        private MyNetworkListener() {
        }

        public void onDocumentLoad(NetworkEvent networkEvent) {
            WebRenderer.this.fSyncManager.setLoadingState(LoadingState.STARTED);
            if (WebRenderer.this.fLoadingMessageLabel != null) {
                WebRenderer.this.remove((Component)WebRenderer.this.fLoadingMessageLabel);
                WebRenderer.this.validate();
                WebRenderer.this.fLoadingMessageLabel = null;
            }
        }

        public void onDocumentComplete(NetworkEvent networkEvent) {
            Object object;
            if (WebRenderer.this.fQueuedLoadRunnable != null) {
                WebRenderer.this.setPendingUrl(null);
                WebRenderer.this.fSyncManager.setLoadingState(LoadingState.NOT_LOADING);
                WebRenderer.this.fQueuedLoadRunnable.run();
                return;
            }
            WebRenderer.this.setCurrentLocationField(WebRenderer.this.getPendingUrl());
            String string = HTMLUtils.getCanonicalUrl(networkEvent.getURL());
            String string2 = null;
            if (string.startsWith("text:") && (string = WebRenderer.this.fCachedBrowser.getUrl(string)).indexOf(35) > -1) {
                string2 = string.substring(string.indexOf(35) + 1);
            }
            if (WebRenderer.this.fParent.getJarFileLinkListener() != null) {
                if (string.startsWith("jar:") || string.startsWith("file:")) {
                    object = WebRenderer.this.getBrowser().getDocument();
                    if (object.getURL() == null) {
                        if (WebRenderer.this.fNavigating != 3) {
                            final String string3 = WebRenderer.this.getPendingUrl();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    WebRenderer.this.setPendingUrl(string3);
                                    WebRenderer.this.reload(false);
                                }
                            });
                        }
                    } else {
                        try {
                            WebRenderer.modifyFileColonLinks(object, new HashSet());
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
                if (string2 != null) {
                    object = string2;
                    new Thread(new Runnable((String)object){
                        final /* synthetic */ String val$targetForScrolling;
                        {
                            this.val$targetForScrolling = string;
                        }

                        @Override
                        public void run() {
                            WebRenderer.this.scrollToTarget(this.val$targetForScrolling);
                        }
                    }).start();
                }
                if (!this.iLicenseCheckStarted) {
                    this.iLicenseCheckStarted = true;
                    new AdaptiveDocWorker().start();
                } else if (sAdaptiveDocString != null) {
                    WebRenderer.this.executeAdaptiveDocScript();
                }
            }
            if (!string.startsWith("matlab:")) {
                if (WebRenderer.this.fNavigating == 0) {
                    WebRenderer.this.fHistoryPos++;
                }
                WebRenderer.this.fNavigating = 0;
            }
            WebRenderer.this.setPendingUrl(null);
            WebRenderer.this.fSyncManager.setLoadingState(LoadingState.NOT_LOADING);
            object = WebRenderer.this.getCurrentPageTitle();
            WebRenderer.this.fParent.resetFindDialogTitle((String)object);
            WebRenderer.this.setCurrentLocationField(WebRenderer.this.getCurrentLocation());
            if (!string.equals(WebRenderer.BLANK_PAGE_URL)) {
                WebRenderer.this.notifyPageChangedListeners((String)object, WebRenderer.this.fCurrentLocation, false);
            }
            WebRenderer.this.enableDisableEvents(false);
        }
    }

    private class LoadInBrowserRunnable
    implements Runnable {
        private final Runnable iRealRunnable;
        private String iUrl;

        private LoadInBrowserRunnable(Runnable runnable, String string) {
            this.iRealRunnable = runnable;
            this.iUrl = string;
        }

        @Override
        public void run() {
            if (WebRenderer.this.isLoadPending()) {
                WebRenderer.this.fQueuedLoadRunnable = this;
            } else {
                WebRenderer.this.fQueuedLoadRunnable = null;
                WebRenderer.this.setPendingUrl(this.iUrl);
                this.iRealRunnable.run();
            }
        }
    }

    private class SetHtmlTextThread
    implements Runnable {
        private String fText;
        private String fLoc;

        private SetHtmlTextThread(String string, String string2) {
            this.fText = string;
            this.fLoc = string2;
        }

        @Override
        public void run() {
            WebRenderer.this.fSyncManager.setLoadingState(LoadingState.PENDING);
            WebRenderer.this.getBrowser().stopLoad();
            WebRenderer.this.fCachedBrowser.loadHTML(this.fText, HTMLUtils.decodeUrl(this.fLoc));
        }
    }

    private class SetLocationThread
    implements Runnable {
        private String fUrl;

        private SetLocationThread(String string) {
            this.fUrl = string;
        }

        @Override
        public void run() {
            WebRenderer.this.fSyncManager.setLoadingState(LoadingState.PENDING);
            IBrowserCanvas iBrowserCanvas = WebRenderer.this.getBrowser();
            iBrowserCanvas.stopLoad();
            if (this.fUrl.startsWith("jar:") && !HTMLUtils.doesFileExist(this.fUrl)) {
                WebRenderer.this.showLinkErrPage(this.fUrl);
            } else {
                final String string = HTMLUtils.correctSlashes(this.fUrl);
                boolean bl = WebRenderer.this.isTargetOnCurrentPage(string);
                if (bl) {
                    WebRenderer.this.setPendingUrl(null);
                }
                iBrowserCanvas.loadURL(string);
                if (bl) {
                    WebRenderer.this.fHistoryPos++;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WebRenderer.this.setCurrentLocationField(string);
                            WebRenderer.this.notifyPageChangedListeners(WebRenderer.this.getCurrentPageTitle(), string, true);
                            WebRenderer.this.fSyncManager.setLoadingState(LoadingState.NOT_LOADING);
                        }
                    });
                }
            }
        }
    }

    private class PrinterJob
    implements Runnable {
        private ActionListener fListener;

        private PrinterJob(ActionListener actionListener) {
            this.fListener = actionListener;
        }

        @Override
        public void run() {
            IBrowserCanvas iBrowserCanvas = WebRenderer.this.getBrowser();
            iBrowserCanvas.addPrintListener((PrintListener)new HTMLPrintListener());
            iBrowserCanvas.print(1);
        }

        private class HTMLPrintListener
        implements PrintListener {
            private HTMLPrintListener() {
            }

            public void onStatusChange(PrintEvent printEvent) {
                if (printEvent.getStatus() == 1 && PrinterJob.this.fListener != null) {
                    PrinterJob.this.fListener.actionPerformed(new ActionEvent(this, 0, "Completed"));
                }
                WebRenderer.this.getBrowser().removePrintListener((PrintListener)this);
            }
        }
    }

    private class WebRendererCanvasComponentAdapter
    extends ComponentAdapter {
        private WebRendererCanvasComponentAdapter() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (WebRenderer.this.isShowing()) {
                componentEvent.getComponent().setVisible(true);
            }
        }
    }

    private class WebRendererHierarchyListener
    implements HierarchyListener {
        private boolean fSetHeavyweight = false;

        private WebRendererHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Container container;
            if (!this.fSetHeavyweight && (container = SwingUtilities.getAncestorOfClass(DTClientBase.class, (Component)((Object)WebRenderer.this))) != null) {
                DTClientBase dTClientBase = (DTClientBase)container;
                dTClientBase.putClientProperty((Object)DTClientProperty.HEAVYWEIGHT, (Object)Boolean.TRUE);
                this.fSetHeavyweight = true;
            }
        }
    }

    private class CanvasFocusListener
    implements FocusListener {
        private CanvasFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (PlatformInfo.isWindows()) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null) {
                    WebRenderer.this.requestFocusInWindow();
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class SetupThread
    implements Runnable {
        private SetupThread() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.createBrowser();
                    WebRenderer.this.fCreationListener.creationSucceeded();
                }
                catch (Exception exception) {
                    if (WebRenderer.this.shouldCancelSetup()) break block2;
                    WebRenderer.this.fCreationListener.creationFailed();
                }
            }
        }

        private void createBrowser() {
            if (WebRenderer.this.shouldCancelSetup()) {
                return;
            }
            IMozillaBrowserCanvas iMozillaBrowserCanvas = BrowserFactory.spawnMozilla();
            if (iMozillaBrowserCanvas == null) {
                throw new IllegalStateException("Could not create Mozilla browser");
            }
            WebRenderer.setPrefProperties((IBrowserCanvas)iMozillaBrowserCanvas);
            iMozillaBrowserCanvas.registerProtocol("matlab", (ProtocolListener)new MatlabProtocolListener());
            WebRendererCachedBrowser webRendererCachedBrowser = new WebRendererCachedBrowser(iMozillaBrowserCanvas);
            webRendererCachedBrowser.setNavigationEnabled(WebRenderer.this.fNavigationEnabled);
            iMozillaBrowserCanvas.registerProtocol("text", (ProtocolListener)webRendererCachedBrowser);
            iMozillaBrowserCanvas.addBrowserListener((BrowserListener)new MyBrowserListener());
            iMozillaBrowserCanvas.addNetworkListener((NetworkListener)new MyNetworkListener());
            iMozillaBrowserCanvas.enableDefaultContextMenu(false);
            iMozillaBrowserCanvas.addMouseListener((MouseListener)new MyMouseListener());
            iMozillaBrowserCanvas.addPromptListener((PromptListener)new MyPromptListener());
            iMozillaBrowserCanvas.addKeyListener((KeyListener)new MyKeyListener());
            iMozillaBrowserCanvas.addWindowListener((WindowListener)new PopupWindowListener());
            WebRenderer.this.setFocusable(false);
            WebRenderer.this.fPdfFileHandler = new DefaultPDFFileHandler(WebRenderer.this);
            WebRenderer.setWebRendererProxySettings((IBrowserCanvas)iMozillaBrowserCanvas);
            MatlabProxyListener matlabProxyListener = WebRenderer.this.createProxyListener();
            HTMLPrefs.addProxyListener(matlabProxyListener);
            Canvas canvas = WebRenderer.findCanvas((Component)iMozillaBrowserCanvas);
            if (canvas != null) {
                canvas.addHierarchyListener(new WebRendererHierarchyListener());
                canvas.addComponentListener(new WebRendererCanvasComponentAdapter());
            }
            if (WebRenderer.this.shouldCancelSetup()) {
                WebRenderer.this.handleDisposal((IBrowserCanvas)iMozillaBrowserCanvas);
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                WebRenderer.this.addWebRenderer((IBrowserCanvas)iMozillaBrowserCanvas, webRendererCachedBrowser);
            } else {
                SwingUtilities.invokeLater(new Runnable((IBrowserCanvas)iMozillaBrowserCanvas, webRendererCachedBrowser){
                    final /* synthetic */ IBrowserCanvas val$browser;
                    final /* synthetic */ WebRendererCachedBrowser val$cachedBrowser;
                    {
                        this.val$browser = iBrowserCanvas;
                        this.val$cachedBrowser = webRendererCachedBrowser;
                    }

                    @Override
                    public void run() {
                        WebRenderer.this.addWebRenderer(this.val$browser, this.val$cachedBrowser);
                    }
                });
            }
        }
    }

    private static enum LoadingState {
        PENDING,
        STARTED,
        NOT_LOADING,
        INITIAL;

    }
}

