/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLRendererActions;
import com.mathworks.mlwidgets.html.HtmlComponentRegistry;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mwswing.MJAbstractAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class HtmlComponentAdapter
implements HtmlComponent<MatlabHtmlActions> {
    private final HTMLRenderer fHTMLRenderer;
    private MatlabHtmlActions fActions;
    private final Map<StatusTextListener, ActionListener> fAdaptedStatusTextListeners = new HashMap<StatusTextListener, ActionListener>();
    private final Map<com.mathworks.html.PageChangedListener, PageChangedListener> fAdaptedPageChangedListeners = new HashMap<com.mathworks.html.PageChangedListener, PageChangedListener>();
    private final int fRegistryId;

    public HtmlComponentAdapter(HTMLRenderer hTMLRenderer) {
        this.fHTMLRenderer = hTMLRenderer;
        hTMLRenderer.putClientProperty("mwjavaguitest.instance", this);
        this.fRegistryId = HtmlComponentRegistry.registerHtmlComponent(this);
        this.fHTMLRenderer.setBrowserId(this.fRegistryId);
    }

    public Component getComponent() {
        return this.fHTMLRenderer;
    }

    public boolean isInitialized() {
        return this.fHTMLRenderer.canExecuteScripts();
    }

    public void setCurrentLocation(String string) {
        this.fHTMLRenderer.setCurrentLocation(string);
    }

    public String getCurrentLocation() {
        return this.fHTMLRenderer.getCurrentLocation();
    }

    public String getTitle() {
        return this.fHTMLRenderer.getCurrentPageTitle();
    }

    public void setHtmlText(String string) {
        this.fHTMLRenderer.setHtmlText(string);
    }

    public void executeScript(String string) {
        this.fHTMLRenderer.executeScript(string);
    }

    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        String string2 = this.fHTMLRenderer.executeScriptWithReturn(string);
        htmlDataListener.dataRetrieved((Object)string2);
    }

    public String getSelectedText() {
        return this.fHTMLRenderer.getSelectedText();
    }

    @Deprecated
    public void getSelectedText(HtmlDataListener<String> htmlDataListener) {
        String string = this.fHTMLRenderer.getSelectedText();
        htmlDataListener.dataRetrieved((Object)string);
    }

    public String getHtmlText() {
        return this.fHTMLRenderer.getHtmlText();
    }

    public boolean canGoBack() {
        return this.fHTMLRenderer.canGoBack();
    }

    public void goBack() {
        this.fHTMLRenderer.goBack();
    }

    public boolean canGoForward() {
        return this.fHTMLRenderer.canGoForward();
    }

    public void goForward() {
        this.fHTMLRenderer.goForward();
    }

    public void reload() {
        this.fHTMLRenderer.reload();
    }

    public String getHomeUrl() {
        return this.fHTMLRenderer.getHomeUrl();
    }

    public boolean isPrintingSupported() {
        return true;
    }

    public void print() {
        this.fHTMLRenderer.doPrint();
    }

    public void saveAs(File file) {
        this.fHTMLRenderer.saveAs();
    }

    public void disableNavigation() {
        this.fHTMLRenderer.disableNavigation();
    }

    public void dispose() {
        HtmlComponentRegistry.removeHtmlComponent(this.fRegistryId);
        this.fHTMLRenderer.dispose();
        this.fAdaptedPageChangedListeners.clear();
        this.fAdaptedStatusTextListeners.clear();
    }

    public void findInPage(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        boolean bl = collection.contains(FindOption.SEARCH_BACKWARDS);
        boolean bl2 = collection.contains(FindOption.MATCH_CASE);
        boolean bl3 = collection.contains(FindOption.WHOLE_WORDS);
        boolean bl4 = false;
        boolean bl5 = this.fHTMLRenderer.search(string, bl, bl2, bl3, bl4);
        htmlDataListener.dataRetrieved((Object)bl5);
    }

    public void addPageChangedListener(com.mathworks.html.PageChangedListener pageChangedListener) {
        PageChangedListener pageChangedListener2 = this.adaptPageChangedListener(pageChangedListener, true);
        this.fHTMLRenderer.addPageChangedListener(pageChangedListener2);
    }

    public void removePageChangedListener(com.mathworks.html.PageChangedListener pageChangedListener) {
        PageChangedListener pageChangedListener2 = this.adaptPageChangedListener(pageChangedListener, false);
        if (pageChangedListener2 != null) {
            this.fHTMLRenderer.removePageChangedListener(pageChangedListener2);
        }
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        ActionListener actionListener = this.adaptStatusTextListener(statusTextListener, true);
        this.fHTMLRenderer.addMouseOverLinkListener(actionListener);
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        ActionListener actionListener = this.adaptStatusTextListener(statusTextListener, false);
        if (actionListener != null) {
            this.fHTMLRenderer.removeMouseOverLinkListener(actionListener);
        }
    }

    public MatlabHtmlActions getActions() {
        if (this.fActions == null) {
            this.fActions = new HtmlActionsAdapter(this.fHTMLRenderer.getActions());
        }
        return this.fActions;
    }

    private ActionListener adaptStatusTextListener(StatusTextListener statusTextListener, boolean bl) {
        ActionListener actionListener = this.fAdaptedStatusTextListeners.get(statusTextListener);
        if (actionListener != null) {
            if (!bl) {
                this.fAdaptedStatusTextListeners.remove(statusTextListener);
            }
        } else if (bl) {
            actionListener = new StatusTextListenerAdapter(statusTextListener);
            this.fAdaptedStatusTextListeners.put(statusTextListener, actionListener);
        }
        return actionListener;
    }

    private PageChangedListener adaptPageChangedListener(com.mathworks.html.PageChangedListener pageChangedListener, boolean bl) {
        PageChangedListener pageChangedListener2 = this.fAdaptedPageChangedListeners.get(pageChangedListener);
        if (pageChangedListener2 != null) {
            if (!bl) {
                this.fAdaptedPageChangedListeners.remove(pageChangedListener);
            }
        } else if (bl) {
            pageChangedListener2 = new PageChangedListenerAdapter(pageChangedListener);
            this.fAdaptedPageChangedListeners.put(pageChangedListener, pageChangedListener2);
        }
        return pageChangedListener2;
    }

    private static class HtmlActionsAdapter
    implements MatlabHtmlActions {
        private final Map<StandardHtmlActionId, MJAbstractAction> iBasicActions;
        private final Map<MatlabHtmlActions.MatlabActionId, MJAbstractAction> iMatlabActions;

        private HtmlActionsAdapter(HTMLRendererActions hTMLRendererActions) {
            this.iBasicActions = HtmlActionsAdapter.buildBasicActionsMap(hTMLRendererActions);
            this.iMatlabActions = HtmlActionsAdapter.buildMatlabActionsMap(hTMLRendererActions);
        }

        private static Map<StandardHtmlActionId, MJAbstractAction> buildBasicActionsMap(HTMLRendererActions hTMLRendererActions) {
            EnumMap<StandardHtmlActionId, MJAbstractAction> enumMap = new EnumMap<StandardHtmlActionId, MJAbstractAction>(StandardHtmlActionId.class);
            for (StandardHtmlActionId standardHtmlActionId : StandardHtmlActionId.values()) {
                MJAbstractAction mJAbstractAction = HtmlActionsAdapter.getStandardAction(hTMLRendererActions, standardHtmlActionId);
                if (mJAbstractAction == null) continue;
                enumMap.put(standardHtmlActionId, mJAbstractAction);
            }
            return enumMap;
        }

        private static MJAbstractAction getStandardAction(HTMLRendererActions hTMLRendererActions, StandardHtmlActionId standardHtmlActionId) {
            switch (standardHtmlActionId) {
                case GO_BACK: {
                    return hTMLRendererActions.fGoBackAction;
                }
                case GO_FORWARD: {
                    return hTMLRendererActions.fGoForwardAction;
                }
                case COPY: {
                    return hTMLRendererActions.fCopyAction;
                }
                case FIND: {
                    return hTMLRendererActions.fFindAction;
                }
                case HOME: {
                    return hTMLRendererActions.fHomeAction;
                }
                case PRINT: {
                    return hTMLRendererActions.fPrintAction;
                }
                case RELOAD: {
                    return hTMLRendererActions.fReloadAction;
                }
                case SAVE_AS: {
                    return hTMLRendererActions.fSaveAsAction;
                }
                case VIEW_SOURCE: {
                    return hTMLRendererActions.fViewSourceAction;
                }
            }
            return null;
        }

        private static Map<MatlabHtmlActions.MatlabActionId, MJAbstractAction> buildMatlabActionsMap(HTMLRendererActions hTMLRendererActions) {
            EnumMap<MatlabHtmlActions.MatlabActionId, MJAbstractAction> enumMap = new EnumMap<MatlabHtmlActions.MatlabActionId, MJAbstractAction>(MatlabHtmlActions.MatlabActionId.class);
            for (MatlabHtmlActions.MatlabActionId matlabActionId : MatlabHtmlActions.MatlabActionId.values()) {
                MJAbstractAction mJAbstractAction = HtmlActionsAdapter.getMatlabAction(hTMLRendererActions, matlabActionId);
                if (mJAbstractAction == null) continue;
                enumMap.put(matlabActionId, mJAbstractAction);
            }
            return enumMap;
        }

        private static MJAbstractAction getMatlabAction(HTMLRendererActions hTMLRendererActions, MatlabHtmlActions.MatlabActionId matlabActionId) {
            switch (matlabActionId) {
                case EVALUATE_SELECTION: {
                    return hTMLRendererActions.fEvalSelectionAction;
                }
                case OPEN_SELECTION: {
                    return hTMLRendererActions.fOpenSelectionAction;
                }
                case HELP_ON_SELECTION: {
                    return hTMLRendererActions.fHelpSelectionAction;
                }
            }
            return null;
        }

        public MJAbstractAction getMatlabAction(MatlabHtmlActions.MatlabActionId matlabActionId) {
            return this.iMatlabActions.get((Object)matlabActionId);
        }

        public Map<StandardHtmlActionId, ? extends MJAbstractAction> getBasicActions() {
            return Collections.unmodifiableMap(this.iBasicActions);
        }

        public Collection<? extends MJAbstractAction> getCustomActions() {
            return this.iMatlabActions.values();
        }

        public void removeNavigationActions() {
            this.iBasicActions.remove(StandardHtmlActionId.GO_BACK);
            this.iBasicActions.remove(StandardHtmlActionId.GO_FORWARD);
            this.iBasicActions.remove(StandardHtmlActionId.RELOAD);
            this.iBasicActions.remove(StandardHtmlActionId.HOME);
        }

        public void dispose() {
        }
    }

    private static class PageChangedListenerAdapter
    implements PageChangedListener {
        private final com.mathworks.html.PageChangedListener iRealListener;

        private PageChangedListenerAdapter(com.mathworks.html.PageChangedListener pageChangedListener) {
            this.iRealListener = pageChangedListener;
        }

        @Override
        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            String string = pageChangedEvent.getTitle();
            String string2 = pageChangedEvent.getFullUrl();
            boolean bl = pageChangedEvent.isTargetOnlyChange();
            PageChangedEvent pageChangedEvent2 = new PageChangedEvent(string, string2, bl);
            this.iRealListener.pageChanged(pageChangedEvent2);
        }
    }

    private static class StatusTextListenerAdapter
    implements ActionListener {
        private final StatusTextListener iTextListener;

        private StatusTextListenerAdapter(StatusTextListener statusTextListener) {
            this.iTextListener = statusTextListener;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            StatusTextChangedEvent statusTextChangedEvent = new StatusTextChangedEvent(string);
            this.iTextListener.statusChanged(statusTextChangedEvent);
        }
    }
}

