/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MComponentInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class HTMLAcceleratorHelper {
    private JComponent fComponent;
    private InputMap fCurrentInputMap;
    private ActionMap fCurrentActionMap;
    private Set<Action> fAcceleratorActions;

    HTMLAcceleratorHelper(JComponent jComponent) {
        this.fComponent = jComponent;
        this.fComponent.addAncestorListener(new MyAncestorListener());
    }

    public void addAction(Action action) {
        if (this.fCurrentInputMap == null || this.fCurrentActionMap == null) {
            this.setAcceleratorComponent(this.fComponent, 2);
        }
        if (this.fAcceleratorActions == null) {
            this.fAcceleratorActions = new HashSet<Action>();
        }
        this.fAcceleratorActions.add(action);
        HTMLAcceleratorHelper.addAction(this.fCurrentInputMap, this.fCurrentActionMap, action);
    }

    void setAcceleratorComponent(JComponent jComponent, int n) {
        assert (jComponent != null) : "Component should not be null";
        Object object = jComponent.getInputMap(n);
        ActionMap actionMap = jComponent.getActionMap();
        if (this.fCurrentActionMap != actionMap || this.fCurrentInputMap != object) {
            if (!(object instanceof ExtendedInputMap)) {
                Object object2 = object instanceof ComponentInputMap ? new MComponentInputMap(jComponent) : new MInputMap();
                ((InputMap)object2).setParent((InputMap)object);
                jComponent.setInputMap(n, (InputMap)object2);
                object = object2;
            }
            if (this.fAcceleratorActions != null) {
                for (Action action : this.fAcceleratorActions) {
                    if (this.fCurrentInputMap != null && this.fCurrentActionMap != null) {
                        HTMLAcceleratorHelper.removeAction(this.fCurrentInputMap, this.fCurrentActionMap, action);
                    }
                    HTMLAcceleratorHelper.addAction((InputMap)object, actionMap, action);
                }
            }
            this.fCurrentInputMap = object;
            this.fCurrentActionMap = actionMap;
        }
    }

    private static void addAction(InputMap inputMap, ActionMap actionMap, Action action) {
        if (MatlabKeyBindings.getManager().containsActionAndContext(action)) {
            assert (inputMap instanceof ExtendedInputMap) : "custom input map should be an ExtendedInputMap";
            ExtendedInputMap extendedInputMap = (ExtendedInputMap)inputMap;
            String string = ((ExtendedAction)action).getActionID();
            MatlabKeyBindings.getManager().addKeyBindings(((ExtendedAction)action).getContextID(), string, extendedInputMap);
            MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)action, actionMap);
        } else {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke != null) {
                inputMap.put(keyStroke, action.getClass().getName());
                actionMap.put(action.getClass().getName(), action);
            }
        }
    }

    private static void removeAction(InputMap inputMap, ActionMap actionMap, Action action) {
        if (MatlabKeyBindings.getManager().containsActionAndContext(action)) {
            assert (inputMap instanceof ExtendedInputMap) : "custom input map should be an ExtendedInputMap";
            ExtendedInputMap extendedInputMap = (ExtendedInputMap)inputMap;
            String string = ((ExtendedAction)action).getActionID();
            MatlabKeyBindings.getManager().clearKeyBindings(((ExtendedAction)action).getContextID(), string, extendedInputMap);
            MatlabKeyBindings.getManager().removeFromActionMap((ExtendedAction)action, actionMap);
        } else {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke != null) {
                inputMap.remove(keyStroke);
                actionMap.remove(action.getClass().getName());
            }
        }
    }

    private class MyAncestorListener
    implements AncestorListener {
        private MyAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Component component = Desktop.getClientComponentAncestor((Component)HTMLAcceleratorHelper.this.fComponent);
            if (component != null && component instanceof JComponent) {
                HTMLAcceleratorHelper.this.setAcceleratorComponent((JComponent)component, 1);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

