/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.helpsearch.index.LocaleFileLocator;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.html.EncodingUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpLocale;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.LocalizationFilter;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelpUtils {
    private static LanguageLocale sLanguageLocale = null;
    private static final String RESDIR = "com.mathworks.mlwidgets.help.resources.";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_HelpInfo");
    private static HelpDependencyProvider sDependencyProvider = new DefaultDocRootProvider();
    private static final Map<String, String> sHelpDirectoriesToReplace = new LinkedHashMap<String, String>();
    private static final Map<String, String> sHelpMapfilesToReplace;

    private static void setDefaultLanguageLocale() {
        HelpUtils.setLanguageLocale(HelpUtils.getDependencyProvider().getHelpLocale());
    }

    static void setLanguageLocale(Locale locale) {
        HelpUtils.setLanguageLocale(LanguageLocale.getSupportedLanguageLocale(locale));
    }

    private static void setLanguageLocale(String string) {
        HelpUtils.setLanguageLocale(string, null);
    }

    private static void setLanguageLocale(String string, String string2) {
        HelpUtils.setLanguageLocale(LanguageLocale.getSupportedLanguageLocale(string, string2));
    }

    private static synchronized void setLanguageLocale(LanguageLocale languageLocale) {
        sLanguageLocale = languageLocale;
    }

    public static synchronized LanguageLocale getLanguageLocale() {
        if (sLanguageLocale == null) {
            HelpUtils.initializeLanguageLocale();
        }
        return sLanguageLocale;
    }

    private static void initializeLanguageLocale() {
        Locale locale;
        Locale locale2 = locale = HelpUtils.canOverrideDocLocale() && Matlab.isMatlabAvailable() ? HelpPrefs.getDocLocale() : null;
        if (locale != null) {
            HelpUtils.setLanguageLocale(locale);
        } else {
            HelpUtils.setDefaultLanguageLocale();
        }
    }

    public static boolean canOverrideDocLocale() {
        Locale locale = HelpUtils.getDependencyProvider().getHelpLocale();
        return !locale.getLanguage().equalsIgnoreCase(Locale.ENGLISH.getLanguage()) && HelpPrefs.isLocalizedDocInstalled(locale);
    }

    public static boolean isEnglish() {
        return HelpUtils.getLanguageLocale().isEnglish();
    }

    public static boolean isJapanese() {
        return HelpUtils.getLanguageLocale() == LanguageLocale.JAPANESE;
    }

    public static String getLocaleString() {
        return HelpUtils.getLanguageLocale().getLocaleString();
    }

    public static String getLocaleWebQueryString() {
        return HelpUtils.getLanguageLocale().getLocaleString().replaceAll("_", "-");
    }

    public static String getDocDirectoryName() {
        return HelpLocale.getDocDirectoryName(HelpUtils.getLanguageLocale());
    }

    public static String getWebSearchDirectoryName() {
        return HelpLocale.getWebSearchDirectoryName(HelpUtils.getLanguageLocale());
    }

    public static String[] getDemosDirectoryName() {
        return HelpLocale.getDemosDirectoryName(HelpUtils.getLanguageLocale());
    }

    public static String getLocalizedFilename(String string) {
        if (string == null || string.equals("about:blank")) {
            return string;
        }
        if (HelpUtils.getDependencyProvider().isUsingDocCenterBrowser()) {
            return HelpUtils.getLocalizedDocCenterFilename(string);
        }
        return HelpUtils.getLocalizedClassicDocFilename(string);
    }

    private static String getLocalizedDocCenterFilename(String string) {
        String string2 = HelpUtils.convertClassicDocPath(string);
        if (string2.startsWith("http:") || string2.startsWith("about:") || string2.startsWith("javascript:")) {
            return string2;
        }
        if (!HelpUtils.isEnglish()) {
            string2 = HelpUtils.getLocalizedFile(string2, HelpUtils.getLanguageLocale().getLocale());
        }
        if (!HelpUtils.isValidFile(string2)) {
            string2 = string;
        }
        return string2;
    }

    private static String getLocalizedClassicDocFilename(String string) {
        Object object;
        String string2 = string.replace('\\', '/');
        if (!string.contains("help/" + HelpUtils.getDocDirectoryName())) {
            object = HelpUtils.getDocroot(string2);
            string2 = string2.replace((CharSequence)object, (String)object + HelpUtils.getDocDirectoryName() + "/");
        }
        object = new FileExistsFilter();
        return HelpUtils.findLocalizedOrAlternateFile(string2, (LocalizationFilter)object);
    }

    public static String convertClassicDocPath(String string) {
        String string2 = string.replace('\\', '/');
        if (string2.startsWith(HelpUtils.getDependencyProvider().getDocRoot()) || string2.startsWith(HelpPrefs.getDocCenterRoot())) {
            for (Map.Entry<String, String> entry : sHelpDirectoriesToReplace.entrySet()) {
                string2 = HelpUtils.replaceDirectoryNameInPath(string2, entry.getKey(), entry.getValue());
            }
            if (string.endsWith(".map")) {
                for (Map.Entry<String, String> entry : sHelpMapfilesToReplace.entrySet()) {
                    string2 = HelpUtils.replaceDirectoryNameInPath(string2, entry.getKey(), entry.getValue());
                }
            }
        }
        return string2;
    }

    private static boolean isValidFile(String string) {
        int n;
        int n2 = string.indexOf(63);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf(35)) > 0) {
            string = string.substring(0, n);
        }
        return HTMLUtils.doesFileExist(string);
    }

    private static String getLocalizedFile(String string, Locale locale) {
        String string2 = string;
        int n = string2.indexOf(63);
        String string3 = "";
        if (n > 0) {
            string3 = string2.substring(n);
            string2 = string2.substring(0, n);
        }
        int n2 = string2.indexOf(35);
        String string4 = "";
        if (n2 > 0) {
            string4 = string2.substring(n2);
            string2 = string2.substring(0, n2);
        }
        if (locale.equals(Locale.JAPANESE)) {
            locale = Locale.JAPAN;
        }
        LocaleFileLocator localeFileLocator = new LocaleFileLocator(locale);
        String string5 = HTMLUtils.getCanonicalUrl(string2);
        if (EncodingUtils.needsDecoding((String)string5)) {
            string5 = EncodingUtils.decodeUrl((String)string5);
        }
        File file = localeFileLocator.findLocalizedFile(new File(string5));
        string2 = file.toString().replace("\\", "/");
        if (n2 > 0) {
            string2 = string2 + string4;
        }
        if (n > 0) {
            string2 = string2 + string3;
        }
        return string2;
    }

    public static String getAlternateLanguagePath(String string) {
        return HelpUtils.convertToNonLocalizedPath(HelpUtils.getLanguageLocale(), string);
    }

    public static String removeLocalizedPath(String string) {
        return HelpUtils.convertToNonLocalizedPath(HelpUtils.getLanguageLocale(), string);
    }

    static String convertToNonLocalizedPath(LanguageLocale languageLocale, String string) {
        String string2;
        if (HelpUtils.getDependencyProvider().isUsingDocCenterBrowser()) {
            string2 = string.replace("_" + HelpUtils.getLocaleString() + ".", ".");
        } else {
            String string3 = HelpUtils.getDocroot(string);
            string2 = string.replace('\\', '/').replace(string3 + HelpLocale.getDocDirectoryName(languageLocale) + "/", string3);
        }
        return string2;
    }

    private static String getDocroot(String string) {
        String string2;
        String string3 = HelpUtils.getDependencyProvider().getDocRoot();
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if (PlatformInfo.isWindows() && string.length() >= string3.length() && (string2 = string.substring(0, string3.length())).equalsIgnoreCase(string3)) {
            string3 = string2;
        }
        return string3;
    }

    public static String getMapfileName(String string, String string2) {
        return CSHelpTopicMap.findLocalizedMapFileName(string, string2);
    }

    public static boolean isDocInstalled() {
        return HelpPrefs.isDocInstalled();
    }

    public static String getInputFilename(String string, String string2, String string3) {
        String string4 = string + string2;
        String string5 = string + string3;
        String string6 = null;
        if (HelpUtils.getDependencyProvider().isStudentVersion()) {
            string6 = HelpUtils.getLocalizedFilename(string5);
        }
        if (string6 == null) {
            string6 = HelpUtils.getLocalizedFilename(string4);
        }
        return string6;
    }

    public static String getLocalizedString(String string) {
        return sRes.getString(string);
    }

    public static String getPrefixForHtmlPath(String string) {
        HelpInfoItem[] helpInfoItemArray = HelpUtils.getDependencyProvider().getInstalledProductHelpInfo();
        if (helpInfoItemArray == null || string == null || string.startsWith("jar:")) {
            return string;
        }
        String string2 = HTMLUtils.getCanonicalUrl(string);
        if (!HelpUtils.isUnderDocroot(string2, HelpUtils.getDependencyProvider().getDocRoot())) {
            return string2;
        }
        String string3 = HelpUtils.findFileInProductHelp(string2);
        if (string3 == null) {
            string3 = HelpUtils.getLocalizedFilename(string2);
        }
        return string3 == null ? string2 : string3;
    }

    public static String getProductHelpPage(HelpInfoItem helpInfoItem, String string) {
        FileExistsFilter fileExistsFilter = new FileExistsFilter(string, true);
        return HelpUtils.findLocalizedOrAlternateFile(helpInfoItem.getUrlPrefix(), fileExistsFilter);
    }

    private static String findFileInProductHelp(String string) {
        HelpInfoItem[] helpInfoItemArray;
        String string2 = HTMLUtils.getCanonicalFilepath(string);
        RelativePathFilter relativePathFilter = new RelativePathFilter(string2);
        for (HelpInfoItem helpInfoItem : helpInfoItemArray = HelpUtils.getDependencyProvider().getInstalledProductHelpInfo()) {
            String string3;
            String string4;
            if (helpInfoItem == null || (string4 = HelpUtils.findLocalizedOrAlternateFile(helpInfoItem.getHelpLoc(), relativePathFilter)) == null || (string3 = HelpUtils.getProductHelpPage(helpInfoItem, string4)) == null) continue;
            return string3;
        }
        return null;
    }

    private static boolean isUnderDocroot(String string, String string2) {
        return StringUtils.startsWith((String)string, (String)string2, (int)0, (boolean)PlatformInfo.isUnix());
    }

    static boolean isUnderDocroot(String string) {
        string = string.replace("\\", "/");
        String string2 = HelpUtils.getDependencyProvider().getDocRoot();
        return HelpUtils.isUnderDocroot(string, string2);
    }

    public static String convertPathToUrlPrefix(String string) {
        String string2;
        File file;
        String string3 = string.replace('\\', '/');
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if ((file = new File(string2 = string3 + "help.jar")).exists()) {
            string2 = "///" + string2;
            return "jar:file:" + string2 + "!/";
        }
        return string3;
    }

    public static String convertFromUrlPrefix(String string) {
        return string != null ? HTMLUtils.convertJarFileUrlToFilePath(string) : null;
    }

    static String findLocalizedOrAlternateFile(String string, LocalizationFilter localizationFilter) {
        Map.Entry<String, String> entry;
        if (string == null || localizationFilter == null) {
            return null;
        }
        String string2 = HelpUtils.findLocalizedOrAlternateFileForPath(string, localizationFilter);
        if (string2 != null) {
            return string2;
        }
        Iterator<Map.Entry<String, String>> iterator = sHelpDirectoriesToReplace.entrySet().iterator();
        while (iterator.hasNext() && (string2 = HelpUtils.convertPathAndFindLocalizedOrAlternate(string, localizationFilter, (entry = iterator.next()).getKey(), entry.getValue())) == null) {
        }
        return string2;
    }

    private static String convertPathAndFindLocalizedOrAlternate(String string, LocalizationFilter localizationFilter, String string2, String string3) {
        String string4 = HelpUtils.replaceDirectoryNameInPath(string, string2, string3);
        if (!string.equalsIgnoreCase(string4)) {
            return HelpUtils.findLocalizedOrAlternateFileForPath(string4, localizationFilter);
        }
        return null;
    }

    static String replaceDirectoryNameInPath(String string, String string2, String string3) {
        String string4 = string.replace('\\', '/');
        Pattern pattern = Pattern.compile("/" + Pattern.quote(string2) + "(?=/|$)");
        Matcher matcher = pattern.matcher(string4);
        if (matcher.find()) {
            String string5 = string3 != null ? "/" + string3 : "";
            return matcher.replaceFirst(string5);
        }
        return string;
    }

    private static String findLocalizedOrAlternateFileForPath(String string, LocalizationFilter localizationFilter) {
        if (string == null || localizationFilter == null) {
            return null;
        }
        if (localizationFilter.accept(string)) {
            return localizationFilter.getAcceptedPath();
        }
        String string2 = HelpUtils.getAlternateLanguagePath(string);
        if (string2 != null && localizationFilter.accept(string2)) {
            return localizationFilter.getAcceptedPath();
        }
        if (!HelpUtils.isEnglish() && (string2 = HelpUtils.convertToNonLocalizedPath(LanguageLocale.ENGLISH, string2)) != null && localizationFilter.accept(string2)) {
            return localizationFilter.getAcceptedPath();
        }
        return null;
    }

    private static synchronized void setDependencyProvider(HelpDependencyProvider helpDependencyProvider) {
        sDependencyProvider = helpDependencyProvider;
    }

    static synchronized HelpDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    public static String getDocCommandArg(String string, boolean bl) {
        if (HelpPrefs.isUsingDocCenterBrowser()) {
            return HelpUtils.getDocCommandArgForDocCenter(string, bl);
        }
        return HelpInfo.getDocCommandArg(string, bl);
    }

    private static String getDocCommandArgForDocCenter(String string, boolean bl) {
        int n = string.indexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        String string3 = n > -1 ? string.substring(0, n) : null;
        ReferenceEntityRequest.Precision precision = ReferenceEntityRequest.Precision.IGNORE_PACKAGE;
        Collection<RefEntityType> collection = HelpUtils.getRefEntityTypes(bl);
        ReferenceEntityRequest referenceEntityRequest = new ReferenceEntityRequest(string2, precision, collection);
        List<ReferenceData> list = HelpUtils.getReferenceData((ReferenceRequest)referenceEntityRequest);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (string3 == null || list.size() == 1) {
            return string2;
        }
        int n2 = HelpUtils.getProdPosition(list, string3);
        if (n2 > 0) {
            return string;
        }
        return string2;
    }

    private static int getProdPosition(List<ReferenceData> list, String string) {
        int n = 0;
        for (ReferenceData referenceData : list) {
            if (referenceData.getProduct().getShortName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
        ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
        try {
            List list = referenceDataRetriever.getReferenceData(referenceRequest);
            return list;
        }
        finally {
            try {
                referenceDataRetriever.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static Collection<RefEntityType> getRefEntityTypes(boolean bl) {
        EnumSet<RefEntityType> enumSet = EnumSet.of(RefEntityType.FUNCTION, RefEntityType.CLASS, RefEntityType.SYSTEM_OBJECT);
        if (bl) {
            enumSet.add(RefEntityType.METHOD);
            enumSet.add(RefEntityType.PROPERTY);
        }
        return enumSet;
    }

    static {
        sHelpDirectoriesToReplace.put("toolbox", null);
        sHelpDirectoriesToReplace.put("techdoc", "matlab");
        sHelpDirectoriesToReplace.put("base", null);
        sHelpDirectoriesToReplace.put("physmod/drive", "physmod/sdl/drive");
        sHelpDirectoriesToReplace.put("physmod/mech", "physmod/sm/mech");
        sHelpMapfilesToReplace = new LinkedHashMap<String, String>();
        sHelpMapfilesToReplace.put("mapfiles/creating_guis.map", "matlab/creating_guis/creating_guis.map");
        sHelpMapfilesToReplace.put("mapfiles/creating_plots.map", "matlab/creating_plots/creating_plots.map");
        sHelpMapfilesToReplace.put("mapfiles/matlab_env_csh.map", "matlab/env_csh/env_csh.map");
        sHelpMapfilesToReplace.put("mapfiles/learn_matlab.map", "matlab/learn_matlab/learn_matlab.map");
        sHelpMapfilesToReplace.put("mapfiles/matlab_env.map", "matlab/matlab_env/matlab_env.map");
        sHelpMapfilesToReplace.put("mapfiles/matlab_prog.map", "matlab/matlab_prog/matlab_prog.map");
        sHelpMapfilesToReplace.put("mapfiles/ref.map", "matlab/ref/matlab_ref.map");
        sHelpMapfilesToReplace.put("mapfiles/visualize.map", "matlab/visualize/matlab_visualize.map");
        sHelpMapfilesToReplace.put("mapfiles/control.map", "control/control.map");
        sHelpMapfilesToReplace.put("mapfiles/finderiv.map", "finderiv/helptargets.map");
        sHelpMapfilesToReplace.put("mapfiles/simulink.map", "simulink/helptargets.map");
        sHelpMapfilesToReplace.put("mapfiles/stateflow.map", "stateflow/stateflow.map");
        sHelpMapfilesToReplace.put("mapfiles/xpc.map", "xpc/xpc.map");
    }

    public static class DefaultDocRootProvider
    implements HelpDependencyProvider {
        @Override
        public String getDocRoot() {
            return MLHelpServices.getDocRoot().replace("\\", "/");
        }

        @Override
        public boolean isStudentVersion() {
            return Matlab.isStudentVersion();
        }

        @Override
        public boolean isUsingDocCenterBrowser() {
            return HelpPrefs.isUsingDocCenterBrowser();
        }

        @Override
        public HelpInfoItem[] getInstalledProductHelpInfo() {
            return ClassicHelpDataAccessor.getInstalledProductHelpInfo();
        }

        @Override
        public List<String> getInstalledProductShortNames() {
            return FunctionReferenceUtils.getInstalledProductShortNames(false);
        }

        @Override
        public String getHelpLanguage() {
            return LanguageUtils.getHelpLanguage();
        }

        @Override
        public Locale getHelpLocale() {
            return LanguageUtils.getHelpLocale();
        }
    }

    public static interface HelpDependencyProvider {
        public String getDocRoot();

        public boolean isUsingDocCenterBrowser();

        public boolean isStudentVersion();

        public HelpInfoItem[] getInstalledProductHelpInfo();

        public List<String> getInstalledProductShortNames();

        public String getHelpLanguage();

        public Locale getHelpLocale();
    }

    static class RelativePathFilter
    implements LocalizationFilter {
        private String iAcceptedPath;
        private String iPath;

        RelativePathFilter(String string) {
            this.iPath = string != null ? string : "";
        }

        @Override
        public boolean accept(String string) {
            if (StringUtils.startsWith((String)this.iPath, (String)string, (int)0, (boolean)PlatformInfo.isUnix())) {
                this.iAcceptedPath = this.iPath.substring(string.length());
                return true;
            }
            this.iAcceptedPath = null;
            return false;
        }

        @Override
        public String getAcceptedPath() {
            return this.iAcceptedPath;
        }
    }

    private static class FileExistsFilter
    implements LocalizationFilter {
        private String iAcceptedPath;
        private String iRelativePathToFile;
        private boolean iConvertPathToUrlPrefix = false;

        FileExistsFilter() {
        }

        FileExistsFilter(String string, boolean bl) {
            this.iRelativePathToFile = string;
            this.iConvertPathToUrlPrefix = bl;
        }

        @Override
        public boolean accept(String string) {
            String string2;
            String string3 = string2 = this.iConvertPathToUrlPrefix ? HelpUtils.convertPathToUrlPrefix(string) : string;
            if (this.iRelativePathToFile != null) {
                string2 = string2 + this.iRelativePathToFile;
            }
            if (HTMLUtils.doesFileExist(string2)) {
                this.iAcceptedPath = string2;
                return true;
            }
            this.iAcceptedPath = null;
            return false;
        }

        @Override
        public String getAcceptedPath() {
            return this.iAcceptedPath;
        }
    }
}

