/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.help.helpui.suggestions.DocSuggestionProtocolHandler;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpComponentHelper;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpToolBar;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ProductFilterRequestHandler;
import com.mathworks.mlwidgets.html.DocSearchRequestHandler;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.LightweightWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public final class HelpPopup {
    private static final Dimension DEFAULT_SIZE = new Dimension(520, 380);
    private static final Dimension MINIMUM_SIZE = new Dimension(200, 100);
    private static Dimension sLastSize;
    private static final String FOCUS_LISTENER_KEY = "focusBackToParent";
    private static HelpPopup sSingleton;
    private static boolean sTesting;
    private MJPanel fPanel;
    private HtmlComponent<MatlabHtmlActions> fHtmlComponent;
    private final KeyListener fEscapeListener = this.createEscapeListener();
    private final PrefListener fPrefListener = new DocCenterPrefsListener();
    private Window fWindow;
    private KeyStrokeList fShiftFocusKeyStrokes;
    private String fFunction;
    private String fFunctionUrl;
    private String fOpenBrowserHyperlink;
    private Frame fParentWindow;
    private JComponent fParent;
    private WindowListener fWindowListener;
    private HyperlinkTextLabel fHyperlink;
    private JComponent fContentPane;

    public static void setShowHelpBrowserPreference(boolean bl) {
        HelpPrefs.setShowHelpBrowserPreference(bl);
    }

    public static boolean isShowingHelpBrowser() {
        return HelpPrefs.getShowHelpBrowserPreference();
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStroke keyStroke) {
        HelpPopup.showHelp(jTextComponent, keyStroke == null ? null : new KeyStrokeList(new KeyStroke[]{keyStroke}));
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStrokeList keyStrokeList) {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("'text' cannot be null");
        }
        String string = jTextComponent.getSelectedText();
        if (string != null && string.trim().length() > 0) {
            HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, HelpPopup.computeBoundsRelativeToCaret(jTextComponent), HelpPopup.stripSelection(string));
        } else {
            HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, HelpPopup.computeBoundsRelativeToCaret(jTextComponent), HelpPopup.computeTextAtCaret(jTextComponent));
        }
    }

    private static String stripSelection(String string) {
        int n = string.indexOf(40);
        return (n > 0 ? string.substring(0, n) : string).trim();
    }

    private static void closeIfShowingWithDifferentParent(JComponent jComponent) {
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        HelpPopup helpPopup = HelpPopup.getInstance();
        if (helpPopup.getParentWindow() != window) {
            helpPopup.cleanup();
        }
    }

    private Window getParentWindow() {
        return this.fParentWindow;
    }

    private static String computeTextAtCaret(JTextComponent jTextComponent) {
        return TextComponentUtils.getFunctionAtCaret((JTextComponent)jTextComponent, (boolean)true);
    }

    public static void showHelp(JTextComponent jTextComponent, KeyStrokeList keyStrokeList, Point point, String string) {
        SwingUtilities.convertPointToScreen(point, jTextComponent);
        HelpPopup.showHelp((JComponent)jTextComponent, keyStrokeList, WindowUtils.computeTextPopupBounds((Dimension)HelpPopup.getLastSize(), (Dimension)DEFAULT_SIZE, (Point)point, (int)jTextComponent.getFontMetrics(jTextComponent.getFont()).getHeight(), (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED), string);
    }

    public static void showHelp(JComponent jComponent, KeyStrokeList keyStrokeList, Rectangle rectangle, String string) {
        if (string != null && string.indexOf(10) != -1) {
            MJOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(jComponent), (Object)HelpUtils.getLocalizedString("helppopup.noNewlines"), (String)HelpUtils.getLocalizedString("helppopup.title"), (int)2);
            return;
        }
        HelpPopup.showHelp(jComponent, keyStrokeList, rectangle, null, string);
    }

    public static void showHelp(JComponent jComponent, KeyStrokeList keyStrokeList, Rectangle rectangle, URL uRL) {
        HelpPopup.showHelp(jComponent, keyStrokeList, rectangle, uRL, null);
    }

    private static synchronized void showHelp(JComponent jComponent, KeyStrokeList keyStrokeList, Rectangle rectangle, URL uRL, String string) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be called on the EDT");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("'parent' cannot be null");
        }
        if (rectangle == null) {
            throw new IllegalArgumentException("'popupLocation' cannot be null");
        }
        HelpPopup.closeIfShowingWithDifferentParent(jComponent);
        HelpPopup helpPopup = HelpPopup.getInstance();
        if (!helpPopup.isVisible()) {
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            if (window == null || !(window instanceof Frame)) {
                throw new IllegalArgumentException("popup must be parented by something that lives in a Frame: " + jComponent);
            }
            helpPopup.reparent((Frame)window, keyStrokeList, rectangle);
        }
        helpPopup.updateFunction(string, uRL);
        helpPopup.populateAndShow(jComponent);
    }

    private void updateFunction(String string, URL uRL) {
        this.fFunctionUrl = uRL == null ? null : uRL.toString();
        this.fFunction = string == null ? null : StringUtils.quoteSingleQuotes((String)string.toLowerCase());
    }

    private static Rectangle computeBoundsRelativeToCaret(JTextComponent jTextComponent) {
        return WindowUtils.computeTextPopupBounds((Dimension)HelpPopup.getLastSize(), (Dimension)DEFAULT_SIZE, (JTextComponent)jTextComponent, (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
    }

    private static synchronized HelpPopup getInstance() {
        if (sSingleton == null) {
            sSingleton = new HelpPopup();
        }
        return sSingleton;
    }

    private HtmlComponent<MatlabHtmlActions> getHtmlComponent() {
        return this.fHtmlComponent;
    }

    private MJPanel getPanel() {
        return this.fPanel;
    }

    private HelpPopup() {
        assert (SwingUtilities.isEventDispatchThread());
        this.createComponents();
    }

    private void createComponents() {
        this.fHtmlComponent = HtmlComponentFactory.buildHtmlComponent(HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER);
        this.fHtmlComponent.getComponent().setName("HTMLRenderer");
        HelpPopupVisitor helpPopupVisitor = new HelpPopupVisitor();
        HtmlConversionUtils.visitBrowser(this.fHtmlComponent, helpPopupVisitor);
        this.fHtmlComponent.getComponent().addKeyListener(this.fEscapeListener);
        HelpToolBar helpToolBar = new HelpToolBar(this.getActions(this.fHtmlComponent), new HelpComponentHelper(), null);
        this.fPanel = new MJPanel();
        this.fPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.fPanel.add((Component)helpToolBar.getComponent(), (Object)"North");
        this.fPanel.add(this.fHtmlComponent.getComponent(), (Object)"Center");
        HelpPrefs.addPrefsListeners(this.fPrefListener, "HelpUseDocCenterBrowser", "HelpDocCenterLocation");
    }

    private static void addHandlersForInstalledDoc(MJHtmlPanel mJHtmlPanel) {
        DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
        mJHtmlPanel.addPageChangedListener((PageChangedListener)new DocSearchPageChangedListener((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.DEFAULT_DOC_RELEASE));
        mJHtmlPanel.addRequestHandler((RequestHandler)new DocSuggestionProtocolHandler((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.getDocCenterRoot()));
        mJHtmlPanel.addRequestHandler((RequestHandler)new ProductFilterRequestHandler(mJHtmlPanel, docCenterSearchHelper.getDocumentationSet()));
    }

    private Map<StandardHtmlActionId, ? extends Action> getActions(HtmlComponent<MatlabHtmlActions> htmlComponent) {
        Map map = ((MatlabHtmlActions)htmlComponent.getActions()).getBasicActions();
        HashMap hashMap = new HashMap();
        hashMap.put(StandardHtmlActionId.GO_BACK, map.get(StandardHtmlActionId.GO_BACK));
        hashMap.put(StandardHtmlActionId.GO_FORWARD, map.get(StandardHtmlActionId.GO_FORWARD));
        hashMap.put(StandardHtmlActionId.RELOAD, map.get(StandardHtmlActionId.RELOAD));
        hashMap.put(StandardHtmlActionId.PRINT, map.get(StandardHtmlActionId.PRINT));
        hashMap.put(StandardHtmlActionId.FIND, map.get(StandardHtmlActionId.FIND));
        return hashMap;
    }

    private void reparent(Frame frame, KeyStrokeList keyStrokeList, Rectangle rectangle) {
        this.fShiftFocusKeyStrokes = keyStrokeList;
        this.fParentWindow = frame;
        this.fWindow = this.buildDialog(rectangle);
    }

    private boolean isVisible() {
        return this.fWindow != null && this.fWindow.isShowing();
    }

    private void setVisible(boolean bl) {
        if (this.fWindow != null) {
            this.fWindow.setVisible(bl);
        }
    }

    private synchronized void dispose() {
        if (this.fWindow != null) {
            this.fWindow.dispose();
        }
        this.disposeComponents();
        sSingleton = null;
    }

    private String computeOpenBrowserHyperlink(boolean bl) {
        if (!bl) {
            return "doc";
        }
        String string = this.fFunctionUrl != null ? this.buildWebCommand(this.fFunctionUrl) : this.buildDocCommand(this.fFunction);
        return string;
    }

    private String buildWebCommand(String string) {
        return this.isUrlUnderDocroot(string) ? "web('" + string + "', '-helpbrowser')" : "web('" + string + "')";
    }

    private boolean isUrlUnderDocroot(String string) {
        string = HTMLUtils.getCanonicalUrl(string);
        return HelpUtils.isUnderDocroot(string);
    }

    private String buildDocCommand(String string) {
        return string == null ? "doc" : "doc ('" + string + "')";
    }

    private KeyListener createEscapeListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    HelpPopup.this.fWindow.dispose();
                    keyEvent.consume();
                }
            }
        };
    }

    private static void setTesting(boolean bl) {
        sTesting = bl;
    }

    public static String getInitialFunction() {
        return HelpPopup.getInstance().getFunction();
    }

    private String getFunction() {
        return this.fFunction;
    }

    private void populateAndShow(JComponent jComponent) {
        Object object;
        if (HelpPopup.isShowingHelpBrowser()) {
            new MatlabMCR().evalConsoleOutput(this.computeOpenBrowserHyperlink(true));
            return;
        }
        this.fOpenBrowserHyperlink = this.computeOpenBrowserHyperlink(true);
        this.fParent = jComponent;
        final HelpPopup helpPopup = HelpPopup.getInstance();
        if (!sTesting) {
            if (this.fFunction == null && this.fFunctionUrl == null) {
                if (!this.fWindow.isVisible()) {
                    object = HelpPopup.getLandingPageUrl();
                    helpPopup.getHtmlComponent().setCurrentLocation((String)object);
                }
            } else if (this.fFunctionUrl != null) {
                if (!this.fFunctionUrl.equals(helpPopup.getHtmlComponent().getCurrentLocation())) {
                    helpPopup.getHtmlComponent().setCurrentLocation(this.fFunctionUrl);
                }
            } else {
                object = HelpPopup.getReferencePageUrl(this.fFunction);
                if (object == null) {
                    this.populateWithMHelp();
                } else if (!((String)object).equals(helpPopup.getHtmlComponent().getCurrentLocation())) {
                    helpPopup.getHtmlComponent().setCurrentLocation((String)object);
                }
            }
        }
        object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        this.fWindow.setVisible(true);
        this.requestFocusInWindow(helpPopup, (Component)object);
        EventQueue.invokeLater(new Runnable((Component)object){
            final /* synthetic */ Component val$oldFocusOwner;
            {
                this.val$oldFocusOwner = component;
            }

            @Override
            public void run() {
                HelpPopup.this.requestFocusInWindow(helpPopup, this.val$oldFocusOwner);
            }
        });
    }

    private void requestFocusInWindow(HelpPopup helpPopup, Component component) {
        boolean bl = helpPopup.getHtmlComponent().getComponent().requestFocusInWindow();
        if (!bl) {
            component.requestFocusInWindow();
        }
    }

    private static String getLandingPageUrl() {
        return HelpPrefs.isUsingDocCenterBrowser() ? DocCenterUtils.buildDocCenterUrl() : HelpInfo.getProductPageForShortName("matlab");
    }

    private static String getReferencePageUrl(String string) {
        return HelpPrefs.isUsingDocCenterBrowser() ? HelpPopup.getDocCenterReferencePageUrl(string) : HelpInfo.getReferencePageUrl(string);
    }

    private static String getDocCenterReferencePageUrl(String string) {
        String string2 = null;
        List<ReferenceData> list = HelpPopup.getReferenceData(string);
        if (!list.isEmpty()) {
            string2 = HelpPopup.getPageLocation(HelpPrefs.getDocCenterRoot(), list.get(0));
            string2 = DocCenterUtils.buildDocCenterUrl(string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ReferenceData> getReferenceData(String string) {
        ReferenceEntityRequest referenceEntityRequest = new ReferenceEntityRequest(string, EnumSet.of(RefEntityType.FUNCTION, RefEntityType.METHOD, RefEntityType.CLASS));
        ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
        try {
            List list;
            List list2 = list = referenceDataRetriever.getReferenceData((ReferenceRequest)referenceEntityRequest);
            return list2;
        }
        finally {
            try {
                referenceDataRetriever.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String getPageLocation(String string, ReferenceData referenceData) {
        return HelpBrowserUtils.concatenatePaths((String[])new String[]{string, referenceData.getProduct().getHelpLocation(), referenceData.getRelativePath()});
    }

    private void populateWithMHelp() {
        assert (Matlab.isMatlabAvailable());
        new MatlabWorker(){

            public Object runOnMatlabThread() {
                Object object;
                try {
                    String string = "";
                    String string2 = "-helpPopup";
                    object = 3.feval((String)"help2html", (Object[])new Object[]{HelpPopup.this.fFunction, string, string2}, (int)2);
                }
                catch (Exception exception) {
                    object = null;
                }
                return object;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (object == null) {
                    HelpPopup.this.cleanup();
                    return;
                }
                Object[] objectArray = (Object[])object;
                HelpPopup helpPopup = HelpPopup.getInstance();
                String string = objectArray[0].toString();
                String string2 = helpPopup.getHtmlComponent().getHtmlText();
                if (string2 == null || !string2.contains(string)) {
                    helpPopup.getHtmlComponent().setHtmlText(string);
                }
                boolean bl = ((boolean[])objectArray[1])[0];
                HelpPopup.this.fOpenBrowserHyperlink = HelpPopup.this.computeOpenBrowserHyperlink(bl);
                helpPopup.getHtmlComponent().getComponent().requestFocusInWindow();
            }
        }.start();
    }

    private Window buildDialog(Rectangle rectangle) {
        JDialog jDialog = new LightweightWindow(this.fParentWindow, HelpUtils.getLocalizedString("helppopup.title"), (Component)HelpPopup.getInstance().getPanel(), this.buildStatusBar()).getWindow();
        jDialog.setName("HelpPopup");
        this.fContentPane = (JComponent)jDialog.getContentPane();
        this.addKeyStrokeToShiftFocus(this.fContentPane);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpPopup.this.cleanup();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                HelpPopup.this.cleanup();
            }
        };
        jDialog.addWindowListener(this.fWindowListener);
        if (!PlatformInfo.isMacintosh()) {
            jDialog.setMinimumSize(MINIMUM_SIZE);
        }
        jDialog.setBounds(rectangle);
        return jDialog;
    }

    private void addKeyStrokeToShiftFocus(JComponent jComponent) {
        if (this.fShiftFocusKeyStrokes != null && !this.fShiftFocusKeyStrokes.isEmpty()) {
            InputMap inputMap = jComponent.getInputMap(1);
            MInputMap mInputMap = new MInputMap();
            mInputMap.setParent(inputMap);
            mInputMap.put(this.fShiftFocusKeyStrokes.toKeyStrokeArray(), (Object)FOCUS_LISTENER_KEY);
            jComponent.setInputMap(1, (InputMap)mInputMap);
            ActionMap actionMap = jComponent.getActionMap();
            actionMap.put(FOCUS_LISTENER_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (HelpPopup.this.fParent != null) {
                        HelpPopup.this.fParent.requestFocus();
                    }
                }
            });
        }
    }

    private MJStatusBar buildStatusBar() {
        String string;
        String string2;
        MJStatusBar mJStatusBar = new MJStatusBar();
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                HelpPopup.this.fWindow.dispose();
                HelpPopup helpPopup = HelpPopup.getInstance();
                if (helpPopup.getHtmlComponent().getCurrentLocation() != null && !helpPopup.getHtmlComponent().getCurrentLocation().startsWith("text")) {
                    MLHelpServices.setCurrentLocation((String)helpPopup.getHtmlComponent().getCurrentLocation());
                } else {
                    new MatlabMCR().evalConsoleOutput(HelpPopup.this.fOpenBrowserHyperlink);
                }
            }
        };
        mJStatusBar.add(Box.createRigidArea(new Dimension(8, 20)), (Object)"West");
        String string3 = HelpUtils.getLocalizedString("helppopup.openHelpBrowser");
        this.fHyperlink = new HyperlinkTextLabel(string3, hyperlinkHandler);
        this.fHyperlink.getComponent().setName("HelpLink");
        this.fHyperlink.setFont(HelpPopup.getReducedFont(new JLabel().getFont()));
        mJStatusBar.add((Component)this.fHyperlink.getComponent(), (Object)"West");
        if (this.fShiftFocusKeyStrokes != null) {
            string2 = KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)this.fShiftFocusKeyStrokes);
            string = MessageFormat.format(HelpUtils.getLocalizedString("helppopup.toggleFocusAndEscape"), string2);
        } else {
            string = HelpUtils.getLocalizedString("helppopup.escape");
        }
        string2 = new MJLabel(string);
        string2.setFont(HelpPopup.getReducedFont(string2.getFont()));
        mJStatusBar.add((Component)((Object)string2));
        return mJStatusBar;
    }

    private static Font getReducedFont(Font font) {
        return font.deriveFont((float)(font.getSize() - 2));
    }

    private static synchronized Dimension getLastSize() {
        return sLastSize == null ? DEFAULT_SIZE : sLastSize;
    }

    private synchronized void cleanup() {
        if (this.fParent != null) {
            sLastSize = this.fWindow.getSize();
            this.fWindow.removeWindowListener(this.fWindowListener);
            this.fContentPane.getActionMap().remove(FOCUS_LISTENER_KEY);
            this.fWindow.dispose();
            this.fHyperlink.cleanup();
            this.fParentWindow = null;
            this.fParent = null;
        }
    }

    private void disposeComponents() {
        if (this.fHtmlComponent != null) {
            this.fHtmlComponent.getComponent().removeKeyListener(this.fEscapeListener);
            this.fHtmlComponent.dispose();
            HelpPrefs.removePrefsListeners(this.fPrefListener, "HelpUseDocCenterBrowser", "HelpDocCenterLocation");
        }
        if (this.fPanel != null) {
            this.fPanel = null;
        }
    }

    private class DocCenterPrefsListener
    implements PrefListener {
        private DocCenterPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (HelpPopup.this.isVisible()) {
                        HelpPopup.this.setVisible(false);
                    }
                    HelpPopup.this.dispose();
                }
            });
        }
    }

    private static class HelpPopupVisitor
    implements HtmlConversionUtils.BrowserVisitor {
        private HelpPopupVisitor() {
        }

        @Override
        public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            if (HelpPrefs.getDocCenterLocation() == DocLocation.INSTALLED) {
                HelpPopup.addHandlersForInstalledDoc(mJHtmlPanel);
            }
        }

        @Override
        public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            hTMLRenderer.addRequestHandler(new DocSearchRequestHandler(hTMLRenderer, (SearchHelper)DocCenterSearchHelper.getInstance(), HelpPrefs.DEFAULT_DOC_RELEASE));
        }
    }
}

