/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.DemoInfoItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItemVisitor;
import com.mathworks.mlwidgets.help.HelpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class DemoTreeItem
implements HelpTreeItem,
DemoInfoItem,
TreeNode {
    private DemoLevel fLevel;
    private String fType;
    private String fRelativeFilename;
    private String fFilename;
    private String fXmlFilename;
    private String fSource;
    private String fCallback;
    private String fTextDescription;
    private String fLabel;
    private String fProduct;
    private Icon fIcon;
    private TreeNode fParent;
    private String fProductType;
    private Collection<DemoTreeItem> fChildren;

    DemoTreeItem(DemoLevel demoLevel) {
        this.fLevel = demoLevel;
    }

    @Override
    public TreeNode getTreeNode() {
        return this;
    }

    @Override
    public void accept(HelpTreeItemVisitor helpTreeItemVisitor) {
        helpTreeItemVisitor.visit(this);
    }

    void setType(String string) {
        this.fType = string;
    }

    DemoLevel getLevel() {
        return this.fLevel;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    void setProductType(String string) {
        this.fProductType = string;
    }

    @Override
    public String getProductType() {
        for (TreeNode treeNode = this; treeNode != null && treeNode instanceof DemoTreeItem; treeNode = treeNode.getParent()) {
            String string = treeNode.getItemProductType();
            if (string == null || string.trim().length() <= 0) continue;
            return string;
        }
        return "";
    }

    @Override
    public void addChild(TreeNode treeNode) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<DemoTreeItem>();
        }
        if (treeNode instanceof DemoTreeItem) {
            this.fChildren.add((DemoTreeItem)treeNode);
        }
    }

    private String getItemProductType() {
        return this.fProductType;
    }

    public void setRelativeFilename(String string) {
        this.fRelativeFilename = string;
    }

    public String getRelativeFilename() {
        return this.fRelativeFilename;
    }

    @Override
    public final String getFilename() {
        return this.getFilename(HelpUtils.getDemosDirectoryName());
    }

    @Override
    public final String getFilename(String[] stringArray) {
        if (this.getRelativeFilename() == null || this.getRelativeFilename().length() == 0) {
            return this.getRelativeFilename();
        }
        if (this.fFilename == null) {
            this.fFilename = DemoInfoUtils.getAbsolutePath(this.getXmlFilename(), this.getRelativeFilename(), stringArray);
        }
        return this.fFilename;
    }

    void setXmlFilename(String string) {
        this.fXmlFilename = string;
    }

    @Override
    public String getXmlFilename() {
        return this.fXmlFilename;
    }

    void setSource(String string) {
        this.fSource = string;
    }

    @Override
    public String getSource() {
        return this.fSource;
    }

    void setCallback(String string) {
        this.fCallback = string;
    }

    @Override
    public String getCallback() {
        return this.fCallback;
    }

    void setTextDescription(String string) {
        this.fTextDescription = string;
    }

    @Override
    public String getTextDescription() {
        return this.fTextDescription;
    }

    public void setLabel(String string) {
        this.fLabel = string;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public String getShortLabel() {
        return this.getLabel();
    }

    public void setProduct(String string) {
        this.fProduct = string;
    }

    @Override
    public String getProduct() {
        for (TreeNode treeNode = this; treeNode != null && treeNode instanceof DemoTreeItem; treeNode = treeNode.getParent()) {
            String string = treeNode.getItemProduct();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private String getItemProduct() {
        return this.fProduct;
    }

    public void setIcon(Icon icon) {
        this.fIcon = icon;
    }

    @Override
    public Icon getIcon() {
        return this.fIcon;
    }

    public void setParent(TreeNode treeNode) {
        this.fParent = treeNode;
    }

    @Override
    public TreeNode getParent() {
        return this.fParent;
    }

    public Collection<DemoTreeItem> getChildren() {
        if (this.fChildren != null) {
            return Collections.unmodifiableCollection(this.fChildren);
        }
        return null;
    }

    private List<DemoTreeItem> getChildList() {
        if (this.fChildren instanceof List) {
            return (List)this.fChildren;
        }
        ArrayList<DemoTreeItem> arrayList = new ArrayList<DemoTreeItem>();
        arrayList.addAll(this.fChildren);
        return arrayList;
    }

    public String toString() {
        return this.getLabel();
    }

    void clear() {
        this.fChildren = null;
    }

    @Override
    public DemoTreeItem getChildAt(int n) {
        if (this.fChildren != null && n < this.fChildren.size()) {
            return this.getChildList().get(n);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.fChildren == null ? 0 : this.fChildren.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (this.fChildren != null && treeNode instanceof DemoTreeItem) {
            DemoTreeItem demoTreeItem = (DemoTreeItem)treeNode;
            return this.getChildList().indexOf(demoTreeItem);
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public boolean isLeaf() {
        return this.fLevel == DemoLevel.DEMO || this.fLevel == DemoLevel.INTRO_PAGE || this.fLevel == DemoLevel.DUMMY;
    }

    public Enumeration<DemoTreeItem> children() {
        return new DemosEnumeration();
    }

    private class DemosEnumeration
    implements Enumeration<DemoTreeItem> {
        private Iterator<DemoTreeItem> iIterator;

        private DemosEnumeration() {
            this.iIterator = DemoTreeItem.this.fChildren != null ? DemoTreeItem.this.fChildren.iterator() : null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iIterator != null && this.iIterator.hasNext();
        }

        @Override
        public DemoTreeItem nextElement() {
            return this.iIterator.next();
        }
    }

    static enum DemoLevel {
        ROOT,
        INTRO_PAGE,
        TOP_LEVEL,
        SECTION,
        PRODUCT,
        DEMO,
        DUMMY;

    }
}

