/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TreeTableModel;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.StateNode;
import java.util.ArrayList;
import java.util.List;

public class PlotPickerTableModel
extends TreeTableModel<Row> {
    private boolean fIsShowingSearchResults = false;

    PlotPickerTableModel() {
    }

    private PlotPickerTableModel(StateNode stateNode, String string, String[] stringArray, boolean bl) {
        this.fIsShowingSearchResults = string != null && string.length() >= 1;
        this.createRows(stateNode, null, string, stringArray, bl);
        this.clearCategoryPostions();
    }

    private PlotPickerTableModel(StateNode stateNode, String[] stringArray, boolean bl) {
        this.fIsShowingSearchResults = false;
        this.createRows(stateNode, null, null, stringArray, bl);
        this.setCategoryPostions();
    }

    static PlotPickerTableModel createPlotPickerTableModel(StateNode stateNode, String[] stringArray, boolean bl) {
        return new PlotPickerTableModel(stateNode, stringArray, bl);
    }

    static PlotPickerTableModel createPlotPickerTableModel(StateNode stateNode, String string, String[] stringArray, boolean bl) {
        return new PlotPickerTableModel(stateNode, string, stringArray, bl);
    }

    int getFirstCategoryRowPos() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row row = this.getRowAt(i);
            if (!(row instanceof Category)) continue;
            return i;
        }
        return -1;
    }

    private void setCategoryPostions() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row row = this.getRowAt(i);
            if (!(row instanceof Category) || row instanceof FavoriteCategory) continue;
            ((Category)row).setPosition(n++);
        }
    }

    private void clearCategoryPostions() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row row = this.getRowAt(i);
            if (!(row instanceof Category)) continue;
            ((Category)row).setPosition(0);
        }
    }

    private void createRows(StateNode stateNode, Row row, String string, String[] stringArray, boolean bl) {
        for (int i = 0; i < stateNode.getChildCount(); ++i) {
            String string2;
            Object object;
            StateNode stateNode2 = (StateNode)stateNode.getChildAt(i);
            if (stateNode2.getAllowsChildren() && stateNode2.getChildCount() > 0) {
                if (!stateNode2.getChildAt(0).getAllowsChildren()) {
                    if (bl) {
                        int n = 0;
                        for (int j = 0; j < stateNode2.getChildCount(); ++j) {
                            object = (StateNode)stateNode2.getChildAt(j);
                            if (!((StateNode)object).isEnabled()) continue;
                            ++n;
                        }
                        if (n == 0) continue;
                    }
                    Category category = new Category((String)stateNode2.getUserObject());
                    category.setExpandable(false);
                    category.setExpanded(true);
                    if (row == null) {
                        this.addRow((Row)category);
                    } else {
                        this.addRow(row, (Row)category);
                    }
                    this.createRows(stateNode2, (Row)category, string, stringArray, bl);
                    continue;
                }
                this.createRows(stateNode2, null, string, stringArray, bl);
                continue;
            }
            if (stateNode2.getAllowsChildren() || bl && !stateNode2.isEnabled()) continue;
            PlotAction plotAction = (PlotAction)stateNode2.getUserObject();
            ActionRow actionRow = new ActionRow(plotAction);
            actionRow.setSearchResult(string != null);
            actionRow.setEnabled(stateNode2.isEnabled());
            if (stringArray != null && stringArray.length == 2) {
                actionRow.setSwapable(stateNode2.isEnabledByUnswappedVariables() && stateNode2.isEnabledBySwappedVariables());
                if (!stateNode2.isEnabledByUnswappedVariables() && stateNode2.isEnabledBySwappedVariables()) {
                    actionRow.setSwapped(true);
                }
            }
            if ((object = stateNode2.getCustomLabelText()) != null && ((String)object).length() > 0) {
                actionRow.setCustomLabel((String)object);
            }
            if (plotAction.allowSwap() && (string2 = stateNode2.getSwappedCustomLabelText()) != null && string2.length() > 0) {
                actionRow.setSwappedCustomLabel(string2);
            }
            if (row == null) {
                if (this.getRowCount() == 0) {
                    if (string == null) {
                        this.addRow((Row)new FavoriteCategory());
                    } else {
                        this.addRow((Row)new Category(PlotPicker.getResourceString("PlotPickerTableModel", "Match") + " " + string));
                    }
                }
                this.addRow((Row)actionRow);
                continue;
            }
            this.addRow(row, (Row)actionRow);
        }
    }

    public int getColumnCount() {
        return 1;
    }

    void removeActionRow(ActionRow actionRow) {
        if (this.fIsShowingSearchResults) {
            actionRow.setFavorite(false);
            ModelStateFactory.removeFavoritePlotActionNode(actionRow.getPlotAction(), (Object)this);
            return;
        }
        actionRow.setFavorite(false);
        if (this.getFavoriteCount() == 0) {
            this.removeRow(0);
        }
        this.removeRow((Row)actionRow);
        ModelStateFactory.removeFavoritePlotActionNode(actionRow.getPlotAction(), (Object)this);
    }

    private int getFavoriteCount() {
        return this.getFavoriteActionsRows().length;
    }

    ActionRow[] getFavoriteActionsRows() {
        ArrayList<ActionRow> arrayList = new ArrayList<ActionRow>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row row = this.getRowAt(i);
            if (!(row instanceof ActionRow) || row.getLevel() != 0 || !((ActionRow)row).isFavorite() || ((ActionRow)row).isSearchResult()) continue;
            arrayList.add((ActionRow)row);
        }
        return arrayList.toArray(new ActionRow[arrayList.size()]);
    }

    ActionRow getMatchingTopLevelFavoriteRow(ActionRow actionRow) {
        ActionRow[] actionRowArray;
        for (ActionRow actionRow2 : actionRowArray = this.getFavoriteActionsRows()) {
            if (actionRow2.getPlotAction() != actionRow.getPlotAction()) continue;
            return actionRow2;
        }
        return null;
    }

    boolean moveActionRow(ActionRow actionRow, Row row) {
        boolean bl;
        Expandable expandable = actionRow.getParent();
        String string = null;
        if (expandable != null && expandable instanceof Category) {
            string = ((Category)expandable).getValueAt(0).toString();
        }
        boolean bl2 = row instanceof FavoriteCategory;
        boolean bl3 = row instanceof ActionRow && !(row.getParent() instanceof Category);
        boolean bl4 = bl = string == null;
        if (this.fIsShowingSearchResults && row != null) {
            return false;
        }
        if (row == null || !bl && (bl2 || bl3)) {
            if (actionRow.getPlotAction().isFavorite()) {
                return false;
            }
            if (this.fIsShowingSearchResults) {
                actionRow.setFavorite(true);
                ModelStateFactory.copyPlotActionToFavorites(actionRow.getPlotAction(), null, (Object)this);
                return true;
            }
            if (this.getFavoriteCount() == 0) {
                this.addRow(0, (Row)new FavoriteCategory(), true);
            }
            if (row != null && row instanceof ActionRow) {
                int n = this.getRowIndex(row);
                this.addRow(n, (Row)new ActionRow(actionRow), false);
                ModelStateFactory.copyPlotActionToFavorites(actionRow.getPlotAction(), ((ActionRow)row).getPlotAction(), (Object)this);
            } else {
                this.addRow(1, (Row)new ActionRow(actionRow), true);
                ModelStateFactory.copyPlotActionToFavorites(actionRow.getPlotAction(), null, (Object)this);
            }
            return true;
        }
        if (bl && !bl2 && !bl3) {
            return false;
        }
        if (row instanceof Category) {
            List list = ((Category)row).getChildren();
            if (list != null) {
                for (Object e : list) {
                    if (!(e instanceof ActionRow) || e == actionRow || ((ActionRow)((Object)e)).getPlotAction() != actionRow.getPlotAction()) continue;
                    return false;
                }
            }
            if (row instanceof FavoriteCategory) {
                this.removeRow((Row)actionRow);
                this.addRow(1, (Row)new ActionRow(actionRow), true);
                ModelStateFactory.moveReferencePlotActionNode(actionRow.getPlotAction(), string, null, null, (Object)this);
            } else {
                this.removeRow((Row)actionRow);
                this.addRow(row, 0, (Row)new ActionRow(actionRow));
                ModelStateFactory.moveReferencePlotActionNode(actionRow.getPlotAction(), string, row.getValueAt(0).toString(), null, (Object)this);
            }
            return true;
        }
        if (row instanceof ActionRow) {
            String string2 = null;
            Expandable expandable2 = row.getParent();
            List list = expandable2.getChildren();
            if (list != null) {
                for (Object e : list) {
                    if (!(e instanceof ActionRow) || e == actionRow || ((ActionRow)((Object)e)).getPlotAction() != actionRow.getPlotAction()) continue;
                    return false;
                }
            }
            if (expandable2 instanceof Category) {
                string2 = ((Category)expandable2).getValueAt(0).toString();
            }
            this.removeRow((Row)actionRow);
            int n = this.getRowIndex(row);
            this.addRow(n, (Row)new ActionRow(actionRow), false);
            ModelStateFactory.moveReferencePlotActionNode(actionRow.getPlotAction(), string, string2, ((ActionRow)row).getPlotAction(), (Object)this);
            return true;
        }
        return false;
    }

    void moveCategoryToTop(String string) {
        int n;
        Category category = null;
        for (n = 0; n < this.getRowCount(); ++n) {
            if (!(this.getRowAt(n) instanceof Category) || !string.equals(this.getRowAt(n).getValueAt(0))) continue;
            category = (Category)this.getRowAt(n);
            this.removeRow((Row)category);
            break;
        }
        if (category == null) {
            return;
        }
        for (n = 0; n < this.getRowCount(); ++n) {
            if (!(this.getRowAt(n) instanceof Category) || ((Category)this.getRowAt(n)).getChildrenCount() <= 0) continue;
            this.addRow(n, (Row)category, true);
            break;
        }
        this.setCategoryPostions();
        ModelStateFactory.moveReferenceCategoryNodeToTop(string, (Object)this);
    }

    Category getNextCategory(Category category) {
        int n = this.getRowIndex((Row)category);
        if (n < 0) {
            return null;
        }
        for (int i = n + 1; i < this.getRowCount(); ++i) {
            Row row = this.getRowAt(i);
            if (!(row instanceof Category)) continue;
            return (Category)row;
        }
        return null;
    }

    ActionRow findFirstPlotActionRow(PlotAction plotAction) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row row = this.getRowAt(i);
            if (!(row instanceof ActionRow) || !plotAction.getID().equals(((ActionRow)row).getPlotAction().getID())) continue;
            return (ActionRow)row;
        }
        return null;
    }

    public static final class ActionRow
    extends DefaultExpandableRow {
        private PlotAction fPlotAction;
        private boolean fEnabled = true;
        private boolean fSwapped = false;
        private boolean fIsSwapable = false;
        private boolean fIsSearchResult = false;
        private String fCustomLabel = null;
        private String fSwappedCustomLabel = null;

        ActionRow(PlotAction plotAction) {
            this.fPlotAction = plotAction;
            this.setExpandable(false);
        }

        ActionRow(ActionRow actionRow) {
            this.fPlotAction = actionRow.fPlotAction;
            this.fEnabled = actionRow.fEnabled;
            this.fSwapped = actionRow.fSwapped;
            this.fIsSwapable = actionRow.fIsSwapable;
            this.fCustomLabel = actionRow.fCustomLabel;
            this.fSwappedCustomLabel = actionRow.fSwappedCustomLabel;
        }

        void setCustomLabel(String string) {
            this.fCustomLabel = string;
        }

        void setSwappedCustomLabel(String string) {
            this.fSwappedCustomLabel = string;
        }

        String getCustomLabel() {
            return this.fCustomLabel;
        }

        String getSwappedCustomLabel() {
            return this.fSwappedCustomLabel;
        }

        public boolean isFavorite() {
            return this.fPlotAction.isFavorite();
        }

        boolean isSearchResult() {
            return this.fIsSearchResult;
        }

        void setSearchResult(boolean bl) {
            this.fIsSearchResult = bl;
        }

        void setFavorite(boolean bl) {
            this.fPlotAction.setFavorite(bl);
        }

        public void setEnabled(boolean bl) {
            this.fEnabled = bl;
        }

        public boolean isEnabled() {
            return this.fEnabled;
        }

        boolean isSwapped() {
            return this.fSwapped;
        }

        boolean isSwapable() {
            return this.fIsSwapable;
        }

        void setSwapable(boolean bl) {
            this.fIsSwapable = this.fPlotAction != null && bl;
        }

        void setSwapped(boolean bl) {
            this.fSwapped = bl;
        }

        public boolean hasChildren() {
            return false;
        }

        public PlotAction getPlotAction() {
            return this.fPlotAction;
        }

        void execute(String[] stringArray, Object object) {
            if (!this.isEnabled()) {
                return;
            }
            this.getPlotAction().execute(stringArray, this.isSwapped(), object);
        }

        void insertCommand(String[] stringArray) {
            this.getPlotAction().insert(stringArray, this.isSwapped());
        }

        public Object getValueAt(int n) {
            return this.fPlotAction;
        }
    }

    public static class Category
    extends DefaultExpandableRow {
        private String iCatName;
        private int iCategoryPos = 0;

        Category(String string) {
            this.iCatName = string;
        }

        boolean isFirstCategoryRow() {
            return this.iCategoryPos == 0;
        }

        void setPosition(int n) {
            this.iCategoryPos = n;
        }

        int getPosition() {
            return this.iCategoryPos;
        }

        public Object getValueAt(int n) {
            return this.iCatName;
        }
    }

    static class FavoriteCategory
    extends Category {
        FavoriteCategory() {
            super(PlotPicker.getResourceString("PlotPickerTableModel", "Favs"));
        }
    }
}

