/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.graphics.IPlotModelChangeListener;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotActionEvaluator;
import com.mathworks.mlwidgets.graphics.PlotPickerXMLParser;
import com.mathworks.mlwidgets.graphics.StateNode;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.util.productinfo.InfoListener;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public final class ModelStateFactory {
    static volatile StateNode sPlotPickerRoot = null;
    private static volatile Map<String, List<PlotAction>> sMethodMap = null;
    private static ProductInfoListener sProductInfoListener = null;
    private static final List<ParseCompleteListener> sParseCompleteListeners = new ArrayList<ParseCompleteListener>();
    private static final List<IPlotModelChangeListener> sPlotModelChangeListeners = new ArrayList<IPlotModelChangeListener>();
    private static final ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.graphics.resources.RES_PlotPicker");

    private ModelStateFactory() {
    }

    public static boolean isInitialized() {
        return sPlotPickerRoot != null;
    }

    static synchronized void restore() {
        sPlotPickerRoot = null;
        ModelStateFactory.createPlotHiearchy();
        ModelStateFactory.firePlotModelChangeListener(null);
    }

    static synchronized void addModelChangeListener(IPlotModelChangeListener iPlotModelChangeListener) {
        if (iPlotModelChangeListener == null || sPlotModelChangeListeners.contains(iPlotModelChangeListener)) {
            return;
        }
        sPlotModelChangeListeners.add(iPlotModelChangeListener);
    }

    static synchronized void removeModelChangeListener(IPlotModelChangeListener iPlotModelChangeListener) {
        sPlotModelChangeListeners.remove(iPlotModelChangeListener);
    }

    static synchronized boolean isReady() {
        return sPlotPickerRoot != null;
    }

    static synchronized void createPlotHiearchy() {
        ModelStateFactory.createPlotHiearchy(true);
    }

    public static synchronized void createPlotHiearchy(boolean bl) {
        Object object;
        if (sPlotPickerRoot != null) {
            return;
        }
        if (!Matlab.isMatlabAvailable()) {
            sPlotPickerRoot = ModelStateFactory.parseMATLAB();
            return;
        }
        Product[] productArray = ProductInfoUtils.getAllProductsInfo();
        if (productArray == null || productArray.length == 0) {
            if (sProductInfoListener == null) {
                sProductInfoListener = new ProductInfoListener(bl);
                ProductInfoUtils.registerInfoListener(sProductInfoListener);
            }
            return;
        }
        ArrayList<PlotPickerXMLParser.ProductParseResults> arrayList = new ArrayList<PlotPickerXMLParser.ProductParseResults>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PlotPickerXMLParser.ProductParseResults productParseResults = PlotPickerXMLParser.parseMATLAB();
        arrayList.add(productParseResults);
        List<String> list = productParseResults.getCategoryList();
        for (String string : list) {
            arrayList2.add(string);
        }
        Object object2 = productArray;
        int n = ((Product[])object2).length;
        for (int i = 0; i < n; ++i) {
            Object object3;
            Object object4;
            object = object2[i];
            String string = ((Product)object).getFilename();
            if (string == null) continue;
            String string2 = string.replaceAll("info.xml$", "") + "plotpickerlayout.xml";
            File file = new File(string2);
            boolean bl2 = FileUtils.fileExists((File)file);
            if (!bl2 && (object4 = file.getParent()) != null) {
                object3 = new File((String)object4).getParentFile();
                try {
                    if (object3 != null && ((File)object3).exists()) {
                        file = new File((File)object3, "plotpickerlayout.xml");
                        bl2 = FileUtils.fileExists((File)file);
                    }
                }
                catch (SecurityException securityException) {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            try {
                object4 = PlotPickerXMLParser.parse(new FileInputStream(file), ((Product)object).getName());
                if (object4 == null) continue;
                arrayList.add((PlotPickerXMLParser.ProductParseResults)object4);
                object3 = object4.getCategoryList();
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    arrayList2.add(string3);
                }
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.log((String)fileNotFoundException.toString());
            }
        }
        if (sPlotPickerRoot == null) {
            sPlotPickerRoot = new StateNode();
        }
        if (bl && (object2 = PlotPickerXMLParser.parseSavedLayout()) != null) {
            ModelStateFactory.addParsedProductContent(sPlotPickerRoot, (PlotPickerXMLParser.ProductParseResults)object2, arrayList);
            for (String string : object2.getCategoryList()) {
                arrayList2.remove(string);
            }
        }
        for (String string : arrayList2) {
            PlotPickerXMLParser.CategoryElement categoryElement = ModelStateFactory.getProductCategoryElement(string, arrayList);
            if (categoryElement == null) continue;
            object = ModelStateFactory.createStateNodeFromCategoryElement(string, categoryElement, arrayList);
            if (resources.getString("PlotPickerTableModel.Favs").equalsIgnoreCase(string)) {
                ModelStateFactory.addFavorites((StateNode)object, sPlotPickerRoot);
                continue;
            }
            sPlotPickerRoot.add((MutableTreeNode)object);
        }
        sMethodMap = new HashMap<String, List<PlotAction>>();
        ModelStateFactory.makeMethodHashMap(sMethodMap, sPlotPickerRoot);
    }

    private static StateNode parseMATLAB() {
        PlotPickerXMLParser.ProductParseResults productParseResults = PlotPickerXMLParser.parseMATLAB();
        StateNode stateNode = new StateNode();
        if (productParseResults != null) {
            HashMap<String, PlotAction> hashMap = productParseResults.getPlotActionHashMap();
            HashMap<String, PlotPickerXMLParser.CategoryElement> hashMap2 = productParseResults.getCategoryHashMap();
            for (String string : productParseResults.getCategoryList()) {
                Object object;
                PlotPickerXMLParser.CategoryElement categoryElement = hashMap2.get(string);
                if (!resources.getString("PlotPickerTableModel.Favs").equalsIgnoreCase(string)) {
                    StateNode stateNode2 = new StateNode(string, true);
                    stateNode2.setProductID(categoryElement.getProductID());
                    stateNode2.setProductVersion(Double.toString(categoryElement.getVersion()));
                    object = stateNode2;
                } else {
                    object = stateNode;
                }
                for (String string2 : categoryElement.getPlotActionIDs()) {
                    PlotAction plotAction = hashMap.get(string2);
                    if (plotAction != null) {
                        plotAction.setFavorite(resources.getString("PlotPickerTableModel.Favs").equalsIgnoreCase(string));
                        ((DefaultMutableTreeNode)object).add(new StateNode(plotAction, false));
                    }
                    if (object == stateNode) continue;
                    stateNode.add((MutableTreeNode)object);
                }
            }
        }
        return stateNode;
    }

    static void addParseCompletionListener(ParseCompleteListener parseCompleteListener) {
        assert (SwingUtilities.isEventDispatchThread());
        if (parseCompleteListener == null || sParseCompleteListeners.contains(parseCompleteListener)) {
            return;
        }
        sParseCompleteListeners.add(parseCompleteListener);
    }

    static void removeParseCompletionListener(ParseCompleteListener parseCompleteListener) {
        assert (SwingUtilities.isEventDispatchThread());
        sParseCompleteListeners.remove(parseCompleteListener);
    }

    static synchronized StateNode createNoSelectionModelState() {
        if (sPlotPickerRoot == null) {
            ModelStateFactory.createPlotHiearchy();
        }
        return sPlotPickerRoot.deepCopy();
    }

    static synchronized StateNode createModelState(String[] stringArray, InterruptibleMatlabWorker interruptibleMatlabWorker) {
        if (sPlotPickerRoot == null) {
            ModelStateFactory.createPlotHiearchy();
        }
        if (interruptibleMatlabWorker != null && interruptibleMatlabWorker.isInterrupted()) {
            return null;
        }
        return ModelStateFactory.getFilteredTreeNode(sPlotPickerRoot, stringArray, interruptibleMatlabWorker);
    }

    static StateNode createModelStateForSearch(StateNode stateNode, String string) {
        if (sPlotPickerRoot == null) {
            ModelStateFactory.createPlotHiearchy();
        }
        return ModelStateFactory.createSearchResultsTreeNode(stateNode, string);
    }

    static StateNode refreshModelStateNodes(Map<String, StateNode> map) {
        StateNode stateNode = sPlotPickerRoot.deepCopy();
        ModelStateFactory.updateEnabledState(map, stateNode);
        return stateNode;
    }

    static Map<String, StateNode> createStateNodeLookupMap(StateNode stateNode) {
        HashMap<String, StateNode> hashMap = new HashMap<String, StateNode>();
        ModelStateFactory.makeFlattenedHashMap(hashMap, stateNode);
        return hashMap;
    }

    private static void makeFlattenedHashMap(HashMap<String, StateNode> hashMap, StateNode stateNode) {
        if (stateNode.getAllowsChildren()) {
            for (int i = 0; i < stateNode.getChildCount(); ++i) {
                ModelStateFactory.makeFlattenedHashMap(hashMap, (StateNode)stateNode.getChildAt(i));
            }
        } else if (!hashMap.containsKey(((PlotAction)stateNode.getUserObject()).getID())) {
            hashMap.put(((PlotAction)stateNode.getUserObject()).getID(), stateNode);
        }
    }

    private static void makeMethodHashMap(Map<String, List<PlotAction>> map, StateNode stateNode) {
        if (stateNode.getAllowsChildren()) {
            for (int i = 0; i < stateNode.getChildCount(); ++i) {
                ModelStateFactory.makeMethodHashMap(map, (StateNode)stateNode.getChildAt(i));
            }
        } else {
            String[] stringArray;
            String string = ((PlotAction)stateNode.getUserObject()).getMethodOf();
            if (string == null || string.trim().length() == 0) {
                return;
            }
            for (String string2 : stringArray = string.split(",")) {
                List<Object> list;
                if (map.containsKey(string2)) {
                    list = map.get(string2);
                    list.add((PlotAction)stateNode.getUserObject());
                    continue;
                }
                list = new ArrayList();
                list.add((PlotAction)stateNode.getUserObject());
                map.put(string2, list);
            }
        }
    }

    private static void updateEnabledState(Map<String, StateNode> map, StateNode stateNode) {
        if (stateNode.getAllowsChildren()) {
            for (int i = 0; i < stateNode.getChildCount(); ++i) {
                ModelStateFactory.updateEnabledState(map, (StateNode)stateNode.getChildAt(i));
            }
        } else {
            StateNode stateNode2 = map.get(((PlotAction)stateNode.getUserObject()).getID());
            stateNode.setEnabledBySwappedVariables(stateNode2 != null && stateNode2.isEnabledBySwappedVariables());
            stateNode.setEnabledByUnswappedVariables(stateNode2 != null && stateNode2.isEnabledByUnswappedVariables());
        }
    }

    static int countEnabledChildren(StateNode stateNode) {
        int n = 0;
        int n2 = stateNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            StateNode stateNode2 = (StateNode)stateNode.getChildAt(i);
            if (stateNode2.getAllowsChildren()) {
                n += ModelStateFactory.countEnabledChildren(stateNode2);
                continue;
            }
            if (!stateNode2.isEnabled()) continue;
            ++n;
        }
        return n;
    }

    private static StateNode getFilteredTreeNode(StateNode stateNode, String[] stringArray, InterruptibleMatlabWorker interruptibleMatlabWorker) {
        assert (NativeMatlab.nativeIsMatlabThread());
        StateNode stateNode2 = new StateNode(stateNode.getUserObject(), stateNode.getAllowsChildren());
        int n = stateNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable;
            if (interruptibleMatlabWorker != null && interruptibleMatlabWorker.isInterrupted()) {
                return null;
            }
            StateNode stateNode3 = (StateNode)stateNode.getChildAt(i);
            Object object = stateNode3.getUserObject();
            if (object != null && object instanceof PlotAction) {
                cloneable = (PlotAction)object;
                StateNode stateNode4 = new StateNode(object, false);
                if (((PlotAction)cloneable).hasCustomLabelFunction()) {
                    stateNode4.setCustomLabelText(((PlotAction)cloneable).evalCustomLabelFunc(stringArray));
                    if (stringArray != null && stringArray.length == 2 && ((PlotAction)cloneable).allowSwap()) {
                        stateNode4.setSwappedCustomLabelText(((PlotAction)cloneable).evalCustomLabelFunc(new String[]{stringArray[1], stringArray[0]}));
                    } else {
                        stateNode4.setSwappedCustomLabelText(null);
                    }
                }
                if (interruptibleMatlabWorker != null && interruptibleMatlabWorker.isInterrupted()) {
                    return null;
                }
                boolean bl = ((PlotAction)cloneable).isEnabledBySelectedVars(stringArray);
                if (interruptibleMatlabWorker != null && interruptibleMatlabWorker.isInterrupted()) {
                    return null;
                }
                stateNode4.setEnabledByUnswappedVariables(bl);
                stateNode4.setEnabledBySwappedVariables(false);
                if (((PlotAction)cloneable).allowSwap() && stringArray != null && stringArray.length == 2 && (((PlotAction)cloneable).getShortDescription() == null || ((PlotAction)cloneable).getShortDescription().length() == 0)) {
                    stateNode4.setEnabledBySwappedVariables(((PlotAction)cloneable).isEnabledBySwappedVars(stringArray));
                }
                stateNode2.add(stateNode4);
                continue;
            }
            if (object == null || !(object instanceof String) || (cloneable = ModelStateFactory.getFilteredTreeNode(stateNode3, stringArray, interruptibleMatlabWorker)) == null) continue;
            stateNode2.add((MutableTreeNode)((Object)cloneable));
        }
        if (stateNode2.getChildCount() > 0) {
            return stateNode2;
        }
        return null;
    }

    private static List<StateNode> findPlotActionStateNodes(List<StateNode> list, StateNode stateNode, String string, boolean bl) {
        if (bl && !string.matches("\\b[a-zA-Z0-9 ]+\\b") && HelpUtils.isEnglish()) {
            return new ArrayList<StateNode>();
        }
        if (HelpUtils.isEnglish()) {
            string = string.replaceAll("[^a-zA-Z0-9\\s]", "");
        }
        int n = stateNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            StateNode stateNode2 = (StateNode)stateNode.getChildAt(i);
            Object object = stateNode2.getUserObject();
            if (object != null && object instanceof PlotAction) {
                PlotAction plotAction = (PlotAction)object;
                if (!plotAction.isSearchResult(string, bl) || !plotAction.isSearchResult(string, bl) || list.contains(stateNode)) continue;
                list.add(stateNode2);
                continue;
            }
            if (object == null || !(object instanceof String)) continue;
            list = ModelStateFactory.findPlotActionStateNodes(list, stateNode2, string, bl);
        }
        return list;
    }

    private static List<String> findPlotCategories(List<String> list, StateNode stateNode, String string, boolean bl) {
        if (bl && !string.matches("\\b[a-zA-Z0-9 ]+\\b") && HelpUtils.isEnglish()) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.matches(".*\\s.*")) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\s")) {
                string2 = string2.trim();
                if (HelpUtils.isEnglish()) {
                    string2 = string2.replaceAll("[^a-zA-Z0-9]", "");
                }
                if (string2.length() == 0) continue;
                arrayList.add(string2);
            }
        } else {
            arrayList.add(string);
        }
        int n = stateNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            StateNode stateNode2 = (StateNode)stateNode.getChildAt(i);
            Object object = stateNode2.getUserObject();
            if (object == null || !(object instanceof String)) continue;
            list = ModelStateFactory.findPlotCategories(list, stateNode2, string, bl);
            if (bl) {
                bl2 = false;
                for (String string2 : arrayList) {
                    if (!object.toString().toLowerCase().matches(".*" + string2.toLowerCase() + ".*")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                boolean bl3 = false;
                for (String string3 : arrayList) {
                    if (!object.toString().toLowerCase().matches(".*\\b" + string3.toLowerCase() + "\\b.*")) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                list.add(object.toString());
                continue;
            }
            bl2 = false;
            for (String string4 : arrayList) {
                if (!object.toString().toLowerCase().matches(".*\\b" + string4.toLowerCase() + "\\b.*")) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            list.add(object.toString());
        }
        return list;
    }

    private static StateNode createSearchResultsTreeNode(StateNode stateNode, String string) {
        List<StateNode> list = ModelStateFactory.findPlotActionStateNodes(new ArrayList<StateNode>(), stateNode, string, false);
        List<StateNode> list2 = ModelStateFactory.findPlotActionStateNodes(new ArrayList<StateNode>(), stateNode, string, true);
        List<String> list3 = ModelStateFactory.findPlotCategories(new ArrayList<String>(), stateNode, string, false);
        List<String> list4 = ModelStateFactory.findPlotCategories(new ArrayList<String>(), stateNode, string, true);
        ArrayList<StateNode> arrayList = new ArrayList<StateNode>();
        ArrayList<StateNode> arrayList2 = new ArrayList<StateNode>();
        ArrayList<PlotAction> arrayList3 = new ArrayList<PlotAction>();
        ArrayList<PlotAction> arrayList4 = new ArrayList<PlotAction>();
        for (StateNode object2 : list) {
            PlotAction plotAction = (PlotAction)object2.getUserObject();
            if (arrayList.contains(object2) || arrayList2.contains(object2) || arrayList3.contains(plotAction) || arrayList4.contains(plotAction)) continue;
            if (object2.isEnabled()) {
                arrayList.add(object2);
                arrayList3.add(plotAction);
                continue;
            }
            arrayList2.add(object2);
            arrayList4.add(plotAction);
        }
        for (StateNode stateNode2 : list2) {
            if (arrayList.contains(stateNode2) || arrayList2.contains(stateNode2)) continue;
            if (stateNode2.isEnabled()) {
                arrayList.add(stateNode2);
                continue;
            }
            arrayList2.add(stateNode2);
        }
        StateNode stateNode2 = new StateNode(null, true);
        for (StateNode stateNode3 : arrayList) {
            stateNode2.add((MutableTreeNode)stateNode3.clone());
        }
        for (StateNode stateNode4 : arrayList2) {
            stateNode2.add((MutableTreeNode)stateNode4.clone());
        }
        for (String string2 : list3) {
            StateNode stateNode5 = ModelStateFactory.findCategoryNode(stateNode, string2);
            if (stateNode5 == null) continue;
            stateNode2.add(stateNode5.deepCopy());
        }
        for (String string2 : list4) {
            StateNode stateNode6 = ModelStateFactory.findCategoryNode(stateNode, string2);
            if (stateNode6 == null) continue;
            stateNode2.add(stateNode6.deepCopy());
        }
        return stateNode2;
    }

    public static synchronized List<String[]> getGraphingPlotActions(String[] stringArray) {
        Object object2;
        if (stringArray == null || stringArray.length == 0) {
            return new ArrayList<String[]>();
        }
        if (sPlotPickerRoot == null) {
            ModelStateFactory.createPlotHiearchy();
        }
        assert (NativeMatlab.nativeIsMatlabThread());
        List<PlotAction> list = ModelStateFactory.getFavoriteActions(stringArray);
        String[] stringArray2 = null;
        if (stringArray[0] != null && !stringArray[0].startsWith("cell2mat")) {
            try {
                object2 = (boolean[])Matlab.mtEvalNoBreakpoints((String)("numel(" + stringArray[0] + ") ==1 && (ishandle(" + stringArray[0] + ") || isobject(" + stringArray[0] + "))"), (int)1);
                if (object2 != null && ((Object)object2).length == 1 && object2[0] != false) {
                    stringArray2 = (String[])Matlab.mtEvalNoBreakpoints((String)("plotpickerfunc('getclassnames',[],{}," + stringArray[0] + ")"), (int)1);
                }
            }
            catch (Exception exception) {
                stringArray2 = null;
            }
        }
        if (stringArray2 != null) {
            for (String string : stringArray2) {
                List<PlotAction> object3 = ModelStateFactory.getMethods(string);
                if (object3 == null) continue;
                for (PlotAction plotAction : object3) {
                    if (list.contains(plotAction)) continue;
                    list.add(plotAction);
                }
            }
        }
        if (list.isEmpty()) {
            return new ArrayList<String[]>();
        }
        object2 = new ArrayList();
        PlotActionEvaluator plotActionEvaluator = new PlotActionEvaluator();
        final ArrayList arrayList = new ArrayList();
        for (final PlotAction plotAction : list) {
            plotActionEvaluator.addEvalItem(new CompletionObserver(){

                public void completed(int n, Object object) {
                    if (n == 0 && ((Boolean)object).booleanValue()) {
                        arrayList.add(plotAction);
                    }
                }
            }, plotAction.getMatlabEvalFunction(stringArray));
        }
        plotActionEvaluator.eval();
        for (PlotAction plotAction : arrayList) {
            String string = plotAction.getShortDescription() != null && plotAction.getShortDescription().length() > 0 ? plotAction.getShortDescription() : (plotAction.hasCustomLabelFunction() ? plotAction.evalCustomLabelFunc(stringArray) : plotAction.getPlotLabel(stringArray));
            if (plotAction.hasCustomExecutionFunction()) {
                object2.add(new String[]{string, plotAction.evalCustomExecutionFunc(stringArray, false)});
                continue;
            }
            object2.add(new String[]{string, plotAction.getExecutionString(stringArray)});
        }
        return object2;
    }

    private static List<PlotAction> getMethods(String string) {
        if (sMethodMap == null) {
            return null;
        }
        return sMethodMap.get(string);
    }

    private static List<PlotAction> getFavoriteActions(String[] stringArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        final ArrayList<PlotAction> arrayList = new ArrayList<PlotAction>();
        PlotActionEvaluator plotActionEvaluator = new PlotActionEvaluator();
        for (int i = 0; i < sPlotPickerRoot.getChildCount() && !sPlotPickerRoot.getChildAt(i).getAllowsChildren(); ++i) {
            final PlotAction plotAction = (PlotAction)((DefaultMutableTreeNode)sPlotPickerRoot.getChildAt(i)).getUserObject();
            plotActionEvaluator.addEvalItem(new CompletionObserver(){

                public void completed(int n, Object object) {
                    if (n == 0 && ((Boolean)object).booleanValue()) {
                        arrayList.add(plotAction);
                    }
                }
            }, plotAction.getMatlabEvalFunction(stringArray));
        }
        plotActionEvaluator.eval();
        return arrayList;
    }

    static StateNode findReferenceCategoryNode(String string) {
        return ModelStateFactory.findCategoryNode(sPlotPickerRoot, string);
    }

    private static StateNode findCategoryNode(StateNode stateNode, String string) {
        if (!stateNode.getAllowsChildren()) {
            return null;
        }
        if (stateNode.getUserObject() != null && stateNode.getUserObject() instanceof String && string.equals(stateNode.getUserObject())) {
            return stateNode;
        }
        for (int i = 0; i < stateNode.getChildCount(); ++i) {
            StateNode stateNode2 = ModelStateFactory.findCategoryNode((StateNode)stateNode.getChildAt(i), string);
            if (stateNode2 == null) continue;
            return stateNode2;
        }
        return null;
    }

    private static StateNode findReferencePlotActionNode(StateNode stateNode, PlotAction plotAction) {
        for (int i = 0; i < stateNode.getChildCount(); ++i) {
            StateNode stateNode2 = (StateNode)stateNode.getChildAt(i);
            if (stateNode2.getAllowsChildren()) {
                StateNode stateNode3 = ModelStateFactory.findReferencePlotActionNode(stateNode2, plotAction);
                if (stateNode3 == null) continue;
                return stateNode3;
            }
            if (plotAction != stateNode2.getUserObject()) continue;
            return stateNode2;
        }
        return null;
    }

    private static StateNode findReferencePlotActionNode(PlotAction plotAction) {
        return ModelStateFactory.findReferencePlotActionNode(sPlotPickerRoot, plotAction);
    }

    private static StateNode findReferenceFavoritePlotActionNode(PlotAction plotAction) {
        for (int i = 0; i < sPlotPickerRoot.getChildCount(); ++i) {
            StateNode stateNode = (StateNode)sPlotPickerRoot.getChildAt(i);
            if (plotAction != stateNode.getUserObject()) continue;
            return stateNode;
        }
        return null;
    }

    private static StateNode findReferencePlotActionNode(String string, PlotAction plotAction) {
        if (string == null) {
            return null;
        }
        StateNode stateNode = ModelStateFactory.findReferenceCategoryNode(string);
        if (stateNode == null) {
            return null;
        }
        return ModelStateFactory.findReferencePlotActionNode(stateNode, plotAction);
    }

    static synchronized void removeFavoritePlotActionNode(PlotAction plotAction) {
        ModelStateFactory.removeFavoritePlotActionNode(plotAction, null);
    }

    static synchronized void removeFavoritePlotActionNode(PlotAction plotAction, Object object) {
        StateNode stateNode = ModelStateFactory.findReferenceFavoritePlotActionNode(plotAction);
        sPlotPickerRoot.remove(stateNode);
        ModelStateFactory.firePlotModelChangeListener(object);
    }

    static void moveReferenceCategoryNodeToTop(String string, Object object) {
        StateNode stateNode = ModelStateFactory.findReferenceCategoryNode(string);
        if (stateNode == null || stateNode.getParent() == null) {
            return;
        }
        ((MutableTreeNode)stateNode.getParent()).remove(stateNode);
        for (int i = 0; i < sPlotPickerRoot.getChildCount(); ++i) {
            if (!sPlotPickerRoot.getChildAt(i).getAllowsChildren()) continue;
            sPlotPickerRoot.insert(stateNode, i);
            break;
        }
        ModelStateFactory.firePlotModelChangeListener(object);
    }

    private static void firePlotModelChangeListener(final Object object) {
        if (object != null && object instanceof TestEventSource) {
            for (IPlotModelChangeListener iPlotModelChangeListener : sPlotModelChangeListeners) {
                iPlotModelChangeListener.modelChanged(object);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphingActionFactory.fireGraphingActionsChanged();
                    for (IPlotModelChangeListener iPlotModelChangeListener : sPlotModelChangeListeners) {
                        iPlotModelChangeListener.modelChanged(object);
                    }
                }
            });
        }
    }

    static void moveReferenceCategoryNodeToTop(String string) {
        ModelStateFactory.moveReferenceCategoryNodeToTop(string, null);
    }

    static void copyPlotActionToFavorites(PlotAction plotAction, PlotAction plotAction2, Object object) {
        StateNode stateNode = ModelStateFactory.findReferencePlotActionNode(plotAction);
        if (stateNode == null) {
            return;
        }
        stateNode = (StateNode)stateNode.clone();
        StateNode stateNode2 = sPlotPickerRoot;
        plotAction.setFavorite(true);
        if (plotAction2 != null) {
            StateNode stateNode3 = ModelStateFactory.findReferenceFavoritePlotActionNode(plotAction2);
            if (stateNode3 == null) {
                return;
            }
            stateNode2.insert(stateNode, stateNode2.getIndex(stateNode3) + 1);
        } else {
            stateNode2.insert(stateNode, 0);
        }
        ModelStateFactory.firePlotModelChangeListener(object);
    }

    static void copyPlotActionToFavorites(PlotAction plotAction, PlotAction plotAction2) {
        ModelStateFactory.copyPlotActionToFavorites(plotAction, plotAction2, null);
    }

    static synchronized void moveReferencePlotActionNode(PlotAction plotAction, String string, String string2, PlotAction plotAction2, Object object) {
        StateNode stateNode = string == null ? ModelStateFactory.findReferenceFavoritePlotActionNode(plotAction) : ModelStateFactory.findReferencePlotActionNode(string, plotAction);
        if (stateNode == null) {
            return;
        }
        StateNode stateNode2 = string2 == null ? sPlotPickerRoot : ModelStateFactory.findReferenceCategoryNode(string2);
        if (stateNode2 == null) {
            return;
        }
        if (plotAction2 != null) {
            StateNode stateNode3 = ModelStateFactory.findReferencePlotActionNode(string2, plotAction2);
            if (stateNode3 == null) {
                return;
            }
            if (stateNode.getParent() == stateNode2) {
                stateNode2.insert(stateNode, stateNode2.getIndex(stateNode3));
            } else {
                stateNode2.insert(stateNode, stateNode2.getIndex(stateNode3) + 1);
            }
        } else {
            stateNode2.insert(stateNode, 0);
        }
        ModelStateFactory.firePlotModelChangeListener(object);
    }

    static synchronized void moveReferencePlotActionNode(PlotAction plotAction, String string, String string2, PlotAction plotAction2) {
        ModelStateFactory.moveReferencePlotActionNode(plotAction, string, string2, plotAction2, null);
    }

    static PlotAction getDefaultPlotAction(StateNode stateNode) {
        Object object;
        if (stateNode == null) {
            return null;
        }
        if (stateNode.getAllowsChildren()) {
            for (int i = 0; i < stateNode.getChildCount(); ++i) {
                PlotAction plotAction = ModelStateFactory.getDefaultPlotAction((StateNode)stateNode.getChildAt(i));
                if (plotAction == null) continue;
                return plotAction;
            }
        } else if (stateNode.isEnabled() && (object = stateNode.getUserObject()) != null && object instanceof PlotAction) {
            return (PlotAction)object;
        }
        return null;
    }

    private static PlotPickerXMLParser.CategoryElement getProductCategoryElement(String string, List<PlotPickerXMLParser.ProductParseResults> list) {
        for (PlotPickerXMLParser.ProductParseResults productParseResults : list) {
            PlotPickerXMLParser.CategoryElement categoryElement = productParseResults.getCategoryHashMap().get(string);
            if (categoryElement == null) continue;
            return categoryElement;
        }
        return null;
    }

    private static PlotAction getPlotAction(String string, List<PlotPickerXMLParser.ProductParseResults> list) {
        for (PlotPickerXMLParser.ProductParseResults productParseResults : list) {
            PlotAction plotAction = productParseResults.getPlotActionHashMap().get(string);
            if (plotAction == null) continue;
            return plotAction;
        }
        return null;
    }

    private static StateNode createStateNodeFromCategoryElement(String string, PlotPickerXMLParser.CategoryElement categoryElement, List<PlotPickerXMLParser.ProductParseResults> list) {
        StateNode stateNode = new StateNode(string, true);
        stateNode.setProductID(categoryElement.getProductID());
        stateNode.setProductVersion(Double.toString(categoryElement.getVersion()));
        for (String string2 : categoryElement.getPlotActionIDs()) {
            PlotAction plotAction = ModelStateFactory.getPlotAction(string2, list);
            if (plotAction == null) continue;
            stateNode.add(new StateNode(plotAction, false));
        }
        if (stateNode.getChildCount() > 0) {
            return stateNode;
        }
        return null;
    }

    private static void addParsedProductContent(StateNode stateNode, PlotPickerXMLParser.ProductParseResults productParseResults, List<PlotPickerXMLParser.ProductParseResults> list) {
        HashMap<String, PlotPickerXMLParser.CategoryElement> hashMap = productParseResults.getCategoryHashMap();
        List<String> list2 = productParseResults.getCategoryList();
        for (String string : list2) {
            PlotPickerXMLParser.CategoryElement categoryElement = hashMap.get(string);
            PlotPickerXMLParser.CategoryElement categoryElement2 = ModelStateFactory.getProductCategoryElement(string, list);
            StateNode stateNode2 = null;
            if (categoryElement2 != null) {
                if (categoryElement.getVersion() >= categoryElement2.getVersion()) {
                    stateNode2 = ModelStateFactory.createStateNodeFromCategoryElement(string, categoryElement, list);
                } else if (categoryElement.getVersion() < categoryElement2.getVersion()) {
                    stateNode2 = ModelStateFactory.createStateNodeFromCategoryElement(string, categoryElement2, list);
                }
            }
            if (stateNode2 == null) continue;
            if (resources.getString("PlotPickerTableModel.Favs").equalsIgnoreCase(string)) {
                ModelStateFactory.addFavorites(stateNode2, stateNode);
                continue;
            }
            stateNode.add(stateNode2);
        }
    }

    private static void addFavorites(StateNode stateNode, StateNode stateNode2) {
        while (stateNode.getChildCount() > 0) {
            StateNode stateNode3 = (StateNode)stateNode.getChildAt(0);
            PlotAction plotAction = (PlotAction)stateNode3.getUserObject();
            plotAction.setFavorite(true);
            stateNode2.add(stateNode3);
        }
    }

    public static class TestEventSource {
    }

    static abstract class InterruptibleMatlabWorker
    extends MatlabWorker<Object> {
        private volatile boolean iInterruptSet = false;
        private volatile boolean iIsRunning = false;

        InterruptibleMatlabWorker() {
        }

        void interrupt() {
            this.iInterruptSet = true;
        }

        void reset() {
            this.iInterruptSet = false;
            this.iIsRunning = false;
        }

        boolean isInterrupted() {
            return this.iInterruptSet;
        }

        boolean isRunning() {
            return this.iIsRunning;
        }

        public void start() {
            this.iIsRunning = true;
            this.iInterruptSet = false;
            super.start();
        }
    }

    static interface ParseCompleteListener {
        public void parseComplete();
    }

    private static class ProductInfoListener
    implements InfoListener {
        private boolean fUseSavedLayout;

        ProductInfoListener(boolean bl) {
            this.fUseSavedLayout = bl;
        }

        @Override
        public void infoChanged(Product[] productArray) {
            if (sPlotPickerRoot == null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ModelStateFactory.createPlotHiearchy(ProductInfoListener.this.fUseSavedLayout);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (ParseCompleteListener parseCompleteListener : sParseCompleteListeners) {
                                    parseCompleteListener.parseComplete();
                                }
                                sParseCompleteListeners.clear();
                            }
                        });
                    }
                }, "ProductInfoListener");
                thread.start();
            }
            ProductInfoUtils.unregisterInfoListener(this);
        }
    }
}

