/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.overlayfs;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.overlayfs.OverlayFileSystem;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.AsyncReceiverUtils;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.io.IOException;

public class OverlayFileList
implements FileList {
    private final OverlayFileSystem fSystem;
    private final FileList fList;
    private final FileList fOverlayList;

    public OverlayFileList(OverlayFileSystem overlayFileSystem, FileList fileList, FileList fileList2) throws IOException {
        this.fSystem = overlayFileSystem;
        this.fList = fileList;
        this.fOverlayList = fileList2;
    }

    public FileSystemEntry getLocationEntry() {
        return this.fList.getLocationEntry();
    }

    public boolean exists(FileLocation fileLocation) {
        return this.fList.exists(fileLocation);
    }

    public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        this.fList.readFilesAndFolders(this.sendExternalEntries(asyncReceiver));
    }

    public void readFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        this.fList.readFolders(this.sendExternalEntries(asyncReceiver));
    }

    public boolean hasFolders() throws IOException {
        return this.fList.hasFolders();
    }

    public boolean isEmpty() throws IOException {
        return this.fList.isEmpty();
    }

    public void pause(ParameterRunnable<Runnable> parameterRunnable) {
        this.fList.pause(parameterRunnable);
    }

    public void close() {
        this.fList.close();
        this.fOverlayList.close();
    }

    private AsyncReceiver<FileSystemEntry> sendExternalEntries(AsyncReceiver<FileSystemEntry> asyncReceiver) {
        return AsyncReceiverUtils.convert(asyncReceiver, (Converter)new Converter<FileSystemEntry, FileSystemEntry>(){

            public FileSystemEntry convert(FileSystemEntry fileSystemEntry) {
                return OverlayFileList.this.fSystem.toExternalEntry(fileSystemEntry, true);
            }
        });
    }

    public String toString() {
        return "OverlayFileList [" + this.fList + "] [" + this.fOverlayList + "]";
    }
}

