/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreActionProvider;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class MacPackageInfoProvider
implements FileInfoProvider,
ActionProvider {
    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return PlatformInfo.isMacintosh() && fileSystemEntry.isFolder() && FileUtils.isANativeMacPackage((File)new File(fileSystemEntry.getLocation().toString()));
    }

    public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.getAction(CoreActionID.OPEN).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                ArrayList arrayList = new ArrayList();
                String string = CoreActionProvider.formatLabel("progress.open", "progress.open.multiple", actionInput.getSelection());
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    final Status status = new Status(string, true);
                    try {
                        fileSystemEntry = fileSystemEntry.getSystem().followShortcutOrLink(fileSystemEntry);
                        fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                        String string2 = "unix('open " + fileSystemEntry.toString() + "')";
                        new Matlab().eval(string2, new CompletionObserver(){

                            public void completed(int n, Object object) {
                                status.markCompleted();
                                Object[] objectArray = (Object[])object;
                                double[] dArray = (double[])objectArray[0];
                                if (dArray[0] != 0.0) {
                                    MJOptionPane.showMessageDialog(null, (Object)ExplorerResources.getString("open.outside.error"), (String)ExplorerResources.getString("open.outside.error.title"), (int)0);
                                }
                            }
                        });
                    }
                    catch (IOException iOException) {
                        status.markCompleted();
                    }
                }
                return new Status(arrayList);
            }
        });
    }
}

