/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.matlab.api.explorer.ActionComponentProvider;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.model.actions.StatusReceiver;
import com.mathworks.mlwidgets.explorer.model.actions.TableActionInput;
import com.mathworks.mlwidgets.explorer.util.MenuUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileTransfer;
import com.mathworks.mlwidgets.explorer.util.UiFileTransferType;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.util.Predicate;
import javax.swing.Action;
import javax.swing.JComponent;

public class CoreWriteActionProvider
implements ActionProvider {
    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        ActionConfiguration actionConfiguration = actionRegistry.getAction(CoreActionID.NEW_FOLDER);
        actionConfiguration.setVisibleOnContextMenu(ActionPredicates.either(ActionPredicates.EMPTY_SELECTION, ActionPredicates.and(ActionPredicates.NOT_SEARCH_MODE, ActionPredicates.ANY_DIRECTORIES_SELECTED, ActionPredicates.SINGLE_SELECTION)));
        actionConfiguration.setCode(SelectionMode.MULTIPLE_SELECTION_OR_CURRENT_LOCATION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                fileTable.createNewFolder();
                return Status.COMPLETED;
            }
        });
        final ActionConfiguration actionConfiguration2 = actionRegistry.getAction(CoreActionID.NEW_FILE_MENU);
        actionConfiguration2.setMenuComponentProvider(SelectionMode.SINGLE_FOLDER_SELECTION_OR_CURRENT_LOCATION, new ActionComponentProvider(){

            public JComponent getComponent(ActionInput actionInput) {
                MJMenu mJMenu = new MJMenu(actionConfiguration2.getDefinition().getLabel());
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                for (MJAbstractAction mJAbstractAction : MenuUtils.getNewFileOptions(fileTable)) {
                    mJMenu.add((Action)mJAbstractAction);
                }
                return mJMenu;
            }
        });
        ActionConfiguration actionConfiguration3 = actionRegistry.getAction(CoreActionID.RENAME);
        actionConfiguration3.setCode(SelectionMode.EXPLICIT_SINGLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                fileTable.rename(fileTable.getSelectedRows()[0]);
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration4 = actionRegistry.getAction(CoreActionID.DELETE);
        actionConfiguration4.setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                Status status = new Status();
                UiFileTransfer uiFileTransfer = new UiFileTransfer(actionInput.getComponent(), UiFileTransferType.RECYCLE_OR_TRASH, actionInput.getSelection(), new StatusReceiver<FileLocation>(status));
                new Thread(uiFileTransfer).start();
                return status;
            }
        });
        ActionConfiguration actionConfiguration5 = actionRegistry.getAction(CoreActionID.PERMANENT_DELETE);
        actionConfiguration5.setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionConfiguration5.setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                Status status = new Status();
                UiFileTransfer uiFileTransfer = new UiFileTransfer(actionInput.getComponent(), UiFileTransferType.DELETE, actionInput.getSelection(), new StatusReceiver<FileLocation>(status));
                new Thread(uiFileTransfer).start();
                return status;
            }
        });
        ActionConfiguration actionConfiguration6 = actionRegistry.getAction(CoreActionID.CUT);
        actionConfiguration6.setEnabled((Predicate)ActionPredicates.CAN_CUT);
        actionConfiguration6.setVisibleOnContextMenu(ActionConfiguration.ALWAYS);
        actionConfiguration6.setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                fileTable.cut();
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration7 = actionRegistry.getAction(CoreActionID.PASTE);
        actionConfiguration7.setEnabled(ActionPredicates.and(ActionPredicates.CAN_PASTE, ActionPredicates.either(ActionPredicates.and(ActionPredicates.IN_SEARCH_MODE, ActionPredicates.NONEMPTY_SELECTION), ActionPredicates.NOT_SEARCH_MODE)));
        actionConfiguration7.setVisibleOnContextMenu(ActionConfiguration.ALWAYS);
        actionConfiguration7.setCode(SelectionMode.SINGLE_SELECTION_OR_CURRENT_LOCATION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                fileTable.paste();
                return Status.COMPLETED;
            }
        });
    }
}

