/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileSystem;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipInput;
import com.mathworks.util.Predicate;
import com.mathworks.util.ThrowableClosure;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class StreamingZipInput
implements ZipInput {
    private final FileSystemEntry fZipFile;

    public StreamingZipInput(FileSystemEntry fileSystemEntry) {
        this.fZipFile = fileSystemEntry;
    }

    @Override
    public void getEntries(final ZipFileSystem zipFileSystem, final Predicate<FileSystemEntry> predicate) throws IOException {
        this.withZipFile(new ThrowableClosure<Void, ZipInputStream, IOException>(){

            public Void run(ZipInputStream zipInputStream) throws IOException {
                try {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (zipEntry != null) {
                        if (!predicate.accept((Object)StreamingZipInput.wrapEntry(zipFileSystem, zipEntry))) {
                            return null;
                        }
                        zipEntry = zipInputStream.getNextEntry();
                    }
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IOException(illegalArgumentException);
                }
            }
        });
    }

    @Override
    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        try {
            InputStream inputStream = this.fZipFile.getSystem().getInputStream(this.fZipFile.getLocation());
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            StreamingZipInput.find(zipInputStream, fileLocation);
            return zipInputStream;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException);
        }
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    private <T> T withZipFile(ThrowableClosure<T, ZipInputStream, IOException> throwableClosure) throws IOException {
        return this.withZipFile(throwableClosure, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withZipFile(ThrowableClosure<T, ZipInputStream, IOException> throwableClosure, boolean bl) throws IOException {
        InputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            inputStream = this.fZipFile.getSystem().getInputStream(this.fZipFile.getLocation());
            zipInputStream = new ZipInputStream(inputStream);
            Object object = throwableClosure.run((Object)zipInputStream);
            return (T)object;
        }
        finally {
            if (!bl) {
                if (zipInputStream != null) {
                    zipInputStream.close();
                } else if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private static ZipEntry find(ZipInputStream zipInputStream, FileLocation fileLocation) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (new FileLocation(zipEntry.getName()).equals((Object)fileLocation)) {
                return zipEntry;
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        throw new IOException("File does not exist: " + fileLocation);
    }

    private static FileSystemEntry wrapEntry(ZipFileSystem zipFileSystem, ZipEntry zipEntry) {
        return new FileSystemEntry((FileSystem)zipFileSystem, new FileLocation(zipEntry.getName()), false, zipEntry.isDirectory(), zipEntry.getSize(), zipEntry.getTime(), 0L);
    }

    @Override
    public void close() {
    }
}

