/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.brushing;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import com.mathworks.widgets.spreadsheet.color.ColorTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class SpreadsheetTableBrushManager {
    private BrushTableMouseListener fBrushMouseListener = null;
    private ReadOnlySelectionModel fReadOnlyRowSelectionColumnModel = null;
    private ReadOnlySelectionModel fReadOnlyColumnSelectionColumnModel = null;
    private KeySelectionState fKeySelectionState;
    private SpreadsheetTable fTable;
    private Color fColor = DEFAULT_COLOR;
    private String fVarName;
    private Cursor fTableCursorCache = new Cursor(1);
    private boolean fIsSingleRow = false;
    private int fMaxRowCount = 0;
    private BrushAction fBrushAction = null;
    private MatlabSelectionUpdater fMatlabSelectionUpdater = new MatlabSelectionUpdater();
    private static final String BRUSH_SHIFT_DOWN = "brushDownShiftArrow";
    private static final String BRUSH_SHIFT_UP = "brushUpShiftArrow";
    private static final String BRUSH_DOWN = "brushDownArrow";
    private static final String BRUSH_UP = "brushUpArrow";
    private static final String BRUSH_SHIFT_LEFT = "brushLeftShiftArrow";
    private static final String BRUSH_SHIFT_RIGHT = "brushRightShiftArrow";
    private static final String BRUSH_LEFT = "brushLeftArrow";
    private static final String BRUSH_RIGHT = "brushRightArrow";
    private static final String SHIFT_PAGEDWN = "shiftPageDown";
    private static final String SHIFT_PAGEUP = "shiftPageUp";
    public static final Color DEFAULT_COLOR = Color.red;
    private static final String[] BRUSH_INPUT_KEYS = new String[]{"brushDownShiftArrow", "brushUpShiftArrow", "brushDownArrow", "brushUpArrow", "brushLeftShiftArrow", "brushRightShiftArrow", "brushLeftArrow", "brushRightArrow", "shiftPageDown", "shiftPageUp"};
    private static final KeyStroke[] BRUSH_INPUT_KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(40, 1), KeyStroke.getKeyStroke(38, 1), KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(37, 1), KeyStroke.getKeyStroke(39, 1), KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(34, 1), KeyStroke.getKeyStroke(33, 1)};
    private static boolean sTrackBrushingState = false;

    public SpreadsheetTableBrushManager(String string, SpreadsheetTable spreadsheetTable) {
        this.fTable = spreadsheetTable;
        this.fVarName = string;
    }

    public Color getBrushingColor() {
        return this.fColor;
    }

    public Action getBrushModeAction() {
        if (this.fBrushAction == null) {
            this.fBrushAction = new BrushAction();
        }
        return this.fBrushAction;
    }

    public void setBrushMode(Color color) {
        Object object;
        TableColumnModel tableColumnModel;
        this.fBrushAction.setMode(true);
        this.resetInternalSelectionState();
        this.fColor = color;
        if (this.fTable.getSelectionModel() != this.fReadOnlyRowSelectionColumnModel) {
            if (this.fReadOnlyRowSelectionColumnModel == null) {
                this.fReadOnlyRowSelectionColumnModel = new ReadOnlySelectionModel((DefaultListSelectionModel)this.fTable.getSelectionModel());
            }
            this.fTable.setSelectionModel((ListSelectionModel)this.fReadOnlyRowSelectionColumnModel);
        }
        if ((tableColumnModel = this.fTable.getColumnModel()).getSelectionModel() != this.fReadOnlyColumnSelectionColumnModel) {
            this.fReadOnlyColumnSelectionColumnModel = new ReadOnlySelectionModel((DefaultListSelectionModel)tableColumnModel.getSelectionModel());
            tableColumnModel.setSelectionModel(this.fReadOnlyColumnSelectionColumnModel);
        }
        if (this.fBrushMouseListener == null) {
            this.fBrushMouseListener = new BrushTableMouseListener();
            this.fTable.addMouseMotionListener((MouseMotionListener)this.fBrushMouseListener);
            this.fTable.addMouseListener((MouseListener)this.fBrushMouseListener);
        }
        for (int i = 0; i < BRUSH_INPUT_KEYSTROKES.length; ++i) {
            Action action;
            object = this.fTable.getInputMap().get(BRUSH_INPUT_KEYSTROKES[i]);
            if (object == null) {
                this.fTable.getInputMap().put(BRUSH_INPUT_KEYSTROKES[i], BRUSH_INPUT_KEYS[i]);
                action = new BrushKeyListener(BRUSH_INPUT_KEYS[i]);
                this.fTable.getActionMap().put(BRUSH_INPUT_KEYS[i], action);
            } else {
                action = this.fTable.getActionMap().get(BRUSH_INPUT_KEYS[i]);
            }
            action.setEnabled(true);
        }
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() {
                try {
                    SpreadsheetTableBrushManager.this.updateArraySize();
                    MatlabMCR.mtFevalConsoleOutput((String)"datamanager.setBrushingInterval", (Object[])new Object[]{SpreadsheetTableBrushManager.this.fVarName, null, null, null, null, "refresh"}, (int)0);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (((Boolean)object).booleanValue()) {
                    SpreadsheetTableBrushManager.this.fTable.setCursor(SpreadsheetTableBrushManager.this.fTableCursorCache);
                    JRootPane jRootPane = SpreadsheetTableBrushManager.this.fTable.getRootPane();
                    if (jRootPane != null) {
                        jRootPane.setCursor(new Cursor(0));
                    }
                }
            }
        };
        this.fTable.setCursor(new Cursor(3));
        object = this.fTable.getRootPane();
        if (object != null) {
            ((Component)object).setCursor(new Cursor(3));
        }
        matlabWorker.start();
    }

    public static void setTrackBrushingState(boolean bl) {
        sTrackBrushingState = bl;
    }

    protected void renameVariableInMatlabBrushingManager(final String string) {
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Matlab.mtFeval((String)"datamanager.rmArrayEditorVariable", (Object[])new Object[]{SpreadsheetTableBrushManager.this.fVarName}, (int)0);
                    Matlab.mtFeval((String)"datamanager.addArrayEditorVariable", (Object[])new Object[]{string}, (int)0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void rename(String string) {
        if (sTrackBrushingState) {
            this.renameVariableInMatlabBrushingManager(string);
        }
        this.fVarName = string;
        ColorTableModel colorTableModel = (ColorTableModel)this.fTable.getClientProperty((Object)"colormodel");
        if (colorTableModel != null) {
            this.fTable.getBorderColorArrayTableModel().removeColorTableModel(colorTableModel);
            this.fTable.getCellColorArrayTableModel().clearModels();
            this.fTable.putClientProperty((Object)"colormodel", null);
        }
    }

    private void updateArraySize() throws Exception {
        double[] dArray = (double[])MatlabMCR.mtEval((String)("size(" + this.fVarName + ",1);"), (int)1);
        int n = new Double(dArray[0]).intValue();
        boolean bl = this.fIsSingleRow = n == 1;
        if (this.fIsSingleRow) {
            double[] dArray2 = (double[])MatlabMCR.mtEval((String)("length(" + this.fVarName + ");"), (int)1);
            this.fMaxRowCount = new Double(dArray2[0]).intValue();
        } else {
            this.fMaxRowCount = n;
        }
    }

    private void setBrushingIntervalInMatlab(int n, int n2, int n3, int n4, String string, float[] fArray) {
        Object[] objectArray = new Object[]{this.fVarName, n + 1, n2 + 1, n3 + 1, n4 + 1, string, fArray};
        if (!this.fMatlabSelectionUpdater.isRunning()) {
            this.fMatlabSelectionUpdater.start(objectArray);
        }
    }

    public synchronized void clearBrushMode() {
        Object object;
        if (this.fTable == null) {
            return;
        }
        this.fBrushAction.setMode(false);
        if (this.fReadOnlyRowSelectionColumnModel != null) {
            this.fTable.setSelectionModel((ListSelectionModel)this.fReadOnlyRowSelectionColumnModel.fDefaultListSelectionModel);
            this.fReadOnlyRowSelectionColumnModel = null;
        }
        if (this.fReadOnlyColumnSelectionColumnModel != null) {
            object = this.fTable.getColumnModel();
            object.setSelectionModel(this.fReadOnlyColumnSelectionColumnModel.fDefaultListSelectionModel);
            this.fReadOnlyColumnSelectionColumnModel = null;
        }
        if (this.fBrushMouseListener != null) {
            this.fTable.removeMouseMotionListener((MouseMotionListener)this.fBrushMouseListener);
            this.fTable.removeMouseListener((MouseListener)this.fBrushMouseListener);
            this.fBrushMouseListener = null;
        }
        for (String string : BRUSH_INPUT_KEYS) {
            Action action = this.fTable.getActionMap().get(string);
            if (action == null) continue;
            action.setEnabled(false);
        }
        this.fTable.setCursor(new Cursor(0));
        object = this.fTable.getRootPane();
        if (object != null) {
            ((Component)object).setCursor(new Cursor(0));
        }
    }

    public boolean isInBrushMode() {
        return this.fBrushAction.getMode();
    }

    public void cleanup() {
        this.clearBrushMode();
        this.fTable.removeMouseMotionListener((MouseMotionListener)this.fBrushMouseListener);
        this.fTable.removeMouseListener((MouseListener)this.fBrushMouseListener);
    }

    public void resetInternalSelectionState() {
        this.fKeySelectionState = new KeySelectionState();
        this.fMaxRowCount = 0;
    }

    private void brushData(int n, int n2, String string) {
        this.brushData(new KeySelectionState(n, n2, -1, -1), string);
    }

    private void brushData(KeySelectionState keySelectionState, String string) {
        int n = keySelectionState.fAnchorRow;
        int n2 = keySelectionState.fLeadingRow;
        int n3 = keySelectionState.fMinSelectionRow;
        int n4 = keySelectionState.fMaxSelectionRow;
        if (n > n2) {
            int n5 = n;
            n = n2;
            n2 = n5;
        }
        float[] fArray = new float[]{(float)this.fColor.getRed() / 255.0f, (float)this.fColor.getGreen() / 255.0f, (float)this.fColor.getBlue() / 255.0f};
        this.setBrushingIntervalInMatlab(n, n2, n3, n4, string, fArray);
    }

    private class BrushAction
    extends MJAbstractAction {
        private boolean iMode = false;

        BrushAction() {
            this.setName(ArrayUtils.getResource("brushaction.brushon"));
            this.setComponentName(ArrayUtils.getResource("brushaction.brushon"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SpreadsheetTableBrushManager.this.isInBrushMode()) {
                SpreadsheetTableBrushManager.this.setBrushMode(SpreadsheetTableBrushManager.this.getBrushingColor());
            } else {
                SpreadsheetTableBrushManager.this.clearBrushMode();
            }
        }

        public void setMode(boolean bl) {
            boolean bl2 = this.iMode;
            this.iMode = bl;
            if (this.iMode) {
                this.setName(ArrayUtils.getResource("brushaction.brushoff"));
                this.setComponentName(ArrayUtils.getResource("brushaction.brushoff"));
            } else {
                this.setName(ArrayUtils.getResource("brushaction.brushon"));
                this.setComponentName(ArrayUtils.getResource("brushaction.brushon"));
            }
            this.firePropertyChange("mode", bl2, bl);
        }

        public boolean getMode() {
            return this.iMode;
        }
    }

    private class KeySelectionState {
        private int fAnchorRow = -1;
        private int fLeadingRow = -1;
        private int fMaxSelectionRow = -1;
        private int fMinSelectionRow = -1;

        KeySelectionState() {
        }

        KeySelectionState(int n, int n2, int n3, int n4) {
            this.fAnchorRow = n;
            this.fLeadingRow = n2;
            this.fMaxSelectionRow = n3;
            this.fMinSelectionRow = n4;
        }

        public KeySelectionState copy() {
            return new KeySelectionState(this.fAnchorRow, this.fLeadingRow, this.fMaxSelectionRow, this.fMinSelectionRow);
        }

        public void resetMinMaxRows() {
            this.fMinSelectionRow = this.fMinSelectionRow > this.fLeadingRow ? this.fLeadingRow : this.fMinSelectionRow;
            this.fMaxSelectionRow = this.fMaxSelectionRow > this.fLeadingRow ? this.fMaxSelectionRow : this.fLeadingRow;
            this.fMinSelectionRow = this.fMinSelectionRow > this.fAnchorRow ? this.fAnchorRow : this.fMinSelectionRow;
            this.fMaxSelectionRow = this.fMaxSelectionRow > this.fAnchorRow ? this.fMaxSelectionRow : this.fAnchorRow;
        }
    }

    private class MatlabSelectionUpdater
    extends MatlabWorker {
        private boolean fIsRunning = false;
        private KeySelectionState fLocalSelectionState;
        private Object[] fArgs;

        private MatlabSelectionUpdater() {
        }

        public Object runOnMatlabThread() {
            try {
                MatlabMCR.mtFeval((String)"datamanager.setBrushingInterval", (Object[])this.fArgs, (int)0);
                SpreadsheetTableBrushManager.this.updateArraySize();
            }
            catch (Exception exception) {
                SpreadsheetTableBrushManager.this.resetInternalSelectionState();
            }
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            SpreadsheetTableBrushManager.this.fKeySelectionState = this.fLocalSelectionState.copy();
            this.fIsRunning = false;
        }

        public void start(Object[] objectArray) {
            this.fIsRunning = true;
            this.fArgs = objectArray != null ? (Object[])objectArray.clone() : null;
            this.fLocalSelectionState = SpreadsheetTableBrushManager.this.fKeySelectionState.copy();
            super.start();
        }

        public boolean isRunning() {
            return this.fIsRunning;
        }
    }

    private static class ReadOnlySelectionModel
    extends DefaultListSelectionModel {
        private DefaultListSelectionModel fDefaultListSelectionModel;

        ReadOnlySelectionModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.fDefaultListSelectionModel = defaultListSelectionModel;
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
        }

        @Override
        public void setLeadSelectionIndex(int n) {
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
        }

        @Override
        public void clearSelection() {
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.fDefaultListSelectionModel.getAnchorSelectionIndex();
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.fDefaultListSelectionModel.getLeadSelectionIndex();
        }

        @Override
        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.fDefaultListSelectionModel.addListSelectionListener(listSelectionListener);
        }

        @Override
        public int getMaxSelectionIndex() {
            return this.fDefaultListSelectionModel.getMaxSelectionIndex();
        }

        @Override
        public int getMinSelectionIndex() {
            return this.fDefaultListSelectionModel.getMinSelectionIndex();
        }

        @Override
        public int getSelectionMode() {
            return this.fDefaultListSelectionModel.getSelectionMode();
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.fDefaultListSelectionModel.getValueIsAdjusting();
        }

        @Override
        public boolean isSelectedIndex(int n) {
            return this.fDefaultListSelectionModel.isSelectedIndex(n);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.fDefaultListSelectionModel.isSelectionEmpty();
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            this.fDefaultListSelectionModel.removeListSelectionListener(listSelectionListener);
        }

        @Override
        public void setSelectionMode(int n) {
            this.fDefaultListSelectionModel.setSelectionMode(n);
        }

        @Override
        public void setValueIsAdjusting(boolean bl) {
        }
    }

    private class BrushTableMouseListener
    extends MouseAdapter {
        private boolean iBlockDrag = false;

        private BrushTableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                this.iBlockDrag = true;
                if (mouseEvent.isPopupTrigger()) {
                    float[] fArray = new float[]{(float)SpreadsheetTableBrushManager.this.fColor.getRed() / 255.0f, (float)SpreadsheetTableBrushManager.this.fColor.getGreen() / 255.0f, (float)SpreadsheetTableBrushManager.this.fColor.getBlue() / 255.0f};
                    int n = !SpreadsheetTableBrushManager.this.fIsSingleRow ? SpreadsheetTableBrushManager.this.fTable.rowAtPoint(mouseEvent.getPoint()) : SpreadsheetTableBrushManager.this.fTable.columnAtPoint(mouseEvent.getPoint());
                    Color[] colorArray = SpreadsheetTableBrushManager.this.fTable.getCellColorArrayTableModel().getColorsAt(n, 0);
                    if (colorArray == null || colorArray.length <= 0 || colorArray[0] == null) {
                        SpreadsheetTableBrushManager.this.setBrushingIntervalInMatlab(n, n, n, n, "popup", fArray);
                    }
                }
                return;
            }
            if (!mouseEvent.isShiftDown()) {
                if (SpreadsheetTableBrushManager.this.fIsSingleRow) {
                    SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow = SpreadsheetTableBrushManager.this.fTable.columnAtPoint(mouseEvent.getPoint());
                } else {
                    SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow = SpreadsheetTableBrushManager.this.fTable.rowAtPoint(mouseEvent.getPoint());
                }
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                WorkspaceMCRProvider.getMCRForUserActions().fevalConsoleOutput("datamanager.setBrushingInterval", new Object[]{SpreadsheetTableBrushManager.this.fVarName, null, null, null, null, "cache"}, 0, (MatlabListener)null);
            } else {
                WorkspaceMCRProvider.getMCRForUserActions().fevalConsoleOutput("datamanager.setBrushingInterval", new Object[]{SpreadsheetTableBrushManager.this.fVarName, null, null, null, null, "clearcache"}, 0, (MatlabListener)null);
            }
            SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow;
            SpreadsheetTableBrushManager.this.fKeySelectionState.fMinSelectionRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow;
            SpreadsheetTableBrushManager.this.fKeySelectionState.fMaxSelectionRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.iBlockDrag = false;
            if (mouseEvent.getButton() != 1) {
                if (mouseEvent.isPopupTrigger()) {
                    float[] fArray = new float[]{(float)SpreadsheetTableBrushManager.this.fColor.getRed() / 255.0f, (float)SpreadsheetTableBrushManager.this.fColor.getGreen() / 255.0f, (float)SpreadsheetTableBrushManager.this.fColor.getBlue() / 255.0f};
                    int n = !SpreadsheetTableBrushManager.this.fIsSingleRow ? SpreadsheetTableBrushManager.this.fTable.rowAtPoint(mouseEvent.getPoint()) : SpreadsheetTableBrushManager.this.fTable.columnAtPoint(mouseEvent.getPoint());
                    if (n < 0) {
                        return;
                    }
                    Color[] colorArray = SpreadsheetTableBrushManager.this.fTable.getCellColorArrayTableModel().getColorsAt(n, 0);
                    if (colorArray == null || colorArray.length <= 0 || colorArray[0] == null) {
                        SpreadsheetTableBrushManager.this.setBrushingIntervalInMatlab(n, n, n, n, "popup", fArray);
                    }
                }
                return;
            }
            this.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iBlockDrag || SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow < 0) {
                return;
            }
            if (SpreadsheetTableBrushManager.this.fIsSingleRow) {
                SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fTable.columnAtPoint(mouseEvent.getPoint());
            } else {
                SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fTable.rowAtPoint(mouseEvent.getPoint());
            }
            if (mouseEvent.isControlDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown() && PlatformInfo.isMacintosh()) {
                SpreadsheetTableBrushManager.this.fKeySelectionState.resetMinMaxRows();
                SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState, "add");
            } else {
                SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow, SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow, "set");
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class BrushKeyListener
    extends AbstractAction {
        private String fKey;

        BrushKeyListener(String string) {
            this.fKey = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            Rectangle rectangle;
            boolean bl = SpreadsheetTableBrushManager.this.fIsSingleRow;
            if (this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_SHIFT_DOWN) || bl && this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_SHIFT_RIGHT)) {
                if (SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow < SpreadsheetTableBrushManager.this.fMaxRowCount - 1) {
                    SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow++;
                    SpreadsheetTableBrushManager.this.fKeySelectionState.resetMinMaxRows();
                    SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState, "add");
                }
            } else if (this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_SHIFT_UP) || bl && this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_SHIFT_LEFT)) {
                if (SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow > 0) {
                    SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow--;
                    SpreadsheetTableBrushManager.this.fKeySelectionState.resetMinMaxRows();
                    SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState, "add");
                }
            } else if (this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_DOWN) || bl && this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_RIGHT)) {
                SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow < SpreadsheetTableBrushManager.this.fMaxRowCount - 1 ? SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow + 1 : SpreadsheetTableBrushManager.this.fMaxRowCount - 1;
                SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow;
                SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow, SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow, "set");
            } else if (this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_UP) || bl && this.fKey.equals(SpreadsheetTableBrushManager.BRUSH_LEFT)) {
                SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow > 0 ? SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow - 1 : 0;
                SpreadsheetTableBrushManager.this.fKeySelectionState.fAnchorRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow;
                SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow, SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow, "set");
            } else if (this.fKey.equals(SpreadsheetTableBrushManager.SHIFT_PAGEDWN)) {
                rectangle = SpreadsheetTableBrushManager.this.fTable.getVisibleRect();
                n2 = SpreadsheetTableBrushManager.this.fTable.rowAtPoint(new Point(rectangle.x, rectangle.y)) + 1;
                n = SpreadsheetTableBrushManager.this.fTable.rowAtPoint(new Point(rectangle.x, rectangle.y + rectangle.height)) + 1;
                SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow + n - n2 > 0 ? SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow + n - n2 : 0;
                SpreadsheetTableBrushManager.this.fKeySelectionState.resetMinMaxRows();
                SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState, "add");
            } else if (this.fKey.equals(SpreadsheetTableBrushManager.SHIFT_PAGEUP)) {
                rectangle = SpreadsheetTableBrushManager.this.fTable.getVisibleRect();
                n2 = SpreadsheetTableBrushManager.this.fTable.rowAtPoint(new Point(rectangle.x, rectangle.y)) + 1;
                n = SpreadsheetTableBrushManager.this.fTable.rowAtPoint(new Point(rectangle.x, rectangle.y + rectangle.height)) + 1;
                SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow - n + n2 > 0 ? SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow - n + n2 : 0;
                SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow = SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow < SpreadsheetTableBrushManager.this.fMaxRowCount ? SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow : SpreadsheetTableBrushManager.this.fMaxRowCount;
                SpreadsheetTableBrushManager.this.fKeySelectionState.resetMinMaxRows();
                SpreadsheetTableBrushManager.this.brushData(SpreadsheetTableBrushManager.this.fKeySelectionState, "add");
            } else {
                return;
            }
            if (bl) {
                return;
            }
            rectangle = SpreadsheetTableBrushManager.this.fTable.getVisibleRect();
            n2 = SpreadsheetTableBrushManager.this.fTable.columnAtPoint(new Point(rectangle.x, rectangle.y)) + 1;
            Rectangle rectangle2 = SpreadsheetTableBrushManager.this.fTable.getCellRect(SpreadsheetTableBrushManager.this.fKeySelectionState.fLeadingRow, n2, false);
            if (rectangle2 != null) {
                SpreadsheetTableBrushManager.this.fTable.scrollRectToVisible(rectangle2);
            }
        }
    }
}

