/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.ValueUpdateRegistry;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class ValueMetaInfoRequester {
    private WorkspaceVariable fWorkspaceVariable;
    private ActionListener fInterestListener;
    private ActionListener fActionListeners = null;

    ValueMetaInfoRequester(WorkspaceVariable workspaceVariable, ActionListener actionListener) {
        this.fWorkspaceVariable = workspaceVariable;
        this.fActionListeners = AWTEventMulticaster.add(this.fActionListeners, actionListener);
        this.registerInterests();
        this.updateValueInformation();
    }

    void cleanup() {
        this.fActionListeners = null;
        this.unregisterInterests();
    }

    private void registerInterests() {
        this.fInterestListener = new InterestListener();
        if (Matlab.isMatlabAvailable()) {
            ValueUpdateRegistry.register(this.fInterestListener);
        }
    }

    private void unregisterInterests() {
        if (Matlab.isMatlabAvailable()) {
            ValueUpdateRegistry.unregister(this.fInterestListener);
        }
        this.fInterestListener = null;
    }

    public void updateValueInformation() {
        if (Matlab.isMatlabAvailable()) {
            if (this.fWorkspaceVariable.isDefaultWorkspace()) {
                this.requestValueExistsFromMatlabDefaultWorkspace();
            } else {
                this.requestValueExistsFromMatlabNonDefault();
            }
        }
    }

    private void requestValueExistsFromMatlabNonDefault() {
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("arrayviewfunc", new Object[]{"updateValueInformation", this.fWorkspaceVariable}, 1, (MatlabListener)new VICO());
    }

    private void requestValueExistsFromMatlabDefaultWorkspace() {
        String string = WorkspaceCommands.getContainingVariable(this.fWorkspaceVariable.getWorkspaceVariableNameTemp());
        Object[] objectArray = new String[]{string, "var"};
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("exist", objectArray, 1, (MatlabListener)new VECO(this.fWorkspaceVariable));
    }

    private void requestValueInformationFromMatlabDefaultWorkspace() {
        Object[] objectArray = new String[]{"arrayviewfunc('reportValueMetaInfo', " + this.fWorkspaceVariable.getVariableName() + ");", "arrayviewfunc('reportNonexistentValueMetaInfo');"};
        ArrayUtils.log(this.getClass(), 1, objectArray[0].toString() + ':' + objectArray[1]);
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", objectArray, 1, (MatlabListener)new VICO());
    }

    private class VICO
    implements MatlabListener {
        private VICO() {
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            ValueMetaInfo valueMetaInfo = (ValueMetaInfo)matlabEvent.getResult();
            if (valueMetaInfo == null) {
                return;
            }
            ArrayUtils.log(this.getClass(), 2, valueMetaInfo.toString());
            ActionEvent actionEvent = new ActionEvent(valueMetaInfo, 0, "update");
            if (ValueMetaInfoRequester.this.fActionListeners != null) {
                if (ArrayUtils.isLogging()) {
                    ArrayUtils.log(this.getClass(), 3, actionEvent.toString());
                }
                ValueMetaInfoRequester.this.fActionListeners.actionPerformed(actionEvent);
            }
        }
    }

    private class VECO
    implements MatlabListener {
        VECO(WorkspaceVariable workspaceVariable) {
            assert (workspaceVariable.getWorkspaceID() == 0);
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            double[] dArray = (double[])matlabEvent.getResult();
            boolean bl = dArray[0] == 1.0;
            ArrayUtils.log(this.getClass(), 3, bl ? "true" : "false");
            if (bl) {
                ValueMetaInfoRequester.this.requestValueInformationFromMatlabDefaultWorkspace();
            } else if (ValueMetaInfoRequester.this.fActionListeners != null) {
                ActionEvent actionEvent = new ActionEvent(ValueMetaInfo.getNonExistentInstance(), 0, "update");
                if (ArrayUtils.isLogging()) {
                    ArrayUtils.log(this.getClass(), 4, actionEvent.toString());
                }
                ValueMetaInfoRequester.this.fActionListeners.actionPerformed(actionEvent);
            }
        }
    }

    private class InterestListener
    implements ActionListener {
        private InterestListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueMetaInfoRequester.this.updateValueInformation();
        }
    }
}

