/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.util.Log;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CommonInsDelToolsetSupplier
implements TSToolSet.ToolSupplier,
ActionListener {
    protected IRegionOpProvider fRegionOpProvider = null;
    protected String fTitle = null;
    protected ImageIcon fRowIcon = null;
    protected ImageIcon fColumnIcon = null;
    private String fIconName = null;
    protected final List<InsertDeleteItem> fItems = new ArrayList<InsertDeleteItem>();
    private JComponent fToolstripButton;
    private static final int QUICK_ACCESS_BAR_SIZE = 16;
    private static final int TOOLSTRIP_SIZE = 24;

    public CommonInsDelToolsetSupplier(TSToolSet tSToolSet, IRegionOpProvider iRegionOpProvider, String string, IRegionOpProvider.Scope[] variableIdentifierProvider, String string2) {
        this.fRegionOpProvider = iRegionOpProvider;
        this.fTitle = string;
        this.fIconName = string2 + "_row_ts_";
        this.fRowIcon = this.getIcon(string2 + "_row_ts_16.png");
        this.fColumnIcon = this.getIcon(string2 + "_column_ts_16.png");
        String string3 = null;
        for (IRegionOpProvider.Scope scope : variableIdentifierProvider) {
            MJAbstractAction mJAbstractAction = this.getActionForScope(scope);
            if (mJAbstractAction == null) continue;
            if (string3 == null) {
                string3 = mJAbstractAction.getName();
            }
            String string4 = mJAbstractAction.getName();
            this.fItems.add(new InsertDeleteItem(mJAbstractAction, this.getIconForScope(scope), scope));
            tSToolSet.configureAndAdd(string2 + scope.getLabel(), (Action)mJAbstractAction);
            if (string4 == null || mJAbstractAction.getName().equals(string4)) continue;
            mJAbstractAction.setName(string4);
        }
        if (this.fItems.size() == 1) {
            this.fTitle = string3;
        }
        if (iRegionOpProvider instanceof VariableIdentifierProvider) {
            VariableIdentifierProvider variableIdentifierProvider2 = (VariableIdentifierProvider)iRegionOpProvider;
            variableIdentifierProvider2.addVariableIdentifierListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        CommonInsDelToolsetSupplier.this.updateEnabled();
                    }
                }
            });
            this.updateEnabled();
        }
    }

    void updateEnabled() {
        if (this.fToolstripButton != null) {
            List list = this.fRegionOpProvider.getScopeSupportedForSelection();
            boolean bl = true;
            if (list == null || list.isEmpty()) {
                bl = false;
            }
            this.fToolstripButton.setEnabled(bl);
        }
    }

    private ImageIcon getIcon(String string) {
        ImageIcon imageIcon = null;
        try {
            URL uRL = this.getClass().getResource("/com/mathworks/common/icons/resources/" + string);
            imageIcon = new ImageIcon(uRL);
        }
        catch (Exception exception) {
            Log.log((String)("Icon not found:" + string));
        }
        return imageIcon;
    }

    private ImageIcon getIcon(String string, TSToolSet.ToolLocation toolLocation) {
        if (toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR) {
            return this.getIcon(string + 16 + ".png");
        }
        return this.getIcon(string + 24 + ".png");
    }

    MJAbstractAction getActionForScope(IRegionOpProvider.Scope scope) {
        return null;
    }

    protected ImageIcon getIconForScope(IRegionOpProvider.Scope scope) {
        ImageIcon imageIcon = null;
        switch (scope) {
            case ROWS: 
            case ROWS_BELOW: {
                imageIcon = this.fRowIcon;
                break;
            }
            case COLUMNS: 
            case COLUMNS_TO_THE_RIGHT: {
                imageIcon = this.fColumnIcon;
                break;
            }
            case CELLS: 
            case SELECTION: {
                imageIcon = null;
            }
        }
        return imageIcon;
    }

    public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
        if (this.fItems.size() > 1) {
            TSDropDownButton tSDropDownButton = new TSDropDownButton(this.fTitle, (Icon)this.getIcon(this.fIconName, toolLocation));
            if (this.fRegionOpProvider == null) {
                tSDropDownButton.setEnabled(false);
            } else {
                tSDropDownButton.setPopupListener((PopupListener)new InsertDeletePopupMenu(this.fItems, this.fRegionOpProvider));
            }
            this.fToolstripButton = tSDropDownButton;
        } else {
            TSButton tSButton = new TSButton(this.fTitle);
            tSButton.setIcon((Icon)this.getIcon(this.fIconName, toolLocation));
            if (this.fItems.isEmpty()) {
                tSButton.setEnabled(false);
            } else {
                tSButton.addActionListener((ActionListener)this);
            }
            this.fToolstripButton = tSButton;
        }
        return this.fToolstripButton;
    }

    protected static List<ListItem> getPopupListContents(List<InsertDeleteItem> list, List<IRegionOpProvider.Scope> list2) {
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        if (list != null) {
            for (InsertDeleteItem insertDeleteItem : list) {
                if (list2 == null || list2.contains(IRegionOpProvider.Scope.CELLS)) {
                    arrayList.add(insertDeleteItem.getListItem());
                    continue;
                }
                if (list2.contains(IRegionOpProvider.Scope.ROWS) && (insertDeleteItem.getScope() == IRegionOpProvider.Scope.ROWS || insertDeleteItem.getScope() == IRegionOpProvider.Scope.ROWS_BELOW)) {
                    arrayList.add(insertDeleteItem.getListItem());
                    continue;
                }
                if (list2.contains(IRegionOpProvider.Scope.COLUMNS) && (insertDeleteItem.getScope() == IRegionOpProvider.Scope.COLUMNS || insertDeleteItem.getScope() == IRegionOpProvider.Scope.COLUMNS_TO_THE_RIGHT)) {
                    arrayList.add(insertDeleteItem.getListItem());
                    continue;
                }
                if (!list2.isEmpty()) continue;
                ListItem listItem = insertDeleteItem.getListItem();
                listItem.setAttribute((Attribute)ListItem.ENABLED_STATE, (Object)false);
                arrayList.add(listItem);
            }
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.fItems.isEmpty()) {
            this.fItems.get(0).getAction().actionPerformed(actionEvent);
        }
    }

    protected static class InsertDeletePopupMenu
    implements PopupListener,
    ListActionListener {
        private final List<InsertDeleteItem> fInsertDeleteItems;
        private final IRegionOpProvider fRegionOpProvider;

        protected InsertDeletePopupMenu(List<InsertDeleteItem> list, IRegionOpProvider iRegionOpProvider) {
            this.fInsertDeleteItems = list;
            this.fRegionOpProvider = iRegionOpProvider;
        }

        public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
            List list = this.fRegionOpProvider.getScopeSupportedForSelection();
            List<ListItem> list2 = CommonInsDelToolsetSupplier.getPopupListContents(this.fInsertDeleteItems, list);
            popupCallback.show((JComponent)this.createList(list2));
        }

        protected PopupList createList(List<ListItem> list) {
            PopupList popupList = new PopupList(list.toArray(new ListItem[list.size()]));
            popupList.setListStyle(ListStyle.ICON_TEXT);
            popupList.addListActionListener((ListActionListener)this);
            return popupList;
        }

        public void listItemSelected(ListActionEvent listActionEvent) {
            String string = listActionEvent.getListItem().getName();
            for (InsertDeleteItem insertDeleteItem : this.fInsertDeleteItems) {
                if (!string.equals(insertDeleteItem.getName())) continue;
                insertDeleteItem.getAction().actionPerformed((ActionEvent)listActionEvent);
                break;
            }
        }
    }

    protected static class InsertDeleteItem {
        private final MJAbstractAction fAction;
        private final ImageIcon fActionIcon;
        private final IRegionOpProvider.Scope fScope;

        public InsertDeleteItem(MJAbstractAction mJAbstractAction, ImageIcon imageIcon, IRegionOpProvider.Scope scope) {
            this.fAction = mJAbstractAction;
            this.fActionIcon = imageIcon;
            this.fScope = scope;
        }

        public MJAbstractAction getAction() {
            return this.fAction;
        }

        public IRegionOpProvider.Scope getScope() {
            return this.fScope;
        }

        public ListItem getListItem() {
            return ListItem.newItem((String)this.getAction().getName(), (String)this.getAction().getName(), (Icon)this.fActionIcon);
        }

        public String getName() {
            return this.getAction().getName();
        }
    }
}

