/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.AbstractMatlabObjectTable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.CellEditorProvider;
import com.mathworks.mlwidgets.array.DatasetTable;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ISelectionOpenerProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.MatlabCellTableModel;
import com.mathworks.mlwidgets.array.ValueDataSection;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotCatalog;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class CellTable
extends AbstractMatlabObjectTable
implements IGraphableInfoProvider,
VariableIdentifierProvider,
ISelectionOpenerProvider,
IGraphingActionListener,
IPlotPickerDisplayTrigger {
    private final MJAbstractAction fOpenCellAction;
    private MJAbstractAction fCatalogAction = null;
    private PlotCatalog fMorePlotsDlg = null;
    private List<ListSelectionListener> fGraphicListener = new Vector<ListSelectionListener>();
    private List<ListSelectionListener> fSimpleVariableListener = new Vector<ListSelectionListener>();
    private ListSelectionListener fLSL;
    private MJAbstractAction fArrayCopyAction;
    private MJAbstractAction fPlotPickerAction = null;
    private final Collection<PlotPickerOpener> fPlotPickerOpeners = new ArrayList<PlotPickerOpener>();
    private static final String[] STRINGS = new String[0];
    private static final String[] ESA = STRINGS;
    private MJMenu fSortMenu = null;
    private MJMenu fExtractMenu = null;
    private CellEditorProvider fProvider;

    public CellTable(MatlabCellTableModel matlabCellTableModel) {
        super(matlabCellTableModel);
        this.fOpenCellAction = new OpenCellAction();
        this.fSelectionPopupMenu.add((Action)this.fOpenCellAction);
        this.fSelectionPopupMenu.add((Component)new JSeparator());
        MJMenuItem mJMenuItem = new MJMenuItem(ArrayUtils.getResource("transpose.Title"));
        mJMenuItem.setName("Transpose");
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ITableController)((Object)CellTable.this.getModel())).transpose();
            }
        });
        this.fSelectionPopupMenu.add((JMenuItem)mJMenuItem);
        this.fSortMenu = new MJMenu(ArrayUtils.getResource("sort.Title"));
        MJMenuItem mJMenuItem2 = new MJMenuItem(ArrayUtils.getResource("sort.Ascending"));
        MJMenuItem mJMenuItem3 = new MJMenuItem(ArrayUtils.getResource("sort.Descending"));
        this.fSortMenu.add((JMenuItem)mJMenuItem2);
        this.fSortMenu.add((JMenuItem)mJMenuItem3);
        this.fSortMenu.setVisible(false);
        this.fSortMenu.setName("Sort");
        mJMenuItem2.setName("Sort_Ascending");
        mJMenuItem3.setName("Sort_Descending");
        this.fSelectionPopupMenu.add((JMenuItem)this.fSortMenu);
        mJMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CellTable.this.restrictRowColumnSpecToValidRegion(CellTable.this.getColumnModel().getSelectedColumns(), 1);
                if (null != nArray) {
                    int n = 0;
                    while (n < nArray.length) {
                        int n2 = n++;
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                ((ITableController)((Object)CellTable.this.getModel())).sortRows(nArray, ITableController.SortDirection.ASCENDING);
            }
        });
        mJMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CellTable.this.restrictRowColumnSpecToValidRegion(CellTable.this.getColumnModel().getSelectedColumns(), 1);
                if (null != nArray) {
                    int n = 0;
                    while (n < nArray.length) {
                        int n2 = n++;
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                ((ITableController)((Object)CellTable.this.getModel())).sortRows(nArray, ITableController.SortDirection.DESCENDING);
            }
        });
        this.fCatalogAction = new MorePlotsAction();
        this.fPlotPickerAction = new MJAbstractAction(ArrayUtils.getResource("menu.picker")){

            public void actionPerformed(ActionEvent actionEvent) {
                CellTable.this.firePlotPickerRequested();
            }
        };
        this.fLSL = new SelListener();
        this.getSelectionModel().addListSelectionListener(this.fLSL);
        this.getColumnModel().getSelectionModel().addListSelectionListener(this.fLSL);
        GraphingActionFactory.addGraphingActionListener(this);
        this.setName("CellTable");
    }

    public void setProvider(CellEditorProvider cellEditorProvider) {
        this.fProvider = cellEditorProvider;
    }

    private void firePlotPickerRequested() {
        for (PlotPickerOpener plotPickerOpener : this.fPlotPickerOpeners) {
            plotPickerOpener.openPlotPicker();
        }
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.add(plotPickerOpener);
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.remove(plotPickerOpener);
    }

    public void cleanup() {
        GraphingActionFactory.removeGraphingActionListener(this);
        if (this.fExtractMenu != null) {
            this.fExtractMenu.removeAll();
        }
        this.fSortMenu.removeAll();
        this.fSelectionPopupMenu.removeAll();
        this.getSelectionModel().removeListSelectionListener(this.fLSL);
        this.getColumnModel().getSelectionModel().removeListSelectionListener(this.fLSL);
        this.fLSL = null;
        this.fGraphicListener = null;
        this.fSimpleVariableListener = null;
        this.fCatalogAction = null;
        super.cleanup();
    }

    @Override
    public void graphingActionsChanged() {
        for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
            listSelectionListener.valueChanged(new ListSelectionEvent(this, 0, this.getRowCount() - 1, false));
        }
    }

    private void addExtractMenu(MJPopupMenu mJPopupMenu, MJAbstractAction[] mJAbstractActionArray) {
        this.removeExtractMenu();
        this.fExtractMenu = new MJMenu(ArrayUtils.getResource("Action.create-variable-from-selection.Label"));
        this.fExtractMenu.add((Action)mJAbstractActionArray[INewVariableProvider.CreationParams.ALL.ordinal()]);
        if (this.getSelectedRowCount() > 1) {
            this.fExtractMenu.add((Action)mJAbstractActionArray[INewVariableProvider.CreationParams.ROWS.ordinal()]);
        }
        if (this.getSelectedColumnCount() > 1) {
            this.fExtractMenu.add((Action)mJAbstractActionArray[INewVariableProvider.CreationParams.COLUMNS.ordinal()]);
        }
        mJPopupMenu.add((JMenuItem)this.fExtractMenu);
    }

    private void removeExtractMenu() {
        if (this.fExtractMenu != null) {
            this.fExtractMenu.removeAll();
            this.fSelectionPopupMenu.remove((Component)this.fExtractMenu);
        }
    }

    public void refreshObjectSpecificPopup() {
        if (this.fSelectionPopupMenu == null) {
            return;
        }
        if (this.getCellEditor() != null) {
            this.getCellEditor().cancelCellEditing();
        }
        if (this.useMinimalMenus()) {
            this.removeExtractMenu();
        } else if (this.fProvider != null) {
            this.addExtractMenu(this.fSelectionPopupMenu, this.fProvider.getCreationActions());
        }
    }

    @Override
    public String[] getGraphableNames() {
        return this.getGraphableNames(this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0), this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1));
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fPlotPickerAction;
    }

    private String getSelectionSubsrefString(int[] nArray, int[] nArray2) {
        String string;
        List list = DatasetTable.getSelectionIntervals((int[])nArray);
        List list2 = DatasetTable.getSelectionIntervals((int[])nArray2);
        TableModel tableModel = this.getModel();
        int n = -1;
        int n2 = -1;
        if (tableModel instanceof IDataBoundsSupplier) {
            n = ((IDataBoundsSupplier)tableModel).getLastDataRow() + 1;
            n2 = ((IDataBoundsSupplier)tableModel).getLastDataColumn() + 1;
        }
        if ((string = ArrayUtils.getSelectionString(list, n, list2, n2)).isEmpty()) {
            return "cell2mat(" + this.getVariableName() + ")";
        }
        return "cell2mat(" + this.getVariableName() + "(" + string + "))";
    }

    private String[] getGraphableNames(int[] nArray, int[] nArray2) {
        if (this.useMinimalMenus()) {
            return STRINGS;
        }
        String[] stringArray = ESA;
        if (nArray.length < 1 || nArray2.length < 1) {
            return stringArray;
        }
        if (this.isCellNumericScalar(nArray[0], nArray2[0])) {
            stringArray = new String[]{this.getSelectionSubsrefString(nArray, nArray2)};
        } else if (nArray.length > 1 && this.isCellNumericScalar(nArray[1], nArray2[0])) {
            stringArray = new String[1];
            int[] nArray3 = Arrays.copyOfRange(nArray, 1, nArray.length);
            stringArray[0] = this.getSelectionSubsrefString(nArray3, nArray2);
        } else if (nArray2.length > 1 && this.isCellNumericScalar(nArray[0], nArray2[1])) {
            stringArray = new String[1];
            int[] nArray4 = Arrays.copyOfRange(nArray2, 1, nArray2.length);
            stringArray[0] = this.getSelectionSubsrefString(nArray, nArray4);
        }
        return stringArray;
    }

    @Override
    public String[] getGraphableSizes() {
        return this.getGraphableSizes(this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0), this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1));
    }

    private String[] getGraphableSizes(int[] nArray, int[] nArray2) {
        String[] stringArray = ESA;
        if (nArray.length < 1 || nArray2.length < 1) {
            return stringArray;
        }
        if (this.isCellNumericScalar(nArray[0], nArray2[0]) || nArray.length > 1 && this.isCellNumericScalar(nArray[1], nArray2[0]) || nArray2.length > 1 && this.isCellNumericScalar(nArray[0], nArray2[1])) {
            stringArray = new String[]{nArray.length + "x" + nArray2.length};
        }
        return stringArray;
    }

    @Override
    public String[] getGraphableClasses() {
        return this.getGraphableClasses(this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0), this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1));
    }

    private String[] getGraphableClasses(int[] nArray, int[] nArray2) {
        String[] stringArray = ESA;
        if (nArray.length < 1 || nArray2.length < 1) {
            return stringArray;
        }
        if (this.isCellNumericScalar(nArray[0], nArray2[0]) || nArray.length > 1 && this.isCellNumericScalar(nArray[1], nArray2[0]) || nArray2.length > 1 && this.isCellNumericScalar(nArray[0], nArray2[1])) {
            stringArray = new String[]{"double"};
        }
        return stringArray;
    }

    @Override
    public final Action getMorePlotsAction() {
        return this.fCatalogAction;
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.add(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.remove(listSelectionListener);
    }

    private boolean isCellNumericScalar(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        return object != null && object instanceof ValueDataSection && ((ValueDataSection)object).isComplexScalar();
    }

    public VariableIdentifier getVariableIdentifier() {
        String string = this.getSelectionNameString();
        return new VariableIdentifier(string, string, this.getVariable().getWorkspaceID());
    }

    public void addVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.add(listSelectionListener);
    }

    public void removeVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.remove(listSelectionListener);
    }

    @Override
    public final Action getSelectionOpenerAction() {
        return this.fOpenCellAction;
    }

    private String getSelectionNameString() {
        String string = null;
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray.length > 0 && nArray2.length > 0) {
            String string2;
            List list = DatasetTable.getSelectionIntervals((int[])nArray);
            List list2 = DatasetTable.getSelectionIntervals((int[])nArray2);
            TableModel tableModel = this.getModel();
            int n = -1;
            int n2 = -1;
            if (tableModel instanceof IDataBoundsSupplier) {
                n = ((IDataBoundsSupplier)tableModel).getLastDataRow() + 1;
                n2 = ((IDataBoundsSupplier)tableModel).getLastDataColumn() + 1;
            }
            string = (string2 = ArrayUtils.getSelectionString(list, n, list2, n2)).isEmpty() ? this.getVariableName() : this.getVariableName() + '(' + string2 + ')';
        }
        return string;
    }

    public final Action getCopyAction() {
        if (this.fArrayCopyAction == null) {
            this.fArrayCopyAction = new CellTableCopyAction();
        }
        return this.fArrayCopyAction;
    }

    private class CellTableCopyAction
    extends SpreadsheetTable.CopyAction {
        private CellTableCopyAction() {
            super((SpreadsheetTable)CellTable.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CellTable.this.populateClipboardFromIdentifier(CellTable.this.getVariableIdentifier());
        }
    }

    private class MorePlotsAction
    extends ArrayUtils.BaseAction {
        MorePlotsAction() {
            super("show-plot-catalog", "show-plot-catalog");
            CellTable.this.registerWithMapsUsingKeyBindingManager(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CellTable.this.fMorePlotsDlg == null) {
                CellTable.this.fMorePlotsDlg = PlotCatalog.getInstance();
            }
            String[] stringArray = ESA;
            String string = CellTable.this.getSelectionNameString();
            if (string != null) {
                stringArray = CellTable.this.getGraphableNames();
            }
            CellTable.this.fMorePlotsDlg.setPlottedVars(stringArray);
            CellTable.this.fMorePlotsDlg.show();
        }
    }

    private class OpenCellAction
    extends ArrayUtils.BaseAction {
        private OpenCellAction() {
            super("open-selection", "OpenCell");
            CellTable.this.registerWithMapsUsingKeyBindingManager(this);
            this.setEnabled(CellTable.this.restrictRowColumnSpecToValidRegion(CellTable.this.getSelectedRows(), 0).length == 1 && CellTable.this.restrictRowColumnSpecToValidRegion(CellTable.this.getSelectedColumns(), 1).length == 1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CellTable.this.openAnchorCell();
        }
    }

    private class SelListener
    implements ListSelectionListener {
        private SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int[] nArray = CellTable.this.restrictRowColumnSpecToValidRegion(CellTable.this.getSelectedRows(), 0);
                int[] nArray2 = CellTable.this.restrictRowColumnSpecToValidRegion(CellTable.this.getSelectedColumns(), 1);
                CellTable.this.refreshObjectSpecificPopup();
                if (CellTable.this.fGraphicListener != null) {
                    for (ListSelectionListener listSelectionListener : CellTable.this.fGraphicListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                if (CellTable.this.fSimpleVariableListener != null) {
                    for (ListSelectionListener listSelectionListener : CellTable.this.fSimpleVariableListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                if (CellTable.this.fExtractMenu != null) {
                    CellTable.this.fExtractMenu.setEnabled(nArray.length > 0 && nArray2.length > 0);
                }
                CellTable.this.fOpenCellAction.setEnabled(nArray.length == 1 && nArray2.length == 1);
                CellTable.this.fSortMenu.setVisible(CellTable.this.isSortEnabledForSelection());
            }
        }
    }
}

