/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.MLArrayEditorServices;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractMatlabTableModel;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DoerCompletionObserver;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

abstract class AbstractMatlabObjectTableModel
extends AbstractMatlabTableModel {
    private ActionListener fOpenActionListener;

    AbstractMatlabObjectTableModel(WorkspaceVariable workspaceVariable, boolean bl) {
        this(new ValueTableModel(workspaceVariable), workspaceVariable, bl);
    }

    public AbstractMatlabObjectTableModel(ValueTableModel valueTableModel, WorkspaceVariable workspaceVariable, boolean bl) {
        super(valueTableModel, workspaceVariable, bl);
        this.setVariableName(workspaceVariable.getWorkspaceVariableNameTemp());
    }

    public void setOpenActionListener(ActionListener actionListener) {
        this.fOpenActionListener = actionListener;
    }

    private void openCellDefaultWorkspace(String string) {
        this.getUserActionMCR().eval("openvar('" + string + "'," + string + ");", ArrayDialog.getErrorDialogCompletionObserver());
    }

    private void openCellNonDefaultWorkspace(String string) {
        MLArrayEditorServices.openVariableLater((WorkspaceVariable)new WorkspaceVariable(string, this.getVariable().getWorkspaceID()));
    }

    public void openCellAt(int n, int n2) {
        int n3 = n + 1;
        int n4 = n2 + 1;
        StringBuilder stringBuilder = this.constructIndexingExpression(n3, n4);
        if (ArrayUtils.isLogging()) {
            ArrayUtils.log(this.getClass(), 1, stringBuilder.toString());
        }
        if (this.fOpenActionListener == null) {
            if (this.getVariable().isDefaultWorkspace()) {
                this.openCellDefaultWorkspace(stringBuilder.toString());
            } else {
                this.openCellNonDefaultWorkspace(stringBuilder.toString());
            }
        } else {
            this.fOpenActionListener.actionPerformed(new ActionEvent(this, 1001, stringBuilder.toString()));
        }
    }

    protected void setValueAt(Object object, int n, int n2, int n3) {
        if (!object.equals(this.getValueAt(n, n2))) {
            new SetValueAtDoer(this.getUserActionMCR(), this.getVariable(), object, n, n2, n3, WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
        }
    }

    private class SetValueAtUndoer
    extends SetValueAtRunnable {
        SetValueAtUndoer(MatlabMCR matlabMCR, WorkspaceVariable workspaceVariable, Object object, int n, int n2, int n3, WorkspaceUndoManager.UndoKey undoKey) {
            super(matlabMCR, workspaceVariable, object, n, n2, n3, undoKey);
        }

        private void runDefaultWorkspace() {
            this.iMatlabMCR.eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, this.iVariable.getVariableName()), (CompletionObserver)new UndoerCompletionObserver(AbstractMatlabObjectTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace() {
            this.iMatlabMCR.feval("arrayviewfunc", new Object[]{"undo", this.iVariable, this.iKey.stringValue()}, 0, AbstractMatlabObjectTableModel.this.getRefreshErrorDialogCOForFeval(ArrayUtils.getResource("alert.PasteGeneralIncompatability"), new UndoerCompletionObserver(AbstractMatlabObjectTableModel.this.fUndoManager)));
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, this.iValue + ", " + this.iRow + ", " + this.iColumn + ", " + this.iStyle);
            }
            if (AbstractMatlabObjectTableModel.this.fUndoManager != null) {
                AbstractMatlabObjectTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (this.iVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValueAtDoer(this.iMatlabMCR, this.iVariable, this.iValue, this.iRow, this.iColumn, this.iStyle, this.iKey);
        }
    }

    private class SetValueAtDoer
    extends SetValueAtRunnable {
        SetValueAtDoer(MatlabMCR matlabMCR, WorkspaceVariable workspaceVariable, Object object, int n, int n2, int n3, WorkspaceUndoManager.UndoKey undoKey) {
            super(matlabMCR, workspaceVariable, object, n, n2, n3, undoKey);
        }

        private void runDefaultWorkspace(String string, boolean bl, String string2) {
            if (this.iStyle == 1) {
                String string3 = bl ? '\'' + string + '\'' : string;
                String string4 = StringUtils.quoteSingleQuotes((String)string3);
                if (ArrayUtils.isLogging()) {
                    ArrayUtils.log(this.getClass(), 1, string2 + ", " + string4);
                }
                this.iMatlabMCR.eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, this.iVariable.getVariableName()) + "try, eval('" + string2 + " = " + string4 + ";');" + " catch, " + string2 + " = '" + string4 + "';" + " end", AbstractMatlabObjectTableModel.this.getRefreshErrorDialogCO(null, new DoerCompletionObserver(this, AbstractMatlabObjectTableModel.this.fUndoManager)));
            } else {
                String string5 = string;
                if (bl) {
                    string5 = "[]";
                }
                if (ArrayUtils.isLogging()) {
                    ArrayUtils.log(this.getClass(), 2, string2 + ", " + string5);
                }
                this.iMatlabMCR.eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, this.iVariable.getVariableName()) + string2 + " = " + string5 + ';', AbstractMatlabObjectTableModel.this.getRefreshErrorDialogCO(null, new DoerCompletionObserver(this, AbstractMatlabObjectTableModel.this.fUndoManager)));
            }
        }

        private void runNonDefaultWorkspace(String string, boolean bl, String string2) {
            String string3 = string;
            if (bl) {
                string3 = "[]";
            }
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 2, string2 + ", " + string3);
            }
            boolean bl2 = this.iStyle == 0;
            this.iMatlabMCR.feval("arrayviewfunc", new Object[]{"amotmSetValueAt", this.iVariable, this.iKey.stringValue(), string2, string3, bl2}, 0, ArrayDialog.getErrorDialogCompletionObserver((CompletionObserver)new DoerCompletionObserver(this, AbstractMatlabObjectTableModel.this.fUndoManager), true));
        }

        @Override
        public void run() {
            String string;
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, this.iValue + ", " + this.iRow + ", " + this.iColumn + ", " + this.iStyle);
            }
            if (AbstractMatlabObjectTableModel.this.fUndoManager != null) {
                AbstractMatlabObjectTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            boolean bl = (string = this.iValue.toString()).trim().length() == 0;
            int n = this.iRow + 1;
            int n2 = this.iColumn + 1;
            StringBuilder stringBuilder = AbstractMatlabObjectTableModel.this.constructIndexingExpression(n, n2);
            if (this.iVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace(string, bl, stringBuilder.toString());
            } else {
                this.runNonDefaultWorkspace(string, bl, stringBuilder.toString());
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValueAtUndoer(this.iMatlabMCR, this.iVariable, this.iValue, this.iRow, this.iColumn, this.iStyle, this.iKey);
        }
    }

    private static abstract class SetValueAtRunnable
    implements InvertableRunnable {
        protected MatlabMCR iMatlabMCR;
        protected WorkspaceVariable iVariable;
        protected Object iValue;
        protected int iRow;
        protected int iColumn;
        protected int iStyle;
        protected WorkspaceUndoManager.UndoKey iKey;

        SetValueAtRunnable(MatlabMCR matlabMCR, WorkspaceVariable workspaceVariable, Object object, int n, int n2, int n3, WorkspaceUndoManager.UndoKey undoKey) {
            this.iMatlabMCR = matlabMCR;
            this.iVariable = workspaceVariable;
            this.iValue = object;
            this.iRow = n;
            this.iColumn = n2;
            this.iStyle = n3;
            this.iKey = undoKey;
        }
    }
}

