/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TreeTableModel;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTip;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTipPanel;
import com.mathworks.mlwidgets.actionbrowser.HelpOnSelectionProvider;
import com.mathworks.mlwidgets.actionbrowser.MouseDirectionFinder;
import com.mathworks.mlwidgets.actionbrowser.TransparentDialog;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MMouseEvent;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.jidesoft.grid.MWTreeTable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public abstract class AbstractActionTable
extends MWTreeTable
implements HelpOnSelectionProvider {
    protected ActionToolTip fActionTip = null;
    protected Timer fToolTipTimer;
    protected Timer fShortDelayClickTimer;
    protected final MouseDirectionFinder fMouseDirectionFinder = new MouseDirectionFinder();
    protected MJPopupMenu fPopup;
    protected ActionTableMouseMotionListener fMouseMotionListener;
    protected static final int TOOLTIP_DELAY = 500;
    protected static final int TOOLTIP_SHORT_DELAY = 150;
    protected static final int[] SCROLL_KEYS = new int[]{34, 33, 40, 38, 225, 224};

    public AbstractActionTable(TreeTableModel treeTableModel) {
        super((TableModel)treeTableModel);
        if (treeTableModel == null) {
            throw new NullPointerException();
        }
        ActionToolTipListener actionToolTipListener = new ActionToolTipListener();
        this.fToolTipTimer = new Timer(500, actionToolTipListener);
        this.fShortDelayClickTimer = new Timer(150, actionToolTipListener);
        this.fToolTipTimer.setRepeats(false);
        this.fShortDelayClickTimer.setRepeats(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setTableHeader(null);
        this.setExpandAllAllowed(false);
        this.setShowTreeLines(false);
        this.setShowGrid(false);
        this.setSelectRowWhenToggling(true);
        this.setShowsRootHandles(false);
        this.setExpandableColumn(-1);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setSelectionMode(0);
        this.fMouseMotionListener = new ActionTableMouseMotionListener();
        this.addMouseMotionListener(this.fMouseMotionListener);
        this.addMouseListener(new ActionTableMouseListener());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (AbstractActionTable.this.getRowCount() > 0 && AbstractActionTable.this.getSelectedRow() < 0) {
                    AbstractActionTable.this.setRowSelectionInterval(0, 0);
                }
                AbstractActionTable.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AbstractActionTable.this.repaint();
            }
        });
        this.setDragEnabled(false);
    }

    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyStroke.getKeyCode() == 9 && n == 0 && this.hasFocus() && bl) {
            Container container = this.getFocusCycleRootAncestor();
            Component component = keyEvent.isShiftDown() ? container.getFocusTraversalPolicy().getComponentBefore(container, (Component)((Object)this)) : container.getFocusTraversalPolicy().getComponentAfter(container, (Component)((Object)this));
            component.requestFocus();
            return true;
        }
        if (AbstractActionTable.isScrollKey(keyEvent) && this.isMouseWheelFocusInTooltip()) {
            this.fActionTip.dispatchScrollEvent(keyEvent);
            return true;
        }
        boolean bl2 = true;
        if (keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 37) {
            Row row;
            int n2 = this.getSelectedRow();
            if (this.isItemRow(n2)) {
                boolean bl3 = bl2 = this.fActionTip != null && this.fActionTip.isShowing() && this.fActionTip.getAlignment() == 2;
                if (keyEvent.getKeyCode() == 39 && !bl2 || keyEvent.getKeyCode() == 37 && bl2) {
                    this.setMouseWheelTooltipManualFocus(true);
                    this.setMouseWheelTooltipFocus(true);
                    return true;
                }
            } else if (this.isCategoryRow(n2) && (row = this.getRowAt(n2)) instanceof DefaultExpandableRow) {
                this.expandRow(n2, keyEvent.getKeyCode() == 39);
                return true;
            }
        }
        if (this.isMouseWheelTooltipManualFocus() && (keyEvent.getKeyCode() == 37 && !bl2 || keyEvent.getKeyCode() == 39 && bl2)) {
            if (this.isMouseWheelTooltipManualFocus()) {
                this.setMouseWheelTooltipFocus(false);
            } else if (this.isMouseWheelFocusInTooltip()) {
                this.setMouseWheelTooltipManualFocus(true);
                this.setMouseWheelTooltipFocus(false);
            }
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void dispatchScrollEvent(AWTEvent aWTEvent) {
        if (this.isMouseWheelFocusInTooltip()) {
            this.fActionTip.dispatchScrollEvent(aWTEvent);
        } else {
            this.dispatchEvent(aWTEvent);
        }
    }

    public void setRowSelectionInterval(int n, int n2) {
        this.setMouseWheelTooltipManualFocus(false);
        this.setMouseWheelTooltipFocus(false);
        int n3 = this.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        if (n != this.getSelectedRow()) {
            int n4 = this.getMinimumSelectableRow();
            n = n < n4 ? n4 : n;
            super.setRowSelectionInterval(n, n);
        }
        this.manageTooltipAtRow(n, n3);
    }

    public void addRowSelectionInterval(int n, int n2) {
        int n3;
        this.setMouseWheelTooltipManualFocus(false);
        this.setMouseWheelTooltipFocus(false);
        if (n >= 0) {
            n3 = this.getMinimumSelectableRow();
            n = n < n3 ? n3 : n;
        }
        n3 = this.getSelectedRow();
        super.setRowSelectionInterval(n, n);
        this.manageTooltipAtRow(n, n3);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        this.setMouseWheelTooltipManualFocus(false);
        this.setMouseWheelTooltipFocus(false);
        if (n < this.getMinimumSelectableRow()) {
            return;
        }
        int n3 = this.getSelectedRow();
        this.manageTooltipAtRow(n, n3);
        super.changeSelection(n, n2, bl, bl2);
        this.repaint();
    }

    public void hideActionToolTip() {
        if (this.fToolTipTimer != null) {
            this.fToolTipTimer.stop();
        }
        if (this.fShortDelayClickTimer != null) {
            this.fShortDelayClickTimer.stop();
        }
        if (this.fActionTip == null) {
            return;
        }
        this.fActionTip.hide();
        this.fActionTip = null;
    }

    public static Window[] getFloatingTooltips(Component component) {
        Window window;
        if (component != null && !(component instanceof Window)) {
            window = SwingUtilities.getWindowAncestor(component);
        } else if (component != null) {
            window = (Window)component;
        } else {
            return null;
        }
        Window[] windowArray = window.getOwnedWindows();
        ArrayList<Window> arrayList = new ArrayList<Window>();
        for (Window window2 : windowArray) {
            if (!(window2 instanceof TransparentDialog)) continue;
            arrayList.add(window2);
        }
        Window[] windowArray2 = new Window[arrayList.size()];
        for (int i = 0; i < windowArray2.length; ++i) {
            windowArray2[i] = (Window)arrayList.get(i);
        }
        return windowArray2;
    }

    public TransparentDialog getToolTipWindow() {
        if (this.fActionTip == null) {
            return null;
        }
        return this.fActionTip.getDialog();
    }

    public static Color getPopupSelectionColor() {
        return PlatformInfo.isMacintosh() ? UIManager.getColor("TextField.selectionBackground") : UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    public static Color getPopupNonselectionColor() {
        return UIManager.getColor("InternalFrame.inactiveTitleBackground");
    }

    protected static boolean isScrollKey(KeyEvent keyEvent) {
        for (int n : SCROLL_KEYS) {
            if (keyEvent.getKeyCode() != n) continue;
            return true;
        }
        return false;
    }

    protected void maybeOpenPopup(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getButton() != 1) {
            this.fToolTipTimer.stop();
            this.fShortDelayClickTimer.stop();
        }
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent instanceof MMouseEvent && ((MMouseEvent)mouseEvent).isKeyTriggered()) {
            n = this.getSelectedRow();
            if (n < 0) {
                return;
            }
        } else {
            n = this.rowAtPoint(mouseEvent.getPoint());
        }
        if (this.isItemRow(n)) {
            this.setRowSelectionInterval(n, n);
            this.updatePopup(this.getRowAt(n));
            this.fPopup.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
            this.fMouseMotionListener.setSkipNextMouseEvent(true);
        }
    }

    public boolean isToolTipShowing() {
        return this.fActionTip != null && this.fActionTip.isShowing();
    }

    protected void trackMouseForTooltip(MouseEvent mouseEvent) {
        int n = this.getSelectedRow();
        if (n > 0 && this.fActionTip != null && this.fActionTip.isShowing() && this.isItemRow(n) && this.fMouseDirectionFinder.isInTooltipCone(this.fActionTip.getAlignment(), (Component)((Object)this), this.getSize())) {
            this.fMouseDirectionFinder.update();
            return;
        }
        this.fMouseDirectionFinder.update();
        this.setRowSelectionInterval(this.rowAtPoint(mouseEvent.getPoint()), this.rowAtPoint(mouseEvent.getPoint()));
    }

    protected int getMinimumSelectableRow() {
        return 0;
    }

    protected Point getToolTipLocationForRow(int n) {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        Rectangle rectangle = window.getBounds();
        Rectangle rectangle2 = this.getCellRect(n, 0, true);
        Point point = new Point(0, rectangle2.y + rectangle2.height / 2);
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this));
        if (this.getParent() == null) {
            return null;
        }
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, (Component)((Object)this));
        if (container == null) {
            return null;
        }
        Rectangle rectangle3 = container.getBounds();
        Point point2 = new Point(rectangle3.x, rectangle3.y);
        SwingUtilities.convertPointToScreen(point2, container);
        Point point3 = new Point(rectangle.x + rectangle.width, point.y);
        if (point3.y < point2.y || point3.y > point2.y + rectangle3.height) {
            return null;
        }
        return point3;
    }

    private boolean isPopupShowing() {
        return this.fPopup != null && this.fPopup.isShowing();
    }

    private void manageTooltipAtRow(int n, int n2) {
        if (!(this.getTopLevelAncestor() instanceof Window)) {
            return;
        }
        if (!((Window)this.getTopLevelAncestor()).isActive()) {
            if (this.fActionTip != null && this.fActionTip.isShowing()) {
                this.fActionTip.hide();
            }
            this.fToolTipTimer.stop();
            this.fShortDelayClickTimer.stop();
            return;
        }
        if (n == n2 && this.fActionTip != null && this.fActionTip.isShowing()) {
            return;
        }
        if (this.fActionTip != null) {
            this.fActionTip.hide();
            this.fActionTip = null;
        }
        if (this.isPopupShowing()) {
            return;
        }
        if (this.isItemRow(n)) {
            this.fToolTipTimer.restart();
            this.fShortDelayClickTimer.stop();
        }
    }

    protected boolean isMouseWheelFocusInTooltip() {
        return this.fActionTip != null && this.fActionTip.isShowing() && this.fActionTip.getDialog().isShowing() && this.fActionTip.isMouseWheelFocusState();
    }

    private void setMouseWheelTooltipManualFocus(boolean bl) {
        if (this.fActionTip == null || !this.fActionTip.isShowing() || !this.fActionTip.getDialog().isShowing()) {
            return;
        }
        this.fActionTip.setMouseWheelFocusManual(bl);
    }

    private void setMouseWheelTooltipFocus(boolean bl) {
        if (this.fActionTip == null || !this.fActionTip.isShowing() || !this.fActionTip.getDialog().isShowing()) {
            return;
        }
        this.fActionTip.setMouseWheelFocus(bl);
    }

    private boolean isMouseWheelTooltipManualFocus() {
        return this.fActionTip != null && this.fActionTip.isShowing() && this.fActionTip.getDialog().isShowing() && this.fActionTip.isMouseWheelFocusState();
    }

    protected void showActionToolTip(Point point, String string, String string2, String string3, String string4) {
        this.showActionToolTip(point, string, string2, string3, string4, null);
    }

    protected void showActionToolTip(Point point, String string, String string2, String string3, String string4, String string5) {
        if (!(this.getTopLevelAncestor() instanceof Window)) {
            return;
        }
        if (!((Window)this.getTopLevelAncestor()).isActive()) {
            return;
        }
        if (this.isPopupShowing()) {
            return;
        }
        if (this.fActionTip != null) {
            this.fActionTip.hide();
            ActionToolTipPanel actionToolTipPanel = this.fActionTip.getTipPanel();
            this.fActionTip = ActionToolTip.createActionToolTip((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)), actionToolTipPanel, (HelpOnSelectionProvider)this);
        } else {
            this.fActionTip = ActionToolTip.createActionToolTip((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)), this);
        }
        this.fActionTip.setArrowPointLocation(new Point(point.x, point.y));
        if (string5 != null) {
            this.fActionTip.openTooltip(string, string2, string3, string4, string5);
        } else {
            this.fActionTip.openTooltip(string, string2, string3, string4);
        }
    }

    protected abstract boolean isCategoryRow(int var1);

    protected abstract boolean isItemRow(int var1);

    protected abstract void execute(int var1, boolean var2);

    protected abstract String getActionNameForRow(int var1);

    protected abstract String getH1LineForRow(int var1);

    protected abstract String getSearchText();

    protected abstract String getURLForRow(int var1);

    protected abstract void updatePopup(Row var1);

    protected boolean isDoubleClickExecutionEvent(MouseEvent mouseEvent) {
        return mouseEvent.getClickCount() == 2;
    }

    private class ActionTableMouseMotionListener
    extends MouseMotionAdapter {
        private boolean fSkipNextMouseEvent = false;

        private ActionTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (AbstractActionTable.this.fPopup != null && AbstractActionTable.this.fPopup.isShowing()) {
                return;
            }
            if (this.fSkipNextMouseEvent) {
                this.fSkipNextMouseEvent = false;
                return;
            }
            if (AbstractActionTable.this.fPopup == null || !AbstractActionTable.this.fPopup.isVisible()) {
                AbstractActionTable.this.trackMouseForTooltip(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            AbstractActionTable.this.fToolTipTimer.stop();
            AbstractActionTable.this.fShortDelayClickTimer.stop();
        }

        public void setSkipNextMouseEvent(boolean bl) {
            this.fSkipNextMouseEvent = bl;
        }
    }

    private class ActionTableMouseListener
    extends MouseAdapter {
        private ActionTableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (AbstractActionTable.this.fActionTip != null && AbstractActionTable.this.fActionTip.isShowing()) {
                AbstractActionTable.this.fActionTip.getDialog().toFront();
            }
            AbstractActionTable.this.maybeOpenPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            AbstractActionTable.this.maybeOpenPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = AbstractActionTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            Row row = AbstractActionTable.this.getRowAt(n);
            assert (row != null);
            if (AbstractActionTable.this.isItemRow(n)) {
                if (AbstractActionTable.this.isDoubleClickExecutionEvent(mouseEvent)) {
                    AbstractActionTable.this.fToolTipTimer.stop();
                    AbstractActionTable.this.fShortDelayClickTimer.stop();
                    AbstractActionTable.this.execute(n, true);
                } else if (!(AbstractActionTable.this.fActionTip != null && AbstractActionTable.this.fActionTip.isShowing() || mouseEvent.isPopupTrigger() || MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent))) {
                    AbstractActionTable.this.fToolTipTimer.stop();
                    AbstractActionTable.this.fShortDelayClickTimer.stop();
                    AbstractActionTable.this.fShortDelayClickTimer.start();
                }
            } else if (AbstractActionTable.this.isCategoryRow(n)) {
                if (mouseEvent.getClickCount() == 2) {
                    return;
                }
                boolean bl = ((Expandable)row).isExpanded();
                AbstractActionTable.this.expandRow(n, !bl);
            }
            AbstractActionTable.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractActionTable.this.fToolTipTimer.stop();
            AbstractActionTable.this.fShortDelayClickTimer.stop();
        }
    }

    private class ActionToolTipListener
    implements ActionListener {
        private ActionToolTipListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AbstractActionTable.this.getSelectedRow();
            Point point = AbstractActionTable.this.getToolTipLocationForRow(n);
            if (point != null && AbstractActionTable.this.isItemRow(n)) {
                AbstractActionTable.this.showActionToolTip(point, AbstractActionTable.this.getActionNameForRow(n), AbstractActionTable.this.getH1LineForRow(n), AbstractActionTable.this.getURLForRow(n), AbstractActionTable.this.getSearchText());
            }
        }
    }
}

