/*!
  \file
  File containing method definitions for the CPUmaniple class.
*/
using namespace std;

#include "legion.hpp"

#include "cputask.hpp"
#include "anytask.hpp"

#include "cpumaniple.hpp"


namespace SciGPU {

  namespace Legion {

    // -------------------------------------------------------

    
    bool CPUmaniple::ApproveType( const Task& theTask ) {
      /*!
	This method for \ref CPUmaniple CPUmaniples
	approves tasks of type CPUtask and AnyTask
      */

      bool res = false;

      res = ( res || this->CheckTaskType<AnyTask>( theTask ) );
      res = ( res || this->CheckTaskType<CPUtask>( theTask ) );

      return( res );
    }
      
    
  }
}
