/*! \file
  File to hold some useful CUDA macros
  Largely taken from the SDK
*/

#ifndef CUDACHECK_H
#define CUDACHECK_H

#include <cstdio>
#include <cstdlib>

#include <cuda_runtime.h>


#define CUDA_SAFE_CALL( call ) do {                                     \
    cudaError err = call;						\
    if( cudaSuccess != err ) {						\
      fprintf( stderr, "CUDA Error in file '%s' on line %i : %s.\n",	\
	       __FILE__, __LINE__, cudaGetErrorString( err ) );		\
      abort();								\
    } } while( 0 );

#define CUDA_CHECK_KERNEL( errorMessage ) do {	\
    cudaError_t err = cudaGetLastError();	\
    if( cudaSuccess != err) {						\
      fprintf(stderr, "Cuda error: %s in file '%s' in line %i : %s.\n",	\
	      errorMessage, __FILE__, __LINE__, cudaGetErrorString( err) ); \
      abort();								\
    }									\
    err = cudaThreadSynchronize();					\
    if( cudaSuccess != err) {						\
      fprintf(stderr, "Cuda error: %s in file '%s' in line %i : %s.\n",	\
	      errorMessage, __FILE__, __LINE__, cudaGetErrorString( err) ); \
      abort();								\
    }									\
  } while( 0 );


#endif
