/*!
  \file
  File containing the Anytask class declaration
*/

#ifndef SCIGPU_LEGION_ANYTASK_HPP
#define SCIGPU_LEGION_ANYTASK_HPP


#include "legion.hpp"

namespace SciGPU {

  namespace Legion {
    
    //! Abstract base class for tasks which will be run on any Maniple
    /*!
      This is a class for \ref Task "Tasks" which can be run by
      any kind of Maniple.
      There are two ways to use this.
      The first is to recognise that even specialised
      \ref Maniple "Maniples" will have some CPU resources associated
      with them, so very simple processing batches can always be
      run on any Maniple.
      Alternatively, an AnyTask object could examine its
      Task::Maniple field, to determine its execution host, and
      use that to call an appropriate 'work' routine.
    */
    class AnyTask : public Task {

    public:
      //! Constructor passes tag through to base Task
      AnyTask( TagType _tag=0 ) : Task(_tag) {} ;

      //! Destructor
      virtual ~AnyTask( void ) {};
    };

  }
}

#endif
