/*!
  \file
  This file contains documentation for the 'basic' example.
  It contains some C++ code, to help Doxygen find its way around.
*/
namespace SciGPU {
  namespace Legion {


    /*!
      \page basicwork A Program which Does Some Work


      \dontinclude basicwork.cpp

      In Section \ref hello we created a very simple
      Task which just printed out a short message.
      We will now introduce a Task which actually does
      some (admittedly useless) task.

      \section bwclass The BasicWork class

      We can derive a more complicated class from 
      the CPUtask class as follows:
      \skip class BasicTask : public SciGPU::Legion::CPUtask {
      \until };
      Note that this class has two additional members,
      which store an initial and final value.
      The Task::Perform method is then over-ridden
      to set add one to the \c initial member, and store
      the result in the \c final member.
      We also make the maniple performing one of these
      \ref Task "Tasks" sleep for 10 milliseconds, just
      to make sure that other maniples have a chance to
      grab something to do.

      \section bwrun Running the tasks

      In the main program, we can then create a list of
      \c BasicTask objects:
      \skip // Declare the list of tasks
      \until }
      We just create as many \c BasicTask objects as
      required, and push them onto a vector.
      In this case, we just set the \c initial values
      randomly.

      We then queue up the tasks as before
      \skip // Enqueue them
      \until }
      and once we have waited for completion,
      we can print them out
      \skip // Print some results
      \until }
      where we have provided a suitable definition of
      \c operator<< for \c std::ostream.

      A sample run (two manipless, twenty tasks) is:
\verbatim
$ ./BasicLegion 
Legion Basic Work
=================

Maniple 0x17f2ac00: Starting up
Maniple 0x17f2a980: Starting up
Results:
Task performed by Maniple 0x17f2ac00:  17767-> 17768
Task performed by Maniple 0x17f2a980:   9158->  9159
Task performed by Maniple 0x17f2ac00:  39017-> 39018
Task performed by Maniple 0x17f2a980:  18547-> 18548
Task performed by Maniple 0x17f2ac00:  56401-> 56402
Task performed by Maniple 0x17f2a980:  23807-> 23808
Task performed by Maniple 0x17f2ac00:  37962-> 37963
Task performed by Maniple 0x17f2a980:  22764-> 22765
Task performed by Maniple 0x17f2ac00:   7977->  7978
Task performed by Maniple 0x17f2a980:  31949-> 31950
Task performed by Maniple 0x17f2ac00:  22714-> 22715
Task performed by Maniple 0x17f2a980:  55211-> 55212
Task performed by Maniple 0x17f2ac00:  16882-> 16883
Task performed by Maniple 0x17f2a980:   7931->  7932
Task performed by Maniple 0x17f2ac00:  43491-> 43492
Task performed by Maniple 0x17f2a980:  57670-> 57671
Task performed by Maniple 0x17f2ac00:    124->   125
Task performed by Maniple 0x17f2a980:  25282-> 25283
Task performed by Maniple 0x17f2ac00:   2132->  2133
Task performed by Maniple 0x17f2a980:  10232-> 10233
Maniple 0x17f2ac00: Caught terminate signal
Maniple 0x17f2ac00: Shutting down
Maniple 0x17f2a980: Caught terminate signal
Maniple 0x17f2a980: Shutting down
\endverbatim			
We can see that both maniples have done a variety of work items.
    */
  }
}
