
# A novel 15-network parcellation from fMRI data in 15 intensively sampled participants

Reference to cite when using these atlases
==========
Du J, DiNicola LM, Angeli PA, Saadon-Grosman N, Sun W, Kaiser S, Ladopoulou J, Xue A, Yeo BTT, Eldaief MC, Buckner RL. Organization of the Human Cerebral Cortex Estimated Within Individuals: Networks, Global Topography, and Function. Journal of Neurophysiology. 2024 March.

Background
==========
A novel 15-network parcellation of the cerebral cortex, DU15NET, was constructed by estimating networks from functional MRI (fMRI) data in 15 intensively sampled participants (scanned 8-11 times). DU15NET atlases can be utilized in group-based studies as a significant update to the previous “Yeo2011” atlases with refinements that align with our current understanding of human cerebral network organization. Initially computed in FreeSurfer fsaverage6 space, the atlases were further sampled to fsaverage5 and fsaverage space. Additionally, they were projected to MNI152 volume space, broadening their utility across various neuroimaging contexts.

Here we provide seven types of files: DU15NET-Consensus, DU15NET-Consensus-Raw, DU15NET-Prior, DU15NET-Agree53, DU15NET-Agree80, DU15NET-AgreeProb, and DU15NET-Tripartite, each described described in detail below, see also https://freesurfer.net/fswiki/CorticalParcellation_DU15NET. For those in search of the primary atlas, please look for DU15NET-Consensus files. For example, the file path ./HCP/fsLR_32k/DU15NET_consensus_fsLR_32k.dscalar.nii represents the DU15NET atlas in HCP fsLR_32k surface space, formatted as CIFTI. If you have any questions about the DU15NET atlases, please contact Jingnan Du at jingnandu@fas.harvard.edu and Randy L. Buckner at randy_buckner@harvard.edu.

DU15NET-Consensus
=====================
A consensus map represents the assignment at each vertex to the most common network among the 15 individuals collected here. For many purposes, this atlas can be utilized in group-based studies as an update to the prior “Yeo2011” atlases with refinements that reflect our current understanding of human cerebral network organization. Given signal dropout near the sinuses and the inner ear, we manually created an uncertain 'network' in the orbitofrontal cortex and adjacent ventrolateral prefrontal cortex (VLPFC), rostral inferior temporal cortex, and the temporal pole, marked as dark grey. We recommend disregarding this 'network' in analyses using this atlas. The DU15NET-Consensus atlas differs from the DU15NET-Prior shown below in that it reflects the idiosyncratic features and spatial registrations of the data from the Du et al.(2024) participants, including small regions that are absent in the group-averaged estimates. For example, there is a clear representation of the SAL / PMN network in the medial prefrontal cortex. For those who prefer a version without marked low-confidence areas, the DU15NET_Consensus_NoLowConfMask is available.

DU15NET-Prior
=====================
The 15-network group prior used in the MS-HBM model is made available as the DU15NET-Prior atlas. The DU15NET-Prior utilizes the HCP data processed via their standard processing pipelines and thus has the benefit of being derived from data collected and registered with a commonly used set of pipelines.

DU15NET-Consensus-Raw
=====================
A consensus map represents the assignment at each vertex to the most common network among the 15 individuals collected here, ensuring that no vertex remains unassigned. This map directly reflects the combined outputs from the 15 individual maps collected in this study, referencing 'DU15NET-Consensus' in Du et al. (2024). The recommended DU15NET-Consensus is subsequently derived based on this map, following a few cleaning procedures outlined in the DU15NET-Consensus section above.

DU15NET-AgreeProb
=====================
The agreement atlas represents the probability at each vertex of the consistent assignment of the same network across individuals within our current sample of 15 participants. The DU15NET-Agree53 and DU15NET-Agree80 atlases provided below are derived from the DU15NET-Consensus-Raw atlas thresholded based on this agreement atlas.

DU15NET-Agree53
=====================
This agreement map is thresholded to leave only vertices with agreement across participants of n ≥ 8 (53%). The agreement atlases are particularly useful when the goal is to construct regions of interest that have a high probability of belonging to one network rather than another, in situations where it is appropriate to have regions that cover a portion of the cerebral cortex not the cortex in its entirety.

DU15NET-Agree80
=====================
This agreement map is thresholded to leave only vertices with agreement across participants of n ≥ 12 (80%).

DU15NET-Tripartite
=====================
This map combines networks from the DU15NET-Consesus map to yield a tripartite hierarchical separation of first-order, second-order, and third-order networks as described in Du et al. (2024). This tripartite grouping of networks is a heuristic that captures some organizational features that distinguish sets of 
networks in a manner that roughly aligns to Paul Flechsig’s (1901, 1920) maps of sequential myelination. See Du et al. (2024) discussion for further elaboration.

Parcellations in Nonlinear MNI152 Volume Space
=====================
The DU15NET atlases are computed in fsaverage6 and sampled to MNI152 volume space. Each parcel was matched to a corresponding network in 15 network parcellation by Du et al. (2024). The projection used the cortical ribbon which is defined by putting the FSL MNI152 1mm template through recon-all using FreeSurfer. The projection process has been consistently applied to all atlases mentioned above. Each atlas is provided in 1mm, 2mm, and 3mm MNI152 volume space versions. For example, DU15NET_consensus_MNI152_1mm.nii.gz represents the volume version of the DU15NET-Consensus atlas in MNI152 volume space at 1mm resolution.

Information about Downloads
=====================
DU15NET, a novel 15-network parcellation from fMRI data in 15 intensively sampled participants. The downloaded folder includes three subfolders corresponding to three different spaces: FreeSurfer, MNI152, and HCP. Link: https://freesurfer.net/fswiki/CorticalParcellation_DU15NET?action=AttachFile&do=get&target=DU15NET.zip

BALSA provides maps for within-individual parcellation, temporal signal-to-noise, and task contrast maps related to DU15NET. Link: https://balsa.wustl.edu/study/zK166

Updates
=====================
- Release v0.1.0 (02/29/2024): release the parcellations in MNI, HCP fsLR and fsaverage space
- Release v0.1.1 (03/31/2024): Add DU15NET-Tripartite atlas which combines networks from the DU15NET-Consesus map to yield a tripartite hierarchical separation of first-order, second-order, and third-order networks as described in Du et al. (2024). 

